/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.util;

import com.google.common.primitives.Longs;
import java.security.SecureRandom;
import java.util.Random;
import org.apache.bookkeeper.common.util.OrderedExecutor;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestThreadSelection {
    private static final Logger log = LoggerFactory.getLogger(TestThreadSelection.class);
    public static final long MAX_KEY = 1000000L;
    public static final int MAX_THREADS = 96;
    public static final double MAX_DISPARITY = 1.25;
    private final Random rnd = new SecureRandom();

    @Test
    public void testThreadSelectionEvenKeys() {
        this.runTest(0L, 2L);
    }

    @Test
    public void testThreadSelectionOddKeys() {
        this.runTest(1L, 2L);
    }

    @Test
    public void testThreadSelectionAllKeys() {
        this.runTest(0L, 1L);
    }

    @Test
    public void testThreadSelectionRandKeys() {
        for (int numThreads = 2; numThreads <= 96; ++numThreads) {
            long[] placement = new long[numThreads];
            log.info("testing {} threads", (Object)numThreads);
            for (long key = 0L; key < 1000000L; ++key) {
                int threadId;
                int n = threadId = OrderedExecutor.chooseThreadIdx((long)this.rnd.nextLong(), (int)numThreads);
                placement[n] = placement[n] + 1L;
            }
            this.validateTest(placement, numThreads);
        }
    }

    @Test
    public void testKeyAssignedToTheSameThread() {
        for (int numThreads = 2; numThreads <= 96; ++numThreads) {
            log.info("testing {} threads", (Object)numThreads);
            for (long key = 0L; key < 1000000L; ++key) {
                int threadId = OrderedExecutor.chooseThreadIdx((long)key, (int)numThreads);
                for (int i = 0; i < 10; ++i) {
                    Assert.assertEquals((String)"must be assigned to the same thread", (long)threadId, (long)OrderedExecutor.chooseThreadIdx((long)key, (int)numThreads));
                }
            }
        }
    }

    private void runTest(long start, long step) {
        for (int numThreads = 2; numThreads <= 96; ++numThreads) {
            long[] placement = new long[numThreads];
            log.info("testing {} threads", (Object)numThreads);
            for (long key = start; key < 1000000L; key += step) {
                int threadId;
                int n = threadId = OrderedExecutor.chooseThreadIdx((long)key, (int)numThreads);
                placement[n] = placement[n] + 1L;
            }
            this.validateTest(placement, numThreads);
        }
    }

    private void validateTest(long[] placement, int numThreads) {
        long min = Longs.min((long[])placement);
        long max = Longs.max((long[])placement);
        log.info("got min={}, max={} (disparity: {}) for {} threads with {} ids", new Object[]{min, max, max - min, numThreads, 1000000L});
        Assert.assertTrue((String)("all threads were used [numThreads: " + numThreads + "]"), (min > 0L ? 1 : 0) != 0);
        log.info("disparity = {}", (Object)String.format("%,.2f", (double)max / (double)min));
        Assert.assertTrue((String)("no large disparity found [numThreads: " + numThreads + "], got " + (double)max / (double)min), ((double)max / (double)min <= 1.25 ? 1 : 0) != 0);
    }
}

