/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.util;

import java.util.function.Function;
import org.apache.bookkeeper.common.collections.RecyclableArrayList;
import org.apache.bookkeeper.common.util.Watchable;
import org.apache.bookkeeper.common.util.Watcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestWatchable {
    private final RecyclableArrayList.Recycler<Watcher<Integer>> recycler = new RecyclableArrayList.Recycler();
    private final Watchable<Integer> watchable = new Watchable(this.recycler);

    @After
    public void teardown() {
        this.watchable.recycle();
    }

    @Test
    public void testAddWatcher() {
        Watcher watcher = (Watcher)Mockito.mock(Watcher.class);
        Assert.assertTrue((boolean)this.watchable.addWatcher(watcher));
        Assert.assertEquals((long)1L, (long)this.watchable.getNumWatchers());
        this.watchable.notifyWatchers(Function.identity(), (Object)123);
        ((Watcher)Mockito.verify((Object)watcher, (VerificationMode)Mockito.times((int)1))).update((Object)ArgumentMatchers.eq((int)123));
        Assert.assertEquals((long)0L, (long)this.watchable.getNumWatchers());
    }

    @Test
    public void testDeleteWatcher() {
        Watcher watcher = (Watcher)Mockito.mock(Watcher.class);
        Assert.assertTrue((boolean)this.watchable.addWatcher(watcher));
        Assert.assertEquals((long)1L, (long)this.watchable.getNumWatchers());
        Assert.assertTrue((boolean)this.watchable.deleteWatcher(watcher));
        Assert.assertEquals((long)0L, (long)this.watchable.getNumWatchers());
        this.watchable.notifyWatchers(Function.identity(), (Object)123);
        ((Watcher)Mockito.verify((Object)watcher, (VerificationMode)Mockito.times((int)0))).update((Object)ArgumentMatchers.anyInt());
    }

    @Test
    public void testMultipleWatchers() {
        Watcher watcher1 = (Watcher)Mockito.mock(Watcher.class);
        Watcher watcher2 = (Watcher)Mockito.mock(Watcher.class);
        Assert.assertTrue((boolean)this.watchable.addWatcher(watcher1));
        Assert.assertTrue((boolean)this.watchable.addWatcher(watcher2));
        Assert.assertEquals((long)2L, (long)this.watchable.getNumWatchers());
        this.watchable.notifyWatchers(Function.identity(), (Object)123);
        ((Watcher)Mockito.verify((Object)watcher1, (VerificationMode)Mockito.times((int)1))).update((Object)ArgumentMatchers.eq((int)123));
        ((Watcher)Mockito.verify((Object)watcher2, (VerificationMode)Mockito.times((int)1))).update((Object)ArgumentMatchers.eq((int)123));
        Assert.assertEquals((long)0L, (long)this.watchable.getNumWatchers());
    }

    @Test
    public void testAddWatchMultipleTimes() {
        Watcher watcher = (Watcher)Mockito.mock(Watcher.class);
        int numTimes = 3;
        for (int i = 0; i < numTimes; ++i) {
            Assert.assertTrue((boolean)this.watchable.addWatcher(watcher));
        }
        Assert.assertEquals((long)numTimes, (long)this.watchable.getNumWatchers());
        this.watchable.notifyWatchers(Function.identity(), (Object)123);
        ((Watcher)Mockito.verify((Object)watcher, (VerificationMode)Mockito.times((int)numTimes))).update((Object)ArgumentMatchers.eq((int)123));
        Assert.assertEquals((long)0L, (long)this.watchable.getNumWatchers());
    }

    @Test
    public void testDeleteWatchers() {
        Watcher watcher1 = (Watcher)Mockito.mock(Watcher.class);
        Watcher watcher2 = (Watcher)Mockito.mock(Watcher.class);
        Assert.assertTrue((boolean)this.watchable.addWatcher(watcher1));
        Assert.assertTrue((boolean)this.watchable.addWatcher(watcher2));
        Assert.assertEquals((long)2L, (long)this.watchable.getNumWatchers());
        this.watchable.deleteWatchers();
        Assert.assertEquals((long)0L, (long)this.watchable.getNumWatchers());
        this.watchable.notifyWatchers(Function.identity(), (Object)123);
        ((Watcher)Mockito.verify((Object)watcher1, (VerificationMode)Mockito.times((int)0))).update((Object)ArgumentMatchers.anyInt());
        ((Watcher)Mockito.verify((Object)watcher2, (VerificationMode)Mockito.times((int)0))).update((Object)ArgumentMatchers.anyInt());
    }
}

