/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.util;

import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bookkeeper.common.util.SingleThreadExecutor;
import org.awaitility.Awaitility;
import org.junit.Assert;
import org.junit.Test;

public class TestSingleThreadExecutor {
    private static final ThreadFactory THREAD_FACTORY = new DefaultThreadFactory("test");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimple() throws Exception {
        SingleThreadExecutor ste = new SingleThreadExecutor(THREAD_FACTORY);
        try {
            AtomicInteger count = new AtomicInteger();
            Assert.assertEquals((long)0L, (long)ste.getSubmittedTasksCount());
            Assert.assertEquals((long)0L, (long)ste.getCompletedTasksCount());
            Assert.assertEquals((long)0L, (long)ste.getQueuedTasksCount());
            for (int i = 0; i < 10; ++i) {
                ste.execute(() -> count.incrementAndGet());
            }
            Assert.assertEquals((long)10L, (long)ste.getSubmittedTasksCount());
            ste.submit(() -> {}).get();
            Assert.assertEquals((long)10L, (long)count.get());
            Assert.assertEquals((long)11L, (long)ste.getSubmittedTasksCount());
            Awaitility.await().untilAsserted(() -> Assert.assertEquals((long)11L, (long)ste.getCompletedTasksCount()));
            Assert.assertEquals((long)0L, (long)ste.getRejectedTasksCount());
            Assert.assertEquals((long)0L, (long)ste.getFailedTasksCount());
            Assert.assertEquals((long)0L, (long)ste.getQueuedTasksCount());
        }
        finally {
            if (Collections.singletonList(ste).get(0) != null) {
                ste.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRejectWhenQueueIsFull() throws Exception {
        SingleThreadExecutor ste = new SingleThreadExecutor(THREAD_FACTORY, 10, true);
        try {
            CyclicBarrier barrier = new CyclicBarrier(11);
            CountDownLatch startedLatch = new CountDownLatch(1);
            for (int i = 0; i < 10; ++i) {
                ste.execute(() -> {
                    startedLatch.countDown();
                    try {
                        barrier.await();
                    }
                    catch (InterruptedException | BrokenBarrierException exception) {
                        // empty catch block
                    }
                });
                startedLatch.await();
            }
            ste.execute(() -> {});
            try {
                ste.execute(() -> {});
                Assert.fail((String)"should have rejected the task");
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
            Assert.assertTrue((ste.getSubmittedTasksCount() >= 11L ? 1 : 0) != 0);
            Assert.assertTrue((ste.getRejectedTasksCount() >= 1L ? 1 : 0) != 0);
            Assert.assertEquals((long)0L, (long)ste.getFailedTasksCount());
        }
        finally {
            if (Collections.singletonList(ste).get(0) != null) {
                ste.shutdownNow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlockWhenQueueIsFull() throws Exception {
        SingleThreadExecutor ste = new SingleThreadExecutor(THREAD_FACTORY, 10, false);
        try {
            CyclicBarrier barrier = new CyclicBarrier(11);
            for (int i = 0; i < 10; ++i) {
                ste.execute(() -> {
                    try {
                        barrier.await(1L, TimeUnit.SECONDS);
                    }
                    catch (TimeoutException timeoutException) {
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            Assert.assertEquals((long)10L, (long)ste.getQueuedTasksCount());
            ste.submit(() -> {}).get();
            Assert.assertEquals((long)11L, (long)ste.getSubmittedTasksCount());
            Assert.assertEquals((long)0L, (long)ste.getRejectedTasksCount());
        }
        finally {
            if (Collections.singletonList(ste).get(0) != null) {
                ste.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testShutdown() throws Exception {
        SingleThreadExecutor ste = new SingleThreadExecutor(THREAD_FACTORY);
        try {
            Assert.assertFalse((boolean)ste.isShutdown());
            Assert.assertFalse((boolean)ste.isTerminated());
            AtomicInteger count = new AtomicInteger();
            for (int i = 0; i < 3; ++i) {
                ste.execute(() -> {
                    try {
                        Thread.sleep(1000L);
                        count.incrementAndGet();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            ste.shutdown();
            Assert.assertTrue((boolean)ste.isShutdown());
            Assert.assertFalse((boolean)ste.isTerminated());
            try {
                ste.execute(() -> {});
                Assert.fail((String)"should have rejected the task");
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
            ste.awaitTermination(10L, TimeUnit.SECONDS);
            Assert.assertTrue((boolean)ste.isShutdown());
            Assert.assertTrue((boolean)ste.isTerminated());
            Assert.assertEquals((long)3L, (long)count.get());
        }
        finally {
            if (Collections.singletonList(ste).get(0) != null) {
                ste.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testShutdownNow() throws Exception {
        SingleThreadExecutor ste = new SingleThreadExecutor(THREAD_FACTORY);
        try {
            Assert.assertFalse((boolean)ste.isShutdown());
            Assert.assertFalse((boolean)ste.isTerminated());
            AtomicInteger count = new AtomicInteger();
            for (int i = 0; i < 3; ++i) {
                ste.execute(() -> {
                    try {
                        Thread.sleep(2000L);
                        count.incrementAndGet();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                });
                Thread.sleep(500L);
            }
            List remainingTasks = ste.shutdownNow();
            Assert.assertEquals((long)2L, (long)remainingTasks.size());
            Assert.assertTrue((boolean)ste.isShutdown());
            try {
                ste.execute(() -> {});
                Assert.fail((String)"should have rejected the task");
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
            ste.awaitTermination(10L, TimeUnit.SECONDS);
            Assert.assertTrue((boolean)ste.isShutdown());
            Assert.assertTrue((boolean)ste.isTerminated());
            Assert.assertEquals((long)0L, (long)count.get());
        }
        finally {
            if (Collections.singletonList(ste).get(0) != null) {
                ste.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTasksWithException() throws Exception {
        SingleThreadExecutor ste = new SingleThreadExecutor(THREAD_FACTORY);
        try {
            AtomicInteger count = new AtomicInteger();
            for (int i = 0; i < 10; ++i) {
                ste.execute(() -> {
                    count.incrementAndGet();
                    throw new RuntimeException("xyz");
                });
            }
            ste.submit(() -> {}).get();
            Assert.assertEquals((long)10L, (long)count.get());
            Assert.assertEquals((long)11L, (long)ste.getSubmittedTasksCount());
            Awaitility.await().untilAsserted(() -> Assert.assertEquals((long)1L, (long)ste.getCompletedTasksCount()));
            Assert.assertEquals((long)0L, (long)ste.getRejectedTasksCount());
            Assert.assertEquals((long)10L, (long)ste.getFailedTasksCount());
        }
        finally {
            if (Collections.singletonList(ste).get(0) != null) {
                ste.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTasksWithNPE() throws Exception {
        SingleThreadExecutor ste = new SingleThreadExecutor(THREAD_FACTORY);
        try {
            AtomicInteger count = new AtomicInteger();
            String npeTest = null;
            for (int i = 0; i < 10; ++i) {
                ste.execute(() -> {
                    count.incrementAndGet();
                    System.out.println(npeTest.length());
                });
            }
            ste.submit(() -> {}).get();
            Assert.assertEquals((long)10L, (long)count.get());
            Assert.assertEquals((long)11L, (long)ste.getSubmittedTasksCount());
            Awaitility.await().untilAsserted(() -> Assert.assertEquals((long)1L, (long)ste.getCompletedTasksCount()));
            Assert.assertEquals((long)0L, (long)ste.getRejectedTasksCount());
            Assert.assertEquals((long)10L, (long)ste.getFailedTasksCount());
        }
        finally {
            if (Collections.singletonList(ste).get(0) != null) {
                ste.shutdown();
            }
        }
    }

    @Test
    public void testShutdownEmpty() throws Exception {
        SingleThreadExecutor ste = new SingleThreadExecutor(THREAD_FACTORY);
        ste.shutdown();
        Assert.assertTrue((boolean)ste.isShutdown());
        ste.awaitTermination(10L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)ste.isShutdown());
        Assert.assertTrue((boolean)ste.isTerminated());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecutorQueueIsNotFixedSize() throws Exception {
        int n = 1000000;
        SingleThreadExecutor ste = new SingleThreadExecutor(THREAD_FACTORY);
        try {
            CountDownLatch latch = new CountDownLatch(1);
            ste.execute(() -> {
                try {
                    latch.await();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            for (int i = 0; i < n; ++i) {
                ste.execute(() -> {});
            }
            Future future = ste.submit(() -> {});
            latch.countDown();
            future.get();
        }
        finally {
            if (Collections.singletonList(ste).get(0) != null) {
                ste.shutdown();
            }
        }
    }
}

