/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.component;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.bookkeeper.common.component.ComponentInfoPublisher;
import org.apache.bookkeeper.common.component.ComponentStarter;
import org.apache.bookkeeper.common.component.LifecycleComponent;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestComponentStarter {
    @Test
    public void testStartComponent() {
        LifecycleComponent component = (LifecycleComponent)Mockito.mock(LifecycleComponent.class);
        Mockito.when((Object)component.getName()).thenReturn((Object)"test-start-component");
        ComponentStarter.startComponent((LifecycleComponent)component);
        ((LifecycleComponent)Mockito.verify((Object)component)).publishInfo((ComponentInfoPublisher)ArgumentMatchers.any(ComponentInfoPublisher.class));
        ((LifecycleComponent)Mockito.verify((Object)component)).start();
    }

    @Test
    public void testComponentShutdownHook() throws Exception {
        LifecycleComponent component = (LifecycleComponent)Mockito.mock(LifecycleComponent.class);
        Mockito.when((Object)component.getName()).thenReturn((Object)"test-shutdown-hook");
        CompletableFuture future = new CompletableFuture();
        ComponentStarter.ComponentShutdownHook shutdownHook = new ComponentStarter.ComponentShutdownHook(component, future);
        shutdownHook.run();
        ((LifecycleComponent)Mockito.verify((Object)component)).close();
        future.get();
    }

    @Test
    public void testExceptionHandler() throws Exception {
        LifecycleComponent component = (LifecycleComponent)Mockito.mock(LifecycleComponent.class);
        Mockito.when((Object)component.getName()).thenReturn((Object)"test-exception-handler");
        AtomicReference exceptionHandlerRef = new AtomicReference();
        ((LifecycleComponent)Mockito.doAnswer(invocationOnMock -> {
            Thread.UncaughtExceptionHandler handler = (Thread.UncaughtExceptionHandler)invocationOnMock.getArgument(0);
            exceptionHandlerRef.set(handler);
            return null;
        }).when((Object)component)).setExceptionHandler((Thread.UncaughtExceptionHandler)ArgumentMatchers.any(Thread.UncaughtExceptionHandler.class));
        CompletableFuture startFuture = ComponentStarter.startComponent((LifecycleComponent)component);
        ((LifecycleComponent)Mockito.verify((Object)component, (VerificationMode)Mockito.times((int)1))).start();
        ((LifecycleComponent)Mockito.verify((Object)component, (VerificationMode)Mockito.times((int)1))).setExceptionHandler((Thread.UncaughtExceptionHandler)ArgumentMatchers.eq((Object)((Thread.UncaughtExceptionHandler)exceptionHandlerRef.get())));
        ((Thread.UncaughtExceptionHandler)exceptionHandlerRef.get()).uncaughtException(Thread.currentThread(), new Exception("test-exception-handler"));
        startFuture.get();
        ((LifecycleComponent)Mockito.verify((Object)component, (VerificationMode)Mockito.times((int)1))).close();
    }
}

