/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.component;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.bookkeeper.common.component.ComponentStarter;
import org.apache.bookkeeper.common.component.Lifecycle;
import org.apache.bookkeeper.common.component.LifecycleComponent;
import org.apache.bookkeeper.common.component.LifecycleComponentStack;
import org.apache.bookkeeper.common.component.LifecycleListener;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestLifecycleComponentStack {
    @Test(expected=NullPointerException.class)
    public void testBuilderWithNullName() {
        LifecycleComponentStack.newBuilder().withName(null).build();
    }

    @Test(expected=NullPointerException.class)
    public void testBuilderWithNullComponent() {
        LifecycleComponentStack.newBuilder().addComponent(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBuilderWithEmptyComponentList() {
        LifecycleComponentStack.newBuilder().withName("empty-list").build();
    }

    @Test
    public void testGetName() {
        String name = "test-get-name";
        LifecycleComponentStack stack = LifecycleComponentStack.newBuilder().withName(name).addComponent((LifecycleComponent)Mockito.mock(LifecycleComponent.class)).build();
        Assert.assertEquals((Object)name, (Object)stack.getName());
    }

    @Test
    public void testLifecycleState() {
        LifecycleComponent component1 = (LifecycleComponent)Mockito.mock(LifecycleComponent.class);
        Mockito.when((Object)component1.lifecycleState()).thenReturn((Object)Lifecycle.State.INITIALIZED);
        LifecycleComponent component2 = (LifecycleComponent)Mockito.mock(LifecycleComponent.class);
        Mockito.when((Object)component2.lifecycleState()).thenReturn((Object)Lifecycle.State.STARTED);
        LifecycleComponentStack stack = LifecycleComponentStack.newBuilder().withName("get-lifecycle-state").addComponent(component1).addComponent(component2).build();
        Assert.assertEquals((Object)Lifecycle.State.INITIALIZED, (Object)stack.lifecycleState());
    }

    @Test
    public void testAddRemoveLifecycleListener() {
        LifecycleComponent component1 = (LifecycleComponent)Mockito.mock(LifecycleComponent.class);
        LifecycleComponent component2 = (LifecycleComponent)Mockito.mock(LifecycleComponent.class);
        LifecycleComponentStack stack = LifecycleComponentStack.newBuilder().withName("get-lifecycle-listener").addComponent(component1).addComponent(component2).build();
        LifecycleListener listener = (LifecycleListener)Mockito.mock(LifecycleListener.class);
        stack.addLifecycleListener(listener);
        ((LifecycleComponent)Mockito.verify((Object)component1)).addLifecycleListener(listener);
        ((LifecycleComponent)Mockito.verify((Object)component2)).addLifecycleListener(listener);
        stack.removeLifecycleListener(listener);
        ((LifecycleComponent)Mockito.verify((Object)component1)).removeLifecycleListener(listener);
        ((LifecycleComponent)Mockito.verify((Object)component2)).removeLifecycleListener(listener);
    }

    @Test
    public void testStartStopClose() {
        LifecycleComponent component1 = (LifecycleComponent)Mockito.mock(LifecycleComponent.class);
        LifecycleComponent component2 = (LifecycleComponent)Mockito.mock(LifecycleComponent.class);
        LifecycleComponentStack stack = LifecycleComponentStack.newBuilder().withName("get-lifecycle-listener").addComponent(component1).addComponent(component2).build();
        stack.start();
        ((LifecycleComponent)Mockito.verify((Object)component1)).start();
        ((LifecycleComponent)Mockito.verify((Object)component2)).start();
        stack.stop();
        ((LifecycleComponent)Mockito.verify((Object)component1)).stop();
        ((LifecycleComponent)Mockito.verify((Object)component2)).stop();
        stack.close();
        ((LifecycleComponent)Mockito.verify((Object)component1)).close();
        ((LifecycleComponent)Mockito.verify((Object)component2)).close();
    }

    @Test
    public void testSetExceptionHandler() {
        LifecycleComponent component1 = (LifecycleComponent)Mockito.mock(LifecycleComponent.class);
        LifecycleComponent component2 = (LifecycleComponent)Mockito.mock(LifecycleComponent.class);
        LifecycleComponentStack stack = LifecycleComponentStack.newBuilder().withName("set-exception-handler-stack").addComponent(component1).addComponent(component2).build();
        Thread.UncaughtExceptionHandler handler = (Thread.UncaughtExceptionHandler)Mockito.mock(Thread.UncaughtExceptionHandler.class);
        stack.setExceptionHandler(handler);
        ((LifecycleComponent)Mockito.verify((Object)component1, (VerificationMode)Mockito.times((int)1))).setExceptionHandler((Thread.UncaughtExceptionHandler)ArgumentMatchers.eq((Object)handler));
        ((LifecycleComponent)Mockito.verify((Object)component2, (VerificationMode)Mockito.times((int)1))).setExceptionHandler((Thread.UncaughtExceptionHandler)ArgumentMatchers.eq((Object)handler));
    }

    @Test
    public void testExceptionHandlerShutdownLifecycleComponentStack() throws Exception {
        LifecycleComponent component1 = (LifecycleComponent)Mockito.mock(LifecycleComponent.class);
        LifecycleComponent component2 = (LifecycleComponent)Mockito.mock(LifecycleComponent.class);
        AtomicReference handlerRef1 = new AtomicReference();
        ((LifecycleComponent)Mockito.doAnswer(invocationOnMock -> {
            handlerRef1.set((Thread.UncaughtExceptionHandler)invocationOnMock.getArgument(0));
            return null;
        }).when((Object)component1)).setExceptionHandler((Thread.UncaughtExceptionHandler)ArgumentMatchers.any(Thread.UncaughtExceptionHandler.class));
        LifecycleComponentStack stack = LifecycleComponentStack.newBuilder().withName("exception-handler-shutdown-lifecycle-component-stack").addComponent(component1).addComponent(component2).build();
        CompletableFuture startFuture = ComponentStarter.startComponent((LifecycleComponent)stack);
        ((LifecycleComponent)Mockito.verify((Object)component1, (VerificationMode)Mockito.times((int)1))).start();
        ((LifecycleComponent)Mockito.verify((Object)component1, (VerificationMode)Mockito.times((int)1))).setExceptionHandler((Thread.UncaughtExceptionHandler)ArgumentMatchers.eq((Object)((Thread.UncaughtExceptionHandler)handlerRef1.get())));
        ((LifecycleComponent)Mockito.verify((Object)component2, (VerificationMode)Mockito.times((int)1))).start();
        ((LifecycleComponent)Mockito.verify((Object)component2, (VerificationMode)Mockito.times((int)1))).setExceptionHandler((Thread.UncaughtExceptionHandler)ArgumentMatchers.eq((Object)((Thread.UncaughtExceptionHandler)handlerRef1.get())));
        ((Thread.UncaughtExceptionHandler)handlerRef1.get()).uncaughtException(Thread.currentThread(), new Exception("exception-handler-shutdown-lifecycle-component-stack"));
        startFuture.get();
        ((LifecycleComponent)Mockito.verify((Object)component1, (VerificationMode)Mockito.times((int)1))).close();
        ((LifecycleComponent)Mockito.verify((Object)component2, (VerificationMode)Mockito.times((int)1))).close();
    }
}

