/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.testing.executors;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.SettableFuture;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.common.testing.executors.MockClock;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockExecutorController {
    private static final Logger log = LoggerFactory.getLogger(MockExecutorController.class);
    private final MockClock clock = new MockClock();
    private final List<DeferredTask> deferredTasks = Lists.newArrayList();

    public MockExecutorController controlSubmit(ScheduledExecutorService service) {
        ((ScheduledExecutorService)Mockito.doAnswer(MockExecutorController.answerNow()).when((Object)service)).submit((Runnable)ArgumentMatchers.any(Runnable.class));
        return this;
    }

    public MockExecutorController controlExecute(ScheduledExecutorService service) {
        ((ScheduledExecutorService)Mockito.doAnswer(MockExecutorController.answerNow()).when((Object)service)).execute((Runnable)ArgumentMatchers.any(Runnable.class));
        return this;
    }

    public MockExecutorController controlSchedule(ScheduledExecutorService service) {
        ((ScheduledExecutorService)Mockito.doAnswer(MockExecutorController.answerDelay(this)).when((Object)service)).schedule((Runnable)ArgumentMatchers.any(Runnable.class), ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)));
        return this;
    }

    public MockExecutorController controlScheduleAtFixedRate(ScheduledExecutorService service, int maxInvocations) {
        ((ScheduledExecutorService)Mockito.doAnswer(MockExecutorController.answerAtFixedRate(this, maxInvocations)).when((Object)service)).scheduleAtFixedRate((Runnable)ArgumentMatchers.any(Runnable.class), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)));
        return this;
    }

    private static Answer<ScheduledFuture<?>> answerAtFixedRate(MockExecutorController controller, int numTimes) {
        return invocationOnMock -> {
            Runnable task = (Runnable)invocationOnMock.getArgument(0);
            long initialDelay = (Long)invocationOnMock.getArgument(1);
            long delay = (Long)invocationOnMock.getArgument(2);
            TimeUnit unit = (TimeUnit)((Object)((Object)invocationOnMock.getArgument(3)));
            DeferredTask deferredTask = null;
            for (int i = 0; i < numTimes; ++i) {
                long delayMs = unit.toMillis(initialDelay) + (long)i * unit.toMillis(delay);
                deferredTask = controller.addDelayedTask(controller, delayMs, task);
            }
            return deferredTask;
        };
    }

    private static Answer<ScheduledFuture<?>> answerDelay(MockExecutorController executor) {
        return invocationOnMock -> {
            Runnable task = (Runnable)invocationOnMock.getArgument(0);
            long value = (Long)invocationOnMock.getArgument(1);
            TimeUnit unit = (TimeUnit)((Object)((Object)invocationOnMock.getArgument(2)));
            return executor.addDelayedTask(executor, unit.toMillis(value), task);
        };
    }

    private static Answer<Future<?>> answerNow() {
        return invocationOnMock -> {
            Runnable task = (Runnable)invocationOnMock.getArgument(0);
            task.run();
            SettableFuture future = SettableFuture.create();
            future.set(null);
            return future;
        };
    }

    private DeferredTask addDelayedTask(MockExecutorController executor, long delayTimeMs, Runnable task) {
        Preconditions.checkArgument((delayTimeMs >= 0L ? 1 : 0) != 0);
        DeferredTask deferredTask = new DeferredTask(task, delayTimeMs);
        if (delayTimeMs > 0L) {
            executor.deferredTasks.add(deferredTask);
        } else {
            task.run();
            FutureUtils.complete((CompletableFuture)deferredTask.future, null);
        }
        return deferredTask;
    }

    public void advance(Duration duration) {
        this.clock.advance(duration);
        Iterator<DeferredTask> entries = this.deferredTasks.iterator();
        ArrayList toExecute = Lists.newArrayList();
        while (entries.hasNext()) {
            DeferredTask next = entries.next();
            if (next.getDelay(TimeUnit.MILLISECONDS) > 0L) continue;
            entries.remove();
            toExecute.add(next);
        }
        for (DeferredTask task : toExecute) {
            task.run();
        }
    }

    public MockClock getClock() {
        return this.clock;
    }

    private class DeferredTask
    implements ScheduledFuture<Void> {
        private final Runnable runnable;
        private final long scheduledAtMillis;
        private final CompletableFuture<Void> future;

        public DeferredTask(Runnable runnable, long delayTimeMs) {
            this.runnable = runnable;
            this.scheduledAtMillis = delayTimeMs + MockExecutorController.this.clock.millis();
            this.future = FutureUtils.createFuture();
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.scheduledAtMillis - MockExecutorController.this.clock.millis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed o) {
            return Long.compare(this.getDelay(TimeUnit.MILLISECONDS), o.getDelay(TimeUnit.MILLISECONDS));
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.future.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.future.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.future.isDone();
        }

        @Override
        public Void get() throws InterruptedException, ExecutionException {
            this.future.get();
            return null;
        }

        @Override
        public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            this.future.get(timeout, unit);
            return null;
        }

        void run() {
            this.runnable.run();
            FutureUtils.complete(this.future, null);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DeferredTask)) {
                return false;
            }
            DeferredTask other = (DeferredTask)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getScheduledAtMillis() != other.getScheduledAtMillis()) {
                return false;
            }
            Runnable this$runnable = this.getRunnable();
            Runnable other$runnable = other.getRunnable();
            if (this$runnable == null ? other$runnable != null : !this$runnable.equals(other$runnable)) {
                return false;
            }
            CompletableFuture<Void> this$future = this.getFuture();
            CompletableFuture<Void> other$future = other.getFuture();
            return !(this$future == null ? other$future != null : !this$future.equals(other$future));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DeferredTask;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $scheduledAtMillis = this.getScheduledAtMillis();
            result = result * 59 + (int)($scheduledAtMillis >>> 32 ^ $scheduledAtMillis);
            Runnable $runnable = this.getRunnable();
            result = result * 59 + ($runnable == null ? 43 : $runnable.hashCode());
            CompletableFuture<Void> $future = this.getFuture();
            result = result * 59 + ($future == null ? 43 : $future.hashCode());
            return result;
        }

        public String toString() {
            return "MockExecutorController.DeferredTask(runnable=" + this.getRunnable() + ", scheduledAtMillis=" + this.getScheduledAtMillis() + ", future=" + this.getFuture() + ")";
        }

        public Runnable getRunnable() {
            return this.runnable;
        }

        public long getScheduledAtMillis() {
            return this.scheduledAtMillis;
        }

        public CompletableFuture<Void> getFuture() {
            return this.future;
        }
    }
}

