/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.util;

import org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.test.TestStatsProvider;
import org.junit.Assert;
import org.junit.Test;

public class TestOrderedExecutor {
    @Test
    public void testOrderExecutorPrometheusMetric() {
        this.testGenerateMetric(false);
        this.testGenerateMetric(true);
    }

    private void testGenerateMetric(boolean isTraceTaskExecution) {
        TestStatsProvider provider = new TestStatsProvider();
        TestStatsProvider.TestStatsLogger rootStatsLogger = provider.getStatsLogger("");
        TestStatsProvider.TestStatsLogger bookieStats = (TestStatsProvider.TestStatsLogger)rootStatsLogger.scope("bookkeeper_server");
        OrderedExecutor executor = OrderedExecutor.newBuilder().statsLogger((StatsLogger)bookieStats).name("test").numThreads(1).traceTaskExecution(isTraceTaskExecution).build();
        TestStatsProvider.TestStatsLogger testStatsLogger = (TestStatsProvider.TestStatsLogger)bookieStats.scope("thread_test_OrderedExecutor_0_0");
        Assert.assertNotNull((Object)testStatsLogger.getGauge("thread_executor_queue").getSample());
        Assert.assertNotNull((Object)testStatsLogger.getGauge("thread_executor_completed").getSample());
        Assert.assertNotNull((Object)testStatsLogger.getGauge("thread_executor_tasks_completed").getSample());
        Assert.assertNotNull((Object)testStatsLogger.getGauge("thread_executor_tasks_rejected").getSample());
        Assert.assertNotNull((Object)testStatsLogger.getGauge("thread_executor_tasks_failed").getSample());
    }
}

