/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.conf;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;

public abstract class ComponentConfiguration
implements Configuration {
    protected static final String DELIMITER = ".";
    private final String componentPrefix;
    private final CompositeConfiguration conf;

    protected ComponentConfiguration(CompositeConfiguration conf, String componentPrefix) {
        this.conf = conf;
        this.componentPrefix = componentPrefix;
    }

    protected String getKeyName(String name) {
        return this.componentPrefix + name;
    }

    public String getComponentPrefix() {
        return this.componentPrefix;
    }

    public CompositeConfiguration getUnderlyingConf() {
        return this.conf;
    }

    public void loadConf(URL confURL) throws ConfigurationException {
        PropertiesConfiguration loadedConf = new PropertiesConfiguration(confURL);
        this.conf.addConfiguration((Configuration)loadedConf);
    }

    public void validate() throws ConfigurationException {
    }

    public Configuration subset(String prefix) {
        return this.conf.subset(this.getKeyName(prefix));
    }

    public boolean isEmpty() {
        return this.conf.subset(this.componentPrefix).isEmpty();
    }

    public boolean containsKey(String key) {
        return this.conf.containsKey(this.getKeyName(key));
    }

    public void addProperty(String key, Object value) {
        this.conf.addProperty(this.getKeyName(key), value);
    }

    public void setProperty(String key, Object value) {
        this.conf.setProperty(this.getKeyName(key), value);
    }

    public void clearProperty(String key) {
        this.conf.clearProperty(this.getKeyName(key));
    }

    public void clear() {
        Iterator keys = this.conf.getKeys();
        keys.forEachRemaining(s -> {
            if (s.startsWith(this.componentPrefix)) {
                this.conf.clearProperty(s);
            }
        });
    }

    public Object getProperty(String key) {
        return this.conf.getProperty(this.getKeyName(key));
    }

    public Iterator<String> getKeys(String prefix) {
        return this.conf.getKeys(this.getKeyName(prefix));
    }

    public Iterator<String> getKeys() {
        return this.conf.getKeys(this.componentPrefix);
    }

    public Properties getProperties(String key) {
        return this.conf.getProperties(this.getKeyName(key));
    }

    public boolean getBoolean(String key) {
        return this.conf.getBoolean(this.getKeyName(key));
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.conf.getBoolean(this.getKeyName(key), defaultValue);
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        return this.conf.getBoolean(this.getKeyName(key), defaultValue);
    }

    public byte getByte(String key) {
        return this.conf.getByte(this.getKeyName(key));
    }

    public byte getByte(String key, byte defaultValue) {
        return this.conf.getByte(this.getKeyName(key), defaultValue);
    }

    public Byte getByte(String key, Byte defaultValue) {
        return this.conf.getByte(this.getKeyName(key), defaultValue);
    }

    public double getDouble(String key) {
        return this.conf.getDouble(this.getKeyName(key));
    }

    public double getDouble(String key, double defaultValue) {
        return this.conf.getDouble(this.getKeyName(key), defaultValue);
    }

    public Double getDouble(String key, Double defaultValue) {
        return this.conf.getDouble(this.getKeyName(key), defaultValue);
    }

    public float getFloat(String key) {
        return this.conf.getFloat(this.getKeyName(key));
    }

    public float getFloat(String key, float defaultValue) {
        return this.conf.getFloat(this.getKeyName(key), defaultValue);
    }

    public Float getFloat(String key, Float defaultValue) {
        return this.conf.getFloat(this.getKeyName(key), defaultValue);
    }

    public int getInt(String key) {
        return this.conf.getInt(this.getKeyName(key));
    }

    public int getInt(String key, int defaultValue) {
        return this.conf.getInt(this.getKeyName(key), defaultValue);
    }

    public Integer getInteger(String key, Integer defaultValue) {
        return this.conf.getInt(this.getKeyName(key), defaultValue.intValue());
    }

    public long getLong(String key) {
        return this.conf.getLong(this.getKeyName(key));
    }

    public long getLong(String key, long defaultValue) {
        return this.conf.getLong(this.getKeyName(key), defaultValue);
    }

    public Long getLong(String key, Long defaultValue) {
        return this.conf.getLong(this.getKeyName(key), defaultValue);
    }

    public short getShort(String key) {
        return this.conf.getShort(this.getKeyName(key));
    }

    public short getShort(String key, short defaultValue) {
        return this.conf.getShort(this.getKeyName(key), defaultValue);
    }

    public Short getShort(String key, Short defaultValue) {
        return this.conf.getShort(this.getKeyName(key), defaultValue);
    }

    public BigDecimal getBigDecimal(String key) {
        return this.conf.getBigDecimal(this.getKeyName(key));
    }

    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        return this.conf.getBigDecimal(this.getKeyName(key), defaultValue);
    }

    public BigInteger getBigInteger(String key) {
        return this.conf.getBigInteger(this.getKeyName(key));
    }

    public BigInteger getBigInteger(String key, BigInteger defaultValue) {
        return this.conf.getBigInteger(this.getKeyName(key), defaultValue);
    }

    public String getString(String key) {
        return this.conf.getString(this.getKeyName(key));
    }

    public String getString(String key, String defaultValue) {
        return this.conf.getString(this.getKeyName(key), defaultValue);
    }

    public String[] getStringArray(String key) {
        return this.conf.getStringArray(this.getKeyName(key));
    }

    public List<Object> getList(String key) {
        return this.conf.getList(this.getKeyName(key));
    }

    public List<Object> getList(String key, List<?> defaultValue) {
        return this.conf.getList(this.getKeyName(key), defaultValue);
    }
}

