/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.component;

import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.common.component.LifecycleComponent;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentStarter {
    private static final Logger log = LoggerFactory.getLogger(ComponentStarter.class);

    public static CompletableFuture<Void> startComponent(LifecycleComponent component) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        Thread shutdownHookThread = new Thread((Runnable)new ComponentShutdownHook(component, future), "component-shutdown-thread");
        Runtime.getRuntime().addShutdownHook(shutdownHookThread);
        component.setExceptionHandler((t, e) -> shutdownHookThread.start());
        log.info("Starting component {}.", (Object)component.getName());
        component.start();
        log.info("Started component {}.", (Object)component.getName());
        return future;
    }

    static class ComponentShutdownHook
    implements Runnable {
        private final LifecycleComponent component;
        private final CompletableFuture<Void> future;

        ComponentShutdownHook(LifecycleComponent component, CompletableFuture<Void> future) {
            this.component = component;
            this.future = future;
        }

        @Override
        public void run() {
            log.info("Closing component {} in shutdown hook.", (Object)this.component.getName());
            try {
                this.component.close();
                log.info("Closed component {} in shutdown hook successfully. Exiting.", (Object)this.component.getName());
                FutureUtils.complete(this.future, null);
            }
            catch (Exception e) {
                log.error("Failed to close component {} in shutdown hook gracefully, Exiting anyway", (Object)this.component.getName(), (Object)e);
                this.future.completeExceptionally(e);
            }
        }
    }
}

