/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.conf;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.bookkeeper.common.annotation.InterfaceAudience;
import org.apache.bookkeeper.common.conf.ConfigException;
import org.apache.bookkeeper.common.conf.ConfigKeyGroup;
import org.apache.bookkeeper.common.conf.Type;
import org.apache.bookkeeper.common.conf.Validator;
import org.apache.bookkeeper.common.conf.validators.NullValidator;
import org.apache.bookkeeper.common.util.ReflectionUtils;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class ConfigKey {
    private static final Logger log = LoggerFactory.getLogger(ConfigKey.class);
    public static final Comparator<ConfigKey> ORDERING = (o1, o2) -> {
        int ret = Integer.compare(o1.orderInGroup, o2.orderInGroup);
        if (ret == 0) {
            return o1.name().compareTo(o2.name());
        }
        return ret;
    };
    private boolean required;
    private String name;
    private Type type;
    private String description;
    private String documentation;
    private Object defaultValue;
    private List<String> optionValues;
    private Validator validator;
    private ConfigKeyGroup group;
    private int orderInGroup;
    private List<String> dependents;
    private boolean deprecated;
    private String deprecatedByConfigKey;
    private String deprecatedSince;
    private String since;

    public static ConfigKeyBuilder builder(String name) {
        return ConfigKey.internalBuilder().name(name);
    }

    private String defaultValueAsString() {
        if (null == this.defaultValue) {
            return null;
        }
        if (this.defaultValue instanceof String) {
            return (String)this.defaultValue;
        }
        if (this.defaultValue instanceof Class) {
            return ((Class)this.defaultValue).getName();
        }
        return this.defaultValue.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ConfigKey)) {
            return false;
        }
        ConfigKey other = (ConfigKey)o;
        return Objects.equals(this.name, other.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public void validate(Configuration conf) throws ConfigException {
        if (conf.containsKey(this.name()) && this.validator() != null) {
            Object value = this.get(conf);
            if (!this.validator().validate(this.name(), value)) {
                throw new ConfigException("Invalid setting of '" + this.name() + "' found the configuration: value = '" + value + "', requirement = '" + this.validator + "'");
            }
        } else if (this.required()) {
            throw new ConfigException("Setting '" + this.name() + "' is required but missing in the configuration");
        }
    }

    public void set(Configuration conf, Object value) {
        if (!this.type().validator().validate(this.name(), value)) {
            throw new IllegalArgumentException("Invalid value '" + value + "' to set on setting '" + this.name() + "': expected type = " + (Object)((Object)this.type));
        }
        if (null != this.validator() && !this.validator().validate(this.name(), value)) {
            throw new IllegalArgumentException("Invalid value '" + value + "' to set on setting '" + this.name() + "': required '" + this.validator() + "'");
        }
        if (value instanceof Class) {
            conf.setProperty(this.name(), (Object)((Class)value).getName());
        } else {
            conf.setProperty(this.name(), value);
        }
    }

    public long getLong(Configuration conf) {
        Preconditions.checkArgument((this.type() == Type.LONG ? 1 : 0) != 0, (Object)("'" + this.name() + "' is NOT a LONG numeric setting"));
        return conf.getLong(this.name(), (Long)this.defaultValue());
    }

    public int getInt(Configuration conf) {
        Preconditions.checkArgument((this.type() == Type.INT ? 1 : 0) != 0, (Object)("'" + this.name() + "' is NOT a INT numeric setting"));
        return conf.getInt(this.name(), ((Integer)this.defaultValue()).intValue());
    }

    public short getShort(Configuration conf) {
        Preconditions.checkArgument((this.type() == Type.SHORT ? 1 : 0) != 0, (Object)("'" + this.name() + "' is NOT a SHORT numeric setting"));
        return conf.getShort(this.name(), (Short)this.defaultValue());
    }

    public boolean getBoolean(Configuration conf) {
        Preconditions.checkArgument((this.type() == Type.BOOLEAN ? 1 : 0) != 0, (Object)("'" + this.name() + "' is NOT a BOOL numeric setting"));
        return conf.getBoolean(this.name(), (Boolean)this.defaultValue());
    }

    public double getDouble(Configuration conf) {
        Preconditions.checkArgument((this.type() == Type.DOUBLE ? 1 : 0) != 0, (Object)("'" + this.name() + "' is NOT a DOUBLE numeric setting"));
        return conf.getDouble(this.name(), (Double)this.defaultValue());
    }

    public String getString(Configuration conf) {
        return conf.getString(this.name(), this.defaultValueAsString());
    }

    public <T> Class<? extends T> getClass(Configuration conf, Class<T> interfaceCls) {
        Preconditions.checkArgument((this.type() == Type.CLASS ? 1 : 0) != 0, (Object)("'" + this.name() + "' is NOT a CLASS setting"));
        try {
            Class defaultClass = (Class)this.defaultValue();
            return ReflectionUtils.getClass(conf, this.name(), defaultClass, interfaceCls, this.getClass().getClassLoader());
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException("Invalid class is set to setting '" + this.name() + "': ", e);
        }
    }

    public Class<?> getClass(Configuration conf) {
        Preconditions.checkArgument((this.type() == Type.CLASS ? 1 : 0) != 0, (Object)("'" + this.name() + "' is NOT a CLASS setting"));
        try {
            Class defaultClass = (Class)this.defaultValue();
            return ReflectionUtils.getClass(conf, this.name(), defaultClass, this.getClass().getClassLoader());
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException("Invalid class is set to setting '" + this.name() + "': ", e);
        }
    }

    public List<Object> getList(Configuration conf) {
        Preconditions.checkArgument((this.type() == Type.LIST ? 1 : 0) != 0, (Object)("'" + this.name() + "' is NOT a LIST setting"));
        List list = (List)this.defaultValue();
        if (null == list) {
            list = Collections.emptyList();
        }
        return conf.getList(this.name(), list);
    }

    public Object get(Configuration conf) {
        switch (this.type()) {
            case LONG: {
                return this.getLong(conf);
            }
            case INT: {
                return this.getInt(conf);
            }
            case SHORT: {
                return this.getShort(conf);
            }
            case DOUBLE: {
                return this.getDouble(conf);
            }
            case BOOLEAN: {
                return this.getBoolean(conf);
            }
            case LIST: {
                return this.getList(conf);
            }
            case CLASS: {
                return this.getClass(conf);
            }
        }
        return this.getString(conf);
    }

    private static boolean $default$required() {
        return false;
    }

    private static Type $default$type() {
        return Type.STRING;
    }

    private static String $default$description() {
        return "";
    }

    private static String $default$documentation() {
        return "";
    }

    private static Object $default$defaultValue() {
        return null;
    }

    private static List<String> $default$optionValues() {
        return Collections.emptyList();
    }

    private static Validator $default$validator() {
        return NullValidator.of();
    }

    private static ConfigKeyGroup $default$group() {
        return ConfigKeyGroup.DEFAULT;
    }

    private static int $default$orderInGroup() {
        return Integer.MIN_VALUE;
    }

    private static List<String> $default$dependents() {
        return Collections.emptyList();
    }

    private static boolean $default$deprecated() {
        return false;
    }

    private static String $default$deprecatedByConfigKey() {
        return "";
    }

    private static String $default$deprecatedSince() {
        return "";
    }

    private static String $default$since() {
        return "";
    }

    ConfigKey(boolean required, String name, Type type, String description, String documentation, Object defaultValue, List<String> optionValues, Validator validator, ConfigKeyGroup group, int orderInGroup, List<String> dependents, boolean deprecated, String deprecatedByConfigKey, String deprecatedSince, String since) {
        this.required = required;
        this.name = name;
        this.type = type;
        this.description = description;
        this.documentation = documentation;
        this.defaultValue = defaultValue;
        this.optionValues = optionValues;
        this.validator = validator;
        this.group = group;
        this.orderInGroup = orderInGroup;
        this.dependents = dependents;
        this.deprecated = deprecated;
        this.deprecatedByConfigKey = deprecatedByConfigKey;
        this.deprecatedSince = deprecatedSince;
        this.since = since;
    }

    public static ConfigKeyBuilder internalBuilder() {
        return new ConfigKeyBuilder();
    }

    private ConfigKey() {
    }

    public boolean required() {
        return this.required;
    }

    public String name() {
        return this.name;
    }

    public Type type() {
        return this.type;
    }

    public String description() {
        return this.description;
    }

    public String documentation() {
        return this.documentation;
    }

    public Object defaultValue() {
        return this.defaultValue;
    }

    public List<String> optionValues() {
        return this.optionValues;
    }

    public Validator validator() {
        return this.validator;
    }

    public ConfigKeyGroup group() {
        return this.group;
    }

    public int orderInGroup() {
        return this.orderInGroup;
    }

    public List<String> dependents() {
        return this.dependents;
    }

    public boolean deprecated() {
        return this.deprecated;
    }

    public String deprecatedByConfigKey() {
        return this.deprecatedByConfigKey;
    }

    public String deprecatedSince() {
        return this.deprecatedSince;
    }

    public String since() {
        return this.since;
    }

    public ConfigKey required(boolean required) {
        this.required = required;
        return this;
    }

    public ConfigKey name(String name) {
        this.name = name;
        return this;
    }

    public ConfigKey type(Type type) {
        this.type = type;
        return this;
    }

    public ConfigKey description(String description) {
        this.description = description;
        return this;
    }

    public ConfigKey documentation(String documentation) {
        this.documentation = documentation;
        return this;
    }

    public ConfigKey defaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public ConfigKey optionValues(List<String> optionValues) {
        this.optionValues = optionValues;
        return this;
    }

    public ConfigKey validator(Validator validator) {
        this.validator = validator;
        return this;
    }

    public ConfigKey group(ConfigKeyGroup group) {
        this.group = group;
        return this;
    }

    public ConfigKey orderInGroup(int orderInGroup) {
        this.orderInGroup = orderInGroup;
        return this;
    }

    public ConfigKey dependents(List<String> dependents) {
        this.dependents = dependents;
        return this;
    }

    public ConfigKey deprecated(boolean deprecated) {
        this.deprecated = deprecated;
        return this;
    }

    public ConfigKey deprecatedByConfigKey(String deprecatedByConfigKey) {
        this.deprecatedByConfigKey = deprecatedByConfigKey;
        return this;
    }

    public ConfigKey deprecatedSince(String deprecatedSince) {
        this.deprecatedSince = deprecatedSince;
        return this;
    }

    public ConfigKey since(String since) {
        this.since = since;
        return this;
    }

    public String toString() {
        return "ConfigKey(required=" + this.required() + ", name=" + this.name() + ", type=" + (Object)((Object)this.type()) + ", description=" + this.description() + ", documentation=" + this.documentation() + ", defaultValue=" + this.defaultValue() + ", optionValues=" + this.optionValues() + ", validator=" + this.validator() + ", group=" + this.group() + ", orderInGroup=" + this.orderInGroup() + ", dependents=" + this.dependents() + ", deprecated=" + this.deprecated() + ", deprecatedByConfigKey=" + this.deprecatedByConfigKey() + ", deprecatedSince=" + this.deprecatedSince() + ", since=" + this.since() + ")";
    }

    public static class ConfigKeyBuilder {
        private boolean required$set;
        private boolean required;
        private String name;
        private boolean type$set;
        private Type type;
        private boolean description$set;
        private String description;
        private boolean documentation$set;
        private String documentation;
        private boolean defaultValue$set;
        private Object defaultValue;
        private boolean optionValues$set;
        private List<String> optionValues;
        private boolean validator$set;
        private Validator validator;
        private boolean group$set;
        private ConfigKeyGroup group;
        private boolean orderInGroup$set;
        private int orderInGroup;
        private boolean dependents$set;
        private List<String> dependents;
        private boolean deprecated$set;
        private boolean deprecated;
        private boolean deprecatedByConfigKey$set;
        private String deprecatedByConfigKey;
        private boolean deprecatedSince$set;
        private String deprecatedSince;
        private boolean since$set;
        private String since;

        ConfigKeyBuilder() {
        }

        public ConfigKeyBuilder required(boolean required) {
            this.required = required;
            this.required$set = true;
            return this;
        }

        public ConfigKeyBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ConfigKeyBuilder type(Type type) {
            this.type = type;
            this.type$set = true;
            return this;
        }

        public ConfigKeyBuilder description(String description) {
            this.description = description;
            this.description$set = true;
            return this;
        }

        public ConfigKeyBuilder documentation(String documentation) {
            this.documentation = documentation;
            this.documentation$set = true;
            return this;
        }

        public ConfigKeyBuilder defaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
            this.defaultValue$set = true;
            return this;
        }

        public ConfigKeyBuilder optionValues(List<String> optionValues) {
            this.optionValues = optionValues;
            this.optionValues$set = true;
            return this;
        }

        public ConfigKeyBuilder validator(Validator validator) {
            this.validator = validator;
            this.validator$set = true;
            return this;
        }

        public ConfigKeyBuilder group(ConfigKeyGroup group) {
            this.group = group;
            this.group$set = true;
            return this;
        }

        public ConfigKeyBuilder orderInGroup(int orderInGroup) {
            this.orderInGroup = orderInGroup;
            this.orderInGroup$set = true;
            return this;
        }

        public ConfigKeyBuilder dependents(List<String> dependents) {
            this.dependents = dependents;
            this.dependents$set = true;
            return this;
        }

        public ConfigKeyBuilder deprecated(boolean deprecated) {
            this.deprecated = deprecated;
            this.deprecated$set = true;
            return this;
        }

        public ConfigKeyBuilder deprecatedByConfigKey(String deprecatedByConfigKey) {
            this.deprecatedByConfigKey = deprecatedByConfigKey;
            this.deprecatedByConfigKey$set = true;
            return this;
        }

        public ConfigKeyBuilder deprecatedSince(String deprecatedSince) {
            this.deprecatedSince = deprecatedSince;
            this.deprecatedSince$set = true;
            return this;
        }

        public ConfigKeyBuilder since(String since) {
            this.since = since;
            this.since$set = true;
            return this;
        }

        public ConfigKey build() {
            boolean required = this.required;
            if (!this.required$set) {
                required = ConfigKey.$default$required();
            }
            Type type = this.type;
            if (!this.type$set) {
                type = ConfigKey.$default$type();
            }
            String description = this.description;
            if (!this.description$set) {
                description = ConfigKey.$default$description();
            }
            String documentation = this.documentation;
            if (!this.documentation$set) {
                documentation = ConfigKey.$default$documentation();
            }
            Object defaultValue = this.defaultValue;
            if (!this.defaultValue$set) {
                defaultValue = ConfigKey.$default$defaultValue();
            }
            List optionValues = this.optionValues;
            if (!this.optionValues$set) {
                optionValues = ConfigKey.$default$optionValues();
            }
            Validator validator = this.validator;
            if (!this.validator$set) {
                validator = ConfigKey.$default$validator();
            }
            ConfigKeyGroup group = this.group;
            if (!this.group$set) {
                group = ConfigKey.$default$group();
            }
            int orderInGroup = this.orderInGroup;
            if (!this.orderInGroup$set) {
                orderInGroup = ConfigKey.$default$orderInGroup();
            }
            List dependents = this.dependents;
            if (!this.dependents$set) {
                dependents = ConfigKey.$default$dependents();
            }
            boolean deprecated = this.deprecated;
            if (!this.deprecated$set) {
                deprecated = ConfigKey.$default$deprecated();
            }
            String deprecatedByConfigKey = this.deprecatedByConfigKey;
            if (!this.deprecatedByConfigKey$set) {
                deprecatedByConfigKey = ConfigKey.$default$deprecatedByConfigKey();
            }
            String deprecatedSince = this.deprecatedSince;
            if (!this.deprecatedSince$set) {
                deprecatedSince = ConfigKey.$default$deprecatedSince();
            }
            String since = this.since;
            if (!this.since$set) {
                since = ConfigKey.$default$since();
            }
            return new ConfigKey(required, this.name, type, description, documentation, defaultValue, optionValues, validator, group, orderInGroup, dependents, deprecated, deprecatedByConfigKey, deprecatedSince, since);
        }

        public String toString() {
            return "ConfigKey.ConfigKeyBuilder(required=" + this.required + ", name=" + this.name + ", type=" + (Object)((Object)this.type) + ", description=" + this.description + ", documentation=" + this.documentation + ", defaultValue=" + this.defaultValue + ", optionValues=" + this.optionValues + ", validator=" + this.validator + ", group=" + this.group + ", orderInGroup=" + this.orderInGroup + ", dependents=" + this.dependents + ", deprecated=" + this.deprecated + ", deprecatedByConfigKey=" + this.deprecatedByConfigKey + ", deprecatedSince=" + this.deprecatedSince + ", since=" + this.since + ")";
        }
    }
}

