/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.conf;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.bookkeeper.common.annotation.InterfaceAudience;

@InterfaceAudience.Public
public class ConfigKeyGroup {
    public static final Comparator<ConfigKeyGroup> ORDERING = (o1, o2) -> {
        int ret = Integer.compare(o1.order, o2.order);
        if (0 == ret) {
            return o1.name().compareTo(o2.name());
        }
        return ret;
    };
    public static final ConfigKeyGroup DEFAULT = ConfigKeyGroup.builder("").build();
    private String name;
    private String description;
    private List<String> children;
    private int order;

    public static ConfigKeyGroupBuilder builder(String name) {
        return ConfigKeyGroup.internalBuilder().name(name);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ConfigKeyGroup)) {
            return false;
        }
        ConfigKeyGroup other = (ConfigKeyGroup)o;
        return Objects.equals(this.name, other.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    private static String $default$description() {
        return "";
    }

    private static List<String> $default$children() {
        return Collections.emptyList();
    }

    private static int $default$order() {
        return Integer.MIN_VALUE;
    }

    ConfigKeyGroup(String name, String description, List<String> children, int order) {
        this.name = name;
        this.description = description;
        this.children = children;
        this.order = order;
    }

    public static ConfigKeyGroupBuilder internalBuilder() {
        return new ConfigKeyGroupBuilder();
    }

    private ConfigKeyGroup() {
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public List<String> children() {
        return this.children;
    }

    public int order() {
        return this.order;
    }

    public ConfigKeyGroup name(String name) {
        this.name = name;
        return this;
    }

    public ConfigKeyGroup description(String description) {
        this.description = description;
        return this;
    }

    public ConfigKeyGroup children(List<String> children) {
        this.children = children;
        return this;
    }

    public ConfigKeyGroup order(int order) {
        this.order = order;
        return this;
    }

    public String toString() {
        return "ConfigKeyGroup(name=" + this.name() + ", description=" + this.description() + ", children=" + this.children() + ", order=" + this.order() + ")";
    }

    public static class ConfigKeyGroupBuilder {
        private String name;
        private boolean description$set;
        private String description;
        private boolean children$set;
        private List<String> children;
        private boolean order$set;
        private int order;

        ConfigKeyGroupBuilder() {
        }

        public ConfigKeyGroupBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ConfigKeyGroupBuilder description(String description) {
            this.description = description;
            this.description$set = true;
            return this;
        }

        public ConfigKeyGroupBuilder children(List<String> children) {
            this.children = children;
            this.children$set = true;
            return this;
        }

        public ConfigKeyGroupBuilder order(int order) {
            this.order = order;
            this.order$set = true;
            return this;
        }

        public ConfigKeyGroup build() {
            String description = this.description;
            if (!this.description$set) {
                description = ConfigKeyGroup.$default$description();
            }
            List children = this.children;
            if (!this.children$set) {
                children = ConfigKeyGroup.$default$children();
            }
            int order = this.order;
            if (!this.order$set) {
                order = ConfigKeyGroup.$default$order();
            }
            return new ConfigKeyGroup(this.name, description, children, order);
        }

        public String toString() {
            return "ConfigKeyGroup.ConfigKeyGroupBuilder(name=" + this.name + ", description=" + this.description + ", children=" + this.children + ", order=" + this.order + ")";
        }
    }
}

