/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.util;

import java.util.function.Function;
import org.apache.bookkeeper.common.collections.RecyclableArrayList;
import org.apache.bookkeeper.common.util.Recyclable;
import org.apache.bookkeeper.common.util.Watcher;
import org.apache.bookkeeper.shaded.com.google.common.base.Preconditions;

public class Watchable<T>
implements Recyclable {
    private final RecyclableArrayList.Recycler<Watcher<T>> recycler;
    private RecyclableArrayList<Watcher<T>> watchers;

    public Watchable(RecyclableArrayList.Recycler<Watcher<T>> recycler) {
        this.recycler = recycler;
        this.watchers = recycler.newInstance();
    }

    synchronized int getNumWatchers() {
        return this.watchers.size();
    }

    public synchronized boolean addWatcher(Watcher<T> w) {
        Preconditions.checkNotNull(w, "Null watcher is provided");
        return this.watchers.add(w);
    }

    public synchronized boolean deleteWatcher(Watcher<T> w) {
        return this.watchers.remove(w);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> void notifyWatchers(Function<R, T> valueFn, R value) {
        RecyclableArrayList<Watcher<T>> watchersLocal;
        Watchable watchable = this;
        synchronized (watchable) {
            watchersLocal = this.watchers;
            this.watchers = this.recycler.newInstance();
        }
        for (Watcher watcher : watchersLocal) {
            watcher.update(valueFn.apply(value));
        }
        watchersLocal.recycle();
    }

    public synchronized void deleteWatchers() {
        this.watchers.clear();
    }

    @Override
    public synchronized void recycle() {
        this.watchers.recycle();
    }
}

