/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import io.netty.buffer.ByteBuf;
import io.netty.util.Recycler;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.common.concurrent.FutureEventListener;
import org.apache.bookkeeper.proto.BookieProtocol;
import org.apache.bookkeeper.proto.BookieRequestHandler;
import org.apache.bookkeeper.proto.BookieRequestProcessor;
import org.apache.bookkeeper.proto.PacketProcessorBase;
import org.apache.bookkeeper.proto.RequestStats;
import org.apache.bookkeeper.proto.ResponseBuilder;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.util.MathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReadEntryProcessor
extends PacketProcessorBase<BookieProtocol.ReadRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(ReadEntryProcessor.class);
    private ExecutorService fenceThreadPool;
    private boolean throttleReadResponses;
    private final Recycler.Handle<ReadEntryProcessor> recyclerHandle;
    private static final Recycler<ReadEntryProcessor> RECYCLER = new Recycler<ReadEntryProcessor>(){

        protected ReadEntryProcessor newObject(Recycler.Handle<ReadEntryProcessor> handle) {
            return new ReadEntryProcessor(handle);
        }
    };

    public static ReadEntryProcessor create(BookieProtocol.ReadRequest request, BookieRequestHandler requestHandler, BookieRequestProcessor requestProcessor, ExecutorService fenceThreadPool, boolean throttleReadResponses) {
        ReadEntryProcessor rep = (ReadEntryProcessor)RECYCLER.get();
        rep.init(request, requestHandler, requestProcessor);
        rep.fenceThreadPool = fenceThreadPool;
        rep.throttleReadResponses = throttleReadResponses;
        requestProcessor.onReadRequestStart(requestHandler.ctx().channel());
        return rep;
    }

    @Override
    protected void processPacket() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received new read request: {}", (Object)this.request);
        }
        if (!this.requestHandler.ctx().channel().isOpen()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Dropping read request for closed channel: {}", (Object)this.requestHandler.ctx().channel());
            }
            this.requestProcessor.onReadRequestFinish();
            return;
        }
        int errorCode = 0;
        long startTimeNanos = MathUtils.nowInNano();
        ByteBuf data = null;
        try {
            CompletableFuture<Boolean> fenceResult = null;
            if (((BookieProtocol.ReadRequest)this.request).isFencing()) {
                LOG.warn("Ledger: {}  fenced by: {}", (Object)((BookieProtocol.ReadRequest)this.request).getLedgerId(), (Object)this.requestHandler.ctx().channel().remoteAddress());
                if (((BookieProtocol.ReadRequest)this.request).hasMasterKey()) {
                    fenceResult = this.requestProcessor.getBookie().fenceLedger(((BookieProtocol.ReadRequest)this.request).getLedgerId(), ((BookieProtocol.ReadRequest)this.request).getMasterKey());
                } else {
                    LOG.error("Password not provided, Not safe to fence {}", (Object)((BookieProtocol.ReadRequest)this.request).getLedgerId());
                    throw BookieException.create(-1);
                }
            }
            data = this.requestProcessor.getBookie().readEntry(((BookieProtocol.ReadRequest)this.request).getLedgerId(), ((BookieProtocol.ReadRequest)this.request).getEntryId());
            if (LOG.isDebugEnabled()) {
                LOG.debug("##### Read entry ##### {} -- ref-count: {}", (Object)data.readableBytes(), (Object)data.refCnt());
            }
            if (fenceResult != null) {
                this.handleReadResultForFenceRead(fenceResult, data, startTimeNanos);
                return;
            }
        }
        catch (Bookie.NoLedgerException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Error reading {}", (Object)this.request, (Object)e);
            }
            errorCode = 1;
        }
        catch (Bookie.NoEntryException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Error reading {}", (Object)this.request, (Object)e);
            }
            errorCode = 2;
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Error reading {}", (Object)this.request, (Object)e);
            }
            errorCode = 101;
        }
        catch (BookieException.DataUnknownException e) {
            LOG.error("Ledger {} is in an unknown state", (Object)((BookieProtocol.ReadRequest)this.request).getLedgerId(), (Object)e);
            errorCode = 107;
        }
        catch (BookieException e) {
            LOG.error("Unauthorized access to ledger {}", (Object)((BookieProtocol.ReadRequest)this.request).getLedgerId(), (Object)e);
            errorCode = 102;
        }
        catch (Throwable t) {
            LOG.error("Unexpected exception reading at {}:{} : {}", new Object[]{((BookieProtocol.ReadRequest)this.request).getLedgerId(), ((BookieProtocol.ReadRequest)this.request).getEntryId(), t.getMessage(), t});
            errorCode = 100;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Read entry rc = {} for {}", (Object)errorCode, (Object)this.request);
        }
        this.sendResponse(data, errorCode, startTimeNanos);
    }

    private void sendResponse(ByteBuf data, int errorCode, long startTimeNanos) {
        BookieProtocol.Response response;
        RequestStats stats = this.requestProcessor.getRequestStats();
        OpStatsLogger logger = stats.getReadEntryStats();
        if (errorCode == 0) {
            logger.registerSuccessfulEvent(MathUtils.elapsedNanos(startTimeNanos), TimeUnit.NANOSECONDS);
            response = ResponseBuilder.buildReadResponse(data, this.request);
        } else {
            if (data != null) {
                ReferenceCountUtil.release((Object)data);
            }
            logger.registerFailedEvent(MathUtils.elapsedNanos(startTimeNanos), TimeUnit.NANOSECONDS);
            response = ResponseBuilder.buildErrorResponse(errorCode, this.request);
        }
        this.sendReadReqResponse(errorCode, response, stats.getReadRequestStats(), this.throttleReadResponses);
        this.recycle();
    }

    private void sendFenceResponse(Boolean result, ByteBuf data, long startTimeNanos) {
        int retCode = result != null && result != false ? 0 : 101;
        this.sendResponse(data, retCode, startTimeNanos);
    }

    private void handleReadResultForFenceRead(CompletableFuture<Boolean> fenceResult, final ByteBuf data, final long startTimeNanos) {
        if (null != this.fenceThreadPool) {
            fenceResult.whenCompleteAsync(new FutureEventListener<Boolean>(){

                @Override
                public void onSuccess(Boolean result) {
                    ReadEntryProcessor.this.sendFenceResponse(result, data, startTimeNanos);
                }

                @Override
                public void onFailure(Throwable t) {
                    LOG.error("Error processing fence request", t);
                    ReadEntryProcessor.this.sendResponse(data, 101, startTimeNanos);
                }
            }, (Executor)this.fenceThreadPool);
        } else {
            try {
                Boolean fenced = fenceResult.get(1000L, TimeUnit.MILLISECONDS);
                this.sendFenceResponse(fenced, data, startTimeNanos);
                return;
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                LOG.error("Interrupting fence read entry {}", (Object)this.request, (Object)ie);
            }
            catch (ExecutionException ee) {
                LOG.error("Failed to fence read entry {}", (Object)this.request, (Object)ee.getCause());
            }
            catch (TimeoutException te) {
                LOG.error("Timeout to fence read entry {}", (Object)this.request, (Object)te);
            }
            this.sendResponse(data, 101, startTimeNanos);
        }
    }

    public String toString() {
        return String.format("ReadEntry(%d, %d)", ((BookieProtocol.ReadRequest)this.request).getLedgerId(), ((BookieProtocol.ReadRequest)this.request).getEntryId());
    }

    private void recycle() {
        ((BookieProtocol.ReadRequest)this.request).recycle();
        super.reset();
        this.recyclerHandle.recycle((Object)this);
    }

    private ReadEntryProcessor(Recycler.Handle<ReadEntryProcessor> recyclerHandle) {
        this.recyclerHandle = recyclerHandle;
    }
}

