/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.Gauge;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stats.annotations.StatsDoc;

@StatsDoc(name="bookkeeper_server", category="server", help="Bookie request stats")
public class RequestStats {
    final AtomicInteger addsInProgress = new AtomicInteger(0);
    final AtomicInteger maxAddsInProgress = new AtomicInteger(0);
    final AtomicInteger addsBlocked = new AtomicInteger(0);
    final AtomicInteger readsInProgress = new AtomicInteger(0);
    final AtomicInteger readsBlocked = new AtomicInteger(0);
    final AtomicInteger maxReadsInProgress = new AtomicInteger(0);
    @StatsDoc(name="ADD_ENTRY_REQUEST", help="request stats of AddEntry on a bookie")
    private final OpStatsLogger addRequestStats;
    @StatsDoc(name="ADD_ENTRY", help="operation stats of AddEntry on a bookie", parent="ADD_ENTRY_REQUEST")
    private final OpStatsLogger addEntryStats;
    @StatsDoc(name="WRITE_THREAD_QUEUED_LATENCY", help="operation stats of enqueuing requests to write threadpool queue", parent="ADD_ENTRY_REQUEST")
    private final OpStatsLogger writeThreadQueuedLatency;
    @StatsDoc(name="ADD_ENTRY_REJECTED", help="Counter for rejected adds on a bookie", parent="ADD_ENTRY_REQUEST")
    private final Counter addEntryRejectedCounter;
    @StatsDoc(name="READ_ENTRY_REQUEST", help="request stats of ReadEntry on a bookie")
    final OpStatsLogger readRequestStats;
    @StatsDoc(name="READ_ENTRY", help="operation stats of ReadEntry on a bookie", parent="READ_ENTRY_REQUEST")
    final OpStatsLogger readEntryStats;
    @StatsDoc(name="READ_ENTRY_REJECTED", help="Counter for rejected reads on a bookie", parent="READ_ENTRY_REQUEST")
    private final Counter readEntryRejectedCounter;
    @StatsDoc(name="FORCE_LEDGER", help="operation stats of ForceLedger on a bookie", parent="FORCE_LEDGER_REQUEST")
    final OpStatsLogger forceLedgerStats;
    @StatsDoc(name="FORCE_LEDGER_REQUEST", help="request stats of ForceLedger on a bookie")
    final OpStatsLogger forceLedgerRequestStats;
    @StatsDoc(name="READ_ENTRY_FENCE_REQUEST", help="request stats of FenceRead on a bookie")
    final OpStatsLogger fenceReadRequestStats;
    @StatsDoc(name="READ_ENTRY_FENCE_READ", help="operation stats of FenceRead on a bookie", parent="READ_ENTRY_FENCE_REQUEST", happensAfter="READ_ENTRY_FENCE_WAIT")
    final OpStatsLogger fenceReadEntryStats;
    @StatsDoc(name="READ_ENTRY_FENCE_WAIT", help="operation stats of FenceReadWait on a bookie", parent="READ_ENTRY_FENCE_REQUEST")
    final OpStatsLogger fenceReadWaitStats;
    @StatsDoc(name="READ_ENTRY_SCHEDULING_DELAY", help="operation stats of ReadEntry scheduling delays on a bookie")
    final OpStatsLogger readEntrySchedulingDelayStats;
    @StatsDoc(name="READ_ENTRY_LONG_POLL_PRE_WAIT", help="operation stats of LongPoll Reads pre wait time on a bookie", parent="READ_ENTRY_LONG_POLL_REQUEST")
    final OpStatsLogger longPollPreWaitStats;
    @StatsDoc(name="READ_ENTRY_LONG_POLL_WAIT", help="operation stats of LongPoll Reads wait time on a bookie", happensAfter="READ_ENTRY_LONG_POLL_PRE_WAIT", parent="READ_ENTRY_LONG_POLL_REQUEST")
    final OpStatsLogger longPollWaitStats;
    @StatsDoc(name="READ_ENTRY_LONG_POLL_READ", help="operation stats of LongPoll Reads on a bookie", happensAfter="READ_ENTRY_LONG_POLL_WAIT", parent="READ_ENTRY_LONG_POLL_REQUEST")
    final OpStatsLogger longPollReadStats;
    @StatsDoc(name="READ_ENTRY_LONG_POLL_REQUEST", help="request stats of LongPoll Reads on a bookie")
    final OpStatsLogger longPollReadRequestStats;
    @StatsDoc(name="READ_LAST_ENTRY_NOENTRY_ERROR", help="total NOENTRY errors of reading last entry on a bookie")
    final Counter readLastEntryNoEntryErrorCounter;
    @StatsDoc(name="WRITE_LAC_REQUEST", help="request stats of WriteLac on a bookie")
    final OpStatsLogger writeLacRequestStats;
    @StatsDoc(name="WRITE_LAC", help="operation stats of WriteLac on a bookie", parent="WRITE_LAC_REQUEST")
    final OpStatsLogger writeLacStats;
    @StatsDoc(name="READ_LAC_REQUEST", help="request stats of ReadLac on a bookie")
    final OpStatsLogger readLacRequestStats;
    @StatsDoc(name="READ_LAC", help="operation stats of ReadLac on a bookie", parent="READ_LAC_REQUEST")
    final OpStatsLogger readLacStats;
    @StatsDoc(name="GET_BOOKIE_INFO_REQUEST", help="request stats of GetBookieInfo on a bookie")
    final OpStatsLogger getBookieInfoRequestStats;
    @StatsDoc(name="GET_BOOKIE_INFO", help="operation stats of GetBookieInfo on a bookie")
    final OpStatsLogger getBookieInfoStats;
    @StatsDoc(name="CHANNEL_WRITE", help="channel write stats on a bookie")
    final OpStatsLogger channelWriteStats;
    @StatsDoc(name="ADD_ENTRY_BLOCKED", help="operation stats of AddEntry blocked on a bookie")
    final OpStatsLogger addEntryBlockedStats;
    @StatsDoc(name="READ_ENTRY_BLOCKED", help="operation stats of ReadEntry blocked on a bookie")
    final OpStatsLogger readEntryBlockedStats;
    @StatsDoc(name="GET_LIST_OF_ENTRIES_OF_LEDGER_REQUEST", help="request stats of GetListOfEntriesOfLedger on a bookie")
    final OpStatsLogger getListOfEntriesOfLedgerRequestStats;
    @StatsDoc(name="GET_LIST_OF_ENTRIES_OF_LEDGER", help="operation stats of GetListOfEntriesOfLedger", parent="GET_LIST_OF_ENTRIES_OF_LEDGER_REQUEST")
    final OpStatsLogger getListOfEntriesOfLedgerStats;

    public RequestStats(StatsLogger statsLogger) {
        this.addEntryStats = statsLogger.getThreadScopedOpStatsLogger("ADD_ENTRY");
        this.writeThreadQueuedLatency = statsLogger.getThreadScopedOpStatsLogger("WRITE_THREAD_QUEUED_LATENCY");
        this.addRequestStats = statsLogger.getOpStatsLogger("ADD_ENTRY_REQUEST");
        this.addEntryRejectedCounter = statsLogger.getCounter("ADD_ENTRY_REJECTED");
        this.readEntryStats = statsLogger.getThreadScopedOpStatsLogger("READ_ENTRY");
        this.readEntryRejectedCounter = statsLogger.getCounter("READ_ENTRY_REJECTED");
        this.forceLedgerStats = statsLogger.getOpStatsLogger("FORCE_LEDGER");
        this.forceLedgerRequestStats = statsLogger.getOpStatsLogger("FORCE_LEDGER_REQUEST");
        this.readRequestStats = statsLogger.getOpStatsLogger("READ_ENTRY_REQUEST");
        this.fenceReadEntryStats = statsLogger.getOpStatsLogger("READ_ENTRY_FENCE_READ");
        this.fenceReadRequestStats = statsLogger.getOpStatsLogger("READ_ENTRY_FENCE_REQUEST");
        this.fenceReadWaitStats = statsLogger.getOpStatsLogger("READ_ENTRY_FENCE_WAIT");
        this.readEntrySchedulingDelayStats = statsLogger.getOpStatsLogger("READ_ENTRY_SCHEDULING_DELAY");
        this.longPollPreWaitStats = statsLogger.getOpStatsLogger("READ_ENTRY_LONG_POLL_PRE_WAIT");
        this.longPollWaitStats = statsLogger.getOpStatsLogger("READ_ENTRY_LONG_POLL_WAIT");
        this.longPollReadStats = statsLogger.getOpStatsLogger("READ_ENTRY_LONG_POLL_READ");
        this.longPollReadRequestStats = statsLogger.getOpStatsLogger("READ_ENTRY_LONG_POLL_REQUEST");
        this.readLastEntryNoEntryErrorCounter = statsLogger.getCounter("READ_LAST_ENTRY_NOENTRY_ERROR");
        this.writeLacStats = statsLogger.getOpStatsLogger("WRITE_LAC");
        this.writeLacRequestStats = statsLogger.getOpStatsLogger("WRITE_LAC_REQUEST");
        this.readLacStats = statsLogger.getOpStatsLogger("READ_LAC");
        this.readLacRequestStats = statsLogger.getOpStatsLogger("READ_LAC_REQUEST");
        this.getBookieInfoStats = statsLogger.getOpStatsLogger("GET_BOOKIE_INFO");
        this.getBookieInfoRequestStats = statsLogger.getOpStatsLogger("GET_BOOKIE_INFO_REQUEST");
        this.channelWriteStats = statsLogger.getOpStatsLogger("CHANNEL_WRITE");
        this.addEntryBlockedStats = statsLogger.getOpStatsLogger("ADD_ENTRY_BLOCKED_WAIT");
        this.readEntryBlockedStats = statsLogger.getOpStatsLogger("READ_ENTRY_BLOCKED_WAIT");
        this.getListOfEntriesOfLedgerStats = statsLogger.getOpStatsLogger("GET_LIST_OF_ENTRIES_OF_LEDGER");
        this.getListOfEntriesOfLedgerRequestStats = statsLogger.getOpStatsLogger("GET_LIST_OF_ENTRIES_OF_LEDGER_REQUEST");
        statsLogger.registerGauge("ADD_ENTRY_IN_PROGRESS", new Gauge<Number>(){

            @Override
            public Number getDefaultValue() {
                return 0;
            }

            @Override
            public Number getSample() {
                return RequestStats.this.addsInProgress;
            }
        });
        statsLogger.registerGauge("ADD_ENTRY_BLOCKED", new Gauge<Number>(){

            @Override
            public Number getDefaultValue() {
                return 0;
            }

            @Override
            public Number getSample() {
                return RequestStats.this.addsBlocked;
            }
        });
        statsLogger.registerGauge("READ_ENTRY_IN_PROGRESS", new Gauge<Number>(){

            @Override
            public Number getDefaultValue() {
                return 0;
            }

            @Override
            public Number getSample() {
                return RequestStats.this.readsInProgress;
            }
        });
        statsLogger.registerGauge("READ_ENTRY_BLOCKED", new Gauge<Number>(){

            @Override
            public Number getDefaultValue() {
                return 0;
            }

            @Override
            public Number getSample() {
                return RequestStats.this.readsBlocked;
            }
        });
    }

    void blockAddRequest() {
        this.addsBlocked.incrementAndGet();
    }

    void unblockAddRequest(long delayNanos) {
        this.addEntryBlockedStats.registerSuccessfulEvent(delayNanos, TimeUnit.NANOSECONDS);
        this.addsBlocked.decrementAndGet();
    }

    void trackAddRequest() {
        int curr = this.addsInProgress.incrementAndGet();
        this.maxAddsInProgress.accumulateAndGet(curr, Integer::max);
    }

    void untrackAddRequest() {
        this.addsInProgress.decrementAndGet();
    }

    int maxAddsInProgressCount() {
        return this.maxAddsInProgress.get();
    }

    void blockReadRequest() {
        this.readsBlocked.incrementAndGet();
    }

    void unblockReadRequest(long delayNanos) {
        this.readEntryBlockedStats.registerSuccessfulEvent(delayNanos, TimeUnit.NANOSECONDS);
        this.readsBlocked.decrementAndGet();
    }

    void trackReadRequest() {
        int curr = this.readsInProgress.incrementAndGet();
        this.maxReadsInProgress.accumulateAndGet(curr, Integer::max);
    }

    void untrackReadRequest() {
        this.readsInProgress.decrementAndGet();
    }

    int maxReadsInProgressCount() {
        return this.maxReadsInProgress.get();
    }

    public AtomicInteger getAddsInProgress() {
        return this.addsInProgress;
    }

    public AtomicInteger getMaxAddsInProgress() {
        return this.maxAddsInProgress;
    }

    public AtomicInteger getAddsBlocked() {
        return this.addsBlocked;
    }

    public AtomicInteger getReadsInProgress() {
        return this.readsInProgress;
    }

    public AtomicInteger getReadsBlocked() {
        return this.readsBlocked;
    }

    public AtomicInteger getMaxReadsInProgress() {
        return this.maxReadsInProgress;
    }

    public OpStatsLogger getAddRequestStats() {
        return this.addRequestStats;
    }

    public OpStatsLogger getAddEntryStats() {
        return this.addEntryStats;
    }

    public OpStatsLogger getWriteThreadQueuedLatency() {
        return this.writeThreadQueuedLatency;
    }

    public Counter getAddEntryRejectedCounter() {
        return this.addEntryRejectedCounter;
    }

    public OpStatsLogger getReadRequestStats() {
        return this.readRequestStats;
    }

    public OpStatsLogger getReadEntryStats() {
        return this.readEntryStats;
    }

    public Counter getReadEntryRejectedCounter() {
        return this.readEntryRejectedCounter;
    }

    public OpStatsLogger getForceLedgerStats() {
        return this.forceLedgerStats;
    }

    public OpStatsLogger getForceLedgerRequestStats() {
        return this.forceLedgerRequestStats;
    }

    public OpStatsLogger getFenceReadRequestStats() {
        return this.fenceReadRequestStats;
    }

    public OpStatsLogger getFenceReadEntryStats() {
        return this.fenceReadEntryStats;
    }

    public OpStatsLogger getFenceReadWaitStats() {
        return this.fenceReadWaitStats;
    }

    public OpStatsLogger getReadEntrySchedulingDelayStats() {
        return this.readEntrySchedulingDelayStats;
    }

    public OpStatsLogger getLongPollPreWaitStats() {
        return this.longPollPreWaitStats;
    }

    public OpStatsLogger getLongPollWaitStats() {
        return this.longPollWaitStats;
    }

    public OpStatsLogger getLongPollReadStats() {
        return this.longPollReadStats;
    }

    public OpStatsLogger getLongPollReadRequestStats() {
        return this.longPollReadRequestStats;
    }

    public Counter getReadLastEntryNoEntryErrorCounter() {
        return this.readLastEntryNoEntryErrorCounter;
    }

    public OpStatsLogger getWriteLacRequestStats() {
        return this.writeLacRequestStats;
    }

    public OpStatsLogger getWriteLacStats() {
        return this.writeLacStats;
    }

    public OpStatsLogger getReadLacRequestStats() {
        return this.readLacRequestStats;
    }

    public OpStatsLogger getReadLacStats() {
        return this.readLacStats;
    }

    public OpStatsLogger getGetBookieInfoRequestStats() {
        return this.getBookieInfoRequestStats;
    }

    public OpStatsLogger getGetBookieInfoStats() {
        return this.getBookieInfoStats;
    }

    public OpStatsLogger getChannelWriteStats() {
        return this.channelWriteStats;
    }

    public OpStatsLogger getAddEntryBlockedStats() {
        return this.addEntryBlockedStats;
    }

    public OpStatsLogger getReadEntryBlockedStats() {
        return this.readEntryBlockedStats;
    }

    public OpStatsLogger getGetListOfEntriesOfLedgerRequestStats() {
        return this.getListOfEntriesOfLedgerRequestStats;
    }

    public OpStatsLogger getGetListOfEntriesOfLedgerStats() {
        return this.getListOfEntriesOfLedgerStats;
    }
}

