/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import io.netty.buffer.ByteBuf;
import io.netty.util.Recycler;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.proto.BookieProtocol;
import org.apache.bookkeeper.proto.BookieRequestHandler;
import org.apache.bookkeeper.proto.BookieRequestProcessor;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.proto.PacketProcessorBase;
import org.apache.bookkeeper.proto.ResponseBuilder;
import org.apache.bookkeeper.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.bookkeeper.util.MathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WriteEntryProcessor
extends PacketProcessorBase<BookieProtocol.ParsedAddRequest>
implements BookkeeperInternalCallbacks.WriteCallback {
    private static final Logger LOG = LoggerFactory.getLogger(WriteEntryProcessor.class);
    long startTimeNanos;
    private final Recycler.Handle<WriteEntryProcessor> recyclerHandle;
    private static final Recycler<WriteEntryProcessor> RECYCLER = new Recycler<WriteEntryProcessor>(){

        protected WriteEntryProcessor newObject(Recycler.Handle<WriteEntryProcessor> handle) {
            return new WriteEntryProcessor(handle);
        }
    };

    @Override
    protected void reset() {
        super.reset();
        this.startTimeNanos = -1L;
    }

    public static WriteEntryProcessor create(BookieProtocol.ParsedAddRequest request, BookieRequestHandler requestHandler, BookieRequestProcessor requestProcessor) {
        WriteEntryProcessor wep = (WriteEntryProcessor)RECYCLER.get();
        wep.init(request, requestHandler, requestProcessor);
        requestProcessor.onAddRequestStart(requestHandler.ctx().channel());
        return wep;
    }

    @Override
    protected void processPacket() {
        if (!(!this.requestProcessor.getBookie().isReadOnly() || ((BookieProtocol.ParsedAddRequest)this.request).isHighPriority() && this.requestProcessor.getBookie().isAvailableForHighPriorityWrites())) {
            LOG.warn("BookieServer is running in readonly mode, so rejecting the request from the client!");
            this.sendWriteReqResponse(105, ResponseBuilder.buildErrorResponse(105, this.request), this.requestProcessor.getRequestStats().getAddRequestStats());
            ((BookieProtocol.ParsedAddRequest)this.request).release();
            ((BookieProtocol.ParsedAddRequest)this.request).recycle();
            return;
        }
        this.startTimeNanos = MathUtils.nowInNano();
        int rc = 0;
        ByteBuf addData = ((BookieProtocol.ParsedAddRequest)this.request).getData();
        try {
            if (((BookieProtocol.ParsedAddRequest)this.request).isRecoveryAdd()) {
                this.requestProcessor.getBookie().recoveryAddEntry(addData, this, (Object)this.requestHandler, ((BookieProtocol.ParsedAddRequest)this.request).getMasterKey());
            } else {
                this.requestProcessor.getBookie().addEntry(addData, false, this, (Object)this.requestHandler, ((BookieProtocol.ParsedAddRequest)this.request).getMasterKey());
            }
        }
        catch (BookieException.OperationRejectedException e) {
            this.requestProcessor.getRequestStats().getAddEntryRejectedCounter().inc();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Operation rejected while writing {}", (Object)this.request, (Object)e);
            }
            rc = 106;
        }
        catch (IOException e) {
            LOG.error("Error writing {}", (Object)this.request, (Object)e);
            rc = 101;
        }
        catch (BookieException.LedgerFencedException lfe) {
            LOG.error("Attempt to write to fenced ledger", (Throwable)lfe);
            rc = 104;
        }
        catch (BookieException e) {
            LOG.error("Unauthorized access to ledger {}", (Object)((BookieProtocol.ParsedAddRequest)this.request).getLedgerId(), (Object)e);
            rc = 102;
        }
        catch (Throwable t) {
            LOG.error("Unexpected exception while writing {}@{} : {}", new Object[]{((BookieProtocol.ParsedAddRequest)this.request).ledgerId, ((BookieProtocol.ParsedAddRequest)this.request).entryId, t.getMessage(), t});
            rc = 100;
        }
        if (rc != 0) {
            this.requestProcessor.getRequestStats().getAddEntryStats().registerFailedEvent(MathUtils.elapsedNanos(this.startTimeNanos), TimeUnit.NANOSECONDS);
            this.sendWriteReqResponse(rc, ResponseBuilder.buildErrorResponse(rc, this.request), this.requestProcessor.getRequestStats().getAddRequestStats());
            ((BookieProtocol.ParsedAddRequest)this.request).recycle();
        }
    }

    @Override
    public void writeComplete(int rc, long ledgerId, long entryId, BookieId addr, Object ctx) {
        if (0 == rc) {
            this.requestProcessor.getRequestStats().getAddEntryStats().registerSuccessfulEvent(MathUtils.elapsedNanos(this.startTimeNanos), TimeUnit.NANOSECONDS);
        } else {
            this.requestProcessor.getRequestStats().getAddEntryStats().registerFailedEvent(MathUtils.elapsedNanos(this.startTimeNanos), TimeUnit.NANOSECONDS);
        }
        this.requestHandler.prepareSendResponseV2(rc, (BookieProtocol.ParsedAddRequest)this.request);
        this.requestProcessor.onAddRequestFinish();
        ((BookieProtocol.ParsedAddRequest)this.request).recycle();
        this.recycle();
    }

    public String toString() {
        return String.format("WriteEntry(%d, %d)", ((BookieProtocol.ParsedAddRequest)this.request).getLedgerId(), ((BookieProtocol.ParsedAddRequest)this.request).getEntryId());
    }

    @VisibleForTesting
    void recycle() {
        this.reset();
        this.recyclerHandle.recycle((Object)this);
    }

    private WriteEntryProcessor(Recycler.Handle<WriteEntryProcessor> recyclerHandle) {
        this.recyclerHandle = recyclerHandle;
    }
}

