/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.server.http.service;

import java.util.HashMap;
import org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.bookkeeper.common.util.JsonUtil;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.http.HttpServer;
import org.apache.bookkeeper.http.service.HttpEndpointService;
import org.apache.bookkeeper.http.service.HttpServiceRequest;
import org.apache.bookkeeper.http.service.HttpServiceResponse;
import org.apache.bookkeeper.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LostBookieRecoveryDelayService
implements HttpEndpointService {
    static final Logger LOG = LoggerFactory.getLogger(LostBookieRecoveryDelayService.class);
    protected ServerConfiguration conf;
    protected BookKeeperAdmin bka;

    public LostBookieRecoveryDelayService(ServerConfiguration conf, BookKeeperAdmin bka) {
        Preconditions.checkNotNull(conf);
        this.conf = conf;
        this.bka = bka;
    }

    public HttpServiceResponse handle(HttpServiceRequest request) throws Exception {
        HttpServiceResponse response = new HttpServiceResponse();
        if (HttpServer.Method.PUT == request.getMethod()) {
            String requestBody = request.getBody();
            if (requestBody == null) {
                response.setCode(HttpServer.StatusCode.NOT_FOUND);
                response.setBody("Null request body for lostBookieRecoveryDelay.");
                return response;
            }
            HashMap configMap = JsonUtil.fromJson(requestBody, HashMap.class);
            if (configMap != null && configMap.containsKey("delay_seconds")) {
                int delaySeconds = (Integer)configMap.get("delay_seconds");
                this.bka.setLostBookieRecoveryDelay(delaySeconds);
                response.setCode(HttpServer.StatusCode.OK);
                response.setBody("Success set lostBookieRecoveryDelay to " + delaySeconds);
                return response;
            }
            response.setCode(HttpServer.StatusCode.NOT_FOUND);
            response.setBody("Request body not contains lostBookieRecoveryDelay.");
            return response;
        }
        if (HttpServer.Method.GET == request.getMethod()) {
            try {
                int delaySeconds = this.bka.getLostBookieRecoveryDelay();
                response.setCode(HttpServer.StatusCode.OK);
                response.setBody("lostBookieRecoveryDelay value: " + delaySeconds);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("response body:" + response.getBody());
                }
                return response;
            }
            catch (Exception e) {
                LOG.error("Exception occurred while getting lost bookie recovery delay", (Throwable)e);
                response.setCode(HttpServer.StatusCode.NOT_FOUND);
                response.setBody("Exception when get lostBookieRecoveryDelay." + e.getMessage());
                return response;
            }
        }
        response.setCode(HttpServer.StatusCode.NOT_FOUND);
        response.setBody("Not found method. Should be PUT method");
        return response;
    }
}

