/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.server.http.service;

import java.io.IOException;
import java.io.StringWriter;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.http.HttpServer;
import org.apache.bookkeeper.http.service.HttpEndpointService;
import org.apache.bookkeeper.http.service.HttpServiceRequest;
import org.apache.bookkeeper.http.service.HttpServiceResponse;
import org.apache.bookkeeper.stats.StatsProvider;

public class MetricsService
implements HttpEndpointService {
    private final ServerConfiguration conf;
    private final StatsProvider statsProvider;

    public MetricsService(ServerConfiguration conf, StatsProvider statsProvider) {
        this.conf = conf;
        this.statsProvider = statsProvider;
    }

    public HttpServiceResponse handle(HttpServiceRequest request) throws Exception {
        HttpServiceResponse response = new HttpServiceResponse();
        if (HttpServer.Method.GET != request.getMethod()) {
            response.setCode(HttpServer.StatusCode.FORBIDDEN);
            response.setBody(request.getMethod() + " is forbidden. Should be GET method");
            return response;
        }
        if (null == this.statsProvider) {
            response.setCode(HttpServer.StatusCode.INTERNAL_ERROR);
            response.setBody("Stats provider is not enabled. Please enable it by set statsProviderClass on bookie configuration");
            return response;
        }
        try (StringWriter writer = new StringWriter(1024);){
            this.statsProvider.writeAllMetrics(writer);
            writer.flush();
            response.setCode(HttpServer.StatusCode.OK);
            response.setBody(writer.getBuffer().toString());
        }
        catch (UnsupportedOperationException uoe) {
            response.setCode(HttpServer.StatusCode.INTERNAL_ERROR);
            response.setBody("Currently stats provider doesn't support exporting metrics in http service");
        }
        catch (IOException ioe) {
            response.setCode(HttpServer.StatusCode.INTERNAL_ERROR);
            response.setBody("Exceptions are thrown when exporting metrics : " + ioe.getMessage());
        }
        return response;
    }
}

