/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.datainteg;

import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.bookkeeper.bookie.LedgerStorage;
import org.apache.bookkeeper.bookie.datainteg.EntryCopier;
import org.apache.bookkeeper.bookie.datainteg.WriteSets;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.proto.BookieClient;
import org.apache.bookkeeper.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.bookkeeper.shaded.com.google.common.base.Ticker;
import org.apache.bookkeeper.shaded.com.google.common.collect.ImmutableList;
import org.apache.bookkeeper.shaded.com.google.common.collect.ImmutableSortedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryCopierImpl
implements EntryCopier {
    private static final Logger log = LoggerFactory.getLogger(EntryCopierImpl.class);
    private static final long SINBIN_DURATION_MS = TimeUnit.MINUTES.toMillis(1L);
    private final BookieId bookieId;
    private final BookieClient bookieClient;
    private final LedgerStorage storage;
    private final Ticker ticker;
    private final SinBin sinBin;

    public EntryCopierImpl(BookieId bookieId, BookieClient bookieClient, LedgerStorage storage, Ticker ticker) {
        this.bookieId = bookieId;
        this.bookieClient = bookieClient;
        this.storage = storage;
        this.ticker = ticker;
        this.sinBin = new SinBin(ticker);
    }

    @Override
    public EntryCopier.Batch newBatch(long ledgerId, LedgerMetadata metadata) throws IOException {
        if (!this.storage.ledgerExists(ledgerId)) {
            this.storage.setMasterKey(ledgerId, metadata.getPassword());
        }
        return new BatchImpl(this.bookieId, ledgerId, metadata, this.sinBin);
    }

    private CompletableFuture<ByteBuf> readEntry(BookieId bookieId, long ledgerId, long entryId) {
        CompletableFuture<ByteBuf> promise = new CompletableFuture<ByteBuf>();
        this.bookieClient.readEntry(bookieId, ledgerId, entryId, (rc, ledgerId1, entryId1, buffer, ctx1) -> {
            if (rc != 0) {
                promise.completeExceptionally(BKException.create(rc));
            } else {
                buffer.retain();
                promise.complete(buffer);
            }
        }, null, 0);
        return promise;
    }

    @VisibleForTesting
    static ImmutableSortedMap<Long, ImmutableList<Integer>> preferredBookieIndices(BookieId bookieId, LedgerMetadata metadata, Set<BookieId> errorBookies, long seed) {
        return metadata.getAllEnsembles().entrySet().stream().collect(ImmutableSortedMap.toImmutableSortedMap(Comparator.naturalOrder(), e -> (Long)e.getKey(), e -> {
            List ensemble = (List)e.getValue();
            int myIndex = ensemble.indexOf(bookieId);
            Set errorIndices = errorBookies.stream().map(b -> ensemble.indexOf(b)).collect(Collectors.toSet());
            List indices = IntStream.range(0, ensemble.size()).filter(i -> i != myIndex).boxed().collect(Collectors.toList());
            Collections.shuffle(indices, new Random(seed));
            Collections.sort(indices, (a, b) -> {
                boolean aErr = errorIndices.contains(a);
                boolean bErr = errorIndices.contains(b);
                if (aErr && !bErr) {
                    return 1;
                }
                if (!aErr && bErr) {
                    return -1;
                }
                return 0;
            });
            return ImmutableList.copyOf(indices);
        }));
    }

    @VisibleForTesting
    static class SinBin {
        private final Ticker ticker;
        private final ConcurrentMap<BookieId, Long> errorBookies = new ConcurrentHashMap<BookieId, Long>();

        SinBin(Ticker ticker) {
            this.ticker = ticker;
        }

        boolean addFailed(BookieId bookie) {
            long newDeadline = TimeUnit.NANOSECONDS.toMillis(this.ticker.read()) + SINBIN_DURATION_MS;
            Long oldDeadline = this.errorBookies.put(bookie, newDeadline);
            return oldDeadline == null;
        }

        Set<BookieId> getErrorBookies() {
            long now = TimeUnit.NANOSECONDS.toMillis(this.ticker.read());
            Iterator iterator = this.errorBookies.entrySet().iterator();
            while (iterator.hasNext()) {
                if ((Long)iterator.next().getValue() >= now) continue;
                iterator.remove();
            }
            return this.errorBookies.keySet();
        }
    }

    @VisibleForTesting
    class BatchImpl
    implements EntryCopier.Batch {
        private final long ledgerId;
        private final LedgerMetadata metadata;
        private final SinBin sinBin;
        private volatile ImmutableSortedMap<Long, WriteSets> writeSets;

        BatchImpl(BookieId bookieId, long ledgerId, LedgerMetadata metadata, SinBin sinBin) {
            this.ledgerId = ledgerId;
            this.metadata = metadata;
            this.sinBin = sinBin;
            this.updateWriteSets();
        }

        private void updateWriteSets() {
            this.writeSets = EntryCopierImpl.preferredBookieIndices(EntryCopierImpl.this.bookieId, this.metadata, this.sinBin.getErrorBookies(), this.ledgerId).entrySet().stream().collect(ImmutableSortedMap.toImmutableSortedMap(Comparator.naturalOrder(), e -> (Long)e.getKey(), e -> new WriteSets((List)e.getValue(), this.metadata.getEnsembleSize(), this.metadata.getWriteQuorumSize())));
        }

        @VisibleForTesting
        void notifyBookieError(BookieId bookie) {
            if (this.sinBin.addFailed(bookie)) {
                this.updateWriteSets();
            }
        }

        @Override
        public CompletableFuture<Long> copyFromAvailable(long entryId) {
            if (entryId < 0L) {
                throw new IllegalArgumentException(String.format("Entry ID (%d) can't be less than 0", entryId));
            }
            if (this.metadata.isClosed() && entryId > this.metadata.getLastEntryId()) {
                throw new IllegalArgumentException(String.format("Invalid entry id (%d), last entry for ledger %d is %d", entryId, this.ledgerId, this.metadata.getLastEntryId()));
            }
            CompletableFuture<Long> promise = new CompletableFuture<Long>();
            this.fetchEntry(entryId).whenComplete((buffer, exception) -> {
                if (exception != null) {
                    promise.completeExceptionally((Throwable)exception);
                } else {
                    try {
                        long length = buffer.readableBytes();
                        EntryCopierImpl.this.storage.addEntry((ByteBuf)buffer);
                        promise.complete(length);
                    }
                    catch (Throwable t) {
                        promise.completeExceptionally(t);
                    }
                    finally {
                        ReferenceCountUtil.release((Object)buffer);
                    }
                }
            });
            return promise;
        }

        @VisibleForTesting
        CompletableFuture<ByteBuf> fetchEntry(long entryId) {
            List<BookieId> ensemble = this.metadata.getEnsembleAt(entryId);
            Map.Entry<Long, WriteSets> writeSetsForEntryId = this.writeSets.floorEntry(entryId);
            if (writeSetsForEntryId == null) {
                log.error("writeSets for entryId {} not found, writeSets {}", (Object)entryId, this.writeSets);
                throw new IllegalStateException("writeSets for entryId: " + entryId + " not found");
            }
            ImmutableList<Integer> writeSet = writeSetsForEntryId.getValue().getForEntry(entryId);
            int attempt = 0;
            CompletableFuture<ByteBuf> promise = new CompletableFuture<ByteBuf>();
            this.fetchRetryLoop(entryId, attempt, ensemble, writeSet, promise, Optional.empty());
            return promise;
        }

        private void fetchRetryLoop(long entryId, int attempt, List<BookieId> ensemble, ImmutableList<Integer> writeSet, CompletableFuture<ByteBuf> promise, Optional<Throwable> firstException) {
            if (attempt >= writeSet.size()) {
                promise.completeExceptionally(firstException.orElse(new BKException.BKReadException()));
                return;
            }
            BookieId bookie = ensemble.get((Integer)writeSet.get(attempt));
            EntryCopierImpl.this.readEntry(bookie, this.ledgerId, entryId).whenComplete((buffer, exception) -> {
                if (exception != null) {
                    this.notifyBookieError(bookie);
                    Optional<Throwable> firstException1 = firstException.isPresent() ? firstException : Optional.of(exception);
                    this.fetchRetryLoop(entryId, attempt + 1, ensemble, writeSet, promise, firstException1);
                } else {
                    promise.complete((ByteBuf)buffer);
                }
            });
        }
    }
}

