/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.storage.directentrylogger;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.concurrent.ExecutorService;
import org.apache.bookkeeper.bookie.EntryLogMetadata;
import org.apache.bookkeeper.bookie.storage.CompactionEntryLog;
import org.apache.bookkeeper.bookie.storage.EntryLogScanner;
import org.apache.bookkeeper.bookie.storage.directentrylogger.BufferPool;
import org.apache.bookkeeper.bookie.storage.directentrylogger.DirectEntryLogger;
import org.apache.bookkeeper.bookie.storage.directentrylogger.DirectReader;
import org.apache.bookkeeper.bookie.storage.directentrylogger.DirectWriter;
import org.apache.bookkeeper.bookie.storage.directentrylogger.Events;
import org.apache.bookkeeper.bookie.storage.directentrylogger.LogReaderScan;
import org.apache.bookkeeper.bookie.storage.directentrylogger.WriterWithMetadata;
import org.apache.bookkeeper.common.util.ExceptionMessageHelper;
import org.apache.bookkeeper.common.util.nativeio.NativeIO;
import org.apache.bookkeeper.slogger.Slogger;
import org.apache.bookkeeper.stats.OpStatsLogger;

public abstract class DirectCompactionEntryLog
implements CompactionEntryLog {
    protected final int srcLogId;
    protected final int dstLogId;
    protected final Slogger slog;
    protected final File compactingFile;
    protected final File compactedFile;
    protected final File completeFile;

    static CompactionEntryLog newLog(int srcLogId, int dstLogId, File ledgerDir, long maxFileSize, ExecutorService writeExecutor, BufferPool writeBuffers, NativeIO nativeIO, ByteBufAllocator allocator, Slogger slog) throws IOException {
        return new WritingDirectCompactionEntryLog(srcLogId, dstLogId, ledgerDir, maxFileSize, writeExecutor, writeBuffers, nativeIO, allocator, slog);
    }

    static CompactionEntryLog recoverLog(int srcLogId, int dstLogId, File ledgerDir, int readBufferSize, int maxSaneEntrySize, NativeIO nativeIO, ByteBufAllocator allocator, OpStatsLogger readBlockStats, Slogger slog) {
        return new RecoveredDirectCompactionEntryLog(srcLogId, dstLogId, ledgerDir, readBufferSize, maxSaneEntrySize, nativeIO, allocator, readBlockStats, slog);
    }

    private DirectCompactionEntryLog(int srcLogId, int dstLogId, File ledgerDir, Slogger slog) {
        this.compactingFile = DirectCompactionEntryLog.compactingFile(ledgerDir, dstLogId);
        this.compactedFile = DirectCompactionEntryLog.compactedFile(ledgerDir, dstLogId, srcLogId);
        this.completeFile = DirectEntryLogger.logFile(ledgerDir, dstLogId);
        this.srcLogId = srcLogId;
        this.dstLogId = dstLogId;
        this.slog = slog.kv((Object)"dstLogId", (Object)dstLogId).kv((Object)"srcLogId", (Object)srcLogId).ctx(DirectCompactionEntryLog.class);
    }

    @Override
    public void abort() {
        try {
            Files.deleteIfExists(this.compactingFile.toPath());
        }
        catch (IOException ioe) {
            this.slog.kv((Object)"compactingFile", (Object)this.compactingFile).warn((Enum)Events.COMPACTION_ABORT_EXCEPTION, (Throwable)ioe);
        }
        try {
            Files.deleteIfExists(this.compactedFile.toPath());
        }
        catch (IOException ioe) {
            this.slog.kv((Object)"compactedFile", (Object)this.compactedFile).warn((Enum)Events.COMPACTION_ABORT_EXCEPTION, (Throwable)ioe);
        }
    }

    @Override
    public void makeAvailable() throws IOException {
        DirectCompactionEntryLog.idempotentLink(this.compactedFile, this.completeFile);
        this.slog.kv((Object)"compactedFile", (Object)this.compactedFile).kv((Object)"completeFile", (Object)this.completeFile).info((Enum)Events.COMPACTION_MAKE_AVAILABLE);
    }

    private static void idempotentLink(File src, File dst) throws IOException {
        if (!src.exists()) {
            throw new IOException(ExceptionMessageHelper.exMsg("src doesn't exist, aborting link").kv("src", src).kv("dst", dst).toString());
        }
        if (!dst.exists()) {
            Files.createLink(dst.toPath(), src.toPath());
        } else if (!Files.isSameFile(src.toPath(), dst.toPath())) {
            throw new IOException(ExceptionMessageHelper.exMsg("dst exists, but doesn't match src").kv("src", src).kv("dst", dst).toString());
        }
    }

    @Override
    public void finalizeAndCleanup() {
        try {
            Files.deleteIfExists(this.compactingFile.toPath());
        }
        catch (IOException ioe) {
            this.slog.kv((Object)"compactingFile", (Object)this.compactingFile).warn((Enum)Events.COMPACTION_DELETE_FAILURE, (Throwable)ioe);
        }
        try {
            Files.deleteIfExists(this.compactedFile.toPath());
        }
        catch (IOException ioe) {
            this.slog.kv((Object)"compactedFile", (Object)this.compactedFile).warn((Enum)Events.COMPACTION_DELETE_FAILURE, (Throwable)ioe);
        }
        this.slog.info((Enum)Events.COMPACTION_COMPLETE);
    }

    @Override
    public long getDstLogId() {
        return this.dstLogId;
    }

    @Override
    public long getSrcLogId() {
        return this.srcLogId;
    }

    public static File compactingFile(File directory, int logId) {
        return new File(directory, String.format("%x%s", logId, ".log.compacting"));
    }

    public static File compactedFile(File directory, int newLogId, int compactedLogId) {
        return new File(directory, String.format("%x.log.%x%s", newLogId, compactedLogId, ".compacted"));
    }

    private static class WritingDirectCompactionEntryLog
    extends DirectCompactionEntryLog {
        private final WriterWithMetadata writer;

        WritingDirectCompactionEntryLog(int srcLogId, int dstLogId, File ledgerDir, long maxFileSize, ExecutorService writeExecutor, BufferPool writeBuffers, NativeIO nativeIO, ByteBufAllocator allocator, Slogger slog) throws IOException {
            super(srcLogId, dstLogId, ledgerDir, slog);
            this.writer = new WriterWithMetadata(new DirectWriter(dstLogId, this.compactingFile.toString(), maxFileSize, writeExecutor, writeBuffers, nativeIO, slog), new EntryLogMetadata(dstLogId), allocator);
            this.slog.info((Enum)Events.COMPACTION_LOG_CREATED);
        }

        @Override
        public long addEntry(long ledgerId, ByteBuf entry) throws IOException {
            return this.writer.addEntry(ledgerId, entry);
        }

        @Override
        public void flush() throws IOException {
            this.writer.flush();
        }

        @Override
        public void markCompacted() throws IOException {
            this.writer.finalizeAndClose();
            DirectCompactionEntryLog.idempotentLink(this.compactingFile, this.compactedFile);
            if (!this.compactingFile.delete()) {
                this.slog.kv((Object)"compactingFile", (Object)this.compactingFile).kv((Object)"compactedFile", (Object)this.compactedFile).info((Enum)Events.COMPACTION_DELETE_FAILURE);
            } else {
                this.slog.kv((Object)"compactingFile", (Object)this.compactingFile).kv((Object)"compactedFile", (Object)this.compactedFile).info((Enum)Events.COMPACTION_MARK_COMPACTED);
            }
        }

        @Override
        public void scan(EntryLogScanner scanner) throws IOException {
            throw new IllegalStateException(ExceptionMessageHelper.exMsg("Scan only valid for recovered log").kv("srcLogId", this.srcLogId).kv("dstLogId", this.dstLogId).kv("compactingFile", this.compactingFile).kv("compactedFile", this.compactedFile).kv("completeFile", this.completeFile).toString());
        }
    }

    private static class RecoveredDirectCompactionEntryLog
    extends DirectCompactionEntryLog {
        private final ByteBufAllocator allocator;
        private final NativeIO nativeIO;
        private final int readBufferSize;
        private final int maxSaneEntrySize;
        private final OpStatsLogger readBlockStats;

        RecoveredDirectCompactionEntryLog(int srcLogId, int dstLogId, File ledgerDir, int readBufferSize, int maxSaneEntrySize, NativeIO nativeIO, ByteBufAllocator allocator, OpStatsLogger readBlockStats, Slogger slog) {
            super(srcLogId, dstLogId, ledgerDir, slog);
            this.allocator = allocator;
            this.nativeIO = nativeIO;
            this.readBufferSize = readBufferSize;
            this.maxSaneEntrySize = maxSaneEntrySize;
            this.readBlockStats = readBlockStats;
            this.slog.info((Enum)Events.COMPACTION_LOG_RECOVERED);
        }

        private IllegalStateException illegalOpException() {
            return new IllegalStateException(ExceptionMessageHelper.exMsg("Invalid operation for recovered log").kv("srcLogId", this.srcLogId).kv("dstLogId", this.dstLogId).kv("compactingFile", this.compactingFile).kv("compactedFile", this.compactedFile).kv("completeFile", this.completeFile).toString());
        }

        @Override
        public long addEntry(long ledgerId, ByteBuf entry) throws IOException {
            throw this.illegalOpException();
        }

        @Override
        public void flush() throws IOException {
            throw this.illegalOpException();
        }

        @Override
        public void markCompacted() throws IOException {
            throw this.illegalOpException();
        }

        @Override
        public void scan(EntryLogScanner scanner) throws IOException {
            try (DirectReader reader = new DirectReader(this.dstLogId, this.compactedFile.toString(), this.allocator, this.nativeIO, this.readBufferSize, this.maxSaneEntrySize, this.readBlockStats);){
                LogReaderScan.scan(this.allocator, reader, scanner);
            }
        }
    }
}

