/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.storage.directentrylogger;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import org.apache.bookkeeper.bookie.EntryLogMetadata;
import org.apache.bookkeeper.bookie.storage.directentrylogger.Header;
import org.apache.bookkeeper.bookie.storage.directentrylogger.LogReader;
import org.apache.bookkeeper.bookie.storage.directentrylogger.LogWriter;
import org.apache.bookkeeper.common.util.ExceptionMessageHelper;
import org.apache.bookkeeper.util.collections.ConcurrentLongLongHashMap;

class LogMetadata {
    static final int LEDGERS_MAP_HEADER_SIZE = 24;
    static final int LEDGERS_MAP_ENTRY_SIZE = 16;
    static final int LEDGERS_MAP_MAX_BATCH_SIZE = 10000;
    static final int LEDGERS_MAP_MAX_MAP_SIZE = 160024;
    static final long INVALID_LID = -1L;
    static final long LEDGERS_MAP_ENTRY_ID = -2L;

    LogMetadata() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void write(final LogWriter writer, EntryLogMetadata metadata, ByteBufAllocator allocator) throws IOException {
        long ledgerMapOffset = writer.position();
        ConcurrentLongLongHashMap ledgersMap = metadata.getLedgersMap();
        final int numberOfLedgers = (int)ledgersMap.size();
        final ByteBuf serializedMap = allocator.buffer(10000);
        ConcurrentLongLongHashMap.BiConsumerLong writingConsumer = new ConcurrentLongLongHashMap.BiConsumerLong(){
            int remainingLedgers;
            boolean startNewBatch;
            int remainingInBatch;
            {
                this.remainingLedgers = numberOfLedgers;
                this.startNewBatch = true;
                this.remainingInBatch = 0;
            }

            @Override
            public void accept(long ledgerId, long size) {
                if (this.startNewBatch) {
                    int batchSize = Math.min(this.remainingLedgers, 10000);
                    serializedMap.clear();
                    serializedMap.writeLong(-1L);
                    serializedMap.writeLong(-2L);
                    serializedMap.writeInt(batchSize);
                    this.startNewBatch = false;
                    this.remainingInBatch = batchSize;
                }
                serializedMap.writeLong(ledgerId);
                serializedMap.writeLong(size);
                --this.remainingLedgers;
                if (--this.remainingInBatch == 0) {
                    try {
                        writer.writeDelimited(serializedMap);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    this.startNewBatch = true;
                }
            }
        };
        try {
            ledgersMap.forEach(writingConsumer);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
        finally {
            ReferenceCountUtil.release((Object)serializedMap);
        }
        ByteBuf buf = allocator.buffer(4096);
        try {
            Header.writeHeader(buf, ledgerMapOffset, numberOfLedgers);
            writer.writeAt(0L, buf);
        }
        finally {
            ReferenceCountUtil.release((Object)buf);
        }
        writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static EntryLogMetadata read(LogReader reader) throws IOException {
        ByteBuf header = reader.readBufferAt(0L, 1024);
        try {
            int headerVersion = Header.extractVersion(header);
            if (headerVersion < 1) {
                throw new IOException(ExceptionMessageHelper.exMsg("Old log file header").kv("headerVersion", headerVersion).toString());
            }
            long ledgerMapOffset = Header.extractLedgerMapOffset(header);
            if (ledgerMapOffset > Integer.MAX_VALUE) {
                throw new IOException(ExceptionMessageHelper.exMsg("ledgerMapOffset too high").kv("ledgerMapOffset", ledgerMapOffset).kv("maxOffset", Integer.MAX_VALUE).toString());
            }
            if (ledgerMapOffset <= 0L) {
                throw new IOException(ExceptionMessageHelper.exMsg("ledgerMap never written").kv("ledgerMapOffset", ledgerMapOffset).toString());
            }
            long offset = ledgerMapOffset;
            EntryLogMetadata meta = new EntryLogMetadata(reader.logId());
            while (offset < reader.maxOffset()) {
                int mapSize = reader.readIntAt((int)offset);
                if (mapSize >= 160024) {
                    throw new IOException(ExceptionMessageHelper.exMsg("ledgerMap too large").kv("maxSize", 160024).kv("mapSize", mapSize).toString());
                }
                if (mapSize <= 0) break;
                ByteBuf ledgerMapBuffer = reader.readBufferAt(offset += 4L, mapSize);
                try {
                    offset += (long)mapSize;
                    long ledgerId = ledgerMapBuffer.readLong();
                    if (ledgerId != -1L) {
                        throw new IOException(ExceptionMessageHelper.exMsg("Bad ledgerID").kv("ledgerId", ledgerId).toString());
                    }
                    long entryId = ledgerMapBuffer.readLong();
                    if (entryId != -2L) {
                        throw new IOException(ExceptionMessageHelper.exMsg("Unexpected entry ID. Expected special value").kv("entryIdRead", entryId).kv("entryIdExpected", -2L).toString());
                    }
                    int countInBatch = ledgerMapBuffer.readInt();
                    for (int i = 0; i < countInBatch; ++i) {
                        ledgerId = ledgerMapBuffer.readLong();
                        long size = ledgerMapBuffer.readLong();
                        meta.addLedgerSize(ledgerId, size);
                    }
                    if (!ledgerMapBuffer.isReadable()) continue;
                    throw new IOException(ExceptionMessageHelper.exMsg("ledgerMapSize didn't match content").kv("expectedCount", countInBatch).kv("bufferSize", mapSize).kv("bytesRemaining", ledgerMapBuffer.readableBytes()).toString());
                }
                finally {
                    ReferenceCountUtil.release((Object)ledgerMapBuffer);
                }
            }
            EntryLogMetadata entryLogMetadata = meta;
            return entryLogMetadata;
        }
        catch (IOException ioe) {
            throw new IOException(ExceptionMessageHelper.exMsg("Error reading index").kv("logId", reader.logId()).kv("reason", ioe.getMessage()).toString(), ioe);
        }
        finally {
            ReferenceCountUtil.release((Object)header);
        }
    }
}

