/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.storage.ldb;

import java.util.function.Supplier;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.Gauge;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stats.annotations.StatsDoc;

@StatsDoc(name="bookie", category="server", help="DbLedgerStorage related stats")
class DbLedgerStorageStats {
    private static final String ADD_ENTRY = "add-entry";
    private static final String READ_ENTRY = "read-entry";
    private static final String READ_ENTRY_LOCATIONS_INDEX_TIME = "read-locations-index-time";
    private static final String READ_ENTRYLOG_TIME = "read-entrylog-time";
    private static final String WRITE_CACHE_HITS = "write-cache-hits";
    private static final String WRITE_CACHE_MISSES = "write-cache-misses";
    private static final String READ_CACHE_HITS = "read-cache-hits";
    private static final String READ_CACHE_MISSES = "read-cache-misses";
    private static final String READAHEAD_BATCH_COUNT = "readahead-batch-count";
    private static final String READAHEAD_BATCH_SIZE = "readahead-batch-size";
    private static final String READAHEAD_TIME = "readahead-time";
    private static final String FLUSH = "flush";
    private static final String FLUSH_ENTRYLOG = "flush-entrylog";
    private static final String FLUSH_LOCATIONS_INDEX = "flush-locations-index";
    private static final String FLUSH_LEDGER_INDEX = "flush-ledger-index";
    private static final String FLUSH_SIZE = "flush-size";
    @Deprecated
    private static final String THROTTLED_WRITE_REQUESTS = "throttled-write-requests";
    private static final String THROTTLED_WRITE = "throttled-write";
    private static final String REJECTED_WRITE_REQUESTS = "rejected-write-requests";
    private static final String WRITE_CACHE_SIZE = "write-cache-size";
    private static final String WRITE_CACHE_COUNT = "write-cache-count";
    private static final String READ_CACHE_SIZE = "read-cache-size";
    private static final String READ_CACHE_COUNT = "read-cache-count";
    @StatsDoc(name="add-entry", help="operation stats of adding entries to db ledger storage", parent="BOOKIE_ADD_ENTRY")
    private final OpStatsLogger addEntryStats;
    @StatsDoc(name="read-entry", help="operation stats of reading entries from db ledger storage", parent="BOOKIE_READ_ENTRY")
    private final OpStatsLogger readEntryStats;
    @StatsDoc(name="read-locations-index-time", help="time spent reading entries from the locations index of the db ledger storage engine", parent="read-entry")
    private final Counter readFromLocationIndexTime;
    @StatsDoc(name="read-entrylog-time", help="time spent reading entries from the entry log files of the db ledger storage engine", parent="read-entry")
    private final Counter readFromEntryLogTime;
    @StatsDoc(name="write-cache-hits", help="number of write cache hits (on reads)", parent="read-entry")
    private final Counter writeCacheHitCounter;
    @StatsDoc(name="write-cache-misses", help="number of write cache misses (on reads)", parent="read-entry")
    private final Counter writeCacheMissCounter;
    @StatsDoc(name="read-cache-hits", help="number of read cache hits", parent="read-entry")
    private final Counter readCacheHitCounter;
    @StatsDoc(name="read-cache-misses", help="number of read cache misses", parent="read-entry")
    private final Counter readCacheMissCounter;
    @StatsDoc(name="readahead-batch-count", help="the distribution of num of entries to read in one readahead batch")
    private final OpStatsLogger readAheadBatchCountStats;
    @StatsDoc(name="readahead-batch-size", help="the distribution of num of bytes to read in one readahead batch")
    private final OpStatsLogger readAheadBatchSizeStats;
    @StatsDoc(name="readahead-time", help="Time spent on readahead operations")
    private final Counter readAheadTime;
    @StatsDoc(name="flush", help="operation stats of flushing write cache to entry log files")
    private final OpStatsLogger flushStats;
    @StatsDoc(name="flush-entrylog", help="operation stats of flushing to the current entry log file")
    private final OpStatsLogger flushEntryLogStats;
    @StatsDoc(name="flush-locations-index", help="operation stats of flushing to the locations index")
    private final OpStatsLogger flushLocationIndexStats;
    @StatsDoc(name="flush-locations-index", help="operation stats of flushing to the ledger index")
    private final OpStatsLogger flushLedgerIndexStats;
    @StatsDoc(name="flush-size", help="the distribution of number of bytes flushed from write cache to entry log files")
    private final OpStatsLogger flushSizeStats;
    @StatsDoc(name="throttled-write-requests", help="The number of requests throttled due to write cache is full")
    private final Counter throttledWriteRequests;
    @StatsDoc(name="throttled-write", help="The stats of throttled write due to write cache is full")
    private final OpStatsLogger throttledWriteStats;
    @StatsDoc(name="rejected-write-requests", help="The number of requests rejected due to write cache is full")
    private final Counter rejectedWriteRequests;
    @StatsDoc(name="write-cache-size", help="Current number of bytes in write cache")
    private final Gauge<Long> writeCacheSizeGauge;
    @StatsDoc(name="write-cache-count", help="Current number of entries in write cache")
    private final Gauge<Long> writeCacheCountGauge;
    @StatsDoc(name="read-cache-size", help="Current number of bytes in read cache")
    private final Gauge<Long> readCacheSizeGauge;
    @StatsDoc(name="read-cache-count", help="Current number of entries in read cache")
    private final Gauge<Long> readCacheCountGauge;

    DbLedgerStorageStats(StatsLogger stats, final Supplier<Long> writeCacheSizeSupplier, final Supplier<Long> writeCacheCountSupplier, final Supplier<Long> readCacheSizeSupplier, final Supplier<Long> readCacheCountSupplier) {
        this.addEntryStats = stats.getThreadScopedOpStatsLogger(ADD_ENTRY);
        this.readEntryStats = stats.getThreadScopedOpStatsLogger(READ_ENTRY);
        this.readFromLocationIndexTime = stats.getThreadScopedCounter(READ_ENTRY_LOCATIONS_INDEX_TIME);
        this.readFromEntryLogTime = stats.getThreadScopedCounter(READ_ENTRYLOG_TIME);
        this.readCacheHitCounter = stats.getCounter(READ_CACHE_HITS);
        this.readCacheMissCounter = stats.getCounter(READ_CACHE_MISSES);
        this.writeCacheHitCounter = stats.getCounter(WRITE_CACHE_HITS);
        this.writeCacheMissCounter = stats.getCounter(WRITE_CACHE_MISSES);
        this.readAheadBatchCountStats = stats.getOpStatsLogger(READAHEAD_BATCH_COUNT);
        this.readAheadBatchSizeStats = stats.getOpStatsLogger(READAHEAD_BATCH_SIZE);
        this.readAheadTime = stats.getThreadScopedCounter(READAHEAD_TIME);
        this.flushStats = stats.getOpStatsLogger(FLUSH);
        this.flushEntryLogStats = stats.getOpStatsLogger(FLUSH_ENTRYLOG);
        this.flushLocationIndexStats = stats.getOpStatsLogger(FLUSH_LOCATIONS_INDEX);
        this.flushLedgerIndexStats = stats.getOpStatsLogger(FLUSH_LEDGER_INDEX);
        this.flushSizeStats = stats.getOpStatsLogger(FLUSH_SIZE);
        this.throttledWriteRequests = stats.getThreadScopedCounter(THROTTLED_WRITE_REQUESTS);
        this.throttledWriteStats = stats.getOpStatsLogger(THROTTLED_WRITE);
        this.rejectedWriteRequests = stats.getThreadScopedCounter(REJECTED_WRITE_REQUESTS);
        this.writeCacheSizeGauge = new Gauge<Long>(){

            @Override
            public Long getDefaultValue() {
                return 0L;
            }

            @Override
            public Long getSample() {
                return (Long)writeCacheSizeSupplier.get();
            }
        };
        stats.registerGauge(WRITE_CACHE_SIZE, this.writeCacheSizeGauge);
        this.writeCacheCountGauge = new Gauge<Long>(){

            @Override
            public Long getDefaultValue() {
                return 0L;
            }

            @Override
            public Long getSample() {
                return (Long)writeCacheCountSupplier.get();
            }
        };
        stats.registerGauge(WRITE_CACHE_COUNT, this.writeCacheCountGauge);
        this.readCacheSizeGauge = new Gauge<Long>(){

            @Override
            public Long getDefaultValue() {
                return 0L;
            }

            @Override
            public Long getSample() {
                return (Long)readCacheSizeSupplier.get();
            }
        };
        stats.registerGauge(READ_CACHE_SIZE, this.readCacheSizeGauge);
        this.readCacheCountGauge = new Gauge<Long>(){

            @Override
            public Long getDefaultValue() {
                return 0L;
            }

            @Override
            public Long getSample() {
                return (Long)readCacheCountSupplier.get();
            }
        };
        stats.registerGauge(READ_CACHE_COUNT, this.readCacheCountGauge);
    }

    public OpStatsLogger getAddEntryStats() {
        return this.addEntryStats;
    }

    public OpStatsLogger getReadEntryStats() {
        return this.readEntryStats;
    }

    public Counter getReadFromLocationIndexTime() {
        return this.readFromLocationIndexTime;
    }

    public Counter getReadFromEntryLogTime() {
        return this.readFromEntryLogTime;
    }

    public Counter getWriteCacheHitCounter() {
        return this.writeCacheHitCounter;
    }

    public Counter getWriteCacheMissCounter() {
        return this.writeCacheMissCounter;
    }

    public Counter getReadCacheHitCounter() {
        return this.readCacheHitCounter;
    }

    public Counter getReadCacheMissCounter() {
        return this.readCacheMissCounter;
    }

    public OpStatsLogger getReadAheadBatchCountStats() {
        return this.readAheadBatchCountStats;
    }

    public OpStatsLogger getReadAheadBatchSizeStats() {
        return this.readAheadBatchSizeStats;
    }

    public Counter getReadAheadTime() {
        return this.readAheadTime;
    }

    public OpStatsLogger getFlushStats() {
        return this.flushStats;
    }

    public OpStatsLogger getFlushEntryLogStats() {
        return this.flushEntryLogStats;
    }

    public OpStatsLogger getFlushLocationIndexStats() {
        return this.flushLocationIndexStats;
    }

    public OpStatsLogger getFlushLedgerIndexStats() {
        return this.flushLedgerIndexStats;
    }

    public OpStatsLogger getFlushSizeStats() {
        return this.flushSizeStats;
    }

    public Counter getThrottledWriteRequests() {
        return this.throttledWriteRequests;
    }

    public OpStatsLogger getThrottledWriteStats() {
        return this.throttledWriteStats;
    }

    public Counter getRejectedWriteRequests() {
        return this.rejectedWriteRequests;
    }

    public Gauge<Long> getWriteCacheSizeGauge() {
        return this.writeCacheSizeGauge;
    }

    public Gauge<Long> getWriteCacheCountGauge() {
        return this.writeCacheCountGauge;
    }

    public Gauge<Long> getReadCacheSizeGauge() {
        return this.readCacheSizeGauge;
    }

    public Gauge<Long> getReadCacheCountGauge() {
        return this.readCacheCountGauge;
    }
}

