/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.EnsemblePlacementPolicy;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerFragment;
import org.apache.bookkeeper.client.LedgerFragmentReplicator;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.LedgerMetadataUtils;
import org.apache.bookkeeper.client.LedgerOpenOp;
import org.apache.bookkeeper.client.RoundRobinDistributionSchedule;
import org.apache.bookkeeper.client.SyncCallbackUtils;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.discover.BookieServiceInfo;
import org.apache.bookkeeper.discover.RegistrationClient;
import org.apache.bookkeeper.discover.RegistrationManager;
import org.apache.bookkeeper.meta.LedgerAuditorManager;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.meta.LedgerUnderreplicationManager;
import org.apache.bookkeeper.meta.MetadataBookieDriver;
import org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.bookkeeper.meta.UnderreplicatedLedger;
import org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.proto.BookieAddressResolver;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.replication.BookieLedgerIndexer;
import org.apache.bookkeeper.replication.ReplicationException;
import org.apache.bookkeeper.shaded.com.google.common.base.Preconditions;
import org.apache.bookkeeper.shaded.com.google.common.collect.Lists;
import org.apache.bookkeeper.shaded.com.google.common.collect.Maps;
import org.apache.bookkeeper.shaded.com.google.common.collect.Sets;
import org.apache.bookkeeper.shaded.com.google.common.util.concurrent.UncheckedExecutionException;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.util.AvailabilityOfEntriesOfLedger;
import org.apache.bookkeeper.util.IOUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookKeeperAdmin
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(BookKeeperAdmin.class);
    private static final Logger VERBOSE = LoggerFactory.getLogger((String)"verbose");
    private static final BiConsumer<Long, Long> NOOP_BICONSUMER = (l, e) -> {};
    private BookKeeper bkc;
    private final boolean ownsBK;
    private LedgerFragmentReplicator lfr;
    private LedgerManagerFactory mFactory;
    private LedgerUnderreplicationManager underreplicationManager;
    private LedgerAuditorManager ledgerAuditorManager;

    public BookKeeperAdmin(String zkServers) throws IOException, InterruptedException, BKException {
        this((ClientConfiguration)((Object)new ClientConfiguration().setMetadataServiceUri("zk+null://" + zkServers + "/ledgers")));
    }

    public BookKeeperAdmin(ClientConfiguration conf) throws IOException, InterruptedException, BKException {
        this.bkc = new BookKeeper(conf);
        this.ownsBK = true;
        this.lfr = new LedgerFragmentReplicator(this.bkc, NullStatsLogger.INSTANCE, conf);
        this.mFactory = this.bkc.ledgerManagerFactory;
    }

    public BookKeeperAdmin(BookKeeper bkc, StatsLogger statsLogger, ClientConfiguration conf) {
        Objects.requireNonNull(conf, "Client configuration cannot be null");
        this.bkc = bkc;
        this.ownsBK = false;
        this.lfr = new LedgerFragmentReplicator(bkc, statsLogger, conf);
        this.mFactory = bkc.ledgerManagerFactory;
    }

    public BookKeeperAdmin(BookKeeper bkc, ClientConfiguration conf) {
        this(bkc, NullStatsLogger.INSTANCE, conf);
    }

    public BookKeeperAdmin(BookKeeper bkc) {
        this.bkc = bkc;
        this.ownsBK = false;
        this.mFactory = bkc.ledgerManagerFactory;
    }

    public ClientConfiguration getConf() {
        return this.bkc.getConf();
    }

    @Override
    public void close() throws InterruptedException, BKException {
        if (this.ownsBK) {
            this.bkc.close();
        }
        if (this.ledgerAuditorManager != null) {
            try {
                this.ledgerAuditorManager.close();
            }
            catch (Exception e) {
                throw new BKException.MetaStoreException(e);
            }
        }
    }

    public Collection<BookieId> getAvailableBookies() throws BKException {
        return this.bkc.bookieWatcher.getBookies();
    }

    public Collection<BookieId> getAllBookies() throws BKException {
        return this.bkc.bookieWatcher.getAllBookies();
    }

    public BookieAddressResolver getBookieAddressResolver() {
        return this.bkc.bookieWatcher.getBookieAddressResolver();
    }

    public BookieServiceInfo getBookieServiceInfo(BookieId bookiedId) throws BKException {
        return FutureUtils.result(this.bkc.getMetadataClientDriver().getRegistrationClient().getBookieServiceInfo(bookiedId)).getValue();
    }

    public Collection<BookieId> getReadOnlyBookies() throws BKException {
        return this.bkc.bookieWatcher.getReadOnlyBookies();
    }

    public void watchWritableBookiesChanged(RegistrationClient.RegistrationListener listener) throws BKException {
        this.bkc.getMetadataClientDriver().getRegistrationClient().watchWritableBookies(listener);
    }

    public void watchReadOnlyBookiesChanged(RegistrationClient.RegistrationListener listener) throws BKException {
        this.bkc.getMetadataClientDriver().getRegistrationClient().watchReadOnlyBookies(listener);
    }

    public void asyncOpenLedger(long lId, AsyncCallback.OpenCallback cb, Object ctx) {
        new LedgerOpenOp(this.bkc, this.bkc.getClientCtx().getClientStats(), lId, cb, ctx).initiate();
    }

    public LedgerHandle openLedger(long lId) throws InterruptedException, BKException {
        CompletableFuture future = new CompletableFuture();
        SyncCallbackUtils.SyncOpenCallback result = new SyncCallbackUtils.SyncOpenCallback(future);
        new LedgerOpenOp(this.bkc, this.bkc.getClientCtx().getClientStats(), lId, result, null).initiate();
        return (LedgerHandle)SyncCallbackUtils.waitForResult(future);
    }

    public void asyncOpenLedgerNoRecovery(long lId, AsyncCallback.OpenCallback cb, Object ctx) {
        new LedgerOpenOp(this.bkc, this.bkc.getClientCtx().getClientStats(), lId, cb, ctx).initiateWithoutRecovery();
    }

    public LedgerHandle openLedgerNoRecovery(long lId) throws InterruptedException, BKException {
        CompletableFuture future = new CompletableFuture();
        SyncCallbackUtils.SyncOpenCallback result = new SyncCallbackUtils.SyncOpenCallback(future);
        new LedgerOpenOp(this.bkc, this.bkc.getClientCtx().getClientStats(), lId, result, null).initiateWithoutRecovery();
        return (LedgerHandle)SyncCallbackUtils.waitForResult(future);
    }

    public Iterable<LedgerEntry> readEntries(long ledgerId, long firstEntry, long lastEntry) throws InterruptedException, BKException {
        Preconditions.checkArgument(ledgerId >= 0L && firstEntry >= 0L);
        return new LedgerEntriesIterable(ledgerId, firstEntry, lastEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<Long, LedgerMetadata> getLedgersContainBookies(Set<BookieId> bookies) throws InterruptedException, BKException {
        final SyncObject sync = new SyncObject();
        final AtomicReference<Object> resultHolder = new AtomicReference<Object>(null);
        this.asyncGetLedgersContainBookies(bookies, new BookkeeperInternalCallbacks.GenericCallback<SortedMap<Long, LedgerMetadata>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void operationComplete(int rc, SortedMap<Long, LedgerMetadata> result) {
                LOG.info("GetLedgersContainBookies completed with rc : {}", (Object)rc);
                SyncObject syncObject = sync;
                synchronized (syncObject) {
                    sync.rc = rc;
                    sync.value = true;
                    resultHolder.set(result);
                    sync.notify();
                }
            }
        });
        SyncObject syncObject = sync;
        synchronized (syncObject) {
            while (!sync.value) {
                sync.wait();
            }
        }
        if (sync.rc != 0) {
            throw BKException.create(sync.rc);
        }
        return resultHolder.get();
    }

    public void asyncGetLedgersContainBookies(final Set<BookieId> bookies, final BookkeeperInternalCallbacks.GenericCallback<SortedMap<Long, LedgerMetadata>> callback) {
        final ConcurrentSkipListMap ledgers = new ConcurrentSkipListMap();
        this.bkc.getLedgerManager().asyncProcessLedgers(new BookkeeperInternalCallbacks.Processor<Long>(){

            @Override
            public void process(Long lid, AsyncCallback.VoidCallback cb) {
                BookKeeperAdmin.this.bkc.getLedgerManager().readLedgerMetadata(lid).whenComplete((metadata, exception) -> {
                    if (BKException.getExceptionCode(exception) == -25) {
                        cb.processResult(0, null, null);
                        return;
                    }
                    if (exception != null) {
                        cb.processResult(BKException.getExceptionCode(exception), null, null);
                        return;
                    }
                    Set<BookieId> bookiesInLedger = LedgerMetadataUtils.getBookiesInThisLedger((LedgerMetadata)metadata.getValue());
                    Sets.SetView<BookieId> intersection = Sets.intersection(bookiesInLedger, bookies);
                    if (!intersection.isEmpty()) {
                        ledgers.put(lid, metadata.getValue());
                    }
                    cb.processResult(0, null, null);
                });
            }
        }, new AsyncCallback.VoidCallback(){

            public void processResult(int rc, String path, Object ctx) {
                callback.operationComplete(rc, ledgers);
            }
        }, null, 0, -18);
    }

    public void recoverBookieData(BookieId bookieSrc) throws InterruptedException, BKException {
        HashSet<BookieId> bookiesSrc = Sets.newHashSet(bookieSrc);
        this.recoverBookieData(bookiesSrc);
    }

    public void recoverBookieData(Set<BookieId> bookiesSrc) throws InterruptedException, BKException {
        this.recoverBookieData(bookiesSrc, false, false);
    }

    public void recoverBookieData(Set<BookieId> bookiesSrc, boolean dryrun, boolean skipOpenLedgers) throws InterruptedException, BKException {
        this.recoverBookieData(bookiesSrc, dryrun, skipOpenLedgers, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverBookieData(Set<BookieId> bookiesSrc, boolean dryrun, boolean skipOpenLedgers, boolean skipUnrecoverableLedgers) throws InterruptedException, BKException {
        SyncObject sync = new SyncObject();
        this.asyncRecoverBookieData(bookiesSrc, dryrun, skipOpenLedgers, skipUnrecoverableLedgers, new AsyncCallback.RecoverCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void recoverComplete(int rc, Object ctx) {
                SyncObject syncObj;
                LOG.info("Recover bookie operation completed with rc: {}", BKException.codeLogger(rc));
                SyncObject syncObject = syncObj = (SyncObject)ctx;
                synchronized (syncObject) {
                    syncObj.rc = rc;
                    syncObj.value = true;
                    syncObj.notify();
                }
            }
        }, (Object)sync);
        SyncObject syncObject = sync;
        synchronized (syncObject) {
            while (!sync.value) {
                sync.wait();
            }
        }
        if (sync.rc != 0) {
            throw BKException.create(sync.rc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverBookieData(long lid, Set<BookieId> bookiesSrc, boolean dryrun, boolean skipOpenLedgers) throws InterruptedException, BKException {
        SyncObject sync = new SyncObject();
        this.asyncRecoverBookieData(lid, bookiesSrc, dryrun, skipOpenLedgers, (int rc, Object ctx) -> {
            SyncObject syncObject;
            LOG.info("Recover bookie for {} completed with rc : {}", (Object)lid, BKException.codeLogger(rc));
            SyncObject syncObject2 = syncObject = (SyncObject)ctx;
            synchronized (syncObject2) {
                syncObject.rc = rc;
                syncObject.value = true;
                syncObject.notify();
            }
        }, (Object)sync);
        SyncObject syncObject = sync;
        synchronized (syncObject) {
            while (!sync.value) {
                sync.wait();
            }
        }
        if (sync.rc != 0) {
            throw BKException.create(sync.rc);
        }
    }

    public void asyncRecoverBookieData(BookieId bookieSrc, AsyncCallback.RecoverCallback cb, Object context) {
        HashSet<BookieId> bookiesSrc = Sets.newHashSet(bookieSrc);
        this.asyncRecoverBookieData(bookiesSrc, cb, context);
    }

    public void asyncRecoverBookieData(Set<BookieId> bookieSrc, AsyncCallback.RecoverCallback cb, Object context) {
        this.asyncRecoverBookieData(bookieSrc, false, false, false, cb, context);
    }

    public void asyncRecoverBookieData(Set<BookieId> bookieSrc, boolean dryrun, boolean skipOpenLedgers, boolean skipUnrecoverableLedgers, AsyncCallback.RecoverCallback cb, Object context) {
        this.getActiveLedgers(bookieSrc, dryrun, skipOpenLedgers, skipUnrecoverableLedgers, cb, context);
    }

    public void asyncRecoverBookieData(long lid, Set<BookieId> bookieSrc, boolean dryrun, boolean skipOpenLedgers, AsyncCallback.RecoverCallback callback, Object context) {
        AsyncCallback.VoidCallback callbackWrapper = (rc, path, ctx) -> callback.recoverComplete(this.bkc.getReturnRc(rc), context);
        this.recoverLedger(bookieSrc, lid, dryrun, skipOpenLedgers, callbackWrapper);
    }

    private void getActiveLedgers(final Set<BookieId> bookiesSrc, final boolean dryrun, final boolean skipOpenLedgers, final boolean skipUnrecoverableLedgers, AsyncCallback.RecoverCallback cb, Object context) {
        BookkeeperInternalCallbacks.Processor<Long> ledgerProcessor = new BookkeeperInternalCallbacks.Processor<Long>(){

            @Override
            public void process(Long ledgerId, AsyncCallback.VoidCallback iterCallback) {
                BookKeeperAdmin.this.recoverLedger(bookiesSrc, ledgerId, dryrun, skipOpenLedgers, skipUnrecoverableLedgers, iterCallback);
            }
        };
        class RecoverCallbackWrapper
        implements AsyncCallback.VoidCallback {
            final AsyncCallback.RecoverCallback cb;

            RecoverCallbackWrapper(AsyncCallback.RecoverCallback cb) {
                this.cb = cb;
            }

            public void processResult(int rc, String path, Object ctx) {
                this.cb.recoverComplete(BookKeeperAdmin.this.bkc.getReturnRc(rc), ctx);
            }
        }
        this.bkc.getLedgerManager().asyncProcessLedgers(ledgerProcessor, new RecoverCallbackWrapper(cb), context, 0, -10);
    }

    private void recoverLedger(Set<BookieId> bookiesSrc, long lId, boolean dryrun, boolean skipOpenLedgers, AsyncCallback.VoidCallback finalLedgerIterCb) {
        this.recoverLedger(bookiesSrc, lId, dryrun, skipOpenLedgers, false, finalLedgerIterCb);
    }

    private void recoverLedger(final Set<BookieId> bookiesSrc, final long lId, final boolean dryrun, final boolean skipOpenLedgers, final boolean skipUnrecoverableLedgers, final AsyncCallback.VoidCallback finalLedgerIterCb) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Recovering ledger : {}", (Object)lId);
        }
        this.asyncOpenLedgerNoRecovery(lId, new AsyncCallback.OpenCallback(){

            @Override
            public void openComplete(int rc, final LedgerHandle lh, Object ctx) {
                boolean fenceRequired;
                if (rc != 0) {
                    if (skipUnrecoverableLedgers) {
                        LOG.warn("BK error opening ledger: {}, skip recover it.", (Object)lId, (Object)BKException.create(rc));
                        finalLedgerIterCb.processResult(0, null, null);
                    } else {
                        LOG.error("BK error opening ledger: {}", (Object)lId, (Object)BKException.create(rc));
                        finalLedgerIterCb.processResult(rc, null, null);
                    }
                    return;
                }
                LedgerMetadata lm = lh.getLedgerMetadata();
                if (skipOpenLedgers && lm.getState() == LedgerMetadata.State.OPEN) {
                    LOG.info("Skip recovering open ledger {}.", (Object)lId);
                    try {
                        lh.close();
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                    catch (BKException bke) {
                        LOG.warn("Error on closing ledger handle for {}.", (Object)lId);
                    }
                    finalLedgerIterCb.processResult(0, null, null);
                    return;
                }
                boolean bl = fenceRequired = !lm.isClosed() && BookKeeperAdmin.containBookiesInLastEnsemble(lm, bookiesSrc);
                if (!dryrun && fenceRequired) {
                    try {
                        lh.close();
                    }
                    catch (Exception ie) {
                        LOG.warn("Error closing non recovery ledger handle for ledger " + lId, (Throwable)ie);
                    }
                    BookKeeperAdmin.this.asyncOpenLedger(lId, new AsyncCallback.OpenCallback(){

                        @Override
                        public void openComplete(int newrc, LedgerHandle newlh, Object newctx) {
                            if (newrc != 0) {
                                if (skipUnrecoverableLedgers) {
                                    LOG.warn("BK error opening ledger: {}, skip recover it.", (Object)lId, (Object)BKException.create(newrc));
                                    finalLedgerIterCb.processResult(0, null, null);
                                } else {
                                    LOG.error("BK error close ledger: {}", (Object)lId, (Object)BKException.create(newrc));
                                    finalLedgerIterCb.processResult(newrc, null, null);
                                }
                                return;
                            }
                            ((BookKeeperAdmin)BookKeeperAdmin.this).bkc.mainWorkerPool.submit(() -> BookKeeperAdmin.this.recoverLedger(bookiesSrc, lId, dryrun, skipOpenLedgers, skipUnrecoverableLedgers, finalLedgerIterCb));
                        }
                    }, null);
                    return;
                }
                AsyncCallback.VoidCallback ledgerIterCb = new AsyncCallback.VoidCallback(){

                    public void processResult(int rc, String path, Object ctx) {
                        if (0 != rc) {
                            if (skipUnrecoverableLedgers) {
                                LOG.warn("Failed to recover ledger: {} : {}, skip recover it.", (Object)lId, BKException.codeLogger(rc));
                                rc = 0;
                            } else {
                                LOG.error("Failed to recover ledger {} : {}", (Object)lId, BKException.codeLogger(rc));
                            }
                        } else {
                            LOG.info("Recovered ledger {}.", (Object)lId);
                        }
                        try {
                            lh.close();
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                        }
                        catch (BKException bke) {
                            LOG.warn("Error on closing ledger handle for {}.", (Object)lId);
                        }
                        finalLedgerIterCb.processResult(rc, path, ctx);
                    }
                };
                LinkedList ledgerFragmentsToRecover = new LinkedList();
                HashMap<Long, Long> ledgerFragmentsRange = new HashMap<Long, Long>();
                Long curEntryId = null;
                for (Map.Entry entry : lh.getLedgerMetadata().getAllEnsembles().entrySet()) {
                    if (curEntryId != null) {
                        ledgerFragmentsRange.put(curEntryId, (Long)entry.getKey() - 1L);
                    }
                    curEntryId = (Long)entry.getKey();
                    if (!BookKeeperAdmin.containBookies((List)entry.getValue(), bookiesSrc)) continue;
                    ledgerFragmentsToRecover.add(entry.getKey());
                }
                if (curEntryId != null) {
                    ledgerFragmentsRange.put(curEntryId, lh.getLastAddConfirmed());
                }
                if (ledgerFragmentsToRecover.size() == 0) {
                    ledgerIterCb.processResult(0, null, null);
                    return;
                }
                if (dryrun) {
                    VERBOSE.info("Recovered ledger {} : {}", (Object)lId, (Object)(fenceRequired ? "[fence required]" : ""));
                }
                BookkeeperInternalCallbacks.MultiCallback ledgerFragmentsMcb = new BookkeeperInternalCallbacks.MultiCallback(ledgerFragmentsToRecover.size(), ledgerIterCb, null, 0, -10);
                for (Long startEntryId : ledgerFragmentsToRecover) {
                    Map targetBookieAddresses;
                    Long endEntryId = (Long)ledgerFragmentsRange.get(startEntryId);
                    List ensemble = (List)lh.getLedgerMetadata().getAllEnsembles().get(startEntryId);
                    try {
                        targetBookieAddresses = BookKeeperAdmin.this.getReplacementBookies(lh, ensemble, bookiesSrc);
                    }
                    catch (BKException.BKNotEnoughBookiesException e) {
                        if (!dryrun) {
                            ledgerFragmentsMcb.processResult(-6, null, null);
                            continue;
                        }
                        VERBOSE.info("  Fragment [{} - {}] : {}", new Object[]{startEntryId, endEntryId, BKException.getMessage(-6)});
                        continue;
                    }
                    if (dryrun) {
                        ArrayList newEnsemble = BookKeeperAdmin.this.replaceBookiesInEnsemble(ensemble, targetBookieAddresses);
                        VERBOSE.info("  Fragment [{} - {}] : ", (Object)startEntryId, (Object)endEntryId);
                        VERBOSE.info("    old ensemble : {}", (Object)BookKeeperAdmin.formatEnsemble(ensemble, bookiesSrc, '*'));
                        VERBOSE.info("    new ensemble : {}", (Object)BookKeeperAdmin.formatEnsemble(newEnsemble, bookiesSrc, '*'));
                        continue;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Replicating fragment from [{}, {}] of ledger {} to {}", new Object[]{startEntryId, endEntryId, lh.getId(), targetBookieAddresses});
                    }
                    try {
                        LedgerFragmentReplicator.SingleFragmentCallback cb = new LedgerFragmentReplicator.SingleFragmentCallback(ledgerFragmentsMcb, lh, BookKeeperAdmin.this.bkc.getLedgerManager(), startEntryId, BookKeeperAdmin.getReplacementBookiesMap(ensemble, (Map<Integer, BookieId>)targetBookieAddresses));
                        LedgerFragment ledgerFragment = new LedgerFragment(lh, startEntryId, endEntryId, targetBookieAddresses.keySet());
                        BookKeeperAdmin.this.asyncRecoverLedgerFragment(lh, ledgerFragment, cb, Sets.newHashSet(targetBookieAddresses.values()), NOOP_BICONSUMER);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
                if (dryrun) {
                    ledgerIterCb.processResult(0, null, null);
                }
            }
        }, null);
    }

    static String formatEnsemble(List<BookieId> ensemble, Set<BookieId> bookiesSrc, char marker) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < ensemble.size(); ++i) {
            sb.append(ensemble.get(i));
            if (bookiesSrc.contains(ensemble.get(i))) {
                sb.append(marker);
            } else {
                sb.append(' ');
            }
            if (i == ensemble.size() - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    private void asyncRecoverLedgerFragment(LedgerHandle lh, LedgerFragment ledgerFragment, AsyncCallback.VoidCallback ledgerFragmentMcb, Set<BookieId> newBookies, BiConsumer<Long, Long> onReadEntryFailureCallback) throws InterruptedException {
        this.lfr.replicate(lh, ledgerFragment, ledgerFragmentMcb, newBookies, onReadEntryFailureCallback);
    }

    private Map<Integer, BookieId> getReplacementBookies(LedgerHandle lh, List<BookieId> ensemble, Set<BookieId> bookiesToRereplicate) throws BKException.BKNotEnoughBookiesException {
        HashSet<Integer> bookieIndexesToRereplicate = Sets.newHashSet();
        for (int bookieIndex = 0; bookieIndex < ensemble.size(); ++bookieIndex) {
            BookieId bookieInEnsemble = ensemble.get(bookieIndex);
            if (!bookiesToRereplicate.contains(bookieInEnsemble)) continue;
            bookieIndexesToRereplicate.add(bookieIndex);
        }
        return this.getReplacementBookiesByIndexes(lh, ensemble, bookieIndexesToRereplicate, Optional.of(bookiesToRereplicate));
    }

    private Map<Integer, BookieId> getReplacementBookiesByIndexes(LedgerHandle lh, List<BookieId> ensemble, Set<Integer> bookieIndexesToRereplicate, Optional<Set<BookieId>> excludedBookies) throws BKException.BKNotEnoughBookiesException {
        HashMap<Integer, BookieId> targetBookieAddresses = Maps.newHashMapWithExpectedSize(bookieIndexesToRereplicate.size());
        HashSet<BookieId> bookiesToExclude = Sets.newHashSet();
        if (excludedBookies.isPresent()) {
            bookiesToExclude.addAll((Collection)excludedBookies.get());
        }
        for (Integer bookieIndex : bookieIndexesToRereplicate) {
            BookieId bookie = ensemble.get(bookieIndex);
            bookiesToExclude.add(bookie);
        }
        for (Integer bookieIndex : bookieIndexesToRereplicate) {
            BookieId oldBookie = ensemble.get(bookieIndex);
            EnsemblePlacementPolicy.PlacementResult<BookieId> replaceBookieResponse = this.bkc.getPlacementPolicy().replaceBookie(lh.getLedgerMetadata().getEnsembleSize(), lh.getLedgerMetadata().getWriteQuorumSize(), lh.getLedgerMetadata().getAckQuorumSize(), lh.getLedgerMetadata().getCustomMetadata(), ensemble, oldBookie, bookiesToExclude);
            BookieId newBookie = replaceBookieResponse.getResult();
            EnsemblePlacementPolicy.PlacementPolicyAdherence isEnsembleAdheringToPlacementPolicy = replaceBookieResponse.getAdheringToPolicy();
            if (isEnsembleAdheringToPlacementPolicy == EnsemblePlacementPolicy.PlacementPolicyAdherence.FAIL && LOG.isDebugEnabled()) {
                LOG.debug("replaceBookie for bookie: {} in ensemble: {} is not adhering to placement policy and chose {}", new Object[]{oldBookie, ensemble, newBookie});
            }
            targetBookieAddresses.put(bookieIndex, newBookie);
            bookiesToExclude.add(newBookie);
        }
        return targetBookieAddresses;
    }

    private ArrayList<BookieId> replaceBookiesInEnsemble(List<BookieId> ensemble, Map<Integer, BookieId> replacedBookies) {
        ArrayList<BookieId> newEnsemble = Lists.newArrayList(ensemble);
        for (Map.Entry<Integer, BookieId> entry : replacedBookies.entrySet()) {
            newEnsemble.set(entry.getKey(), entry.getValue());
        }
        return newEnsemble;
    }

    public void replicateLedgerFragment(LedgerHandle lh, LedgerFragment ledgerFragment, BiConsumer<Long, Long> onReadEntryFailureCallback) throws InterruptedException, BKException {
        Map<Integer, BookieId> targetBookieAddresses = null;
        if (LedgerFragment.ReplicateType.DATA_LOSS == ledgerFragment.getReplicateType()) {
            Optional<Set<BookieId>> excludedBookies = Optional.empty();
            targetBookieAddresses = this.getReplacementBookiesByIndexes(lh, ledgerFragment.getEnsemble(), ledgerFragment.getBookiesIndexes(), excludedBookies);
        } else if (LedgerFragment.ReplicateType.DATA_NOT_ADHERING_PLACEMENT == ledgerFragment.getReplicateType()) {
            targetBookieAddresses = this.replaceNotAdheringPlacementPolicyBookie(ledgerFragment.getEnsemble(), lh.getLedgerMetadata().getWriteQuorumSize(), lh.getLedgerMetadata().getAckQuorumSize());
            ledgerFragment.getBookiesIndexes().addAll(targetBookieAddresses.keySet());
        }
        if (MapUtils.isEmpty(targetBookieAddresses)) {
            LOG.warn("Could not replicate for {} ledger: {}, not find target bookie.", (Object)ledgerFragment.getReplicateType(), (Object)ledgerFragment.getLedgerId());
            throw new BKException.BKLedgerRecoveryException();
        }
        this.replicateLedgerFragment(lh, ledgerFragment, targetBookieAddresses, onReadEntryFailureCallback);
    }

    private void replicateLedgerFragment(LedgerHandle lh, LedgerFragment ledgerFragment, Map<Integer, BookieId> targetBookieAddresses, BiConsumer<Long, Long> onReadEntryFailureCallback) throws InterruptedException, BKException {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        ResultCallBack resultCallBack = new ResultCallBack(result);
        LedgerFragmentReplicator.SingleFragmentCallback cb = new LedgerFragmentReplicator.SingleFragmentCallback(resultCallBack, lh, this.bkc.getLedgerManager(), ledgerFragment.getFirstEntryId(), BookKeeperAdmin.getReplacementBookiesMap(ledgerFragment, targetBookieAddresses));
        HashSet<BookieId> targetBookieSet = Sets.newHashSet();
        targetBookieSet.addAll(targetBookieAddresses.values());
        this.asyncRecoverLedgerFragment(lh, ledgerFragment, cb, targetBookieSet, onReadEntryFailureCallback);
        try {
            SyncCallbackUtils.waitForResult(result);
        }
        catch (BKException err) {
            throw BKException.create(this.bkc.getReturnRc(err.getCode()));
        }
    }

    private static Map<BookieId, BookieId> getReplacementBookiesMap(List<BookieId> ensemble, Map<Integer, BookieId> targetBookieAddresses) {
        HashMap<BookieId, BookieId> bookiesMap = new HashMap<BookieId, BookieId>();
        for (Map.Entry<Integer, BookieId> entry : targetBookieAddresses.entrySet()) {
            BookieId oldBookie = ensemble.get(entry.getKey());
            BookieId newBookie = entry.getValue();
            bookiesMap.put(oldBookie, newBookie);
        }
        return bookiesMap;
    }

    private static Map<BookieId, BookieId> getReplacementBookiesMap(LedgerFragment ledgerFragment, Map<Integer, BookieId> targetBookieAddresses) {
        HashMap<BookieId, BookieId> bookiesMap = new HashMap<BookieId, BookieId>();
        for (Integer bookieIndex : ledgerFragment.getBookiesIndexes()) {
            BookieId oldBookie = ledgerFragment.getAddress(bookieIndex);
            BookieId newBookie = targetBookieAddresses.get(bookieIndex);
            bookiesMap.put(oldBookie, newBookie);
        }
        return bookiesMap;
    }

    private static boolean containBookiesInLastEnsemble(LedgerMetadata lm, Set<BookieId> bookies) {
        if (lm.getAllEnsembles().size() <= 0) {
            return false;
        }
        Long lastKey = (Long)lm.getAllEnsembles().lastKey();
        List lastEnsemble = (List)lm.getAllEnsembles().get(lastKey);
        return BookKeeperAdmin.containBookies(lastEnsemble, bookies);
    }

    private static boolean containBookies(List<BookieId> ensemble, Set<BookieId> bookies) {
        for (BookieId bookie : ensemble) {
            if (!bookies.contains(bookie)) continue;
            return true;
        }
        return false;
    }

    public static boolean format(final ServerConfiguration conf, final boolean isInteractive, final boolean force) throws Exception {
        return MetadataDrivers.runFunctionWithMetadataBookieDriver(conf, new Function<MetadataBookieDriver, Boolean>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
            public Boolean apply(MetadataBookieDriver driver) {
                try (RegistrationManager regManager = driver.createRegistrationManager();){
                    boolean ledgerRootExists = regManager.prepareFormat();
                    boolean doFormat = true;
                    if (ledgerRootExists) {
                        doFormat = !isInteractive ? force : IOUtils.confirmPrompt("Ledger root already exists. Are you sure to format bookkeeper metadata? This may cause data loss.");
                    }
                    if (!doFormat) {
                        Boolean bl = false;
                        return bl;
                    }
                    driver.getLedgerManagerFactory().format(conf, driver.getLayoutManager());
                    Boolean bl = regManager.format();
                    return bl;
                }
                catch (Exception e) {
                    throw new UncheckedExecutionException(e.getMessage(), e);
                }
            }
        });
    }

    public static boolean initNewCluster(ServerConfiguration conf) throws Exception {
        return MetadataDrivers.runFunctionWithRegistrationManager(conf, rm -> {
            try {
                return rm.initNewCluster();
            }
            catch (Exception e) {
                throw new UncheckedExecutionException(e.getMessage(), e);
            }
        });
    }

    public static boolean nukeExistingCluster(ServerConfiguration conf, String ledgersRootPath, String instanceId, boolean force) throws Exception {
        String confLedgersRootPath = ZKMetadataDriverBase.resolveZkLedgersRootPath(conf);
        if (!confLedgersRootPath.equals(ledgersRootPath)) {
            LOG.error("Provided ledgerRootPath : {} is not matching with config's ledgerRootPath: {}, so exiting nuke operation", (Object)ledgersRootPath, (Object)confLedgersRootPath);
            return false;
        }
        return MetadataDrivers.runFunctionWithRegistrationManager(conf, rm -> {
            try {
                if (!force) {
                    String readInstanceId = rm.getClusterInstanceId();
                    if (instanceId == null || !instanceId.equals(readInstanceId)) {
                        LOG.error("Provided InstanceId : {} is not matching with cluster InstanceId in ZK: {}", (Object)instanceId, (Object)readInstanceId);
                        return false;
                    }
                }
                return rm.nukeExistingCluster();
            }
            catch (Exception e) {
                throw new UncheckedExecutionException(e.getMessage(), e);
            }
        });
    }

    public static boolean initBookie(ServerConfiguration conf) throws Exception {
        File[] journalDirs = conf.getJournalDirs();
        if (!BookKeeperAdmin.validateDirectoriesAreEmpty(journalDirs, "JournalDir")) {
            return false;
        }
        File[] ledgerDirs = conf.getLedgerDirs();
        if (!BookKeeperAdmin.validateDirectoriesAreEmpty(ledgerDirs, "LedgerDir")) {
            return false;
        }
        File[] indexDirs = conf.getIndexDirs();
        if (indexDirs != null && !BookKeeperAdmin.validateDirectoriesAreEmpty(indexDirs, "IndexDir")) {
            return false;
        }
        return MetadataDrivers.runFunctionWithRegistrationManager(conf, rm -> {
            try {
                BookieId bookieId = BookieImpl.getBookieId(conf);
                if (rm.isBookieRegistered(bookieId)) {
                    LOG.error("Bookie with bookieId: {} is still registered, If this node is running bookie process, try stopping it first.", (Object)bookieId);
                    return false;
                }
                try {
                    rm.readCookie(bookieId);
                    LOG.error("Cookie still exists in the ZK for this bookie: {}, try formatting the bookie", (Object)bookieId);
                    return false;
                }
                catch (BookieException.CookieNotFoundException cookieNotFoundException) {
                    return true;
                }
            }
            catch (Exception e) {
                throw new UncheckedExecutionException(e.getMessage(), e);
            }
        });
    }

    private static boolean validateDirectoriesAreEmpty(File[] dirs, String typeOfDir) {
        for (File dir : dirs) {
            File[] dirFiles = dir.listFiles();
            if (dirFiles == null || dirFiles.length == 0) continue;
            LOG.error("{}: {} is existing and its not empty, try formatting the bookie", (Object)typeOfDir, (Object)dir);
            return false;
        }
        return true;
    }

    public Iterable<Long> listLedgers() throws IOException {
        final LedgerManager.LedgerRangeIterator iterator = this.bkc.getLedgerManager().getLedgerRanges(0L);
        return new Iterable<Long>(){

            @Override
            public Iterator<Long> iterator() {
                return new Iterator<Long>(){
                    Iterator<Long> currentRange = null;

                    @Override
                    public boolean hasNext() {
                        try {
                            if (iterator.hasNext()) {
                                return true;
                            }
                            if (this.currentRange != null && this.currentRange.hasNext()) {
                                return true;
                            }
                        }
                        catch (IOException e) {
                            LOG.error("Error while checking if there is a next element", (Throwable)e);
                        }
                        return false;
                    }

                    @Override
                    public Long next() throws NoSuchElementException {
                        try {
                            if (this.currentRange == null || !this.currentRange.hasNext()) {
                                this.currentRange = iterator.next().getLedgers().iterator();
                            }
                        }
                        catch (IOException e) {
                            LOG.error("Error while reading the next element", (Throwable)e);
                            throw new NoSuchElementException(e.getMessage());
                        }
                        return this.currentRange.next();
                    }

                    @Override
                    public void remove() throws UnsupportedOperationException {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public LedgerMetadata getLedgerMetadata(LedgerHandle lh) {
        return lh.getLedgerMetadata();
    }

    private LedgerUnderreplicationManager getUnderreplicationManager() throws ReplicationException.CompatibilityException, ReplicationException.UnavailableException, InterruptedException {
        if (this.underreplicationManager == null) {
            this.underreplicationManager = this.mFactory.newLedgerUnderreplicationManager();
        }
        return this.underreplicationManager;
    }

    private LedgerAuditorManager getLedgerAuditorManager() throws IOException, InterruptedException {
        if (this.ledgerAuditorManager == null) {
            this.ledgerAuditorManager = this.mFactory.newLedgerAuditorManager();
        }
        return this.ledgerAuditorManager;
    }

    public void setLostBookieRecoveryDelay(int lostBookieRecoveryDelay) throws ReplicationException.CompatibilityException, KeeperException, InterruptedException, ReplicationException.UnavailableException {
        LedgerUnderreplicationManager urlManager = this.getUnderreplicationManager();
        urlManager.setLostBookieRecoveryDelay(lostBookieRecoveryDelay);
    }

    public int getLostBookieRecoveryDelay() throws ReplicationException.CompatibilityException, KeeperException, InterruptedException, ReplicationException.UnavailableException {
        LedgerUnderreplicationManager urlManager = this.getUnderreplicationManager();
        return urlManager.getLostBookieRecoveryDelay();
    }

    public void triggerAudit() throws ReplicationException.CompatibilityException, KeeperException, InterruptedException, ReplicationException.UnavailableException, IOException {
        LedgerUnderreplicationManager urlManager = this.getUnderreplicationManager();
        if (!urlManager.isLedgerReplicationEnabled()) {
            LOG.error("Autorecovery is disabled. So giving up!");
            throw new ReplicationException.UnavailableException("Autorecovery is disabled. So giving up!");
        }
        BookieId auditorId = this.getLedgerAuditorManager().getCurrentAuditor();
        if (auditorId == null) {
            LOG.error("No auditor elected, though Autorecovery is enabled. So giving up.");
            throw new ReplicationException.UnavailableException("No auditor elected, though Autorecovery is enabled. So giving up.");
        }
        int previousLostBookieRecoveryDelayValue = urlManager.getLostBookieRecoveryDelay();
        LOG.info("Resetting LostBookieRecoveryDelay value: {}, to kickstart audit task", (Object)previousLostBookieRecoveryDelayValue);
        urlManager.setLostBookieRecoveryDelay(previousLostBookieRecoveryDelayValue);
    }

    public void decommissionBookie(BookieId bookieAddress) throws ReplicationException.CompatibilityException, ReplicationException.UnavailableException, KeeperException, InterruptedException, IOException, ReplicationException.BKAuditException, TimeoutException, BKException {
        Predicate<List<String>> predicate;
        Iterator<UnderreplicatedLedger> urLedgerIterator;
        if (this.getAvailableBookies().contains(bookieAddress) || this.getReadOnlyBookies().contains(bookieAddress)) {
            LOG.error("Bookie: {} is not shutdown yet", (Object)bookieAddress);
            throw BKException.create(-100);
        }
        this.triggerAudit();
        Thread.sleep(30000L);
        BookieLedgerIndexer bookieLedgerIndexer = new BookieLedgerIndexer(this.bkc.ledgerManager);
        Map<String, Set<Long>> bookieToLedgersMap = bookieLedgerIndexer.getBookieToLedgerIndex();
        Set<Long> ledgersStoredInThisBookie = bookieToLedgersMap.get(bookieAddress.toString());
        if (ledgersStoredInThisBookie != null && !ledgersStoredInThisBookie.isEmpty()) {
            this.waitForLedgersToBeReplicated(ledgersStoredInThisBookie, bookieAddress, this.bkc.ledgerManager);
        }
        if ((urLedgerIterator = this.underreplicationManager.listLedgersToRereplicate(predicate = replicasList -> replicasList.contains(bookieAddress.toString()))).hasNext()) {
            LOG.info("Still in some underreplicated ledgers metadata, this bookie is part of its ensemble. Have to make sure that those ledger fragments are rereplicated");
            ArrayList<Long> urLedgers = new ArrayList<Long>();
            urLedgerIterator.forEachRemaining(urLedger -> urLedgers.add(urLedger.getLedgerId()));
            this.waitForLedgersToBeReplicated(urLedgers, bookieAddress, this.bkc.ledgerManager);
        }
    }

    private void waitForLedgersToBeReplicated(Collection<Long> ledgers, BookieId thisBookieAddress, LedgerManager ledgerManager) throws InterruptedException, TimeoutException {
        int maxSleepTimeInBetweenChecks = 600000;
        int sleepTimePerLedger = 10000;
        Predicate<Long> validateBookieIsNotPartOfEnsemble = ledgerId -> !BookKeeperAdmin.areEntriesOfLedgerStoredInTheBookie((long)ledgerId, thisBookieAddress, ledgerManager);
        while (!ledgers.isEmpty()) {
            LOG.info("Count of Ledgers which need to be rereplicated: {}", (Object)ledgers.size());
            int sleepTimeForThisCheck = (long)ledgers.size() * (long)sleepTimePerLedger > (long)maxSleepTimeInBetweenChecks ? maxSleepTimeInBetweenChecks : ledgers.size() * sleepTimePerLedger;
            Thread.sleep(sleepTimeForThisCheck);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Making sure following ledgers replication to be completed: {}", ledgers);
            }
            ledgers.removeIf(validateBookieIsNotPartOfEnsemble);
        }
    }

    public static boolean areEntriesOfLedgerStoredInTheBookie(long ledgerId, BookieId bookieAddress, LedgerManager ledgerManager) {
        try {
            LedgerMetadata ledgerMetadata = ledgerManager.readLedgerMetadata(ledgerId).get().getValue();
            return BookKeeperAdmin.areEntriesOfLedgerStoredInTheBookie(ledgerId, bookieAddress, ledgerMetadata);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(ie);
        }
        catch (ExecutionException e) {
            if (e.getCause() != null && e.getCause().getClass().equals(BKException.BKNoSuchLedgerExistsOnMetadataServerException.class)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Ledger: {} has been deleted", (Object)ledgerId);
                }
                return false;
            }
            LOG.error("Got exception while trying to read LedgerMetadata of " + ledgerId, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static boolean areEntriesOfLedgerStoredInTheBookie(long ledgerId, BookieId bookieAddress, LedgerMetadata ledgerMetadata) {
        Collection ensemblesOfSegments = ledgerMetadata.getAllEnsembles().values();
        Iterator ensemblesOfSegmentsIterator = ensemblesOfSegments.iterator();
        int segmentNo = 0;
        while (ensemblesOfSegmentsIterator.hasNext()) {
            List ensemble = (List)ensemblesOfSegmentsIterator.next();
            if (ensemble.contains(bookieAddress) && BookKeeperAdmin.areEntriesOfSegmentStoredInTheBookie(ledgerMetadata, bookieAddress, segmentNo)) {
                return true;
            }
            ++segmentNo;
        }
        return false;
    }

    private static boolean areEntriesOfSegmentStoredInTheBookie(LedgerMetadata ledgerMetadata, BookieId bookieAddress, int segmentNo) {
        boolean lastSegment;
        boolean isLedgerClosed = ledgerMetadata.isClosed();
        int ensembleSize = ledgerMetadata.getEnsembleSize();
        int writeQuorumSize = ledgerMetadata.getWriteQuorumSize();
        LinkedList segments = new LinkedList(ledgerMetadata.getAllEnsembles().entrySet());
        List currentSegmentEnsemble = (List)((Map.Entry)segments.get(segmentNo)).getValue();
        boolean bl = lastSegment = segmentNo == segments.size() - 1;
        if (lastSegment && isLedgerClosed && ledgerMetadata.getLastEntryId() < (Long)((Map.Entry)segments.get(segmentNo)).getKey()) {
            return false;
        }
        if (!currentSegmentEnsemble.contains(bookieAddress)) {
            return false;
        }
        if (lastSegment && !isLedgerClosed || ensembleSize == writeQuorumSize) {
            return true;
        }
        RoundRobinDistributionSchedule distributionSchedule = new RoundRobinDistributionSchedule(ledgerMetadata.getWriteQuorumSize(), ledgerMetadata.getAckQuorumSize(), ledgerMetadata.getEnsembleSize());
        int thisBookieIndexInCurrentEnsemble = currentSegmentEnsemble.indexOf(bookieAddress);
        long firstEntryId = (Long)((Map.Entry)segments.get(segmentNo)).getKey();
        long lastEntryId = lastSegment ? ledgerMetadata.getLastEntryId() : (Long)((Map.Entry)segments.get(segmentNo + 1)).getKey() - 1L;
        long firstStoredEntryId = -1L;
        long firstEntryIter = firstEntryId;
        for (int i = 0; i < ensembleSize && firstEntryIter <= lastEntryId; ++firstEntryIter, ++i) {
            if (!distributionSchedule.hasEntry(firstEntryIter, thisBookieIndexInCurrentEnsemble)) continue;
            firstStoredEntryId = firstEntryIter;
            break;
        }
        return firstStoredEntryId != -1L;
    }

    public EnsemblePlacementPolicy.PlacementPolicyAdherence isEnsembleAdheringToPlacementPolicy(List<BookieId> ensembleBookiesList, int writeQuorumSize, int ackQuorumSize) {
        return this.bkc.getPlacementPolicy().isEnsembleAdheringToPlacementPolicy(ensembleBookiesList, writeQuorumSize, ackQuorumSize);
    }

    public Map<Integer, BookieId> replaceNotAdheringPlacementPolicyBookie(List<BookieId> ensembleBookiesList, int writeQuorumSize, int ackQuorumSize) {
        try {
            EnsemblePlacementPolicy.PlacementResult<List<BookieId>> placementResult = this.bkc.getPlacementPolicy().replaceToAdherePlacementPolicy(ensembleBookiesList.size(), writeQuorumSize, ackQuorumSize, new HashSet<BookieId>(), ensembleBookiesList);
            if (EnsemblePlacementPolicy.PlacementPolicyAdherence.FAIL != placementResult.getAdheringToPolicy()) {
                HashMap<Integer, BookieId> targetMap = new HashMap<Integer, BookieId>();
                List<BookieId> newEnsembles = placementResult.getResult();
                for (int i = 0; i < ensembleBookiesList.size(); ++i) {
                    BookieId newBookie;
                    BookieId originBookie = ensembleBookiesList.get(i);
                    if (originBookie.equals(newBookie = newEnsembles.get(i))) continue;
                    targetMap.put(i, newBookie);
                }
                return targetMap;
            }
        }
        catch (UnsupportedOperationException e) {
            LOG.warn("The placement policy: {} didn't support replaceToAdherePlacementPolicy, ignore replace not adhere bookie.", (Object)this.bkc.getPlacementPolicy().getClass().getName());
        }
        return Collections.emptyMap();
    }

    public CompletableFuture<AvailabilityOfEntriesOfLedger> asyncGetListOfEntriesOfLedger(BookieId address, long ledgerId) {
        return this.bkc.getBookieClient().getListOfEntriesOfLedger(address, ledgerId);
    }

    public BookieId getCurrentAuditor() throws IOException, InterruptedException {
        return this.getLedgerAuditorManager().getCurrentAuditor();
    }

    public static class ResultCallBack
    implements AsyncCallback.VoidCallback {
        private final CompletableFuture<Void> sync;

        public ResultCallBack(CompletableFuture<Void> sync) {
            this.sync = sync;
        }

        public void processResult(int rc, String s, Object ctx) {
            SyncCallbackUtils.finish(rc, null, this.sync);
        }
    }

    static class SyncObject {
        boolean value = false;
        int rc = 0;
    }

    class LedgerEntriesIterator
    implements Iterator<LedgerEntry> {
        final LedgerHandle handle;
        final long ledgerId;
        final long lastEntryId;
        long nextEntryId;
        LedgerEntry currentEntry;

        public LedgerEntriesIterator(long ledgerId, long firstEntry, long lastEntry) throws InterruptedException, BKException {
            this.handle = BookKeeperAdmin.this.openLedgerNoRecovery(ledgerId);
            this.ledgerId = ledgerId;
            this.nextEntryId = firstEntry;
            this.lastEntryId = lastEntry;
            this.currentEntry = null;
        }

        @Override
        public boolean hasNext() {
            if (this.currentEntry != null) {
                return true;
            }
            if ((this.lastEntryId == -1L || this.nextEntryId <= this.lastEntryId) && this.nextEntryId <= this.handle.getLastAddConfirmed()) {
                try {
                    CompletableFuture<Enumeration<LedgerEntry>> result = new CompletableFuture<Enumeration<LedgerEntry>>();
                    this.handle.asyncReadEntriesInternal(this.nextEntryId, this.nextEntryId, new SyncCallbackUtils.SyncReadCallback(result), null, false);
                    this.currentEntry = SyncCallbackUtils.waitForResult(result).nextElement();
                    return true;
                }
                catch (Exception e) {
                    if (e instanceof BKException.BKNoSuchEntryException && this.lastEntryId == -1L) {
                        this.close();
                        return false;
                    }
                    LOG.error("Error reading entry {} from ledger {}", new Object[]{this.nextEntryId, this.ledgerId, e});
                    this.close();
                    throw new RuntimeException(e);
                }
            }
            this.close();
            return false;
        }

        @Override
        public LedgerEntry next() {
            if (this.lastEntryId > -1L && this.nextEntryId > this.lastEntryId) {
                throw new NoSuchElementException();
            }
            ++this.nextEntryId;
            LedgerEntry entry = this.currentEntry;
            this.currentEntry = null;
            return entry;
        }

        @Override
        public void remove() {
        }

        private void close() {
            if (this.handle != null) {
                try {
                    this.handle.close();
                }
                catch (Exception e) {
                    LOG.error("Error closing ledger handle {}", (Object)this.handle, (Object)e);
                }
            }
        }
    }

    class LedgerEntriesIterable
    implements Iterable<LedgerEntry> {
        final long ledgerId;
        final long firstEntryId;
        final long lastEntryId;

        public LedgerEntriesIterable(long ledgerId, long firstEntry) {
            this(ledgerId, firstEntry, -1L);
        }

        public LedgerEntriesIterable(long ledgerId, long firstEntry, long lastEntry) {
            this.ledgerId = ledgerId;
            this.firstEntryId = firstEntry;
            this.lastEntryId = lastEntry;
        }

        @Override
        public Iterator<LedgerEntry> iterator() {
            try {
                return new LedgerEntriesIterator(this.ledgerId, this.firstEntryId, this.lastEntryId);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

