/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.replication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.bookkeeper.client.RoundRobinDistributionSchedule;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.LedgerUnderreplicationManager;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.replication.AuditorStats;
import org.apache.bookkeeper.replication.AuditorTask;
import org.apache.bookkeeper.replication.ReplicationException;
import org.apache.bookkeeper.shaded.com.google.common.base.Stopwatch;
import org.apache.bookkeeper.shaded.com.google.common.collect.HashMultiset;
import org.apache.bookkeeper.shaded.com.google.common.collect.Multiset;
import org.apache.bookkeeper.util.AvailabilityOfEntriesOfLedger;
import org.apache.bookkeeper.versioning.Versioned;
import org.apache.zookeeper.AsyncCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditorReplicasCheckTask
extends AuditorTask {
    private static final Logger LOG = LoggerFactory.getLogger(AuditorReplicasCheckTask.class);
    private static final int MAX_CONCURRENT_REPLICAS_CHECK_LEDGER_REQUESTS = 100;
    private static final int REPLICAS_CHECK_TIMEOUT_IN_SECS = 120;
    private static final BitSet EMPTY_BITSET = new BitSet();
    private final int zkOpTimeoutMs;
    private final AtomicInteger numLedgersFoundHavingNoReplicaOfAnEntry;
    private final AtomicInteger numLedgersFoundHavingLessThanAQReplicasOfAnEntry;
    private final AtomicInteger numLedgersFoundHavingLessThanWQReplicasOfAnEntry;

    AuditorReplicasCheckTask(ServerConfiguration conf, AuditorStats auditorStats, BookKeeperAdmin admin, LedgerManager ledgerManager, LedgerUnderreplicationManager ledgerUnderreplicationManager, AuditorTask.ShutdownTaskHandler shutdownTaskHandler, BiConsumer<AtomicBoolean, Throwable> hasAuditCheckTask) {
        super(conf, auditorStats, admin, ledgerManager, ledgerUnderreplicationManager, shutdownTaskHandler, hasAuditCheckTask);
        this.zkOpTimeoutMs = conf.getZkTimeout() * 2;
        this.numLedgersFoundHavingNoReplicaOfAnEntry = new AtomicInteger(0);
        this.numLedgersFoundHavingLessThanAQReplicasOfAnEntry = new AtomicInteger(0);
        this.numLedgersFoundHavingLessThanWQReplicasOfAnEntry = new AtomicInteger(0);
    }

    @Override
    protected void runTask() {
        if (this.hasBookieCheckTask()) {
            LOG.info("Audit bookie task already scheduled; skipping periodic replicas check task");
            return;
        }
        try {
            if (!this.ledgerUnderreplicationManager.isLedgerReplicationEnabled()) {
                LOG.info("Ledger replication disabled, skipping replicasCheck task.");
                return;
            }
            Stopwatch stopwatch = Stopwatch.createStarted();
            LOG.info("Starting ReplicasCheck");
            this.replicasCheck();
            long replicasCheckDuration = stopwatch.stop().elapsed(TimeUnit.MILLISECONDS);
            int numLedgersFoundHavingNoReplicaOfAnEntryValue = this.numLedgersFoundHavingNoReplicaOfAnEntry.get();
            int numLedgersFoundHavingLessThanAQReplicasOfAnEntryValue = this.numLedgersFoundHavingLessThanAQReplicasOfAnEntry.get();
            int numLedgersFoundHavingLessThanWQReplicasOfAnEntryValue = this.numLedgersFoundHavingLessThanWQReplicasOfAnEntry.get();
            LOG.info("Completed ReplicasCheck in {} milliSeconds numLedgersFoundHavingNoReplicaOfAnEntry {} numLedgersFoundHavingLessThanAQReplicasOfAnEntry {} numLedgersFoundHavingLessThanWQReplicasOfAnEntry {}.", new Object[]{replicasCheckDuration, numLedgersFoundHavingNoReplicaOfAnEntryValue, numLedgersFoundHavingLessThanAQReplicasOfAnEntryValue, numLedgersFoundHavingLessThanWQReplicasOfAnEntryValue});
            this.auditorStats.getNumLedgersHavingNoReplicaOfAnEntryGuageValue().set(numLedgersFoundHavingNoReplicaOfAnEntryValue);
            this.auditorStats.getNumLedgersHavingLessThanAQReplicasOfAnEntryGuageValue().set(numLedgersFoundHavingLessThanAQReplicasOfAnEntryValue);
            this.auditorStats.getNumLedgersHavingLessThanWQReplicasOfAnEntryGuageValue().set(numLedgersFoundHavingLessThanWQReplicasOfAnEntryValue);
            this.auditorStats.getReplicasCheckTime().registerSuccessfulEvent(replicasCheckDuration, TimeUnit.MILLISECONDS);
        }
        catch (ReplicationException.BKAuditException e) {
            int numLedgersFoundHavingLessThanWQReplicasOfAnEntryValue;
            int numLedgersFoundHavingLessThanAQReplicasOfAnEntryValue;
            LOG.error("BKAuditException running periodic replicas check.", (Throwable)e);
            int numLedgersFoundHavingNoReplicaOfAnEntryValue = this.numLedgersFoundHavingNoReplicaOfAnEntry.get();
            if (numLedgersFoundHavingNoReplicaOfAnEntryValue > 0) {
                this.auditorStats.getNumLedgersHavingNoReplicaOfAnEntryGuageValue().set(numLedgersFoundHavingNoReplicaOfAnEntryValue);
            }
            if ((numLedgersFoundHavingLessThanAQReplicasOfAnEntryValue = this.numLedgersFoundHavingLessThanAQReplicasOfAnEntry.get()) > 0) {
                this.auditorStats.getNumLedgersHavingLessThanAQReplicasOfAnEntryGuageValue().set(numLedgersFoundHavingLessThanAQReplicasOfAnEntryValue);
            }
            if ((numLedgersFoundHavingLessThanWQReplicasOfAnEntryValue = this.numLedgersFoundHavingLessThanWQReplicasOfAnEntry.get()) > 0) {
                this.auditorStats.getNumLedgersHavingLessThanWQReplicasOfAnEntryGuageValue().set(numLedgersFoundHavingLessThanWQReplicasOfAnEntryValue);
            }
        }
        catch (ReplicationException.UnavailableException ue) {
            LOG.error("Underreplication manager unavailable running periodic check", (Throwable)ue);
        }
    }

    @Override
    public void shutdown() {
    }

    void replicasCheck() throws ReplicationException.BKAuditException {
        block14: {
            AtomicInteger resultCode;
            int resultCodeIntValue;
            ConcurrentHashMap<Long, MissingEntriesInfoOfLedger> ledgersWithMissingEntries = new ConcurrentHashMap<Long, MissingEntriesInfoOfLedger>();
            ConcurrentHashMap<Long, MissingEntriesInfoOfLedger> ledgersWithUnavailableBookies = new ConcurrentHashMap<Long, MissingEntriesInfoOfLedger>();
            LedgerManager.LedgerRangeIterator ledgerRangeIterator = this.ledgerManager.getLedgerRanges(this.zkOpTimeoutMs);
            final Semaphore maxConcurrentSemaphore = new Semaphore(100);
            do {
                LedgerManager.LedgerRange ledgerRange = null;
                try {
                    if (!ledgerRangeIterator.hasNext()) break block14;
                    ledgerRange = ledgerRangeIterator.next();
                }
                catch (IOException ioe) {
                    LOG.error("Got IOException while iterating LedgerRangeIterator", (Throwable)ioe);
                    throw new ReplicationException.BKAuditException("Got IOException while iterating LedgerRangeIterator", ioe);
                }
                ledgersWithMissingEntries.clear();
                ledgersWithUnavailableBookies.clear();
                this.numLedgersFoundHavingNoReplicaOfAnEntry.set(0);
                this.numLedgersFoundHavingLessThanAQReplicasOfAnEntry.set(0);
                this.numLedgersFoundHavingLessThanWQReplicasOfAnEntry.set(0);
                Set<Long> ledgersInRange = ledgerRange.getLedgers();
                int numOfLedgersInRange = ledgersInRange.size();
                resultCode = new AtomicInteger();
                CountDownLatch replicasCheckLatch = new CountDownLatch(1);
                ReplicasCheckFinalCallback finalCB = new ReplicasCheckFinalCallback(resultCode, replicasCheckLatch);
                BookkeeperInternalCallbacks.MultiCallback mcbForThisLedgerRange = new BookkeeperInternalCallbacks.MultiCallback(numOfLedgersInRange, finalCB, null, 0, -1){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void processResult(int rc, String path, Object ctx) {
                        try {
                            super.processResult(rc, path, ctx);
                        }
                        finally {
                            maxConcurrentSemaphore.release();
                        }
                    }
                };
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Number of ledgers in the current LedgerRange : {}", (Object)numOfLedgersInRange);
                }
                for (Long ledgerInRange : ledgersInRange) {
                    try {
                        if (!maxConcurrentSemaphore.tryAcquire(120L, TimeUnit.SECONDS)) {
                            LOG.error("Timedout ({} secs) while waiting for acquiring semaphore", (Object)120);
                            throw new ReplicationException.BKAuditException("Timedout while waiting for acquiring semaphore");
                        }
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        LOG.error("Got InterruptedException while acquiring semaphore for replicascheck", (Throwable)ie);
                        throw new ReplicationException.BKAuditException("Got InterruptedException while acquiring semaphore for replicascheck", ie);
                    }
                    if (this.checkUnderReplicationForReplicasCheck(ledgerInRange, mcbForThisLedgerRange)) continue;
                    this.ledgerManager.readLedgerMetadata(ledgerInRange).whenComplete((BiConsumer)new ReadLedgerMetadataCallbackForReplicasCheck(ledgerInRange, mcbForThisLedgerRange, ledgersWithMissingEntries, ledgersWithUnavailableBookies));
                }
                try {
                    if (!replicasCheckLatch.await(120L, TimeUnit.SECONDS)) {
                        LOG.error("For LedgerRange with num of ledgers : {} it didn't complete replicascheck in {} secs, so giving up", (Object)numOfLedgersInRange, (Object)120);
                        throw new ReplicationException.BKAuditException("Got InterruptedException while doing replicascheck");
                    }
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    LOG.error("Got InterruptedException while doing replicascheck", (Throwable)ie);
                    throw new ReplicationException.BKAuditException("Got InterruptedException while doing replicascheck", ie);
                }
                this.reportLedgersWithMissingEntries(ledgersWithMissingEntries);
                this.reportLedgersWithUnavailableBookies(ledgersWithUnavailableBookies);
            } while ((resultCodeIntValue = resultCode.get()) == 0);
            throw new ReplicationException.BKAuditException("Exception while doing replicas check", BKException.create(resultCodeIntValue));
        }
        try {
            this.ledgerUnderreplicationManager.setReplicasCheckCTime(System.currentTimeMillis());
        }
        catch (ReplicationException.NonRecoverableReplicationException nre) {
            LOG.error("Non Recoverable Exception while reading from ZK", (Throwable)nre);
            this.submitShutdownTask();
        }
        catch (ReplicationException.UnavailableException ue) {
            LOG.error("Got exception while trying to set ReplicasCheckCTime", (Throwable)ue);
        }
    }

    private void reportLedgersWithMissingEntries(ConcurrentHashMap<Long, MissingEntriesInfoOfLedger> ledgersWithMissingEntries) {
        StringBuilder errMessage = new StringBuilder();
        HashMultiset missingEntries = HashMultiset.create();
        for (Map.Entry<Long, MissingEntriesInfoOfLedger> missingEntriesInfoOfLedgerEntry : ledgersWithMissingEntries.entrySet()) {
            missingEntries.clear();
            errMessage.setLength(0);
            long ledgerWithMissingEntries = missingEntriesInfoOfLedgerEntry.getKey();
            MissingEntriesInfoOfLedger missingEntriesInfoOfLedger = missingEntriesInfoOfLedgerEntry.getValue();
            List missingEntriesInfoList = missingEntriesInfoOfLedger.getMissingEntriesInfoList();
            int writeQuorumSize = missingEntriesInfoOfLedger.getWriteQuorumSize();
            int ackQuorumSize = missingEntriesInfoOfLedger.getAckQuorumSize();
            errMessage.append("Ledger : " + ledgerWithMissingEntries + " has following missing entries : ");
            for (int listInd = 0; listInd < missingEntriesInfoList.size(); ++listInd) {
                MissingEntriesInfo missingEntriesInfo = (MissingEntriesInfo)missingEntriesInfoList.get(listInd);
                List unavailableEntriesList = missingEntriesInfo.getUnavailableEntriesList();
                Map.Entry segmentEnsemble = missingEntriesInfo.getSegmentEnsemble();
                missingEntries.addAll(unavailableEntriesList);
                errMessage.append("In segment starting at " + segmentEnsemble.getKey() + " with ensemble " + segmentEnsemble.getValue() + ", following entries " + unavailableEntriesList + " are missing in bookie: " + missingEntriesInfo.getBookieMissingEntries());
                if (listInd >= missingEntriesInfoList.size() - 1) continue;
                errMessage.append(", ");
            }
            LOG.error(errMessage.toString());
            Set missingEntriesSet = missingEntries.entrySet();
            int maxNumOfMissingReplicas = 0;
            long entryWithMaxNumOfMissingReplicas = -1L;
            for (Multiset.Entry missingEntryWithCount : missingEntriesSet) {
                if (missingEntryWithCount.getCount() <= maxNumOfMissingReplicas) continue;
                maxNumOfMissingReplicas = missingEntryWithCount.getCount();
                entryWithMaxNumOfMissingReplicas = (Long)missingEntryWithCount.getElement();
            }
            int leastNumOfReplicasOfAnEntry = writeQuorumSize - maxNumOfMissingReplicas;
            if (leastNumOfReplicasOfAnEntry == 0) {
                this.numLedgersFoundHavingNoReplicaOfAnEntry.incrementAndGet();
                LOG.error("Ledger : {} entryId : {} is missing all replicas", (Object)ledgerWithMissingEntries, (Object)entryWithMaxNumOfMissingReplicas);
                continue;
            }
            if (leastNumOfReplicasOfAnEntry < ackQuorumSize) {
                this.numLedgersFoundHavingLessThanAQReplicasOfAnEntry.incrementAndGet();
                LOG.error("Ledger : {} entryId : {} is having: {} replicas, less than ackQuorum num of replicas : {}", new Object[]{ledgerWithMissingEntries, entryWithMaxNumOfMissingReplicas, leastNumOfReplicasOfAnEntry, ackQuorumSize});
                continue;
            }
            if (leastNumOfReplicasOfAnEntry >= writeQuorumSize) continue;
            this.numLedgersFoundHavingLessThanWQReplicasOfAnEntry.incrementAndGet();
            LOG.error("Ledger : {} entryId : {} is having: {} replicas, less than writeQuorum num of replicas : {}", new Object[]{ledgerWithMissingEntries, entryWithMaxNumOfMissingReplicas, leastNumOfReplicasOfAnEntry, writeQuorumSize});
        }
    }

    private void reportLedgersWithUnavailableBookies(ConcurrentHashMap<Long, MissingEntriesInfoOfLedger> ledgersWithUnavailableBookies) {
        StringBuilder errMessage = new StringBuilder();
        for (Map.Entry<Long, MissingEntriesInfoOfLedger> ledgerWithUnavailableBookiesInfo : ledgersWithUnavailableBookies.entrySet()) {
            errMessage.setLength(0);
            long ledgerWithUnavailableBookies = ledgerWithUnavailableBookiesInfo.getKey();
            List missingBookiesInfoList = ledgerWithUnavailableBookiesInfo.getValue().getMissingEntriesInfoList();
            errMessage.append("Ledger : " + ledgerWithUnavailableBookies + " has following unavailable bookies : ");
            for (int listInd = 0; listInd < missingBookiesInfoList.size(); ++listInd) {
                MissingEntriesInfo missingBookieInfo = (MissingEntriesInfo)missingBookiesInfoList.get(listInd);
                Map.Entry segmentEnsemble = missingBookieInfo.getSegmentEnsemble();
                errMessage.append("In segment starting at " + segmentEnsemble.getKey() + " with ensemble " + segmentEnsemble.getValue() + ", following bookie has not responded " + missingBookieInfo.getBookieMissingEntries());
                if (listInd >= missingBookiesInfoList.size() - 1) continue;
                errMessage.append(", ");
            }
            LOG.error(errMessage.toString());
        }
    }

    boolean checkUnderReplicationForReplicasCheck(long ledgerInRange, AsyncCallback.VoidCallback mcbForThisLedgerRange) {
        try {
            if (this.ledgerUnderreplicationManager.getLedgerUnreplicationInfo(ledgerInRange) == null) {
                return false;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ledger: {} is marked underrreplicated, ignore this ledger for replicasCheck", (Object)ledgerInRange);
            }
            mcbForThisLedgerRange.processResult(0, null, null);
            return true;
        }
        catch (ReplicationException.NonRecoverableReplicationException nre) {
            LOG.error("Non Recoverable Exception while reading from ZK", (Throwable)nre);
            this.submitShutdownTask();
            return true;
        }
        catch (ReplicationException.UnavailableException une) {
            LOG.error("Got exception while trying to check if ledger: {} is underreplicated", (Object)ledgerInRange, (Object)une);
            mcbForThisLedgerRange.processResult(BKException.getExceptionCode(une), null, null);
            return true;
        }
    }

    private static class ReplicasCheckFinalCallback
    implements AsyncCallback.VoidCallback {
        final AtomicInteger resultCode;
        final CountDownLatch replicasCheckLatch;

        private ReplicasCheckFinalCallback(AtomicInteger resultCode, CountDownLatch replicasCheckLatch) {
            this.resultCode = resultCode;
            this.replicasCheckLatch = replicasCheckLatch;
        }

        public void processResult(int rc, String s, Object obj) {
            this.resultCode.set(rc);
            this.replicasCheckLatch.countDown();
        }
    }

    private static class GetListOfEntriesOfLedgerCallbackForReplicasCheck
    implements BiConsumer<AvailabilityOfEntriesOfLedger, Throwable> {
        private final long ledgerInRange;
        private final int ensembleSize;
        private final int writeQuorumSize;
        private final int ackQuorumSize;
        private final BookieId bookieInEnsemble;
        private final List<BookieExpectedToContainSegmentInfo> bookieExpectedToContainSegmentInfoList;
        private final ConcurrentHashMap<Long, MissingEntriesInfoOfLedger> ledgersWithMissingEntries;
        private final ConcurrentHashMap<Long, MissingEntriesInfoOfLedger> ledgersWithUnavailableBookies;
        private final BookkeeperInternalCallbacks.MultiCallback mcbForThisLedger;

        private GetListOfEntriesOfLedgerCallbackForReplicasCheck(long ledgerInRange, int ensembleSize, int writeQuorumSize, int ackQuorumSize, BookieId bookieInEnsemble, List<BookieExpectedToContainSegmentInfo> bookieExpectedToContainSegmentInfoList, ConcurrentHashMap<Long, MissingEntriesInfoOfLedger> ledgersWithMissingEntries, ConcurrentHashMap<Long, MissingEntriesInfoOfLedger> ledgersWithUnavailableBookies, BookkeeperInternalCallbacks.MultiCallback mcbForThisLedger) {
            this.ledgerInRange = ledgerInRange;
            this.ensembleSize = ensembleSize;
            this.writeQuorumSize = writeQuorumSize;
            this.ackQuorumSize = ackQuorumSize;
            this.bookieInEnsemble = bookieInEnsemble;
            this.bookieExpectedToContainSegmentInfoList = bookieExpectedToContainSegmentInfoList;
            this.ledgersWithMissingEntries = ledgersWithMissingEntries;
            this.ledgersWithUnavailableBookies = ledgersWithUnavailableBookies;
            this.mcbForThisLedger = mcbForThisLedger;
        }

        @Override
        public void accept(AvailabilityOfEntriesOfLedger availabilityOfEntriesOfLedger, Throwable listOfEntriesException) {
            if (listOfEntriesException != null) {
                if (BKException.getExceptionCode(listOfEntriesException) == -7) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Got NoSuchLedgerExistsException for ledger: {} from bookie: {}", (Object)this.ledgerInRange, (Object)this.bookieInEnsemble);
                    }
                    availabilityOfEntriesOfLedger = AvailabilityOfEntriesOfLedger.EMPTY_AVAILABILITYOFENTRIESOFLEDGER;
                } else {
                    LOG.warn("Unable to GetListOfEntriesOfLedger for ledger: {} from: {}", new Object[]{this.ledgerInRange, this.bookieInEnsemble, listOfEntriesException});
                    MissingEntriesInfoOfLedger unavailableBookiesInfoOfThisLedger = this.ledgersWithUnavailableBookies.get(this.ledgerInRange);
                    if (unavailableBookiesInfoOfThisLedger == null) {
                        this.ledgersWithUnavailableBookies.putIfAbsent(this.ledgerInRange, new MissingEntriesInfoOfLedger(this.ledgerInRange, this.ensembleSize, this.writeQuorumSize, this.ackQuorumSize, Collections.synchronizedList(new ArrayList())));
                        unavailableBookiesInfoOfThisLedger = this.ledgersWithUnavailableBookies.get(this.ledgerInRange);
                    }
                    List missingEntriesInfoList = unavailableBookiesInfoOfThisLedger.getMissingEntriesInfoList();
                    for (BookieExpectedToContainSegmentInfo bookieExpectedToContainSegmentInfo : this.bookieExpectedToContainSegmentInfoList) {
                        missingEntriesInfoList.add(new MissingEntriesInfo(this.ledgerInRange, bookieExpectedToContainSegmentInfo.getSegmentEnsemble(), this.bookieInEnsemble, null));
                        this.mcbForThisLedger.processResult(0, null, null);
                    }
                    return;
                }
            }
            for (BookieExpectedToContainSegmentInfo bookieExpectedToContainSegmentInfo : this.bookieExpectedToContainSegmentInfoList) {
                long startEntryIdOfSegment = bookieExpectedToContainSegmentInfo.getStartEntryIdOfSegment();
                long lastEntryIdOfSegment = bookieExpectedToContainSegmentInfo.getLastEntryIdOfSegment();
                BitSet entriesStripedToThisBookie = bookieExpectedToContainSegmentInfo.getEntriesOfSegmentStripedToThisBookie();
                Map.Entry<Long, ? extends List<BookieId>> segmentEnsemble = bookieExpectedToContainSegmentInfo.getSegmentEnsemble();
                List<Long> unavailableEntriesList = availabilityOfEntriesOfLedger.getUnavailableEntries(startEntryIdOfSegment, lastEntryIdOfSegment, entriesStripedToThisBookie);
                if (unavailableEntriesList != null && !unavailableEntriesList.isEmpty()) {
                    MissingEntriesInfoOfLedger missingEntriesInfoOfThisLedger = this.ledgersWithMissingEntries.get(this.ledgerInRange);
                    if (missingEntriesInfoOfThisLedger == null) {
                        this.ledgersWithMissingEntries.putIfAbsent(this.ledgerInRange, new MissingEntriesInfoOfLedger(this.ledgerInRange, this.ensembleSize, this.writeQuorumSize, this.ackQuorumSize, Collections.synchronizedList(new ArrayList())));
                        missingEntriesInfoOfThisLedger = this.ledgersWithMissingEntries.get(this.ledgerInRange);
                    }
                    missingEntriesInfoOfThisLedger.getMissingEntriesInfoList().add(new MissingEntriesInfo(this.ledgerInRange, segmentEnsemble, this.bookieInEnsemble, unavailableEntriesList));
                }
                this.mcbForThisLedger.processResult(0, null, null);
            }
        }
    }

    private static class BookieExpectedToContainSegmentInfo {
        private final long startEntryIdOfSegment;
        private final long lastEntryIdOfSegment;
        private final Map.Entry<Long, ? extends List<BookieId>> segmentEnsemble;
        private final BitSet entriesOfSegmentStripedToThisBookie;

        private BookieExpectedToContainSegmentInfo(long startEntryIdOfSegment, long lastEntryIdOfSegment, Map.Entry<Long, ? extends List<BookieId>> segmentEnsemble, BitSet entriesOfSegmentStripedToThisBookie) {
            this.startEntryIdOfSegment = startEntryIdOfSegment;
            this.lastEntryIdOfSegment = lastEntryIdOfSegment;
            this.segmentEnsemble = segmentEnsemble;
            this.entriesOfSegmentStripedToThisBookie = entriesOfSegmentStripedToThisBookie;
        }

        public long getStartEntryIdOfSegment() {
            return this.startEntryIdOfSegment;
        }

        public long getLastEntryIdOfSegment() {
            return this.lastEntryIdOfSegment;
        }

        public Map.Entry<Long, ? extends List<BookieId>> getSegmentEnsemble() {
            return this.segmentEnsemble;
        }

        public BitSet getEntriesOfSegmentStripedToThisBookie() {
            return this.entriesOfSegmentStripedToThisBookie;
        }
    }

    private class ReadLedgerMetadataCallbackForReplicasCheck
    implements BiConsumer<Versioned<LedgerMetadata>, Throwable> {
        private final long ledgerInRange;
        private final BookkeeperInternalCallbacks.MultiCallback mcbForThisLedgerRange;
        private final ConcurrentHashMap<Long, MissingEntriesInfoOfLedger> ledgersWithMissingEntries;
        private final ConcurrentHashMap<Long, MissingEntriesInfoOfLedger> ledgersWithUnavailableBookies;

        ReadLedgerMetadataCallbackForReplicasCheck(long ledgerInRange, BookkeeperInternalCallbacks.MultiCallback mcbForThisLedgerRange, ConcurrentHashMap<Long, MissingEntriesInfoOfLedger> ledgersWithMissingEntries, ConcurrentHashMap<Long, MissingEntriesInfoOfLedger> ledgersWithUnavailableBookies) {
            this.ledgerInRange = ledgerInRange;
            this.mcbForThisLedgerRange = mcbForThisLedgerRange;
            this.ledgersWithMissingEntries = ledgersWithMissingEntries;
            this.ledgersWithUnavailableBookies = ledgersWithUnavailableBookies;
        }

        @Override
        public void accept(Versioned<LedgerMetadata> metadataVer, Throwable exception) {
            if (exception != null) {
                if (BKException.getExceptionCode(exception) == -25) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Ignoring replicas check of already deleted ledger {}", (Object)this.ledgerInRange);
                    }
                    this.mcbForThisLedgerRange.processResult(0, null, null);
                    return;
                }
                LOG.warn("Unable to read the ledger: {} information", (Object)this.ledgerInRange, (Object)exception);
                this.mcbForThisLedgerRange.processResult(BKException.getExceptionCode(exception), null, null);
                return;
            }
            LedgerMetadata metadata = metadataVer.getValue();
            if (!metadata.isClosed()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Ledger: {} is not yet closed, so skipping the replicas check analysis for now", (Object)this.ledgerInRange);
                }
                this.mcbForThisLedgerRange.processResult(0, null, null);
                return;
            }
            long lastEntryId = metadata.getLastEntryId();
            if (lastEntryId == -1L) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Ledger: {} is closed but it doesn't has any entries, so skipping the replicas check", (Object)this.ledgerInRange);
                }
                this.mcbForThisLedgerRange.processResult(0, null, null);
                return;
            }
            int writeQuorumSize = metadata.getWriteQuorumSize();
            int ackQuorumSize = metadata.getAckQuorumSize();
            int ensembleSize = metadata.getEnsembleSize();
            RoundRobinDistributionSchedule distributionSchedule = new RoundRobinDistributionSchedule(writeQuorumSize, ackQuorumSize, ensembleSize);
            LinkedList segments = new LinkedList(metadata.getAllEnsembles().entrySet());
            BookkeeperInternalCallbacks.MultiCallback mcbForThisLedger = new BookkeeperInternalCallbacks.MultiCallback(ensembleSize * segments.size(), this.mcbForThisLedgerRange, null, 0, -1);
            HashMap<BookieId, ArrayList<BookieExpectedToContainSegmentInfo>> bookiesSegmentInfoMap = new HashMap<BookieId, ArrayList<BookieExpectedToContainSegmentInfo>>();
            for (int segmentNum = 0; segmentNum < segments.size(); ++segmentNum) {
                long lastEntryIdOfSegment;
                Map.Entry segmentEnsemble = (Map.Entry)segments.get(segmentNum);
                List ensembleOfSegment = (List)segmentEnsemble.getValue();
                long startEntryIdOfSegment = (Long)segmentEnsemble.getKey();
                boolean lastSegment = segmentNum == segments.size() - 1;
                long l = lastEntryIdOfSegment = lastSegment ? lastEntryId : (Long)((Map.Entry)segments.get(segmentNum + 1)).getKey() - 1L;
                boolean emptySegment = lastSegment ? startEntryIdOfSegment > lastEntryId : startEntryIdOfSegment == (Long)((Map.Entry)segments.get(segmentNum + 1)).getKey();
                for (int bookieIndex = 0; bookieIndex < ensembleOfSegment.size(); ++bookieIndex) {
                    BitSet entriesStripedToThisBookie;
                    BookieId bookieInEnsemble = (BookieId)ensembleOfSegment.get(bookieIndex);
                    BitSet bitSet = entriesStripedToThisBookie = emptySegment ? EMPTY_BITSET : distributionSchedule.getEntriesStripedToTheBookie(bookieIndex, startEntryIdOfSegment, lastEntryIdOfSegment);
                    if (entriesStripedToThisBookie.cardinality() == 0) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("For ledger: {}, in Segment: {}, no entry is expected to contain in this bookie: {}. So skipping getListOfEntriesOfLedger call", new Object[]{this.ledgerInRange, segmentEnsemble, bookieInEnsemble});
                        }
                        mcbForThisLedger.processResult(0, null, null);
                        continue;
                    }
                    ArrayList<BookieExpectedToContainSegmentInfo> bookieSegmentInfoList = (ArrayList<BookieExpectedToContainSegmentInfo>)bookiesSegmentInfoMap.get(bookieInEnsemble);
                    if (bookieSegmentInfoList == null) {
                        bookieSegmentInfoList = new ArrayList<BookieExpectedToContainSegmentInfo>();
                        bookiesSegmentInfoMap.put(bookieInEnsemble, bookieSegmentInfoList);
                    }
                    bookieSegmentInfoList.add(new BookieExpectedToContainSegmentInfo(startEntryIdOfSegment, lastEntryIdOfSegment, segmentEnsemble, entriesStripedToThisBookie));
                }
            }
            for (Map.Entry bookiesSegmentInfoTuple : bookiesSegmentInfoMap.entrySet()) {
                BookieId bookieInEnsemble = (BookieId)bookiesSegmentInfoTuple.getKey();
                List bookieSegmentInfoList = (List)bookiesSegmentInfoTuple.getValue();
                AuditorReplicasCheckTask.this.admin.asyncGetListOfEntriesOfLedger(bookieInEnsemble, this.ledgerInRange).whenComplete((BiConsumer)new GetListOfEntriesOfLedgerCallbackForReplicasCheck(this.ledgerInRange, ensembleSize, writeQuorumSize, ackQuorumSize, bookieInEnsemble, bookieSegmentInfoList, this.ledgersWithMissingEntries, this.ledgersWithUnavailableBookies, mcbForThisLedger));
            }
        }
    }

    private static class MissingEntriesInfoOfLedger {
        private final long ledgerId;
        private final int ensembleSize;
        private final int writeQuorumSize;
        private final int ackQuorumSize;
        private final List<MissingEntriesInfo> missingEntriesInfoList;

        private MissingEntriesInfoOfLedger(long ledgerId, int ensembleSize, int writeQuorumSize, int ackQuorumSize, List<MissingEntriesInfo> missingEntriesInfoList) {
            this.ledgerId = ledgerId;
            this.ensembleSize = ensembleSize;
            this.writeQuorumSize = writeQuorumSize;
            this.ackQuorumSize = ackQuorumSize;
            this.missingEntriesInfoList = missingEntriesInfoList;
        }

        private long getLedgerId() {
            return this.ledgerId;
        }

        private int getEnsembleSize() {
            return this.ensembleSize;
        }

        private int getWriteQuorumSize() {
            return this.writeQuorumSize;
        }

        private int getAckQuorumSize() {
            return this.ackQuorumSize;
        }

        private List<MissingEntriesInfo> getMissingEntriesInfoList() {
            return this.missingEntriesInfoList;
        }
    }

    private static class MissingEntriesInfo {
        private final long ledgerId;
        private final Map.Entry<Long, ? extends List<BookieId>> segmentEnsemble;
        private final BookieId bookieMissingEntries;
        private final List<Long> unavailableEntriesList;

        private MissingEntriesInfo(long ledgerId, Map.Entry<Long, ? extends List<BookieId>> segmentEnsemble, BookieId bookieMissingEntries, List<Long> unavailableEntriesList) {
            this.ledgerId = ledgerId;
            this.segmentEnsemble = segmentEnsemble;
            this.bookieMissingEntries = bookieMissingEntries;
            this.unavailableEntriesList = unavailableEntriesList;
        }

        private long getLedgerId() {
            return this.ledgerId;
        }

        private Map.Entry<Long, ? extends List<BookieId>> getSegmentEnsemble() {
            return this.segmentEnsemble;
        }

        private BookieId getBookieMissingEntries() {
            return this.bookieMissingEntries;
        }

        private List<Long> getUnavailableEntriesList() {
            return this.unavailableEntriesList;
        }
    }
}

