/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.server.http.service;

import java.util.HashMap;
import java.util.Map;
import org.apache.bookkeeper.bookie.LedgerStorage;
import org.apache.bookkeeper.common.util.JsonUtil;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.http.HttpServer;
import org.apache.bookkeeper.http.service.HttpEndpointService;
import org.apache.bookkeeper.http.service.HttpServiceRequest;
import org.apache.bookkeeper.http.service.HttpServiceResponse;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.shaded.com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerGCService
implements HttpEndpointService {
    static final Logger LOG = LoggerFactory.getLogger(TriggerGCService.class);
    protected ServerConfiguration conf;
    protected BookieServer bookieServer;

    public TriggerGCService(ServerConfiguration conf, BookieServer bookieServer) {
        Preconditions.checkNotNull(conf);
        Preconditions.checkNotNull(bookieServer);
        this.conf = conf;
        this.bookieServer = bookieServer;
    }

    public HttpServiceResponse handle(HttpServiceRequest request) throws Exception {
        HttpServiceResponse response = new HttpServiceResponse();
        try {
            if (HttpServer.Method.PUT == request.getMethod()) {
                String requestBody = request.getBody();
                if (StringUtils.isBlank((CharSequence)requestBody)) {
                    this.bookieServer.getBookie().getLedgerStorage().forceGC();
                } else {
                    Map configMap = JsonUtil.fromJson(requestBody, HashMap.class);
                    LedgerStorage ledgerStorage = this.bookieServer.getBookie().getLedgerStorage();
                    boolean forceMajor = !ledgerStorage.isMajorGcSuspended();
                    boolean forceMinor = !ledgerStorage.isMinorGcSuspended();
                    forceMajor = Boolean.parseBoolean(((Object)configMap.getOrDefault("forceMajor", forceMajor)).toString());
                    forceMinor = Boolean.parseBoolean(((Object)configMap.getOrDefault("forceMinor", forceMinor)).toString());
                    ledgerStorage.forceGC(forceMajor, forceMinor);
                }
                String output = "Triggered GC on BookieServer: " + this.bookieServer.getBookieId();
                String jsonResponse = JsonUtil.toJson(output);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("output body:" + jsonResponse);
                }
                response.setBody(jsonResponse);
                response.setCode(HttpServer.StatusCode.OK);
                return response;
            }
            if (HttpServer.Method.GET == request.getMethod()) {
                Boolean isInForceGC = this.bookieServer.getBookie().getLedgerStorage().isInForceGC();
                Pair output = Pair.of((Object)"is_in_force_gc", (Object)isInForceGC.toString());
                String jsonResponse = JsonUtil.toJson(output);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("output body:" + jsonResponse);
                }
                response.setBody(jsonResponse);
                response.setCode(HttpServer.StatusCode.OK);
                return response;
            }
            response.setCode(HttpServer.StatusCode.METHOD_NOT_ALLOWED);
            response.setBody("Not allowed method. Should be PUT to trigger GC, Or GET to get Force GC state.");
            return response;
        }
        catch (Exception e) {
            LOG.error("Failed to handle the request, method: {}, body: {} ", new Object[]{request.getMethod(), request.getBody(), e});
            response.setCode(HttpServer.StatusCode.BAD_REQUEST);
            response.setBody("Failed to handle the request, exception: " + e.getMessage());
            return response;
        }
    }
}

