/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tools.cli.commands.bookies;

import com.beust.jcommander.Parameter;
import java.io.IOException;
import java.util.Collection;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.discover.BookieServiceInfo;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.shaded.com.google.common.util.concurrent.UncheckedExecutionException;
import org.apache.bookkeeper.tools.cli.helpers.BookieCommand;
import org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.bookkeeper.tools.framework.CliSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointInfoCommand
extends BookieCommand<EndpointInfoFlags> {
    static final Logger LOG = LoggerFactory.getLogger(EndpointInfoCommand.class);
    private static final String NAME = "endpointinfo";
    private static final String DESC = "Get all end point information about a given bookie.";

    public EndpointInfoCommand() {
        this(new EndpointInfoFlags());
    }

    private EndpointInfoCommand(EndpointInfoFlags flags) {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags(flags).build());
    }

    @Override
    public boolean apply(ServerConfiguration conf, EndpointInfoFlags cmdFlags) {
        try {
            return this.getEndpointInfo(conf, cmdFlags);
        }
        catch (Exception e) {
            throw new UncheckedExecutionException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getEndpointInfo(ServerConfiguration conf, EndpointInfoFlags flags) throws BKException, InterruptedException, IOException {
        ClientConfiguration adminConf = new ClientConfiguration(conf);
        try (BookKeeperAdmin admin = new BookKeeperAdmin(adminConf);){
            String bookieIdStr = flags.bookie;
            if (bookieIdStr == null || bookieIdStr.isEmpty()) {
                throw new IllegalArgumentException("BookieId is required");
            }
            BookieId bookieId = BookieId.parse(bookieIdStr);
            Collection<BookieId> allBookies = admin.getAllBookies();
            if (!allBookies.contains(bookieId)) {
                LOG.info("Bookie {} does not exist, only {}", (Object)bookieId, allBookies);
                boolean bl = false;
                return bl;
            }
            BookieServiceInfo bookieServiceInfo = admin.getBookieServiceInfo(bookieId);
            LOG.info("BookiedId: {}", (Object)bookieId);
            if (!bookieServiceInfo.getProperties().isEmpty()) {
                LOG.info("Properties");
                bookieServiceInfo.getProperties().forEach((k, v) -> LOG.info("{} : {}", k, v));
            }
            if (bookieServiceInfo.getEndpoints().isEmpty()) {
                LOG.info("Bookie did not publish any endpoint info. Maybe it is down");
                boolean bl = false;
                return bl;
            }
            bookieServiceInfo.getEndpoints().forEach(e -> {
                LOG.info("Endpoint: {}", (Object)e.getId());
                LOG.info("Protocol: {}", (Object)e.getProtocol());
                LOG.info("Address: {} : {}", (Object)e.getHost(), (Object)e.getPort());
                LOG.info("Auth: {}", e.getAuth());
                LOG.info("Extensions: {}", e.getExtensions());
            });
            boolean bl = true;
            return bl;
        }
    }

    public static class EndpointInfoFlags
    extends CliFlags {
        @Parameter(required=true, names={"-b", "--bookieid"}, description="Get information about a remote bookie")
        private String bookie;

        public EndpointInfoFlags bookie(String bookie) {
            this.bookie = bookie;
            return this;
        }
    }
}

