/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tools.cli.commands.health;

import com.beust.jcommander.Parameter;
import java.util.concurrent.ExecutionException;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.bookkeeper.meta.exceptions.MetadataException;
import org.apache.bookkeeper.shaded.com.google.common.util.concurrent.UncheckedExecutionException;
import org.apache.bookkeeper.tools.cli.helpers.BookieCommand;
import org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.bookkeeper.tools.framework.CliSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchOfHealthCheckCommand
extends BookieCommand<HealthCheckFlags> {
    static final Logger LOG = LoggerFactory.getLogger(SwitchOfHealthCheckCommand.class);
    private static final String NAME = "switch";
    private static final String DESC = "Enables or disables health check in the cluster. Default is enabled.";

    public SwitchOfHealthCheckCommand() {
        this(new HealthCheckFlags());
    }

    private SwitchOfHealthCheckCommand(HealthCheckFlags flags) {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags(flags).build());
    }

    @Override
    public boolean apply(ServerConfiguration conf, HealthCheckFlags cmdFlags) {
        try {
            return this.handler(conf, cmdFlags);
        }
        catch (ExecutionException | MetadataException e) {
            throw new UncheckedExecutionException(e.getMessage(), e);
        }
    }

    private boolean handler(ServerConfiguration conf, HealthCheckFlags flags) throws MetadataException, ExecutionException {
        MetadataDrivers.runFunctionWithMetadataBookieDriver(conf, driver -> {
            try {
                boolean isEnable = driver.isHealthCheckEnabled().get();
                if (flags.status) {
                    LOG.info("EnableHealthCheck is " + (isEnable ? "enabled." : "disabled."));
                    return null;
                }
                if (flags.enable) {
                    if (isEnable) {
                        LOG.warn("HealthCheck already enabled. Doing nothing");
                    } else {
                        LOG.info("Enable HealthCheck");
                        driver.enableHealthCheck().get();
                    }
                } else if (!isEnable) {
                    LOG.warn("HealthCheck already disabled. Doing nothing");
                } else {
                    LOG.info("Disable HealthCheck");
                    driver.disableHealthCheck().get();
                }
            }
            catch (Exception e) {
                LOG.error("exception", (Throwable)e);
                throw new UncheckedExecutionException(e);
            }
            return null;
        });
        return true;
    }

    public static class HealthCheckFlags
    extends CliFlags {
        @Parameter(names={"-e", "--enable"}, description="Enable or disable health check.")
        private boolean enable;
        @Parameter(names={"-s", "--status"}, description="Check the health check status.")
        private boolean status;

        public HealthCheckFlags enable(boolean enable) {
            this.enable = enable;
            return this;
        }

        public HealthCheckFlags status(boolean status) {
            this.status = status;
            return this;
        }
    }
}

