/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.bookkeeper.bookie.DefaultEntryLogger;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.shaded.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EntryLoggerAllocator {
    private static final Logger log = LoggerFactory.getLogger(EntryLoggerAllocator.class);
    private long preallocatedLogId;
    Future<DefaultEntryLogger.BufferedLogChannel> preallocation = null;
    ExecutorService allocatorExecutor;
    private final ServerConfiguration conf;
    private final LedgerDirsManager ledgerDirsManager;
    private final Object createEntryLogLock = new Object();
    private final Object createCompactionLogLock = new Object();
    private final DefaultEntryLogger.RecentEntryLogsStatus recentlyCreatedEntryLogsStatus;
    private final boolean entryLogPreAllocationEnabled;
    private final ByteBufAllocator byteBufAllocator;
    final ByteBuf logfileHeader = Unpooled.buffer((int)1024);

    EntryLoggerAllocator(ServerConfiguration conf, LedgerDirsManager ledgerDirsManager, DefaultEntryLogger.RecentEntryLogsStatus recentlyCreatedEntryLogsStatus, long logId, ByteBufAllocator byteBufAllocator) {
        this.conf = conf;
        this.byteBufAllocator = byteBufAllocator;
        this.ledgerDirsManager = ledgerDirsManager;
        this.preallocatedLogId = logId;
        this.recentlyCreatedEntryLogsStatus = recentlyCreatedEntryLogsStatus;
        this.entryLogPreAllocationEnabled = conf.isEntryLogFilePreAllocationEnabled();
        this.allocatorExecutor = Executors.newSingleThreadExecutor();
        this.logfileHeader.writeBytes("BKLO".getBytes(StandardCharsets.UTF_8));
        this.logfileHeader.writeInt(1);
        this.logfileHeader.writerIndex(1024);
    }

    synchronized long getPreallocatedLogId() {
        return this.preallocatedLogId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DefaultEntryLogger.BufferedLogChannel createNewLog(File dirForNextEntryLog) throws IOException {
        Object object = this.createEntryLogLock;
        synchronized (object) {
            DefaultEntryLogger.BufferedLogChannel bc;
            if (!this.entryLogPreAllocationEnabled) {
                DefaultEntryLogger.BufferedLogChannel bc2 = this.allocateNewLog(dirForNextEntryLog);
                return bc2;
            }
            if (null == this.preallocation) {
                bc = this.allocateNewLog(dirForNextEntryLog);
            } else {
                try {
                    bc = this.preallocation.get();
                }
                catch (ExecutionException ee) {
                    if (ee.getCause() instanceof IOException) {
                        throw (IOException)ee.getCause();
                    }
                    throw new IOException("Error to execute entry log allocation.", ee);
                }
                catch (CancellationException ce) {
                    throw new IOException("Task to allocate a new entry log is cancelled.", ce);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Intrrupted when waiting a new entry log to be allocated.", ie);
                }
            }
            this.preallocation = this.allocatorExecutor.submit(() -> this.allocateNewLog(dirForNextEntryLog));
            return bc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DefaultEntryLogger.BufferedLogChannel createNewLogForCompaction(File dirForNextEntryLog) throws IOException {
        Object object = this.createCompactionLogLock;
        synchronized (object) {
            return this.allocateNewLog(dirForNextEntryLog, ".log.compacting");
        }
    }

    private synchronized DefaultEntryLogger.BufferedLogChannel allocateNewLog(File dirForNextEntryLog) throws IOException {
        return this.allocateNewLog(dirForNextEntryLog, ".log");
    }

    private synchronized DefaultEntryLogger.BufferedLogChannel allocateNewLog(File dirForNextEntryLog, String suffix) throws IOException {
        String logFileName;
        List<File> ledgersDirs = this.ledgerDirsManager.getAllLedgerDirs();
        File testLogFile = null;
        block0: do {
            this.preallocatedLogId = this.preallocatedLogId >= Integer.MAX_VALUE ? 0L : ++this.preallocatedLogId;
            logFileName = Long.toHexString(this.preallocatedLogId) + suffix;
            for (File dir : ledgersDirs) {
                testLogFile = new File(dir, logFileName);
                if (!testLogFile.exists()) continue;
                log.warn("Found existed entry log " + testLogFile + " when trying to create it as a new log.");
                testLogFile = null;
                continue block0;
            }
        } while (testLogFile == null);
        File newLogFile = new File(dirForNextEntryLog, logFileName);
        FileChannel channel = new RandomAccessFile(newLogFile, "rw").getChannel();
        DefaultEntryLogger.BufferedLogChannel logChannel = new DefaultEntryLogger.BufferedLogChannel(this.byteBufAllocator, channel, this.conf.getWriteBufferBytes(), this.conf.getReadBufferBytes(), this.preallocatedLogId, newLogFile, this.conf.getFlushIntervalInBytes());
        this.logfileHeader.readerIndex(0);
        logChannel.write(this.logfileHeader);
        for (File f : ledgersDirs) {
            this.setLastLogId(f, this.preallocatedLogId);
        }
        if (suffix.equals(".log")) {
            this.recentlyCreatedEntryLogsStatus.createdEntryLog(this.preallocatedLogId);
        }
        log.info("Created new entry log file {} for logId {}.", (Object)newLogFile, (Object)this.preallocatedLogId);
        return logChannel;
    }

    private synchronized void closePreAllocateLog() {
        if (this.preallocation != null) {
            try {
                DefaultEntryLogger.BufferedLogChannel bufferedLogChannel = this.getPreallocationFuture().get(3L, TimeUnit.SECONDS);
                if (bufferedLogChannel != null) {
                    bufferedLogChannel.close();
                }
            }
            catch (InterruptedException e) {
                log.warn("interrupted while release preAllocate log");
                Thread.currentThread().interrupt();
            }
            catch (IOException | ExecutionException | TimeoutException e) {
                log.warn("release preAllocate log failed, ignore error");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void setLastLogId(File dir, long logId) throws IOException {
        FileOutputStream fos = new FileOutputStream(new File(dir, "lastId"));
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8));
        try {
            bw.write(Long.toHexString(logId) + "\n");
            bw.flush();
        }
        catch (IOException e) {
            log.warn("Failed write lastId file");
        }
        finally {
            try {
                bw.close();
            }
            catch (IOException e) {
                log.error("Could not close lastId file in {}", (Object)dir.getPath());
            }
        }
    }

    void stop() {
        this.allocatorExecutor.execute(this::closePreAllocateLog);
        this.allocatorExecutor.shutdown();
        try {
            if (!this.allocatorExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                log.warn("Timedout while awaiting for allocatorExecutor's termination, so force shuttingdown");
            }
        }
        catch (InterruptedException e) {
            log.warn("Got InterruptedException while awaiting termination of allocatorExecutor, so force shuttingdown");
            Thread.currentThread().interrupt();
        }
        this.allocatorExecutor.shutdownNow();
        log.info("Stopped entry logger preallocator.");
    }

    Future<DefaultEntryLogger.BufferedLogChannel> getPreallocationFuture() {
        return this.preallocation;
    }
}

