/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.bookkeeper.bookie.Cookie;
import org.apache.bookkeeper.bookie.CookieValidation;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.discover.RegistrationManager;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.shaded.com.google.common.collect.Lists;
import org.apache.bookkeeper.versioning.Version;
import org.apache.bookkeeper.versioning.Versioned;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyCookieValidation
implements CookieValidation {
    private static final Logger log = LoggerFactory.getLogger(LegacyCookieValidation.class);
    private final ServerConfiguration conf;
    private final RegistrationManager registrationManager;

    public LegacyCookieValidation(ServerConfiguration conf, RegistrationManager registrationManager) {
        this.conf = conf;
        this.registrationManager = registrationManager;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void checkCookies(List<File> directories) throws BookieException {
        try {
            String instanceId = this.registrationManager.getClusterInstanceId();
            Cookie.Builder builder = Cookie.generateCookie(this.conf);
            if (null != instanceId) {
                builder.setInstanceId(instanceId);
            }
            Cookie masterCookie = builder.build();
            boolean allowExpansion = this.conf.getAllowStorageExpansion();
            List<BookieId> possibleBookieIds = LegacyCookieValidation.possibleBookieIds(this.conf);
            Versioned<Cookie> rmCookie = LegacyCookieValidation.readAndVerifyCookieFromRegistrationManager(masterCookie, this.registrationManager, possibleBookieIds, allowExpansion);
            ArrayList<File> missedCookieDirs = new ArrayList<File>();
            ArrayList<Cookie> existingCookies = Lists.newArrayList();
            if (null != rmCookie) {
                existingCookies.add(rmCookie.getValue());
            }
            Pair<List<File>, List<Cookie>> result = LegacyCookieValidation.verifyAndGetMissingDirs(masterCookie, allowExpansion, directories);
            missedCookieDirs.addAll((Collection)result.getLeft());
            existingCookies.addAll((Collection)result.getRight());
            if (missedCookieDirs.isEmpty()) {
                if (rmCookie != null) return;
                log.error("Cookie for this bookie is not stored in metadata store. Bookie failing to come up");
                throw new BookieException.InvalidCookieException();
            }
            if (rmCookie == null) {
                LegacyCookieValidation.verifyDirsForNewEnvironment(missedCookieDirs);
                LegacyCookieValidation.stampNewCookie(this.conf, masterCookie, this.registrationManager, Version.NEW, directories);
                return;
            }
            if (allowExpansion) {
                Set<File> knownDirs = LegacyCookieValidation.getKnownDirs(existingCookies);
                LegacyCookieValidation.verifyDirsForStorageExpansion(missedCookieDirs, knownDirs);
                LegacyCookieValidation.stampNewCookie(this.conf, masterCookie, this.registrationManager, rmCookie.getVersion(), directories);
                return;
            }
            log.error("There are directories without a cookie, and this is neither a new environment, nor is storage expansion enabled. Empty directories are {}", missedCookieDirs);
            throw new BookieException.InvalidCookieException();
        }
        catch (IOException ioe) {
            log.error("Error accessing cookie on disks", (Throwable)ioe);
            throw new BookieException.InvalidCookieException(ioe);
        }
    }

    private static List<BookieId> possibleBookieIds(ServerConfiguration conf) throws BookieException {
        ArrayList<BookieId> addresses = Lists.newArrayListWithExpectedSize(3);
        try {
            if (null != conf.getBookieId()) {
                addresses.add(BookieImpl.getBookieId(conf));
            } else {
                addresses.add(BookieImpl.getBookieAddress(new ServerConfiguration(conf).setUseHostNameAsBookieID(false).setAdvertisedAddress(null).setAllowLoopback(true)).toBookieId());
                addresses.add(BookieImpl.getBookieAddress(new ServerConfiguration(conf).setUseHostNameAsBookieID(true).setAdvertisedAddress(null).setAllowLoopback(true)).toBookieId());
                if (null != conf.getAdvertisedAddress()) {
                    addresses.add(BookieImpl.getBookieAddress(conf).toBookieId());
                }
            }
        }
        catch (UnknownHostException e) {
            throw new BookieException.UnknownBookieIdException(e);
        }
        return addresses;
    }

    private static Versioned<Cookie> readAndVerifyCookieFromRegistrationManager(Cookie masterCookie, RegistrationManager rm, List<BookieId> addresses, boolean allowExpansion) throws BookieException {
        Versioned<Cookie> rmCookie = null;
        for (BookieId address : addresses) {
            try {
                rmCookie = Cookie.readFromRegistrationManager(rm, address);
                if (allowExpansion) {
                    masterCookie.verifyIsSuperSet(rmCookie.getValue());
                    continue;
                }
                masterCookie.verify(rmCookie.getValue());
            }
            catch (BookieException.CookieNotFoundException e) {}
        }
        return rmCookie;
    }

    private static Pair<List<File>, List<Cookie>> verifyAndGetMissingDirs(Cookie masterCookie, boolean allowExpansion, List<File> dirs) throws BookieException.InvalidCookieException, IOException {
        ArrayList<File> missingDirs = Lists.newArrayList();
        ArrayList<Cookie> existedCookies = Lists.newArrayList();
        for (File dir : dirs) {
            try {
                Cookie c = Cookie.readFromDirectory(dir);
                if (allowExpansion) {
                    masterCookie.verifyIsSuperSet(c);
                } else {
                    masterCookie.verify(c);
                }
                existedCookies.add(c);
            }
            catch (FileNotFoundException fnf) {
                missingDirs.add(dir);
            }
        }
        return Pair.of(missingDirs, existedCookies);
    }

    private static void verifyDirsForNewEnvironment(List<File> missedCookieDirs) throws BookieException.InvalidCookieException {
        ArrayList<File> nonEmptyDirs = new ArrayList<File>();
        for (File dir : missedCookieDirs) {
            String[] content = dir.list();
            if (content == null || content.length == 0) continue;
            nonEmptyDirs.add(dir);
        }
        if (!nonEmptyDirs.isEmpty()) {
            log.error("Not all the new directories are empty. New directories that are not empty are: " + nonEmptyDirs);
            throw new BookieException.InvalidCookieException();
        }
    }

    private static void stampNewCookie(ServerConfiguration conf, Cookie masterCookie, RegistrationManager rm, Version version, List<File> dirs) throws BookieException, IOException {
        log.info("Stamping new cookies on all dirs {}", dirs);
        for (File dir : dirs) {
            masterCookie.writeToDirectory(dir);
        }
        masterCookie.writeToRegistrationManager(rm, conf, version);
    }

    private static Set<File> getKnownDirs(List<Cookie> cookies) {
        return cookies.stream().flatMap(c -> {
            ArrayList<String> dirs = new ArrayList<String>(Arrays.asList(c.getLedgerDirPathsFromCookie()));
            if (null != c.getIndexDirPathsFromCookie()) {
                dirs.addAll(Arrays.asList(c.getIndexDirPathsFromCookie()));
            }
            return Arrays.stream(dirs.toArray(new String[0]));
        }).map(s -> new File((String)s)).collect(Collectors.toSet());
    }

    private static void verifyDirsForStorageExpansion(List<File> missedCookieDirs, Set<File> existingLedgerDirs) throws BookieException.InvalidCookieException {
        ArrayList<File> dirsMissingData = new ArrayList<File>();
        ArrayList<File> nonEmptyDirs = new ArrayList<File>();
        for (File dir : missedCookieDirs) {
            if (existingLedgerDirs.contains(dir.getParentFile())) {
                dirsMissingData.add(dir);
                continue;
            }
            String[] content = dir.list();
            if (content == null || content.length == 0) continue;
            nonEmptyDirs.add(dir);
        }
        if (dirsMissingData.size() > 0 || nonEmptyDirs.size() > 0) {
            log.error("Either not all local directories have cookies or directories being added  newly are not empty. Directories missing cookie file are: " + dirsMissingData + " New directories that are not empty are: " + nonEmptyDirs);
            throw new BookieException.InvalidCookieException();
        }
    }
}

