/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.stats;

import java.util.function.Supplier;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.Gauge;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stats.annotations.StatsDoc;

@StatsDoc(name="bookie", category="server", help="Index Persistence Manager related stats")
public class IndexPersistenceMgrStats {
    @StatsDoc(name="LEDGER_CACHE_NUM_EVICTED_LEDGERS", help="Number of ledgers evicted from ledger caches")
    private final Counter evictedLedgersCounter;
    @StatsDoc(name="PENDING_GET_FILE_INFO", help="Number of pending get-file-info requests")
    private final Counter pendingGetFileInfoCounter;
    @StatsDoc(name="WRITE_FILE_INFO_CACHE_SIZE", help="Current write file info cache size")
    private final Gauge<Number> writeFileInfoCacheSizeGauge;
    @StatsDoc(name="READ_FILE_INFO_CACHE_SIZE", help="Current read file info cache size")
    private final Gauge<Number> readFileInfoCacheSizeGauge;

    public IndexPersistenceMgrStats(StatsLogger statsLogger, final Supplier<Number> writeFileInfoCacheSizeSupplier, final Supplier<Number> readFileInfoCacheSizeSupplier) {
        this.evictedLedgersCounter = statsLogger.getCounter("LEDGER_CACHE_NUM_EVICTED_LEDGERS");
        this.pendingGetFileInfoCounter = statsLogger.getCounter("PENDING_GET_FILE_INFO");
        this.writeFileInfoCacheSizeGauge = new Gauge<Number>(){

            @Override
            public Number getDefaultValue() {
                return 0;
            }

            @Override
            public Number getSample() {
                return (Number)writeFileInfoCacheSizeSupplier.get();
            }
        };
        statsLogger.registerGauge("WRITE_FILE_INFO_CACHE_SIZE", this.writeFileInfoCacheSizeGauge);
        this.readFileInfoCacheSizeGauge = new Gauge<Number>(){

            @Override
            public Number getDefaultValue() {
                return 0;
            }

            @Override
            public Number getSample() {
                return (Number)readFileInfoCacheSizeSupplier.get();
            }
        };
        statsLogger.registerGauge("READ_FILE_INFO_CACHE_SIZE", this.readFileInfoCacheSizeGauge);
    }

    public Counter getEvictedLedgersCounter() {
        return this.evictedLedgersCounter;
    }

    public Counter getPendingGetFileInfoCounter() {
        return this.pendingGetFileInfoCounter;
    }

    public Gauge<Number> getWriteFileInfoCacheSizeGauge() {
        return this.writeFileInfoCacheSizeGauge;
    }

    public Gauge<Number> getReadFileInfoCacheSizeGauge() {
        return this.readFileInfoCacheSizeGauge;
    }
}

