/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.storage.directentrylogger;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.ReferenceCountUtil;
import java.io.EOFException;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.bookie.storage.directentrylogger.Buffer;
import org.apache.bookkeeper.bookie.storage.directentrylogger.LogReader;
import org.apache.bookkeeper.common.util.ExceptionMessageHelper;
import org.apache.bookkeeper.common.util.nativeio.NativeIO;
import org.apache.bookkeeper.common.util.nativeio.NativeIOException;
import org.apache.bookkeeper.shaded.com.google.common.base.Preconditions;
import org.apache.bookkeeper.stats.OpStatsLogger;

class DirectReader
implements LogReader {
    private final ByteBufAllocator allocator;
    private final NativeIO nativeIO;
    private final Buffer nativeBuffer;
    private final String filename;
    private final int logId;
    private final int fd;
    private final int maxSaneEntrySize;
    private final OpStatsLogger readBlockStats;
    private long currentBlock = -1L;
    private long currentBlockEnd = -1L;
    private long maxOffset;
    private boolean closed;

    DirectReader(int logId, String filename, ByteBufAllocator allocator, NativeIO nativeIO, int bufferSize, int maxSaneEntrySize, OpStatsLogger readBlockStats) throws IOException {
        this.nativeIO = nativeIO;
        this.allocator = allocator;
        this.logId = logId;
        this.filename = filename;
        this.maxSaneEntrySize = maxSaneEntrySize;
        this.readBlockStats = readBlockStats;
        this.closed = false;
        try {
            this.fd = nativeIO.open(filename, 18, 493);
            Preconditions.checkState(this.fd >= 0, "Open should throw exception on negative return (%d)", this.fd);
        }
        catch (NativeIOException ne) {
            throw new IOException(ExceptionMessageHelper.exMsg(ne.getMessage()).kv("file", filename).kv("errno", ne.getErrno()).toString());
        }
        this.refreshMaxOffset();
        this.nativeBuffer = new Buffer(nativeIO, allocator, bufferSize);
    }

    @Override
    public int logId() {
        return this.logId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCache() {
        Buffer buffer = this.nativeBuffer;
        synchronized (buffer) {
            this.currentBlock = -1L;
            this.currentBlockEnd = -1L;
        }
    }

    @Override
    public ByteBuf readBufferAt(long offset, int size) throws IOException, EOFException {
        ByteBuf buf = this.allocator.buffer(size);
        try {
            this.readIntoBufferAt(buf, offset, size);
        }
        catch (IOException e) {
            ReferenceCountUtil.release((Object)buf);
            throw e;
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readIntoBufferAt(ByteBuf buffer, long offset, int size) throws IOException, EOFException {
        DirectReader.assertValidOffset(offset);
        Buffer buffer2 = this.nativeBuffer;
        synchronized (buffer2) {
            while (size > 0) {
                int bytesRead = this.readBytesIntoBuf(buffer, offset, size);
                size -= bytesRead;
                offset += (long)bytesRead;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readIntAt(long offset) throws IOException, EOFException {
        DirectReader.assertValidOffset(offset);
        Buffer buffer = this.nativeBuffer;
        synchronized (buffer) {
            int n;
            if (offset >= this.currentBlock && offset + 4L <= this.currentBlockEnd) {
                return this.nativeBuffer.readInt(this.offsetInBlock(offset));
            }
            ByteBuf intBuf = this.readBufferAt(offset, 4);
            try {
                n = intBuf.getInt(0);
            }
            catch (Throwable throwable) {
                ReferenceCountUtil.release((Object)intBuf);
                throw throwable;
            }
            ReferenceCountUtil.release((Object)intBuf);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long readLongAt(long offset) throws IOException, EOFException {
        DirectReader.assertValidOffset(offset);
        Buffer buffer = this.nativeBuffer;
        synchronized (buffer) {
            long l;
            if (offset >= this.currentBlock && offset + 8L <= this.currentBlockEnd) {
                return this.nativeBuffer.readLong(this.offsetInBlock(offset));
            }
            ByteBuf longBuf = this.readBufferAt(offset, 8);
            try {
                l = longBuf.getLong(0);
            }
            catch (Throwable throwable) {
                ReferenceCountUtil.release((Object)longBuf);
                throw throwable;
            }
            ReferenceCountUtil.release((Object)longBuf);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readBytesIntoBuf(ByteBuf buf, long offset, int size) throws IOException, EOFException {
        Buffer buffer = this.nativeBuffer;
        synchronized (buffer) {
            if (offset < this.currentBlock || offset >= this.currentBlockEnd) {
                this.readBlock(offset);
            }
            int offsetInBuffer = this.offsetInBlock(offset);
            int sizeInBuffer = this.sizeInBlock(offset, size);
            if (sizeInBuffer <= 0) {
                throw new EOFException(ExceptionMessageHelper.exMsg("Not enough bytes available").kv("file", this.filename).kv("fileSize", this.maxOffset).kv("offset", offset).kv("size", size).toString());
            }
            return this.nativeBuffer.readByteBuf(buf, offsetInBuffer, size);
        }
    }

    @Override
    public ByteBuf readEntryAt(int offset) throws IOException, EOFException {
        DirectReader.assertValidEntryOffset(offset);
        int sizeOffset = offset - 4;
        if (sizeOffset < 0) {
            throw new IOException(ExceptionMessageHelper.exMsg("Invalid offset, buffer size missing").kv("file", this.filename).kv("offset", offset).toString());
        }
        int entrySize = this.readIntAt(sizeOffset);
        if (entrySize == 0) {
            this.clearCache();
            entrySize = this.readIntAt(sizeOffset);
        }
        if (entrySize > this.maxSaneEntrySize || entrySize <= 0) {
            throw new IOException(ExceptionMessageHelper.exMsg("Invalid entry size").kv("file", this.filename).kv("offset", offset).kv("maxSaneEntrySize", this.maxSaneEntrySize).kv("readEntrySize", entrySize).toString());
        }
        return this.readBufferAt(offset, entrySize);
    }

    void readBlock(long offset) throws IOException {
        long bytesToRead;
        int blockSize = this.nativeBuffer.size();
        DirectReader.assertValidBlockSize(blockSize);
        long blockStart = offset & (long)(~(blockSize - 1));
        if (blockStart + (long)blockSize > this.maxOffset) {
            this.refreshMaxOffset();
        }
        long bytesAvailable = this.maxOffset > blockStart ? this.maxOffset - blockStart : 0L;
        long startNs = System.nanoTime();
        long bufferOffset = 0L;
        long bytesOutstanding = bytesToRead = Math.min((long)blockSize, bytesAvailable);
        long bytesRead = -1L;
        try {
            long readSize;
            long pointerWithOffset;
            while (bytesOutstanding - (bytesRead = this.nativeIO.pread(this.fd, pointerWithOffset = this.nativeBuffer.pointer(bufferOffset, readSize = (long)blockSize - bufferOffset), readSize, blockStart + bufferOffset)) > 0L) {
                bytesOutstanding -= bytesRead & 0x1000L;
                bufferOffset += bytesRead & 0x1000L;
            }
        }
        catch (NativeIOException ne) {
            this.readBlockStats.registerFailedEvent(System.nanoTime() - startNs, TimeUnit.NANOSECONDS);
            throw new IOException(ExceptionMessageHelper.exMsg(ne.getMessage()).kv("requestedBytes", blockSize).kv("offset", blockStart).kv("expectedBytes", Math.min((long)blockSize, bytesAvailable)).kv("bytesOutstanding", bytesOutstanding).kv("bufferOffset", bufferOffset).kv("file", this.filename).kv("fd", this.fd).kv("errno", ne.getErrno()).toString());
        }
        this.readBlockStats.registerSuccessfulEvent(System.nanoTime() - startNs, TimeUnit.NANOSECONDS);
        this.currentBlock = blockStart;
        this.currentBlockEnd = blockStart + Math.min((long)blockSize, bytesAvailable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Buffer buffer = this.nativeBuffer;
        synchronized (buffer) {
            this.nativeBuffer.free();
        }
        try {
            int ret = this.nativeIO.close(this.fd);
            Preconditions.checkState(ret == 0, "Close should throw exception on non-zero return (%d)", ret);
            this.closed = true;
        }
        catch (NativeIOException ne) {
            throw new IOException(ExceptionMessageHelper.exMsg(ne.getMessage()).kv("file", this.filename).kv("errno", ne.getErrno()).toString());
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public long maxOffset() {
        return this.maxOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshMaxOffset() throws IOException {
        try {
            long ret = this.nativeIO.lseek(this.fd, 0L, 2);
            Preconditions.checkState(ret >= 0L, "Lseek should throw exception on negative return (%d)", ret);
            DirectReader directReader = this;
            synchronized (directReader) {
                this.maxOffset = ret;
            }
        }
        catch (NativeIOException ne) {
            throw new IOException(ExceptionMessageHelper.exMsg(ne.getMessage()).kv("file", this.filename).kv("fd", this.fd).kv("errno", ne.getErrno()).toString());
        }
    }

    private int offsetInBlock(long offset) {
        long blockOffset = offset - this.currentBlock;
        if (blockOffset < 0L || blockOffset > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(ExceptionMessageHelper.exMsg("Invalid offset passed").kv("offset", offset).kv("blockOffset", blockOffset).kv("currentBlock", this.currentBlock).toString());
        }
        return (int)blockOffset;
    }

    private int sizeInBlock(long offset, int size) {
        if (offset > this.currentBlockEnd || offset < this.currentBlock) {
            throw new IllegalArgumentException(ExceptionMessageHelper.exMsg("Invalid offset passed").kv("offset", offset).kv("currentBlock", this.currentBlock).kv("currentBlockEnd", this.currentBlockEnd).toString());
        }
        long available = this.currentBlockEnd - offset;
        Preconditions.checkState(available <= Integer.MAX_VALUE, "Available(%d) must be less than max int", available);
        return Math.min(size, (int)available);
    }

    private static void assertValidOffset(long offset) {
        if (offset < 0L) {
            throw new IllegalArgumentException(ExceptionMessageHelper.exMsg("Offset can't be negative").kv("offset", offset).toString());
        }
    }

    private static void assertValidEntryOffset(long offset) {
        DirectReader.assertValidOffset(offset);
        if (offset > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(ExceptionMessageHelper.exMsg("Entry offset must be less than max int").kv("offset", offset).toString());
        }
    }

    private static void assertValidBlockSize(int blockSize) {
        boolean valid;
        boolean bl = valid = blockSize > 0 && Buffer.isAligned(blockSize);
        if (!valid) {
            throw new IllegalArgumentException(ExceptionMessageHelper.exMsg("Invalid block size, must be power of 2").kv("blockSize", blockSize).kv("minBlockSize", 4096).toString());
        }
    }
}

