/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.meta;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.bookkeeper.common.annotation.InterfaceAudience;
import org.apache.bookkeeper.common.annotation.InterfaceStability;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.discover.RegistrationClient;
import org.apache.bookkeeper.meta.LayoutManager;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.meta.exceptions.MetadataException;
import org.apache.bookkeeper.stats.StatsLogger;

@InterfaceAudience.LimitedPrivate
@InterfaceStability.Evolving
public interface MetadataClientDriver
extends AutoCloseable {
    public MetadataClientDriver initialize(ClientConfiguration var1, ScheduledExecutorService var2, StatsLogger var3, Optional<Object> var4) throws MetadataException;

    public String getScheme();

    public RegistrationClient getRegistrationClient();

    public LedgerManagerFactory getLedgerManagerFactory() throws MetadataException;

    public LayoutManager getLayoutManager();

    @Override
    public void close();

    public void setSessionStateListener(SessionStateListener var1);

    default public CompletableFuture<Boolean> isHealthCheckEnabled() {
        return FutureUtils.value(true);
    }

    @FunctionalInterface
    public static interface SessionStateListener {
        public void onSessionExpired();
    }
}

