/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.net;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.net.DNSToSwitchMapping;
import org.apache.bookkeeper.shaded.com.google.common.base.Preconditions;

public class NetUtils {
    public static String normalizeHostName(String name) {
        try {
            return InetAddress.getByName(name).getHostAddress();
        }
        catch (UnknownHostException e) {
            return name;
        }
    }

    public static List<String> normalizeHostNames(Collection<String> names) {
        ArrayList<String> hostNames = new ArrayList<String>(names.size());
        for (String name : names) {
            hostNames.add(NetUtils.normalizeHostName(name));
        }
        return hostNames;
    }

    public static String resolveNetworkLocation(DNSToSwitchMapping dnsResolver, BookieSocketAddress addr) {
        ArrayList<String> names = new ArrayList<String>(1);
        InetSocketAddress inetSocketAddress = addr.getSocketAddress();
        if (dnsResolver.useHostName()) {
            names.add(addr.getHostName());
        } else {
            InetAddress inetAddress = inetSocketAddress.getAddress();
            if (null == inetAddress) {
                names.add(addr.getHostName());
            } else {
                names.add(inetAddress.getHostAddress());
            }
        }
        List<String> rNames = dnsResolver.resolve(names);
        Preconditions.checkNotNull(rNames, "DNS Resolver should not return null response.");
        Preconditions.checkState(rNames.size() == 1, "Expected exactly one element");
        return rNames.get(0);
    }
}

