/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.server.http.service;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.BookieInfoReader;
import org.apache.bookkeeper.common.util.JsonUtil;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.http.HttpServer;
import org.apache.bookkeeper.http.service.HttpEndpointService;
import org.apache.bookkeeper.http.service.HttpServiceRequest;
import org.apache.bookkeeper.http.service.HttpServiceResponse;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.shaded.com.google.common.base.Preconditions;
import org.apache.bookkeeper.shaded.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListBookieInfoService
implements HttpEndpointService {
    static final Logger LOG = LoggerFactory.getLogger(ListBookieInfoService.class);
    protected ServerConfiguration conf;

    public ListBookieInfoService(ServerConfiguration conf) {
        Preconditions.checkNotNull(conf);
        this.conf = conf;
    }

    String getReadable(long val) {
        double d;
        String[] unit = new String[]{"", "KB", "MB", "GB", "TB"};
        int cnt = 0;
        for (d = (double)val; d >= 1000.0 && cnt < unit.length - 1; d /= 1000.0, ++cnt) {
        }
        DecimalFormat df = new DecimalFormat("#.###");
        df.setRoundingMode(RoundingMode.DOWN);
        return cnt > 0 ? "(" + df.format(d) + unit[cnt] + ")" : unit[cnt];
    }

    public HttpServiceResponse handle(HttpServiceRequest request) throws Exception {
        HttpServiceResponse response = new HttpServiceResponse();
        if (HttpServer.Method.GET == request.getMethod()) {
            ClientConfiguration clientConf = new ClientConfiguration(this.conf);
            clientConf.setDiskWeightBasedPlacementEnabled(true);
            BookKeeper bk = new BookKeeper(clientConf);
            Map<BookieId, BookieInfoReader.BookieInfo> map = bk.getBookieInfo();
            if (map.size() == 0) {
                bk.close();
                response.setCode(HttpServer.StatusCode.NOT_FOUND);
                response.setBody("Not found any Bookie info.");
                return response;
            }
            LinkedHashMap<String, String> output = Maps.newLinkedHashMapWithExpectedSize(map.size());
            Long totalFree = 0L;
            Long total = 0L;
            for (Map.Entry<BookieId, BookieInfoReader.BookieInfo> infoEntry : map.entrySet()) {
                BookieInfoReader.BookieInfo bInfo = infoEntry.getValue();
                output.put(infoEntry.getKey().toString(), ": {Free: " + bInfo.getFreeDiskSpace() + this.getReadable(bInfo.getFreeDiskSpace()) + ", Total: " + bInfo.getTotalDiskSpace() + this.getReadable(bInfo.getTotalDiskSpace()) + "},");
                totalFree = totalFree + bInfo.getFreeDiskSpace();
                total = total + bInfo.getTotalDiskSpace();
            }
            output.put("ClusterInfo: ", "{Free: " + totalFree + this.getReadable(totalFree) + ", Total: " + total + this.getReadable(total) + "}");
            bk.close();
            String jsonResponse = JsonUtil.toJson(output);
            if (LOG.isDebugEnabled()) {
                LOG.debug("output body:" + jsonResponse);
            }
            response.setBody(jsonResponse);
            response.setCode(HttpServer.StatusCode.OK);
            return response;
        }
        response.setCode(HttpServer.StatusCode.NOT_FOUND);
        response.setBody("Not found method. Should be GET method");
        return response;
    }
}

