/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.server.http.service;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.bookkeeper.bookie.LedgerStorage;
import org.apache.bookkeeper.common.util.JsonUtil;
import org.apache.bookkeeper.http.HttpServer;
import org.apache.bookkeeper.http.service.HttpEndpointService;
import org.apache.bookkeeper.http.service.HttpServiceRequest;
import org.apache.bookkeeper.http.service.HttpServiceResponse;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.shaded.com.google.common.base.Preconditions;
import org.apache.bookkeeper.shaded.com.google.common.collect.Lists;
import org.apache.bookkeeper.shaded.com.google.common.collect.Sets;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerLocationCompactService
implements HttpEndpointService {
    static final Logger LOG = LoggerFactory.getLogger(TriggerLocationCompactService.class);
    private final BookieServer bookieServer;
    private final List<String> entryLocationDBPath;

    public TriggerLocationCompactService(BookieServer bookieServer) {
        this.bookieServer = Preconditions.checkNotNull(bookieServer);
        this.entryLocationDBPath = bookieServer.getBookie().getLedgerStorage().getEntryLocationDBPath();
    }

    public HttpServiceResponse handle(HttpServiceRequest request) throws Exception {
        HttpServiceResponse response = new HttpServiceResponse();
        LedgerStorage ledgerStorage = this.bookieServer.getBookie().getLedgerStorage();
        if (HttpServer.Method.PUT.equals((Object)request.getMethod())) {
            String requestBody = request.getBody();
            String output = "Not trigger Entry Location RocksDB compact.";
            if (StringUtils.isBlank((CharSequence)requestBody)) {
                output = "Empty request body";
                response.setBody(output);
                response.setCode(HttpServer.StatusCode.BAD_REQUEST);
                return response;
            }
            try {
                Map configMap = JsonUtil.fromJson(requestBody, HashMap.class);
                Boolean isEntryLocationCompact = configMap.getOrDefault("entryLocationRocksDBCompact", false);
                String entryLocations = configMap.getOrDefault("entryLocations", "");
                if (!isEntryLocationCompact.booleanValue()) {
                    response.setBody(output);
                    response.setCode(HttpServer.StatusCode.OK);
                    return response;
                }
                if (StringUtils.isNotBlank((CharSequence)entryLocations)) {
                    HashSet<String> locations = Sets.newHashSet(entryLocations.trim().split(","));
                    if (CollectionUtils.isSubCollection(locations, this.entryLocationDBPath)) {
                        ledgerStorage.entryLocationCompact(Lists.newArrayList(locations));
                        output = String.format("Triggered entry Location RocksDB: %s compact on bookie:%s.", entryLocations, this.bookieServer.getBookieId());
                        response.setCode(HttpServer.StatusCode.OK);
                    } else {
                        output = String.format("Specified trigger compact entryLocations: %s is invalid. Bookie entry location RocksDB path: %s.", entryLocations, this.entryLocationDBPath);
                        response.setCode(HttpServer.StatusCode.BAD_REQUEST);
                    }
                } else {
                    ledgerStorage.entryLocationCompact();
                    output = "Triggered entry Location RocksDB compact on bookie:" + this.bookieServer.getBookieId();
                    response.setCode(HttpServer.StatusCode.OK);
                }
            }
            catch (JsonUtil.ParseJsonException ex) {
                output = ex.getMessage();
                response.setCode(HttpServer.StatusCode.BAD_REQUEST);
                LOG.warn("Trigger entry location index RocksDB compact failed, caused by: " + ex.getMessage());
            }
            String jsonResponse = JsonUtil.toJson(output);
            if (LOG.isDebugEnabled()) {
                LOG.debug("output body:" + jsonResponse);
            }
            response.setBody(jsonResponse);
            return response;
        }
        if (HttpServer.Method.GET == request.getMethod()) {
            Map<String, Boolean> compactStatus = ledgerStorage.isEntryLocationCompacting(this.entryLocationDBPath);
            String jsonResponse = JsonUtil.toJson(compactStatus);
            if (LOG.isDebugEnabled()) {
                LOG.debug("output body:" + jsonResponse);
            }
            response.setBody(jsonResponse);
            response.setCode(HttpServer.StatusCode.OK);
            return response;
        }
        response.setCode(HttpServer.StatusCode.METHOD_NOT_ALLOWED);
        response.setBody("Not found method. Should be PUT to trigger entry location compact, Or GET to get entry location compact state.");
        return response;
    }
}

