/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tools.cli.commands.bookies;

import com.beust.jcommander.Parameter;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.bookie.Cookie;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.discover.RegistrationManager;
import org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.shaded.com.google.common.util.concurrent.UncheckedExecutionException;
import org.apache.bookkeeper.tools.cli.helpers.BookieCommand;
import org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.bookkeeper.tools.framework.CliSpec;
import org.apache.bookkeeper.util.IOUtils;
import org.apache.bookkeeper.versioning.Versioned;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoverCommand
extends BookieCommand<RecoverFlags> {
    private static final Logger LOG = LoggerFactory.getLogger(RecoverCommand.class);
    private static final String NAME = "recover";
    private static final String DESC = "Recover the ledger data for failed bookie";
    private static final long DEFAULT_ID = -1L;

    public RecoverCommand() {
        this(new RecoverFlags());
    }

    private RecoverCommand(RecoverFlags flags) {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags(flags).build());
    }

    @Override
    public boolean apply(ServerConfiguration conf, RecoverFlags cmdFlags) {
        try {
            return this.recover(conf, cmdFlags);
        }
        catch (Exception e) {
            throw new UncheckedExecutionException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean recover(ServerConfiguration conf, RecoverFlags flags) throws IOException, BKException, InterruptedException, KeeperException {
        boolean query = flags.query;
        boolean dryrun = flags.dryRun;
        boolean force = flags.force;
        boolean skipOpenLedgers = flags.skipOpenLedgers;
        boolean removeCookies = !dryrun && flags.deleteCookie;
        boolean skipUnrecoverableLedgers = flags.skipUnrecoverableLedgers;
        Long ledgerId = flags.ledger;
        int replicateRate = flags.replicateRate;
        String[] bookieStrs = flags.bookieAddress.split(",");
        HashSet<BookieId> bookieAddrs = new HashSet<BookieId>();
        for (String bookieStr : bookieStrs) {
            try {
                bookieAddrs.add(BookieId.parse(bookieStr));
            }
            catch (IllegalArgumentException err) {
                LOG.error("BookieSrcs has invalid bookie id format: {}", (Object)bookieStr);
                return false;
            }
        }
        if (!force) {
            LOG.error("Bookies : {}", bookieAddrs);
            if (!IOUtils.confirmPrompt("Are you sure to recover them : (Y/N)")) {
                LOG.error("Give up!");
                return false;
            }
        }
        LOG.info("Constructing admin");
        conf.setReplicationRateByBytes(replicateRate);
        ClientConfiguration adminConf = new ClientConfiguration(conf);
        LOG.info("Construct admin : {}", (Object)admin);
        try (BookKeeperAdmin admin = new BookKeeperAdmin(adminConf);){
            int n;
            if (query) {
                n = this.bkQuery(admin, bookieAddrs) ? 1 : 0;
                return n != 0;
            }
            if (-1L != ledgerId) {
                n = this.bkRecoveryLedger(admin, ledgerId, bookieAddrs, dryrun, skipOpenLedgers, removeCookies);
                return n != 0;
            }
            n = this.bkRecovery(admin, bookieAddrs, dryrun, skipOpenLedgers, removeCookies, skipUnrecoverableLedgers);
            return n != 0;
        }
    }

    private boolean bkQuery(BookKeeperAdmin bkAdmin, Set<BookieId> bookieAddrs) throws InterruptedException, BKException {
        SortedMap<Long, LedgerMetadata> ledgersContainBookies = bkAdmin.getLedgersContainBookies(bookieAddrs);
        LOG.error("NOTE: Bookies in inspection list are marked with '*'.");
        for (Map.Entry<Long, LedgerMetadata> ledger : ledgersContainBookies.entrySet()) {
            LOG.info("ledger {} : {}", (Object)ledger.getKey(), (Object)ledger.getValue().getState());
            Map<Long, Integer> numBookiesToReplacePerEnsemble = this.inspectLedger(ledger.getValue(), bookieAddrs);
            LOG.info("summary: [");
            for (Map.Entry<Long, Integer> entry : numBookiesToReplacePerEnsemble.entrySet()) {
                LOG.info("{}={}, ", (Object)entry.getKey(), (Object)entry.getValue());
            }
            LOG.info("]");
            LOG.info("");
        }
        LOG.error("Done");
        return true;
    }

    private Map<Long, Integer> inspectLedger(LedgerMetadata metadata, Set<BookieId> bookiesToInspect) {
        TreeMap<Long, Integer> numBookiesToReplacePerEnsemble = new TreeMap<Long, Integer>();
        for (Map.Entry ensemble : metadata.getAllEnsembles().entrySet()) {
            List bookieList = (List)ensemble.getValue();
            LOG.info("{}:\t", ensemble.getKey());
            int numBookiesToReplace = 0;
            for (BookieId bookie : bookieList) {
                LOG.info("{}", (Object)bookie.toString());
                if (bookiesToInspect.contains(bookie)) {
                    LOG.info("*");
                    ++numBookiesToReplace;
                } else {
                    LOG.info(" ");
                }
                LOG.info(" ");
            }
            LOG.info("");
            numBookiesToReplacePerEnsemble.put((Long)ensemble.getKey(), numBookiesToReplace);
        }
        return numBookiesToReplacePerEnsemble;
    }

    private boolean bkRecoveryLedger(BookKeeperAdmin bkAdmin, long lid, Set<BookieId> bookieAddrs, boolean dryrun, boolean skipOpenLedgers, boolean removeCookies) throws InterruptedException, BKException {
        bkAdmin.recoverBookieData(lid, bookieAddrs, dryrun, skipOpenLedgers);
        if (removeCookies) {
            this.deleteCookies(bkAdmin.getConf(), bookieAddrs);
        }
        return true;
    }

    private void deleteCookies(ClientConfiguration conf, Set<BookieId> bookieAddrs) throws BKException {
        ServerConfiguration serverConf = new ServerConfiguration(conf);
        try {
            MetadataDrivers.runFunctionWithRegistrationManager(serverConf, rm -> {
                try {
                    for (BookieId addr : bookieAddrs) {
                        this.deleteCookie((RegistrationManager)rm, addr);
                    }
                }
                catch (Exception e) {
                    throw new UncheckedExecutionException(e);
                }
                return null;
            });
        }
        catch (Exception e) {
            Throwable cause = e;
            if (e instanceof UncheckedExecutionException) {
                cause = e.getCause();
            }
            if (cause instanceof BKException) {
                throw (BKException)cause;
            }
            BKException.MetaStoreException bke = new BKException.MetaStoreException();
            bke.initCause(bke);
            throw bke;
        }
    }

    private void deleteCookie(RegistrationManager rm, BookieId bookieSrc) throws BookieException {
        try {
            Versioned<Cookie> cookie = Cookie.readFromRegistrationManager(rm, bookieSrc);
            cookie.getValue().deleteFromRegistrationManager(rm, bookieSrc, cookie.getVersion());
        }
        catch (BookieException.CookieNotFoundException nne) {
            LOG.warn("No cookie to remove for {} : ", (Object)bookieSrc, (Object)nne);
        }
    }

    private boolean bkRecovery(BookKeeperAdmin bkAdmin, Set<BookieId> bookieAddrs, boolean dryrun, boolean skipOpenLedgers, boolean removeCookies, boolean skipUnrecoverableLedgers) throws InterruptedException, BKException {
        bkAdmin.recoverBookieData(bookieAddrs, dryrun, skipOpenLedgers, skipUnrecoverableLedgers);
        if (removeCookies) {
            this.deleteCookies(bkAdmin.getConf(), bookieAddrs);
        }
        return true;
    }

    public static class RecoverFlags
    extends CliFlags {
        @Parameter(names={"-l", "--ledger"}, description="Recover a specific ledger")
        private long ledger = -1L;
        @Parameter(names={"-f", "--force"}, description="Force recovery without confirmation")
        private boolean force;
        @Parameter(names={"-q", "--query"}, description="Query the ledgers that contain given bookies")
        private boolean query;
        @Parameter(names={"-dr", "--drarun"}, description="Printing the recovery plan w/o doing actual recovery")
        private boolean dryRun;
        @Parameter(names={"-sk", "--skipopenledgers"}, description="Skip recovering open ledgers")
        private boolean skipOpenLedgers;
        @Parameter(names={"-d", "--deletecookie"}, description="Delete cookie node for the bookie")
        private boolean deleteCookie;
        @Parameter(names={"-bs", "--bokiesrc"}, description="Bookie address")
        private String bookieAddress;
        @Parameter(names={"-sku", "--skipunrecoverableledgers"}, description="Skip unrecoverable ledgers")
        private boolean skipUnrecoverableLedgers;
        @Parameter(names={"-rate", "--replicationrate"}, description="Replication rate in bytes")
        private int replicateRate;

        public RecoverFlags ledger(long ledger) {
            this.ledger = ledger;
            return this;
        }

        public RecoverFlags force(boolean force) {
            this.force = force;
            return this;
        }

        public RecoverFlags query(boolean query) {
            this.query = query;
            return this;
        }

        public RecoverFlags dryRun(boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public RecoverFlags skipOpenLedgers(boolean skipOpenLedgers) {
            this.skipOpenLedgers = skipOpenLedgers;
            return this;
        }

        public RecoverFlags deleteCookie(boolean deleteCookie) {
            this.deleteCookie = deleteCookie;
            return this;
        }

        public RecoverFlags bookieAddress(String bookieAddress) {
            this.bookieAddress = bookieAddress;
            return this;
        }

        public RecoverFlags skipUnrecoverableLedgers(boolean skipUnrecoverableLedgers) {
            this.skipUnrecoverableLedgers = skipUnrecoverableLedgers;
            return this;
        }

        public RecoverFlags replicateRate(int replicateRate) {
            this.replicateRate = replicateRate;
            return this;
        }
    }
}

