/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.bookkeeper.bookie.AbstractLogCompactor;
import org.apache.bookkeeper.bookie.CompactableLedgerStorage;
import org.apache.bookkeeper.bookie.EntryLogMetadata;
import org.apache.bookkeeper.bookie.EntryLogger;
import org.apache.bookkeeper.bookie.GarbageCollectorThread;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.stats.StatsLogger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.powermock.reflect.Whitebox;

public class GarbageCollectorThreadTest {
    @InjectMocks
    @Spy
    private GarbageCollectorThread mockGCThread;
    @Mock
    private LedgerManager ledgerManager;
    @Mock
    private StatsLogger statsLogger;
    @Mock
    private ScheduledExecutorService gcExecutor;
    private ServerConfiguration conf = (ServerConfiguration)Mockito.spy((Object)new ServerConfiguration());
    private CompactableLedgerStorage ledgerStorage = (CompactableLedgerStorage)Mockito.mock(CompactableLedgerStorage.class);

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.ledgerStorage.getEntryLogger()).thenReturn(Mockito.mock(EntryLogger.class));
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testCompactEntryLogWithException() throws Exception {
        AbstractLogCompactor mockCompactor = (AbstractLogCompactor)Mockito.mock(AbstractLogCompactor.class);
        Mockito.when((Object)mockCompactor.compact((EntryLogMetadata)Mockito.any(EntryLogMetadata.class))).thenThrow(new Throwable[]{new RuntimeException("Unexpected compaction error")});
        Whitebox.setInternalState((Object)this.mockGCThread, (String)"compactor", (Object)mockCompactor);
        AtomicBoolean compacting = (AtomicBoolean)Whitebox.getInternalState((Object)this.mockGCThread, (String)"compacting");
        Assert.assertFalse((boolean)compacting.get());
        this.mockGCThread.compactEntryLog(new EntryLogMetadata(9999L));
        Assert.assertFalse((boolean)compacting.get());
    }
}

