/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import com.google.common.base.Charsets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Collections;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.FileInfo;
import org.apache.bookkeeper.bookie.FileInfoBackingCache;
import org.apache.bookkeeper.bookie.IndexPersistenceMgr;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.LedgerDirsMonitor;
import org.apache.bookkeeper.bookie.LedgerEntryPage;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.common.util.Watcher;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.proto.DataFormats;
import org.apache.bookkeeper.proto.checksum.DigestManager;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.util.DiskChecker;
import org.apache.bookkeeper.util.SnapshotMap;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IndexPersistenceMgrTest {
    ServerConfiguration conf;
    File journalDir;
    File ledgerDir;
    LedgerDirsManager ledgerDirsManager;
    LedgerDirsMonitor ledgerMonitor;
    final long lid = 1L;
    final byte[] masterKey = "write".getBytes();

    @Before
    public void setUp() throws Exception {
        this.journalDir = File.createTempFile("IndexPersistenceMgr", "Journal");
        this.journalDir.delete();
        this.journalDir.mkdir();
        this.ledgerDir = File.createTempFile("IndexPersistenceMgr", "Ledger");
        this.ledgerDir.delete();
        this.ledgerDir.mkdir();
        Bookie.getCurrentDirectory((File)this.journalDir).mkdir();
        Bookie.getCurrentDirectory((File)this.ledgerDir).mkdir();
        this.conf = new ServerConfiguration();
        this.conf.setMetadataServiceUri(null);
        this.conf.setJournalDirName(this.journalDir.getPath());
        this.conf.setLedgerDirNames(new String[]{this.ledgerDir.getPath()});
        this.ledgerDirsManager = new LedgerDirsManager(this.conf, this.conf.getLedgerDirs(), new DiskChecker(this.conf.getDiskUsageThreshold(), this.conf.getDiskUsageWarnThreshold()));
        this.ledgerMonitor = new LedgerDirsMonitor(this.conf, new DiskChecker(this.conf.getDiskUsageThreshold(), this.conf.getDiskUsageWarnThreshold()), Collections.singletonList(this.ledgerDirsManager));
        this.ledgerMonitor.init();
    }

    @After
    public void tearDown() throws Exception {
        this.ledgerMonitor.shutdown();
        FileUtils.deleteDirectory((File)this.journalDir);
        FileUtils.deleteDirectory((File)this.ledgerDir);
    }

    private IndexPersistenceMgr createIndexPersistenceManager(int openFileLimit) throws Exception {
        ServerConfiguration newConf = new ServerConfiguration();
        newConf.addConfiguration((Configuration)this.conf);
        newConf.setOpenFileLimit(openFileLimit);
        return new IndexPersistenceMgr(newConf.getPageSize(), newConf.getPageSize() / LedgerEntryPage.getIndexEntrySize(), newConf, new SnapshotMap(), this.ledgerDirsManager, (StatsLogger)NullStatsLogger.INSTANCE);
    }

    private static void getNumFileInfos(IndexPersistenceMgr indexPersistenceMgr, int numFiles, byte[] masterKey) throws Exception {
        for (int i = 0; i < numFiles; ++i) {
            indexPersistenceMgr.getFileInfo(Long.valueOf(i), masterKey);
        }
    }

    @Test
    public void testEvictFileInfoWhenUnderlyingFileExists() throws Exception {
        this.evictFileInfoTest(true);
    }

    @Test
    public void testEvictFileInfoWhenUnderlyingFileDoesntExist() throws Exception {
        this.evictFileInfoTest(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evictFileInfoTest(boolean createFile) throws Exception {
        try (IndexPersistenceMgr indexPersistenceMgr = this.createIndexPersistenceManager(2);){
            long lid = 99999L;
            byte[] masterKey = "evict-file-info".getBytes(Charsets.UTF_8);
            FileInfoBackingCache.CachedFileInfo fi = indexPersistenceMgr.getFileInfo(Long.valueOf(lid), masterKey);
            if (createFile) {
                fi.checkOpen(true);
            }
            fi.setFenced();
            IndexPersistenceMgrTest.getNumFileInfos(indexPersistenceMgr, 10, masterKey);
            fi = indexPersistenceMgr.getFileInfo(Long.valueOf(lid), masterKey);
            Assert.assertTrue((String)"Fence bit should be persisted", (boolean)fi.isFenced());
        }
    }

    @Test
    public void testGetFileInfoReadBeforeWrite() throws Exception {
        IndexPersistenceMgr indexPersistenceMgr = null;
        try {
            indexPersistenceMgr = this.createIndexPersistenceManager(1);
            try {
                indexPersistenceMgr.getFileInfo(Long.valueOf(1L), null);
                Assert.fail((String)"Should fail get file info for reading if the file doesn't exist");
            }
            catch (Bookie.NoLedgerException noLedgerException) {
                // empty catch block
            }
            Assert.assertEquals((long)0L, (long)indexPersistenceMgr.writeFileInfoCache.size());
            Assert.assertEquals((long)0L, (long)indexPersistenceMgr.readFileInfoCache.size());
            FileInfoBackingCache.CachedFileInfo writeFileInfo = indexPersistenceMgr.getFileInfo(Long.valueOf(1L), this.masterKey);
            Assert.assertEquals((long)2L, (long)writeFileInfo.getRefCount());
            Assert.assertEquals((long)1L, (long)indexPersistenceMgr.writeFileInfoCache.size());
            Assert.assertEquals((long)0L, (long)indexPersistenceMgr.readFileInfoCache.size());
            writeFileInfo.release();
            Assert.assertEquals((long)1L, (long)writeFileInfo.getRefCount());
        }
        finally {
            if (null != indexPersistenceMgr) {
                indexPersistenceMgr.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetFileInfoWriteBeforeRead() throws Exception {
        IndexPersistenceMgr indexPersistenceMgr = null;
        try {
            indexPersistenceMgr = this.createIndexPersistenceManager(1);
            FileInfoBackingCache.CachedFileInfo writeFileInfo = indexPersistenceMgr.getFileInfo(Long.valueOf(1L), this.masterKey);
            Assert.assertEquals((long)2L, (long)writeFileInfo.getRefCount());
            Assert.assertEquals((long)1L, (long)indexPersistenceMgr.writeFileInfoCache.size());
            Assert.assertEquals((long)0L, (long)indexPersistenceMgr.readFileInfoCache.size());
            writeFileInfo.release();
            FileInfoBackingCache.CachedFileInfo readFileInfo = indexPersistenceMgr.getFileInfo(Long.valueOf(1L), null);
            Assert.assertEquals((long)3L, (long)readFileInfo.getRefCount());
            Assert.assertEquals((long)1L, (long)indexPersistenceMgr.writeFileInfoCache.size());
            Assert.assertEquals((long)1L, (long)indexPersistenceMgr.readFileInfoCache.size());
            readFileInfo.release();
            Assert.assertEquals((long)2L, (long)writeFileInfo.getRefCount());
            Assert.assertEquals((long)2L, (long)readFileInfo.getRefCount());
        }
        finally {
            if (null != indexPersistenceMgr) {
                indexPersistenceMgr.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadFileInfoCacheEviction() throws Exception {
        IndexPersistenceMgr indexPersistenceMgr = null;
        try {
            int i;
            indexPersistenceMgr = this.createIndexPersistenceManager(1);
            for (i = 0; i < 3; ++i) {
                FileInfoBackingCache.CachedFileInfo fileInfo = indexPersistenceMgr.getFileInfo(Long.valueOf(1L + (long)i), this.masterKey);
                fileInfo.checkOpen(true);
                fileInfo.release();
                indexPersistenceMgr.getFileInfo(Long.valueOf(1L + (long)i), null).release();
            }
            indexPersistenceMgr.getFileInfo(Long.valueOf(1L), this.masterKey);
            Assert.assertEquals((long)1L, (long)indexPersistenceMgr.writeFileInfoCache.size());
            Assert.assertEquals((long)2L, (long)indexPersistenceMgr.readFileInfoCache.size());
            for (i = 1; i <= 2; ++i) {
                indexPersistenceMgr.getFileInfo(Long.valueOf(1L + (long)i), null);
            }
            Assert.assertEquals((long)1L, (long)indexPersistenceMgr.writeFileInfoCache.size());
            Assert.assertEquals((long)2L, (long)indexPersistenceMgr.readFileInfoCache.size());
            FileInfoBackingCache.CachedFileInfo fileInfo = (FileInfoBackingCache.CachedFileInfo)indexPersistenceMgr.writeFileInfoCache.asMap().get(1L);
            Assert.assertNotNull((Object)fileInfo);
            Assert.assertEquals((long)2L, (long)fileInfo.getRefCount());
            fileInfo = (FileInfoBackingCache.CachedFileInfo)indexPersistenceMgr.writeFileInfoCache.asMap().get(2L);
            Assert.assertNull((Object)fileInfo);
            fileInfo = (FileInfoBackingCache.CachedFileInfo)indexPersistenceMgr.writeFileInfoCache.asMap().get(3L);
            Assert.assertNull((Object)fileInfo);
            fileInfo = (FileInfoBackingCache.CachedFileInfo)indexPersistenceMgr.readFileInfoCache.asMap().get(1L);
            Assert.assertNull((Object)fileInfo);
            fileInfo = (FileInfoBackingCache.CachedFileInfo)indexPersistenceMgr.readFileInfoCache.asMap().get(2L);
            Assert.assertNotNull((Object)fileInfo);
            Assert.assertEquals((long)2L, (long)fileInfo.getRefCount());
            fileInfo = (FileInfoBackingCache.CachedFileInfo)indexPersistenceMgr.readFileInfoCache.asMap().get(3L);
            Assert.assertNotNull((Object)fileInfo);
            Assert.assertEquals((long)2L, (long)fileInfo.getRefCount());
        }
        finally {
            if (null != indexPersistenceMgr) {
                indexPersistenceMgr.close();
            }
        }
    }

    @Test
    public void testEvictionShouldNotAffectLongPollRead() throws Exception {
        IndexPersistenceMgr indexPersistenceMgr = null;
        Watcher watcher = notification -> notification.recycle();
        try {
            indexPersistenceMgr = this.createIndexPersistenceManager(1);
            indexPersistenceMgr.getFileInfo(Long.valueOf(1L), this.masterKey);
            indexPersistenceMgr.getFileInfo(Long.valueOf(1L), null);
            indexPersistenceMgr.updateLastAddConfirmed(1L, 1L);
            Assert.assertTrue((boolean)indexPersistenceMgr.waitForLastAddConfirmedUpdate(1L, 1L, watcher));
            indexPersistenceMgr.getFileInfo(Long.valueOf(2L), this.masterKey);
            Assert.assertTrue((boolean)indexPersistenceMgr.waitForLastAddConfirmedUpdate(1L, 1L, watcher));
            indexPersistenceMgr.getFileInfo(Long.valueOf(3L), this.masterKey);
            indexPersistenceMgr.getFileInfo(Long.valueOf(3L), null);
            Assert.assertTrue((boolean)indexPersistenceMgr.waitForLastAddConfirmedUpdate(1L, 1L, watcher));
        }
        finally {
            if (null != indexPersistenceMgr) {
                indexPersistenceMgr.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEvictBeforeReleaseRace() throws Exception {
        IndexPersistenceMgr indexPersistenceMgr = null;
        Watcher watcher = notification -> notification.recycle();
        try {
            indexPersistenceMgr = this.createIndexPersistenceManager(1);
            indexPersistenceMgr.getFileInfo(Long.valueOf(1L), this.masterKey);
            indexPersistenceMgr.getFileInfo(Long.valueOf(2L), this.masterKey);
            indexPersistenceMgr.getFileInfo(Long.valueOf(3L), this.masterKey);
            indexPersistenceMgr.getFileInfo(Long.valueOf(4L), this.masterKey);
            FileInfoBackingCache.CachedFileInfo fi = indexPersistenceMgr.getFileInfo(Long.valueOf(1L), this.masterKey);
            indexPersistenceMgr.getFileInfo(Long.valueOf(2L), this.masterKey);
            indexPersistenceMgr.getFileInfo(Long.valueOf(3L), null);
            indexPersistenceMgr.getFileInfo(Long.valueOf(4L), null);
            Thread.sleep(1000L);
            fi.setFenced();
            fi.release();
            Assert.assertTrue((boolean)indexPersistenceMgr.isFenced(1L));
        }
        finally {
            if (null != indexPersistenceMgr) {
                indexPersistenceMgr.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileInfosOfVariousHeaderVersions() throws Exception {
        IndexPersistenceMgr indexPersistenceMgr = null;
        try {
            indexPersistenceMgr = this.createIndexPersistenceManager(1);
            long ledgerIdWithVersionZero = 25L;
            this.validateFileInfo(indexPersistenceMgr, ledgerIdWithVersionZero, 0);
            long ledgerIdWithVersionOne = 135L;
            this.validateFileInfo(indexPersistenceMgr, ledgerIdWithVersionOne, 1);
        }
        finally {
            if (null != indexPersistenceMgr) {
                indexPersistenceMgr.close();
            }
        }
    }

    void validateFileInfo(IndexPersistenceMgr indexPersistenceMgr, long ledgerId, int headerVersion) throws IOException, GeneralSecurityException {
        BookKeeper.DigestType digestType = BookKeeper.DigestType.CRC32;
        boolean getUseV2WireProtocol = true;
        this.preCreateFileInfoForLedger(ledgerId, headerVersion);
        DigestManager digestManager = DigestManager.instantiate((long)ledgerId, (byte[])this.masterKey, (DataFormats.LedgerMetadataFormat.DigestType)BookKeeper.DigestType.toProtoDigestType((BookKeeper.DigestType)digestType), (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, (boolean)getUseV2WireProtocol);
        FileInfoBackingCache.CachedFileInfo fileInfo = indexPersistenceMgr.getFileInfo(Long.valueOf(ledgerId), this.masterKey);
        fileInfo.readHeader();
        Assert.assertEquals((String)"ExplicitLac should be null", null, (Object)fileInfo.getExplicitLac());
        Assert.assertEquals((String)"Header Version should match with precreated fileinfos headerversion", (long)headerVersion, (long)fileInfo.headerVersion);
        Assert.assertTrue((String)"Masterkey should match with precreated fileinfos masterkey", (boolean)Arrays.equals(this.masterKey, fileInfo.masterKey));
        long explicitLac = 22L;
        ByteBuf explicitLacByteBuf = digestManager.computeDigestAndPackageForSendingLac(explicitLac).getBuffer(0);
        explicitLacByteBuf.markReaderIndex();
        indexPersistenceMgr.setExplicitLac(ledgerId, explicitLacByteBuf);
        explicitLacByteBuf.resetReaderIndex();
        Assert.assertEquals((String)"explicitLac ByteBuf contents should match", (long)0L, (long)ByteBufUtil.compare((ByteBuf)explicitLacByteBuf, (ByteBuf)indexPersistenceMgr.getExplicitLac(ledgerId)));
        while (fileInfo.refCount.get() != -57005) {
            fileInfo.release();
        }
        fileInfo = indexPersistenceMgr.getFileInfo(Long.valueOf(ledgerId), this.masterKey);
        fileInfo.readHeader();
        Assert.assertEquals((String)"Header Version should match with precreated fileinfos headerversion even after reopening", (long)headerVersion, (long)fileInfo.headerVersion);
        Assert.assertTrue((String)"Masterkey should match with precreated fileinfos masterkey", (boolean)Arrays.equals(this.masterKey, fileInfo.masterKey));
        if (headerVersion == 0) {
            Assert.assertEquals((String)"Since it is V0 Header, explicitLac will not be persisted and should be null after reopening", null, (Object)indexPersistenceMgr.getExplicitLac(ledgerId));
        } else {
            explicitLacByteBuf.resetReaderIndex();
            Assert.assertEquals((String)"Since it is V1 Header, explicitLac will be persisted and should not be null after reopening", (long)0L, (long)ByteBufUtil.compare((ByteBuf)explicitLacByteBuf, (ByteBuf)indexPersistenceMgr.getExplicitLac(ledgerId)));
        }
    }

    void preCreateFileInfoForLedger(long ledgerId, int headerVersion) throws IOException {
        File ledgerCurDir = Bookie.getCurrentDirectory((File)this.ledgerDir);
        String ledgerName = IndexPersistenceMgr.getLedgerName((long)ledgerId);
        File indexFile = new File(ledgerCurDir, ledgerName);
        indexFile.getParentFile().mkdirs();
        indexFile.createNewFile();
        try (RandomAccessFile raf = new RandomAccessFile(indexFile, "rw");){
            FileChannel fcForIndexFile = raf.getChannel();
            ByteBuffer bb = ByteBuffer.allocate(1024);
            bb.putInt(FileInfo.SIGNATURE);
            bb.putInt(headerVersion);
            bb.putInt(this.masterKey.length);
            bb.put(this.masterKey);
            bb.putInt(0);
            if (headerVersion == 1) {
                bb.putInt(0);
            }
            bb.rewind();
            fcForIndexFile.position(0L);
            fcForIndexFile.write(bb);
            fcForIndexFile.close();
        }
    }
}

