/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.io.IOException;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.CheckpointSource;
import org.apache.bookkeeper.bookie.Checkpointer;
import org.apache.bookkeeper.bookie.EntryLogger;
import org.apache.bookkeeper.bookie.InterleavedLedgerStorage;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.StateManager;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.stats.StatsLogger;

public class SlowInterleavedLedgerStorage
extends InterleavedLedgerStorage {
    public static final String PROP_SLOW_STORAGE_FLUSH_DELAY = "test.slowStorage.flushDelay";
    public static final String PROP_SLOW_STORAGE_ADD_DELAY = "test.slowStorage.addDelay";
    public static final String PROP_SLOW_STORAGE_GET_DELAY = "test.slowStorage.getDelay";

    public void initialize(ServerConfiguration conf, LedgerManager ledgerManager, LedgerDirsManager ledgerDirsManager, LedgerDirsManager indexDirsManager, StateManager stateManager, CheckpointSource checkpointSource, Checkpointer checkpointer, StatsLogger statsLogger, ByteBufAllocator allocator) throws IOException {
        super.initialize(conf, ledgerManager, ledgerDirsManager, indexDirsManager, stateManager, checkpointSource, checkpointer, statsLogger, allocator);
        long getDelay = conf.getLong(PROP_SLOW_STORAGE_GET_DELAY, 0L);
        long addDelay = conf.getLong(PROP_SLOW_STORAGE_ADD_DELAY, 0L);
        long flushDelay = conf.getLong(PROP_SLOW_STORAGE_FLUSH_DELAY, 0L);
        this.entryLogger = new SlowEntryLogger(conf, ledgerDirsManager, (EntryLogger.EntryLogListener)this, statsLogger).setAddDelay(addDelay).setGetDelay(getDelay).setFlushDelay(flushDelay);
    }

    public void setAddDelay(long delay) {
        ((SlowEntryLogger)this.entryLogger).setAddDelay(delay);
    }

    public void setGetDelay(long delay) {
        ((SlowEntryLogger)this.entryLogger).setGetDelay(delay);
    }

    public void setFlushDelay(long delay) {
        ((SlowEntryLogger)this.entryLogger).setFlushDelay(delay);
    }

    public static class SlowEntryLogger
    extends EntryLogger {
        public volatile long getDelay = 0L;
        public volatile long addDelay = 0L;
        public volatile long flushDelay = 0L;

        public SlowEntryLogger(ServerConfiguration conf, LedgerDirsManager ledgerDirsManager, EntryLogger.EntryLogListener listener, StatsLogger statsLogger) throws IOException {
            super(conf, ledgerDirsManager, listener, statsLogger, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        }

        public SlowEntryLogger setAddDelay(long delay) {
            this.addDelay = delay;
            return this;
        }

        public SlowEntryLogger setGetDelay(long delay) {
            this.getDelay = delay;
            return this;
        }

        public SlowEntryLogger setFlushDelay(long delay) {
            this.flushDelay = delay;
            return this;
        }

        public void flush() throws IOException {
            SlowEntryLogger.delayMs(this.flushDelay);
            super.flush();
        }

        public long addEntry(long ledger, ByteBuf entry, boolean rollLog) throws IOException {
            SlowEntryLogger.delayMs(this.addDelay);
            return super.addEntry(ledger, entry, rollLog);
        }

        public ByteBuf readEntry(long ledgerId, long entryId, long location) throws IOException, Bookie.NoEntryException {
            SlowEntryLogger.delayMs(this.getDelay);
            return super.readEntry(ledgerId, entryId, location);
        }

        private static void delayMs(long delay) {
            if (delay < 1L) {
                return;
            }
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

