/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.bookie.CheckpointSource;
import org.apache.bookkeeper.bookie.Checkpointer;
import org.apache.bookkeeper.bookie.EntryLogManagerForSingleEntryLog;
import org.apache.bookkeeper.bookie.LedgerStorageTestBase;
import org.apache.bookkeeper.bookie.SortedLedgerStorage;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortedLedgerStorageCheckpointTest
extends LedgerStorageTestBase {
    private static final Logger log = LoggerFactory.getLogger(SortedLedgerStorageCheckpointTest.class);
    private SortedLedgerStorage storage;
    private Checkpointer checkpointer;
    private final LinkedBlockingQueue<CheckpointSource.Checkpoint> checkpoints;
    private final TestCheckpointSource checkpointSrc = new TestCheckpointSource();

    public SortedLedgerStorageCheckpointTest() {
        this.conf.setEntryLogSizeLimit(1024L);
        this.conf.setEntryLogFilePreAllocationEnabled(false);
        this.checkpoints = new LinkedBlockingQueue();
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.storage = new SortedLedgerStorage();
        this.checkpointer = new Checkpointer(){

            public void startCheckpoint(CheckpointSource.Checkpoint checkpoint) {
                SortedLedgerStorageCheckpointTest.this.storage.getScheduler().submit(() -> {
                    log.info("Checkpoint the storage at {}", (Object)checkpoint);
                    try {
                        SortedLedgerStorageCheckpointTest.this.storage.checkpoint(checkpoint);
                        SortedLedgerStorageCheckpointTest.this.checkpoints.add(checkpoint);
                    }
                    catch (IOException e) {
                        log.error("Failed to checkpoint at {}", (Object)checkpoint, (Object)e);
                    }
                });
            }

            public void start() {
            }
        };
        this.storage.initialize(this.conf, (LedgerManager)Mockito.mock(LedgerManager.class), this.ledgerDirsManager, this.ledgerDirsManager, null, (CheckpointSource)this.checkpointSrc, this.checkpointer, (StatsLogger)NullStatsLogger.INSTANCE, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        if (null != this.storage) {
            this.storage.shutdown();
        }
        super.tearDown();
    }

    ByteBuf prepareEntry(long ledgerId, long entryId) {
        ByteBuf entry = Unpooled.buffer((int)32);
        entry.writeLong(ledgerId);
        entry.writeLong(entryId);
        entry.writeLong(entryId - 1L);
        entry.writeLong(entryId);
        return entry;
    }

    @Test
    public void testCheckpoint() throws Exception {
        CheckpointSource.Checkpoint memtableCp = this.storage.memTable.kvmap.cp;
        Assert.assertEquals((Object)new TestCheckpoint(0L), (Object)memtableCp);
        long lid = System.currentTimeMillis();
        this.storage.setMasterKey(lid, new byte[0]);
        for (int i = 0; i < 20; ++i) {
            this.storage.addEntry(this.prepareEntry(lid, i));
        }
        this.checkpointSrc.advanceOffset(100L);
        memtableCp = this.storage.memTable.kvmap.cp;
        Assert.assertEquals((Object)new TestCheckpoint(0L), (Object)memtableCp);
        Assert.assertNotNull((String)"snapshot shouldn't have returned null", (Object)this.storage.memTable.snapshot());
        this.storage.onSizeLimitReached(this.checkpointSrc.newCheckpoint());
        this.checkpoints.poll(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)new TestCheckpoint(100L), (Object)this.storage.memTable.kvmap.cp);
        Assert.assertEquals((long)0L, (long)this.storage.memTable.kvmap.size());
    }

    @Test
    public void testCheckpointAfterEntryLogRotated() throws Exception {
        CheckpointSource.Checkpoint memtableCp = this.storage.memTable.kvmap.cp;
        Assert.assertEquals((Object)new TestCheckpoint(0L), (Object)memtableCp);
        long lid = System.currentTimeMillis();
        this.storage.setMasterKey(lid, new byte[0]);
        for (int i = 0; i < 20; ++i) {
            this.storage.addEntry(this.prepareEntry(lid, i));
        }
        this.checkpointSrc.advanceOffset(100L);
        memtableCp = this.storage.memTable.kvmap.cp;
        Assert.assertEquals((Object)new TestCheckpoint(0L), (Object)memtableCp);
        Assert.assertEquals((long)20L, (long)this.storage.memTable.kvmap.size());
        CountDownLatch readyLatch = new CountDownLatch(1);
        this.storage.getScheduler().submit(() -> {
            try {
                readyLatch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        });
        EntryLogManagerForSingleEntryLog entryLogManager = (EntryLogManagerForSingleEntryLog)this.storage.getEntryLogger().getEntryLogManager();
        entryLogManager.createNewLog(-1L);
        long leastUnflushedLogId = this.storage.getEntryLogger().getLeastUnflushedLogId();
        long currentLogId = entryLogManager.getCurrentLogId();
        log.info("Least unflushed entry log : current = {}, leastUnflushed = {}", (Object)currentLogId, (Object)leastUnflushedLogId);
        readyLatch.countDown();
        Assert.assertNull((Object)this.checkpoints.poll());
        Assert.assertEquals((Object)new TestCheckpoint(0L), (Object)this.storage.memTable.kvmap.cp);
        Assert.assertEquals((long)20L, (long)this.storage.memTable.kvmap.size());
        Assert.assertNotNull((String)"snapshot shouldn't have returned null", (Object)this.storage.memTable.snapshot());
        this.storage.onSizeLimitReached(this.checkpointSrc.newCheckpoint());
        Assert.assertEquals((Object)new TestCheckpoint(100L), (Object)this.checkpoints.poll(Long.MAX_VALUE, TimeUnit.MILLISECONDS));
        Assert.assertEquals((Object)new TestCheckpoint(100L), (Object)this.storage.memTable.kvmap.cp);
        Assert.assertEquals((long)0L, (long)this.storage.memTable.kvmap.size());
        Assert.assertTrue((String)("current log " + currentLogId + " contains entries added from memtable should be forced to disk but least unflushed log is " + this.storage.getEntryLogger().getLeastUnflushedLogId()), (this.storage.getEntryLogger().getLeastUnflushedLogId() > currentLogId ? 1 : 0) != 0);
    }

    private static class TestCheckpointSource
    implements CheckpointSource {
        private long currentOffset = 0L;

        void advanceOffset(long numBytes) {
            this.currentOffset += numBytes;
        }

        public CheckpointSource.Checkpoint newCheckpoint() {
            TestCheckpoint cp = new TestCheckpoint(this.currentOffset);
            log.info("New checkpoint : {}", (Object)cp);
            return cp;
        }

        public void checkpointComplete(CheckpointSource.Checkpoint checkpoint, boolean compact) throws IOException {
            log.info("Complete checkpoint : {}", (Object)checkpoint);
        }
    }

    private static class TestCheckpoint
    implements CheckpointSource.Checkpoint {
        private final long offset;

        public int compareTo(CheckpointSource.Checkpoint o) {
            if (CheckpointSource.Checkpoint.MAX == o) {
                return -1;
            }
            TestCheckpoint other = (TestCheckpoint)o;
            return Long.compare(this.offset, other.offset);
        }

        public long getOffset() {
            return this.offset;
        }

        public TestCheckpoint(long offset) {
            this.offset = offset;
        }

        public String toString() {
            return "SortedLedgerStorageCheckpointTest.TestCheckpoint(offset=" + this.getOffset() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TestCheckpoint)) {
                return false;
            }
            TestCheckpoint other = (TestCheckpoint)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.getOffset() == other.getOffset();
        }

        protected boolean canEqual(Object other) {
            return other instanceof TestCheckpoint;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $offset = this.getOffset();
            result = result * 59 + (int)($offset >>> 32 ^ $offset);
            return result;
        }
    }
}

