/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.PrimitiveIterator;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.CacheCallback;
import org.apache.bookkeeper.bookie.CheckpointSource;
import org.apache.bookkeeper.bookie.EntryKeyValue;
import org.apache.bookkeeper.bookie.EntryMemTable;
import org.apache.bookkeeper.bookie.EntryMemTableWithParallelFlusher;
import org.apache.bookkeeper.bookie.LogMark;
import org.apache.bookkeeper.bookie.SkipListFlusher;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.conf.TestBKConfiguration;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class TestEntryMemTable
implements CacheCallback,
SkipListFlusher,
CheckpointSource {
    private static final Logger log = LoggerFactory.getLogger(TestEntryMemTable.class);
    private Class entryMemTableClass;
    private EntryMemTable memTable;
    private final Random random = new Random();
    private TestCheckPoint curCheckpoint = new TestCheckPoint(0L, 0L);

    @Parameterized.Parameters
    public static Collection<Object[]> memTableClass() {
        return Arrays.asList({EntryMemTable.class}, {EntryMemTableWithParallelFlusher.class});
    }

    public TestEntryMemTable(Class entryMemTableClass) {
        this.entryMemTableClass = entryMemTableClass;
    }

    public CheckpointSource.Checkpoint newCheckpoint() {
        return this.curCheckpoint;
    }

    public void checkpointComplete(CheckpointSource.Checkpoint checkpoint, boolean compact) throws IOException {
    }

    @Before
    public void setUp() throws Exception {
        if (this.entryMemTableClass.equals(EntryMemTableWithParallelFlusher.class)) {
            ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
            this.memTable = new EntryMemTableWithParallelFlusher(conf, (CheckpointSource)this, (StatsLogger)NullStatsLogger.INSTANCE);
        } else {
            this.memTable = new EntryMemTable(TestBKConfiguration.newServerConfiguration(), (CheckpointSource)this, (StatsLogger)NullStatsLogger.INSTANCE);
        }
    }

    @After
    public void cleanup() throws Exception {
        this.memTable.close();
    }

    @Test
    public void testLogMark() throws IOException {
        LogMark mark = new LogMark();
        Assert.assertTrue((mark.compare(new LogMark()) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((mark.compare(LogMark.MAX_VALUE) < 0 ? 1 : 0) != 0);
        mark.setLogMark(3L, 11L);
        byte[] data = new byte[16];
        ByteBuffer buf = ByteBuffer.wrap(data);
        mark.writeLogMark(buf);
        buf.flip();
        LogMark mark1 = new LogMark(9L, 13L);
        Assert.assertTrue((mark1.compare(mark) > 0 ? 1 : 0) != 0);
        mark1.readLogMark(buf);
        Assert.assertTrue((mark1.compare(mark) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testBasicOps() throws IOException {
        long ledgerId = 1L;
        long entryId = 1L;
        byte[] data = new byte[10];
        this.random.nextBytes(data);
        ByteBuffer buf = ByteBuffer.wrap(data);
        this.memTable.addEntry(ledgerId, entryId, buf, (CacheCallback)this);
        buf.rewind();
        EntryKeyValue kv = this.memTable.getEntry(ledgerId, entryId);
        Assert.assertTrue((kv.getLedgerId() == ledgerId ? 1 : 0) != 0);
        Assert.assertTrue((kv.getEntryId() == entryId ? 1 : 0) != 0);
        Assert.assertTrue((boolean)kv.getValueAsByteBuffer().nioBuffer().equals(buf));
        this.memTable.flush((SkipListFlusher)this);
    }

    public void onSizeLimitReached(CheckpointSource.Checkpoint cp) throws IOException {
    }

    public void process(long ledgerId, long entryId, ByteBuf entry) throws IOException {
    }

    @Test
    public void testScanAcrossSnapshot() throws IOException {
        byte[] data = new byte[10];
        ArrayList<EntryKeyValue> keyValues = new ArrayList<EntryKeyValue>();
        for (long entryId = 1L; entryId < 100L; ++entryId) {
            for (long ledgerId = 1L; ledgerId < 3L; ++ledgerId) {
                this.random.nextBytes(data);
                this.memTable.addEntry(ledgerId, entryId, ByteBuffer.wrap(data), (CacheCallback)this);
                keyValues.add(this.memTable.getEntry(ledgerId, entryId));
                if (this.random.nextInt(16) != 0) continue;
                this.memTable.snapshot();
            }
        }
        for (EntryKeyValue kv : keyValues) {
            Assert.assertTrue((boolean)this.memTable.getEntry(kv.getLedgerId(), kv.getEntryId()).equals((Object)kv));
        }
        this.memTable.flush((SkipListFlusher)this, CheckpointSource.Checkpoint.MAX);
    }

    @Test
    public void testFlushLogMark() throws IOException {
        Set<EntryKeyValue> flushedKVs = Collections.newSetFromMap(new ConcurrentHashMap());
        KVFLusher flusher = new KVFLusher(flushedKVs);
        this.curCheckpoint.setCheckPoint(2L, 2L);
        byte[] data = new byte[10];
        long ledgerId = 100L;
        for (long entryId = 1L; entryId < 100L; ++entryId) {
            this.random.nextBytes(data);
            this.memTable.addEntry(ledgerId, entryId, ByteBuffer.wrap(data), (CacheCallback)this);
        }
        Assert.assertNull((Object)this.memTable.snapshot((CheckpointSource.Checkpoint)new TestCheckPoint(1L, 1L)));
        Assert.assertNotNull((Object)this.memTable.snapshot((CheckpointSource.Checkpoint)new TestCheckPoint(3L, 3L)));
        Assert.assertTrue((0L < this.memTable.flush((SkipListFlusher)flusher) ? 1 : 0) != 0);
        Assert.assertTrue((0L == this.memTable.flush((SkipListFlusher)flusher) ? 1 : 0) != 0);
        this.curCheckpoint.setCheckPoint(4L, 4L);
        this.random.nextBytes(data);
        this.memTable.addEntry(ledgerId, 101L, ByteBuffer.wrap(data), (CacheCallback)this);
        Assert.assertTrue((0L == this.memTable.flush((SkipListFlusher)flusher) ? 1 : 0) != 0);
        Assert.assertTrue((0L == this.memTable.flush((SkipListFlusher)flusher, (CheckpointSource.Checkpoint)new TestCheckPoint(3L, 3L)) ? 1 : 0) != 0);
        Assert.assertTrue((0L < this.memTable.flush((SkipListFlusher)flusher, (CheckpointSource.Checkpoint)new TestCheckPoint(4L, 5L)) ? 1 : 0) != 0);
    }

    @Test
    public void testFlushSnapshot() throws IOException {
        HashSet<EntryKeyValue> keyValues = new HashSet<EntryKeyValue>();
        Set<EntryKeyValue> flushedKVs = Collections.newSetFromMap(new ConcurrentHashMap());
        KVFLusher flusher = new KVFLusher(flushedKVs);
        byte[] data = new byte[10];
        for (long entryId = 1L; entryId < 100L; ++entryId) {
            for (long ledgerId = 1L; ledgerId < 100L; ++ledgerId) {
                this.random.nextBytes(data);
                Assert.assertTrue((String)(ledgerId + ":" + entryId + " is duplicate in mem-table!"), (this.memTable.addEntry(ledgerId, entryId, ByteBuffer.wrap(data), (CacheCallback)this) != 0L ? 1 : 0) != 0);
                Assert.assertTrue((String)(ledgerId + ":" + entryId + " is duplicate in hash-set!"), (boolean)keyValues.add(this.memTable.getEntry(ledgerId, entryId)));
                if (this.random.nextInt(16) != 0 || null == this.memTable.snapshot() || this.random.nextInt(2) != 0) continue;
                this.memTable.flush((SkipListFlusher)flusher);
            }
        }
        this.memTable.flush((SkipListFlusher)flusher, CheckpointSource.Checkpoint.MAX);
        for (EntryKeyValue kv : keyValues) {
            Assert.assertTrue((String)("kv " + kv.toString() + " was not flushed!"), (boolean)flushedKVs.contains(kv));
        }
    }

    @Test
    public void testNoLedgerException() throws IOException {
        NoLedgerFLusher flusher = new NoLedgerFLusher();
        byte[] data = new byte[10];
        for (long entryId = 1L; entryId < 100L; ++entryId) {
            for (long ledgerId = 1L; ledgerId < 100L; ++ledgerId) {
                this.random.nextBytes(data);
                if (this.random.nextInt(16) != 0 || null == this.memTable.snapshot()) continue;
                this.memTable.flush((SkipListFlusher)flusher);
            }
        }
        this.memTable.flush((SkipListFlusher)flusher, CheckpointSource.Checkpoint.MAX);
    }

    @Test
    public void testGetListOfEntriesOfLedger() throws IOException {
        int i;
        Consumer<Long> addMethod;
        ArrayList listOfEntries;
        long ledgerId;
        Set<EntryKeyValue> flushedKVs = Collections.newSetFromMap(new ConcurrentHashMap());
        KVFLusher flusher = new KVFLusher(flushedKVs);
        int numofEntries = 100;
        int numOfLedgers = 5;
        byte[] data = new byte[10];
        for (long entryId = 1L; entryId <= (long)numofEntries; ++entryId) {
            for (long ledgerId2 = 1L; ledgerId2 <= (long)numOfLedgers; ++ledgerId2) {
                this.random.nextBytes(data);
                Assert.assertTrue((String)(ledgerId2 + ":" + entryId + " is duplicate in mem-table!"), (this.memTable.addEntry(ledgerId2, entryId, ByteBuffer.wrap(data), (CacheCallback)this) != 0L ? 1 : 0) != 0);
            }
        }
        for (ledgerId = 1L; ledgerId <= (long)numOfLedgers; ++ledgerId) {
            PrimitiveIterator.OfLong entriesItr = this.memTable.getListOfEntriesOfLedger((long)(this.random.nextInt((int)ledgerId) + 1));
            listOfEntries = new ArrayList();
            addMethod = listOfEntries::add;
            entriesItr.forEachRemaining((Consumer<? super Long>)addMethod);
            Assert.assertEquals((String)"Number of Entries", (long)numofEntries, (long)listOfEntries.size());
            for (i = 0; i < numofEntries; ++i) {
                Assert.assertEquals((String)"listOfEntries should be sorted", (Object)(i + 1), listOfEntries.get(i));
            }
        }
        Assert.assertTrue((String)"Snapshot is expected to be empty since snapshot is not done", (boolean)this.memTable.snapshot.isEmpty());
        Assert.assertTrue((String)"Take snapshot and returned checkpoint should not be empty", (this.memTable.snapshot() != null ? 1 : 0) != 0);
        Assert.assertFalse((String)"After taking snapshot, snapshot should not be empty ", (boolean)this.memTable.snapshot.isEmpty());
        for (ledgerId = 1L; ledgerId <= (long)numOfLedgers; ++ledgerId) {
            PrimitiveIterator.OfLong entriesItr = this.memTable.getListOfEntriesOfLedger((long)(this.random.nextInt((int)ledgerId) + 1));
            listOfEntries = new ArrayList();
            addMethod = listOfEntries::add;
            entriesItr.forEachRemaining((Consumer<? super Long>)addMethod);
            Assert.assertEquals((String)"Number of Entries should be the same even after taking snapshot", (long)numofEntries, (long)listOfEntries.size());
            for (i = 0; i < numofEntries; ++i) {
                Assert.assertEquals((String)"listOfEntries should be sorted", (Object)(i + 1), listOfEntries.get(i));
            }
        }
        this.memTable.flush((SkipListFlusher)flusher);
        for (ledgerId = 1L; ledgerId <= (long)numOfLedgers; ++ledgerId) {
            PrimitiveIterator.OfLong entriesItr = this.memTable.getListOfEntriesOfLedger((long)(this.random.nextInt((int)ledgerId) + 1));
            Assert.assertFalse((String)"After flushing there shouldn't be entries in memtable", (boolean)entriesItr.hasNext());
        }
    }

    @Test
    public void testGetListOfEntriesOfLedgerFromBothKVMapAndSnapshot() throws IOException {
        long ledgerId;
        long entryId;
        int numofEntries = 100;
        int newNumOfEntries = 200;
        int numOfLedgers = 5;
        byte[] data = new byte[10];
        for (entryId = 1L; entryId <= (long)numofEntries; ++entryId) {
            for (ledgerId = 1L; ledgerId <= (long)numOfLedgers; ++ledgerId) {
                this.random.nextBytes(data);
                Assert.assertTrue((String)(ledgerId + ":" + entryId + " is duplicate in mem-table!"), (this.memTable.addEntry(ledgerId, entryId, ByteBuffer.wrap(data), (CacheCallback)this) != 0L ? 1 : 0) != 0);
            }
        }
        Assert.assertTrue((String)"Snapshot is expected to be empty since snapshot is not done", (boolean)this.memTable.snapshot.isEmpty());
        Assert.assertTrue((String)"Take snapshot and returned checkpoint should not be empty", (this.memTable.snapshot() != null ? 1 : 0) != 0);
        Assert.assertFalse((String)"After taking snapshot, snapshot should not be empty ", (boolean)this.memTable.snapshot.isEmpty());
        for (entryId = (long)(numofEntries + 1); entryId <= (long)newNumOfEntries; ++entryId) {
            for (ledgerId = 1L; ledgerId <= (long)numOfLedgers; ++ledgerId) {
                this.random.nextBytes(data);
                Assert.assertTrue((String)(ledgerId + ":" + entryId + " is duplicate in mem-table!"), (this.memTable.addEntry(ledgerId, entryId, ByteBuffer.wrap(data), (CacheCallback)this) != 0L ? 1 : 0) != 0);
            }
        }
        for (long ledgerId2 = 1L; ledgerId2 <= (long)numOfLedgers; ++ledgerId2) {
            PrimitiveIterator.OfLong entriesItr = this.memTable.getListOfEntriesOfLedger((long)(this.random.nextInt((int)ledgerId2) + 1));
            ArrayList listOfEntries = new ArrayList();
            Consumer<Long> addMethod = listOfEntries::add;
            entriesItr.forEachRemaining((Consumer<? super Long>)addMethod);
            Assert.assertEquals((String)"Number of Entries should be the same", (long)newNumOfEntries, (long)listOfEntries.size());
            for (int i = 0; i < newNumOfEntries; ++i) {
                Assert.assertEquals((String)"listOfEntries should be sorted", (Object)(i + 1), listOfEntries.get(i));
            }
        }
    }

    @Test
    public void testGetListOfEntriesOfLedgerWhileAddingConcurrently() throws IOException, InterruptedException {
        long entryId;
        int numofEntries = 100;
        int newNumOfEntries = 200;
        int concurrentAddOfEntries = 300;
        final long ledgerId = 5L;
        final byte[] data = new byte[10];
        for (entryId = 1L; entryId <= 100L; ++entryId) {
            this.random.nextBytes(data);
            Assert.assertTrue((String)(ledgerId + ":" + entryId + " is duplicate in mem-table!"), (this.memTable.addEntry(ledgerId, entryId, ByteBuffer.wrap(data), (CacheCallback)this) != 0L ? 1 : 0) != 0);
        }
        Assert.assertTrue((String)"Snapshot is expected to be empty since snapshot is not done", (boolean)this.memTable.snapshot.isEmpty());
        Assert.assertTrue((String)"Take snapshot and returned checkpoint should not be empty", (this.memTable.snapshot() != null ? 1 : 0) != 0);
        Assert.assertFalse((String)"After taking snapshot, snapshot should not be empty ", (boolean)this.memTable.snapshot.isEmpty());
        for (entryId = 101L; entryId <= 200L; ++entryId) {
            this.random.nextBytes(data);
            Assert.assertTrue((String)(ledgerId + ":" + entryId + " is duplicate in mem-table!"), (this.memTable.addEntry(ledgerId, entryId, ByteBuffer.wrap(data), (CacheCallback)this) != 0L ? 1 : 0) != 0);
        }
        final AtomicBoolean successfullyAdded = new AtomicBoolean(true);
        Thread threadToAdd = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    for (long entryId = 201L; entryId <= 300L; ++entryId) {
                        TestEntryMemTable.this.random.nextBytes(data);
                        boolean thisEntryAddedSuccessfully = TestEntryMemTable.this.memTable.addEntry(ledgerId, entryId, ByteBuffer.wrap(data), (CacheCallback)TestEntryMemTable.this) != 0L;
                        successfullyAdded.set(successfullyAdded.get() && thisEntryAddedSuccessfully);
                        Thread.sleep(10L);
                    }
                }
                catch (IOException e) {
                    log.error("Got Unexpected exception while adding entries");
                    successfullyAdded.set(false);
                }
                catch (InterruptedException e) {
                    log.error("Got InterruptedException while waiting");
                    successfullyAdded.set(false);
                }
            }
        });
        threadToAdd.start();
        Thread.sleep(200L);
        PrimitiveIterator.OfLong entriesItr = this.memTable.getListOfEntriesOfLedger(ledgerId);
        ArrayList<Long> listOfEntries = new ArrayList<Long>();
        while (entriesItr.hasNext()) {
            listOfEntries.add(entriesItr.next());
            Thread.sleep(5L);
        }
        threadToAdd.join(5000L);
        Assert.assertTrue((String)"Entries should be added successfully in the spawned thread", (boolean)successfullyAdded.get());
        for (int i = 0; i < 200; ++i) {
            Assert.assertEquals((String)"listOfEntries should be sorted", (Object)(i + 1), listOfEntries.get(i));
        }
    }

    private static class TestCheckPoint
    implements CheckpointSource.Checkpoint {
        LogMark mark;

        public TestCheckPoint(long fid, long fpos) {
            this.mark = new LogMark(fid, fpos);
        }

        private void setCheckPoint(long fid, long fpos) {
            this.mark.setLogMark(fid, fpos);
        }

        public int compareTo(CheckpointSource.Checkpoint o) {
            if (CheckpointSource.Checkpoint.MAX == o) {
                return -1;
            }
            return this.mark.compare(((TestCheckPoint)o).mark);
        }
    }

    private class NoLedgerFLusher
    implements SkipListFlusher {
        private NoLedgerFLusher() {
        }

        public void process(long ledgerId, long entryId, ByteBuf entry) throws IOException {
            throw new Bookie.NoLedgerException(ledgerId);
        }
    }

    private class KVFLusher
    implements SkipListFlusher {
        final Set<EntryKeyValue> keyValues;

        KVFLusher(Set<EntryKeyValue> keyValues) {
            this.keyValues = keyValues;
        }

        public void process(long ledgerId, long entryId, ByteBuf entry) throws IOException {
            Assert.assertTrue((String)(ledgerId + ":" + entryId + " is duplicate in store!"), (boolean)this.keyValues.add(new EntryKeyValue(ledgerId, entryId, entry.array())));
        }
    }
}

