/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.storage.ldb;

import java.io.File;
import java.io.IOException;
import org.apache.bookkeeper.bookie.storage.ldb.EntryLocationIndex;
import org.apache.bookkeeper.bookie.storage.ldb.KeyValueStorageRocksDB;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.junit.Assert;
import org.junit.Test;

public class EntryLocationIndexTest {
    private final ServerConfiguration serverConfiguration = new ServerConfiguration();

    @Test
    public void deleteLedgerTest() throws Exception {
        File tmpDir = File.createTempFile("bkTest", ".dir");
        tmpDir.delete();
        tmpDir.mkdir();
        tmpDir.deleteOnExit();
        EntryLocationIndex idx = new EntryLocationIndex(this.serverConfiguration, KeyValueStorageRocksDB.factory, tmpDir.getAbsolutePath(), (StatsLogger)NullStatsLogger.INSTANCE);
        idx.addLocation(40312L, 0L, 1L);
        idx.addLocation(40313L, 10L, 2L);
        idx.addLocation(40320L, 0L, 3L);
        idx.addLocation(40313L, 11L, 5L);
        idx.addLocation(40313L, 12L, 6L);
        idx.addLocation(40320L, 1L, 7L);
        idx.addLocation(40312L, 3L, 4L);
        idx.delete(40313L);
        Assert.assertEquals((long)1L, (long)idx.getLocation(40312L, 0L));
        Assert.assertEquals((long)4L, (long)idx.getLocation(40312L, 3L));
        Assert.assertEquals((long)3L, (long)idx.getLocation(40320L, 0L));
        Assert.assertEquals((long)7L, (long)idx.getLocation(40320L, 1L));
        Assert.assertEquals((long)2L, (long)idx.getLocation(40313L, 10L));
        Assert.assertEquals((long)5L, (long)idx.getLocation(40313L, 11L));
        Assert.assertEquals((long)6L, (long)idx.getLocation(40313L, 12L));
        idx.removeOffsetFromDeletedLedgers();
        Assert.assertEquals((long)0L, (long)idx.getLocation(40313L, 10L));
        Assert.assertEquals((long)0L, (long)idx.getLocation(40313L, 11L));
        Assert.assertEquals((long)0L, (long)idx.getLocation(40313L, 12L));
        idx.close();
    }

    @Test
    public void addLedgerAfterDeleteTest() throws Exception {
        File tmpDir = File.createTempFile("bkTest", ".dir");
        tmpDir.delete();
        tmpDir.mkdir();
        tmpDir.deleteOnExit();
        EntryLocationIndex idx = new EntryLocationIndex(this.serverConfiguration, KeyValueStorageRocksDB.factory, tmpDir.getAbsolutePath(), (StatsLogger)NullStatsLogger.INSTANCE);
        idx.addLocation(40312L, 0L, 1L);
        idx.addLocation(40313L, 10L, 2L);
        idx.addLocation(40320L, 0L, 3L);
        idx.delete(40313L);
        idx.addLocation(40313L, 11L, 5L);
        idx.addLocation(40313L, 12L, 6L);
        idx.addLocation(40320L, 1L, 7L);
        idx.addLocation(40312L, 3L, 4L);
        idx.removeOffsetFromDeletedLedgers();
        Assert.assertEquals((long)0L, (long)idx.getLocation(40313L, 11L));
        Assert.assertEquals((long)0L, (long)idx.getLocation(40313L, 12L));
        idx.close();
    }

    @Test
    public void testDeleteSpecialEntry() throws IOException {
        File tmpDir = File.createTempFile("bkTest", ".dir");
        tmpDir.delete();
        tmpDir.mkdir();
        tmpDir.deleteOnExit();
        EntryLocationIndex idx = new EntryLocationIndex(this.serverConfiguration, KeyValueStorageRocksDB.factory, tmpDir.getAbsolutePath(), (StatsLogger)NullStatsLogger.INSTANCE);
        idx.addLocation(40312L, -1L, 1L);
        idx.addLocation(40313L, 10L, 2L);
        idx.addLocation(40320L, 0L, 3L);
        idx.addLocation(40313L, 11L, 5L);
        idx.addLocation(40313L, 12L, 6L);
        idx.addLocation(40320L, 1L, 7L);
        idx.delete(40312L);
        idx.removeOffsetFromDeletedLedgers();
        idx.delete(40313L);
        idx.removeOffsetFromDeletedLedgers();
        Assert.assertEquals((long)0L, (long)idx.getLocation(40312L, 10L));
    }
}

