/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.DefaultEnsemblePlacementPolicy;
import org.apache.bookkeeper.client.EnsemblePlacementPolicy;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class GenericEnsemblePlacementPolicyTest
extends BookKeeperClusterTestCase {
    private BookKeeper.DigestType digestType = BookKeeper.DigestType.CRC32;
    private static final String PASSWORD = "testPasswd";
    private static final String property = "foo";
    private static final byte[] value = "bar".getBytes(StandardCharsets.UTF_8);
    private static List<Map<String, byte[]>> customMetadataOnNewEnsembleStack = new ArrayList<Map<String, byte[]>>();
    private static List<Map<String, byte[]>> customMetadataOnReplaceBookieStack = new ArrayList<Map<String, byte[]>>();

    @Parameterized.Parameters
    public static Collection<Object[]> getDiskWeightBasedPlacementEnabled() {
        return Arrays.asList({false}, {true});
    }

    public GenericEnsemblePlacementPolicyTest(boolean diskWeightBasedPlacementEnabled) {
        super(0);
        this.baseClientConf.setEnsemblePlacementPolicy(CustomEnsemblePlacementPolicy.class);
        this.baseClientConf.setDiskWeightBasedPlacementEnabled(diskWeightBasedPlacementEnabled);
    }

    @Before
    public void reset() {
        customMetadataOnNewEnsembleStack.clear();
        customMetadataOnReplaceBookieStack.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNewEnsemble() throws Exception {
        this.numBookies = 1;
        this.startBKCluster(this.zkUtil.getMetadataServiceUri());
        try {
            HashMap<String, byte[]> customMetadata = new HashMap<String, byte[]>();
            customMetadata.put(property, value);
            try (BookKeeper bk = new BookKeeper(this.baseClientConf, this.zkc);){
                bk.createLedger(1, 1, 1, this.digestType, PASSWORD.getBytes(), customMetadata);
            }
            Assert.assertEquals((long)1L, (long)customMetadataOnNewEnsembleStack.size());
            Assert.assertArrayEquals((byte[])value, (byte[])customMetadataOnNewEnsembleStack.get(0).get(property));
        }
        finally {
            this.stopBKCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNewEnsembleWithNotEnoughtBookies() throws Exception {
        this.numBookies = 0;
        try {
            this.startBKCluster(this.zkUtil.getMetadataServiceUri());
            HashMap<String, byte[]> customMetadata = new HashMap<String, byte[]>();
            customMetadata.put(property, value);
            try (BookKeeper bk = new BookKeeper(this.baseClientConf, this.zkc);){
                bk.createLedger(1, 1, 1, this.digestType, PASSWORD.getBytes(), customMetadata);
                Assert.fail((String)"creation should fail");
            }
            catch (BKException.BKNotEnoughBookiesException bKNotEnoughBookiesException) {
                // empty catch block
            }
            Assert.assertEquals((long)2L, (long)customMetadataOnNewEnsembleStack.size());
            Assert.assertArrayEquals((byte[])value, (byte[])customMetadataOnNewEnsembleStack.get(0).get(property));
            Assert.assertArrayEquals((byte[])value, (byte[])customMetadataOnNewEnsembleStack.get(1).get(property));
        }
        finally {
            this.stopBKCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReplaceBookie() throws Exception {
        this.numBookies = 3;
        this.startBKCluster(this.zkUtil.getMetadataServiceUri());
        try {
            HashMap<String, byte[]> customMetadata = new HashMap<String, byte[]>();
            customMetadata.put(property, value);
            try (BookKeeper bk = new BookKeeper(this.baseClientConf, this.zkc);
                 LedgerHandle lh = bk.createLedger(2, 2, 2, this.digestType, PASSWORD.getBytes(), customMetadata);){
                lh.addEntry(value);
                long lId = lh.getId();
                List ensembleAtFirstEntry = lh.getLedgerMetadata().getEnsembleAt(lId);
                Assert.assertEquals((long)2L, (long)ensembleAtFirstEntry.size());
                this.killBookie((BookieSocketAddress)ensembleAtFirstEntry.get(0));
                lh.addEntry(value);
            }
            Assert.assertEquals((long)2L, (long)customMetadataOnNewEnsembleStack.size());
            Assert.assertArrayEquals((byte[])value, (byte[])customMetadataOnNewEnsembleStack.get(0).get(property));
            Assert.assertArrayEquals((byte[])value, (byte[])customMetadataOnNewEnsembleStack.get(0).get(property));
            Assert.assertEquals((long)1L, (long)customMetadataOnReplaceBookieStack.size());
            Assert.assertArrayEquals((byte[])value, (byte[])customMetadataOnReplaceBookieStack.get(0).get(property));
        }
        finally {
            this.stopBKCluster();
        }
    }

    public static final class CustomEnsemblePlacementPolicy
    extends DefaultEnsemblePlacementPolicy {
        public EnsemblePlacementPolicy.PlacementResult<BookieSocketAddress> replaceBookie(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Map<String, byte[]> customMetadata, List<BookieSocketAddress> currentEnsemble, BookieSocketAddress bookieToReplace, Set<BookieSocketAddress> excludeBookies) throws BKException.BKNotEnoughBookiesException {
            new Exception("replaceBookie " + ensembleSize + "," + customMetadata).printStackTrace();
            Assert.assertNotNull(customMetadata);
            customMetadataOnReplaceBookieStack.add(customMetadata);
            return super.replaceBookie(ensembleSize, writeQuorumSize, ackQuorumSize, customMetadata, currentEnsemble, bookieToReplace, excludeBookies);
        }

        public EnsemblePlacementPolicy.PlacementResult<List<BookieSocketAddress>> newEnsemble(int ensembleSize, int quorumSize, int ackQuorumSize, Map<String, byte[]> customMetadata, Set<BookieSocketAddress> excludeBookies) throws BKException.BKNotEnoughBookiesException {
            Assert.assertNotNull(customMetadata);
            customMetadataOnNewEnsembleStack.add(customMetadata);
            return super.newEnsemble(ensembleSize, quorumSize, ackQuorumSize, customMetadata, excludeBookies);
        }
    }
}

