/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import com.google.common.base.Charsets;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.BookKeeperTestClient;
import org.apache.bookkeeper.client.LedgerChecker;
import org.apache.bookkeeper.client.LedgerFragment;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.bookkeeper.test.TestCallbacks;
import org.apache.commons.configuration.Configuration;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LedgerCloseTest
extends BookKeeperClusterTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(LedgerCloseTest.class);
    static final int READ_TIMEOUT = 1;
    final BookKeeper.DigestType digestType = BookKeeper.DigestType.CRC32;

    public LedgerCloseTest() {
        super(6);
        this.baseClientConf.setReadTimeout(99999);
        this.baseConf.setGcWaitTime(999999L);
    }

    @Test
    public void testLedgerCloseWithConsistentLength() throws Exception {
        ClientConfiguration conf = new ClientConfiguration();
        conf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        conf.setReadTimeout(1);
        BookKeeper bkc = new BookKeeper(conf);
        LedgerHandle lh = bkc.createLedger(6, 3, BookKeeper.DigestType.CRC32, new byte[0]);
        final CountDownLatch latch = new CountDownLatch(1);
        this.stopBKCluster();
        final AtomicInteger i = new AtomicInteger(-559038737);
        AsyncCallback.AddCallback cb = new AsyncCallback.AddCallback(){

            public void addComplete(int rc, LedgerHandle lh, long entryId, Object ctx) {
                i.set(rc);
                latch.countDown();
            }
        };
        lh.asyncAddEntry("Test Entry".getBytes(), cb, null);
        latch.await();
        Assert.assertEquals((long)i.get(), (long)-6L);
        Assert.assertEquals((long)0L, (long)lh.getLength());
        Assert.assertEquals((long)-1L, (long)lh.getLastAddConfirmed());
        this.startBKCluster(this.zkUtil.getMetadataServiceUri());
        LedgerHandle newLh = bkc.openLedger(lh.getId(), BookKeeper.DigestType.CRC32, new byte[0]);
        Assert.assertEquals((long)0L, (long)newLh.getLength());
        Assert.assertEquals((long)-1L, (long)newLh.getLastAddConfirmed());
    }

    @Test
    public void testLedgerCloseDuringUnrecoverableErrors() throws Exception {
        int numEntries = 3;
        LedgerHandle lh = this.bkc.createLedger(3, 3, 3, this.digestType, "".getBytes());
        this.verifyMetadataConsistency(numEntries, lh);
    }

    @Test
    public void testLedgerCheckerShouldnotSelectInvalidLastFragments() throws Exception {
        int numEntries = 10;
        LedgerHandle lh = this.bkc.createLedger(3, 3, 3, this.digestType, "".getBytes());
        for (int i = 0; i < numEntries; ++i) {
            lh.addEntry("data".getBytes());
        }
        numEntries = 4;
        this.verifyMetadataConsistency(numEntries, lh);
        LedgerChecker checker = new LedgerChecker((BookKeeper)this.bkc);
        CheckerCallback cb = new CheckerCallback();
        checker.checkLedger(lh, (BookkeeperInternalCallbacks.GenericCallback)cb);
        Set<LedgerFragment> result = cb.waitAndGetResult();
        Assert.assertEquals((String)"No fragments should be selected", (long)0L, (long)result.size());
    }

    private void verifyMetadataConsistency(int numEntries, LedgerHandle lh) throws Exception {
        CountDownLatch addDoneLatch = new CountDownLatch(1);
        final CountDownLatch deadIOLatch = new CountDownLatch(1);
        final CountDownLatch recoverDoneLatch = new CountDownLatch(1);
        final CountDownLatch failedLatch = new CountDownLatch(1);
        BookieSocketAddress bookie = (BookieSocketAddress)lh.getCurrentEnsemble().get(0);
        ServerConfiguration conf = this.killBookie(bookie);
        this.startUnauthorizedBookie(conf, addDoneLatch);
        bookie = (BookieSocketAddress)lh.getCurrentEnsemble().get(1);
        conf = this.killBookie(bookie);
        this.startDeadBookie(conf, deadIOLatch);
        for (int i = 0; i < numEntries; ++i) {
            lh.asyncAddEntry("data".getBytes(), new AsyncCallback.AddCallback(){

                public void addComplete(int rc, LedgerHandle lh, long entryId, Object ctx) {
                    if (0 != rc) {
                        failedLatch.countDown();
                        deadIOLatch.countDown();
                    }
                    if (0L == entryId) {
                        try {
                            recoverDoneLatch.await();
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
            }, null);
        }
        addDoneLatch.countDown();
        failedLatch.await();
        LOG.info("Recover ledger {}.", (Object)lh.getId());
        ClientConfiguration newConf = new ClientConfiguration();
        newConf.addConfiguration((Configuration)this.baseClientConf);
        BookKeeperTestClient newBkc = new BookKeeperTestClient(newConf.setReadTimeout(1));
        LedgerHandle recoveredLh = newBkc.openLedger(lh.getId(), this.digestType, "".getBytes());
        LOG.info("Recover ledger {} done.", (Object)lh.getId());
        recoverDoneLatch.countDown();
        TimeUnit.SECONDS.sleep(5L);
        LedgerHandle newLh = newBkc.openLedger(lh.getId(), this.digestType, "".getBytes());
        Assert.assertEquals((String)"Metadata should be consistent across different opened ledgers", (long)recoveredLh.getLastAddConfirmed(), (long)newLh.getLastAddConfirmed());
    }

    private void startUnauthorizedBookie(ServerConfiguration conf, final CountDownLatch latch) throws Exception {
        Bookie sBookie = new Bookie(conf){

            public void addEntry(ByteBuf entry, boolean ackBeforeSync, BookkeeperInternalCallbacks.WriteCallback cb, Object ctx, byte[] masterKey) throws IOException, BookieException {
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                throw BookieException.create((int)-1);
            }

            public void recoveryAddEntry(ByteBuf entry, BookkeeperInternalCallbacks.WriteCallback cb, Object ctx, byte[] masterKey) throws IOException, BookieException {
                throw new IOException("Dead bookie for recovery adds.");
            }
        };
        this.bsConfs.add(conf);
        this.bs.add(this.startBookie(conf, sBookie));
    }

    private void startDeadBookie(ServerConfiguration conf, final CountDownLatch latch) throws Exception {
        Bookie dBookie = new Bookie(conf){

            public void addEntry(ByteBuf entry, boolean ackBeforeSync, BookkeeperInternalCallbacks.WriteCallback cb, Object ctx, byte[] masterKey) throws IOException, BookieException {
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                throw new IOException("Dead bookie");
            }
        };
        this.bsConfs.add(conf);
        this.bs.add(this.startBookie(conf, dBookie));
    }

    @Test
    public void testAllWritesAreCompletedOnClosedLedger() throws Exception {
        for (int i = 0; i < 100; ++i) {
            LOG.info("Iteration {}", (Object)i);
            ArrayList<TestCallbacks.AddCallbackFuture> futures = new ArrayList<TestCallbacks.AddCallbackFuture>();
            LedgerHandle w = this.bkc.createLedger(BookKeeper.DigestType.CRC32, new byte[0]);
            TestCallbacks.AddCallbackFuture f = new TestCallbacks.AddCallbackFuture(0L);
            w.asyncAddEntry("foobar".getBytes(Charsets.UTF_8), (AsyncCallback.AddCallback)f, null);
            f.get();
            LedgerHandle r = this.bkc.openLedger(w.getId(), BookKeeper.DigestType.CRC32, new byte[0]);
            for (int j = 0; j < 100; ++j) {
                TestCallbacks.AddCallbackFuture f1 = new TestCallbacks.AddCallbackFuture(1L + (long)j);
                w.asyncAddEntry("foobar".getBytes(), (AsyncCallback.AddCallback)f1, null);
                futures.add(f1);
            }
            for (TestCallbacks.AddCallbackFuture f2 : futures) {
                try {
                    f2.get(10L, TimeUnit.SECONDS);
                }
                catch (ExecutionException executionException) {
                }
                catch (TimeoutException te) {
                    LOG.error("Error on waiting completing entry {} : ", (Object)f2.getExpectedEntryId(), (Object)te);
                    Assert.fail((String)("Should succeed on waiting completing entry " + f2.getExpectedEntryId()));
                }
            }
        }
    }

    class CheckerCallback
    implements BookkeeperInternalCallbacks.GenericCallback<Set<LedgerFragment>> {
        private Set<LedgerFragment> result = null;
        private CountDownLatch latch = new CountDownLatch(1);

        CheckerCallback() {
        }

        public void operationComplete(int rc, Set<LedgerFragment> result) {
            this.result = result;
            this.latch.countDown();
        }

        Set<LedgerFragment> waitAndGetResult() throws InterruptedException {
            this.latch.await();
            return this.result;
        }
    }
}

