/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Enumeration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.ClientContext;
import org.apache.bookkeeper.client.ClientInternalConf;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.LedgerRecoveryOp;
import org.apache.bookkeeper.client.MockClientContext;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LedgerRecoveryTest
extends BookKeeperClusterTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(LedgerRecoveryTest.class);
    private final BookKeeper.DigestType digestType = BookKeeper.DigestType.CRC32;

    public LedgerRecoveryTest() {
        super(3);
        this.baseConf.setAllowEphemeralPorts(false);
    }

    private void testInternal(int numEntries) throws Exception {
        LedgerHandle beforelh = null;
        beforelh = this.bkc.createLedger(this.digestType, "".getBytes());
        String tmp = "BookKeeper is cool!";
        for (int i = 0; i < numEntries; ++i) {
            beforelh.addEntry(tmp.getBytes());
        }
        long length = numEntries * tmp.length();
        LedgerHandle afterlh = this.bkc.openLedger(beforelh.getId(), this.digestType, "".getBytes());
        Assert.assertEquals((String)"Has not recovered correctly", (long)(numEntries - 1), (long)afterlh.getLastAddConfirmed());
        Assert.assertEquals((String)"Has not set the length correctly", (long)length, (long)afterlh.getLength());
    }

    @Test
    public void testLedgerRecovery() throws Exception {
        this.testInternal(100);
    }

    @Test
    public void testEmptyLedgerRecoveryOne() throws Exception {
        this.testInternal(1);
    }

    @Test
    public void testEmptyLedgerRecovery() throws Exception {
        this.testInternal(0);
    }

    @Test
    public void testLedgerRecoveryWithWrongPassword() throws Exception {
        byte[] ledgerPassword = "aaaa".getBytes();
        LedgerHandle lh = this.bkc.createLedger(this.digestType, ledgerPassword);
        long ledgerId = lh.getId();
        LOG.info("Ledger ID: " + lh.getId());
        String tmp = "BookKeeper is cool!";
        int numEntries = 30;
        for (int i = 0; i < numEntries; ++i) {
            lh.addEntry(tmp.getBytes());
        }
        ledgerPassword = "bbbb".getBytes();
        try {
            lh = this.bkc.openLedger(ledgerId, this.digestType, ledgerPassword);
            Assert.fail((String)"Opening ledger with wrong password should fail");
        }
        catch (BKException bKException) {
            // empty catch block
        }
    }

    @Test
    public void testLedgerRecoveryWithNotEnoughBookies() throws Exception {
        int numEntries = 3;
        LedgerHandle beforelh = null;
        beforelh = this.bkc.createLedger(3, 3, this.digestType, "".getBytes());
        String tmp = "BookKeeper is cool!";
        for (int i = 0; i < numEntries; ++i) {
            beforelh.addEntry(tmp.getBytes());
        }
        ((BookieServer)this.bs.get(0)).shutdown();
        this.bs.remove(0);
        try {
            this.bkc.openLedger(beforelh.getId(), this.digestType, "".getBytes());
            Assert.fail((String)"should not reach here!");
        }
        catch (Exception i) {
            // empty catch block
        }
        this.startNewBookie();
        LedgerHandle afterlh = this.bkc.openLedger(beforelh.getId(), this.digestType, "".getBytes());
        Assert.assertEquals((long)(numEntries - 1), (long)afterlh.getLastAddConfirmed());
    }

    @Test
    public void testLedgerRecoveryWithSlowBookie() throws Exception {
        for (int i = 0; i < 3; ++i) {
            LOG.info("TestLedgerRecoveryWithAckQuorum @ slow bookie {}", (Object)i);
            this.ledgerRecoveryWithSlowBookie(3, 3, 2, 1, i);
        }
    }

    private void ledgerRecoveryWithSlowBookie(int ensembleSize, int writeQuorumSize, int ackQuorumSize, int numEntries, int slowBookieIdx) throws Exception {
        LedgerHandle beforelh = null;
        beforelh = this.bkc.createLedger(ensembleSize, writeQuorumSize, ackQuorumSize, this.digestType, "".getBytes());
        BookieSocketAddress host = (BookieSocketAddress)beforelh.getCurrentEnsemble().get(slowBookieIdx);
        ServerConfiguration conf = this.killBookie(host);
        Bookie fakeBookie = new Bookie(conf){

            public void addEntry(ByteBuf entry, boolean ackBeforeSync, BookkeeperInternalCallbacks.WriteCallback cb, Object ctx, byte[] masterKey) throws IOException, BookieException {
            }
        };
        this.bsConfs.add(conf);
        this.bs.add(this.startBookie(conf, fakeBookie));
        this.startNewBookie();
        String tmp = "BookKeeper is cool!";
        for (int i = 0; i < numEntries; ++i) {
            beforelh.addEntry(tmp.getBytes());
        }
        conf = this.killBookie(host);
        this.bsConfs.add(conf);
        this.bs.add(this.startBookie(conf));
        LedgerHandle afterlh = this.bkc.openLedger(beforelh.getId(), this.digestType, "".getBytes());
        Assert.assertEquals((long)(numEntries - 1), (long)afterlh.getLastAddConfirmed());
    }

    @Test
    public void testLedgerRecoveryWithRollingRestart() throws Exception {
        LedgerHandle lhbefore = this.bkc.createLedger(this.numBookies, 2, this.digestType, "".getBytes());
        for (int i = 0; i < this.numBookies * 3 + 1; ++i) {
            lhbefore.addEntry("data".getBytes());
        }
        ServerConfiguration conf = this.newServerConfiguration();
        Bookie deadBookie1 = new Bookie(conf){

            public void recoveryAddEntry(ByteBuf entry, BookkeeperInternalCallbacks.WriteCallback cb, Object ctx, byte[] masterKey) throws IOException, BookieException {
                throw new IOException("Couldn't write for some reason");
            }
        };
        this.bsConfs.add(conf);
        this.bs.add(this.startBookie(conf, deadBookie1));
        BookieSocketAddress bookie1 = (BookieSocketAddress)lhbefore.getCurrentEnsemble().get(0);
        ServerConfiguration conf1 = this.killBookie(bookie1);
        try {
            this.bkc.openLedger(lhbefore.getId(), this.digestType, "".getBytes());
            Assert.fail((String)"Shouldn't be able to open ledger, there should be entries missing");
        }
        catch (BKException.BKLedgerRecoveryException bKLedgerRecoveryException) {
            // empty catch block
        }
        this.bsConfs.add(conf1);
        this.bs.add(this.startBookie(conf1));
        BookieSocketAddress bookie2 = (BookieSocketAddress)lhbefore.getCurrentEnsemble().get(1);
        ServerConfiguration conf2 = this.killBookie(bookie2);
        final AtomicInteger returnCode = new AtomicInteger(0);
        final CountDownLatch openLatch = new CountDownLatch(1);
        this.bkc.asyncOpenLedger(lhbefore.getId(), this.digestType, "".getBytes(), new AsyncCallback.OpenCallback(){

            public void openComplete(int rc, LedgerHandle lh, Object ctx) {
                returnCode.set(rc);
                openLatch.countDown();
                if (rc == 0) {
                    try {
                        lh.close();
                    }
                    catch (Exception e) {
                        LOG.error("Exception closing ledger handle", (Throwable)e);
                    }
                }
            }
        }, null);
        Assert.assertTrue((String)"Open call should have completed", (boolean)openLatch.await(5L, TimeUnit.SECONDS));
        Assert.assertFalse((String)"Open should not have succeeded", (returnCode.get() == 0 ? 1 : 0) != 0);
        this.bsConfs.add(conf2);
        this.bs.add(this.startBookie(conf2));
        LedgerHandle lhafter = this.bkc.openLedger(lhbefore.getId(), this.digestType, "".getBytes());
        Assert.assertEquals((String)"Fenced ledger should have correct lastAddConfirmed", (long)lhbefore.getLastAddConfirmed(), (long)lhafter.getLastAddConfirmed());
    }

    @Test
    public void testBookieFailureDuringRecovery() throws Exception {
        LedgerHandle lhbefore = this.bkc.createLedger(this.numBookies, 2, this.digestType, "".getBytes());
        for (int i = 0; i < this.numBookies * 3 + 1; ++i) {
            lhbefore.addEntry("data".getBytes());
        }
        ServerConfiguration conf = this.newServerConfiguration();
        Bookie deadBookie1 = new Bookie(conf){

            public void recoveryAddEntry(ByteBuf entry, BookkeeperInternalCallbacks.WriteCallback cb, Object ctx, byte[] masterKey) throws IOException, BookieException {
                throw new IOException("Couldn't write for some reason");
            }
        };
        this.bsConfs.add(conf);
        this.bs.add(this.startBookie(conf, deadBookie1));
        BookieSocketAddress bookie1 = (BookieSocketAddress)lhbefore.getCurrentEnsemble().get(0);
        this.killBookie(bookie1);
        try {
            this.bkc.openLedger(lhbefore.getId(), this.digestType, "".getBytes());
            Assert.fail((String)"Shouldn't be able to open ledger, there should be entries missing");
        }
        catch (BKException.BKLedgerRecoveryException bKLedgerRecoveryException) {
            // empty catch block
        }
        this.startNewBookie();
        LedgerHandle lhafter = this.bkc.openLedger(lhbefore.getId(), this.digestType, "".getBytes());
        Assert.assertEquals((String)"Fenced ledger should have correct lastAddConfirmed", (long)lhbefore.getLastAddConfirmed(), (long)lhafter.getLastAddConfirmed());
    }

    @Test
    public void testEnsembleChangeDuringRecovery() throws Exception {
        LedgerHandle lh = this.bkc.createLedger(this.numBookies, 2, 2, this.digestType, "".getBytes());
        int numEntries = this.numBookies * 3 + 1;
        final AtomicInteger numPendingAdds = new AtomicInteger(numEntries);
        final CountDownLatch addDone = new CountDownLatch(1);
        for (int i = 0; i < numEntries; ++i) {
            lh.asyncAddEntry("data".getBytes(), new AsyncCallback.AddCallback(){

                public void addComplete(int rc, LedgerHandle lh, long entryId, Object ctx) {
                    if (0 != rc) {
                        addDone.countDown();
                        return;
                    }
                    if (numPendingAdds.decrementAndGet() == 0) {
                        addDone.countDown();
                    }
                }
            }, null);
        }
        addDone.await(10L, TimeUnit.SECONDS);
        if (numPendingAdds.get() > 0) {
            Assert.fail((String)("Failed to add " + numEntries + " to ledger handle " + lh.getId()));
        }
        BookieSocketAddress bookie1 = (BookieSocketAddress)lh.getCurrentEnsemble().get(0);
        ServerConfiguration conf1 = this.killBookie(bookie1);
        BookieSocketAddress bookie2 = (BookieSocketAddress)lh.getCurrentEnsemble().get(1);
        ServerConfiguration conf2 = this.killBookie(bookie2);
        this.startDeadBookie(conf1);
        this.startDeadBookie(conf2);
        this.startNewBookie();
        this.startNewBookie();
        LedgerHandle recoveredLh = this.bkc.openLedger(lh.getId(), this.digestType, "".getBytes());
        Assert.assertEquals((String)"Fenced ledger should have correct lastAddConfirmed", (long)lh.getLastAddConfirmed(), (long)recoveredLh.getLastAddConfirmed());
    }

    private void startDeadBookie(ServerConfiguration conf) throws Exception {
        Bookie rBookie = new Bookie(conf){

            public void recoveryAddEntry(ByteBuf entry, BookkeeperInternalCallbacks.WriteCallback cb, Object ctx, byte[] masterKey) throws IOException, BookieException {
                throw new IOException("Couldn't write entries for some reason");
            }
        };
        this.bsConfs.add(conf);
        this.bs.add(this.startBookie(conf, rBookie));
    }

    @Test
    public void testBatchRecoverySize3() throws Exception {
        this.batchRecovery(3);
    }

    @Test
    public void testBatchRecoverySize13() throws Exception {
        this.batchRecovery(13);
    }

    private void batchRecovery(int batchSize) throws Exception {
        ClientConfiguration newConf = new ClientConfiguration().setReadEntryTimeout(60000).setAddEntryTimeout(60000).setEnableParallelRecoveryRead(false).setRecoveryReadBatchSize(batchSize);
        newConf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        BookKeeper newBk = new BookKeeper(newConf);
        LedgerHandle lh = newBk.createLedger(this.numBookies, 2, 2, this.digestType, "".getBytes());
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(1);
        this.sleepBookie((BookieSocketAddress)lh.getCurrentEnsemble().get(0), latch1);
        this.sleepBookie((BookieSocketAddress)lh.getCurrentEnsemble().get(1), latch2);
        int numEntries = this.numBookies * 3 + 1;
        final AtomicInteger numPendingAdds = new AtomicInteger(numEntries);
        final CountDownLatch addDone = new CountDownLatch(1);
        for (int i = 0; i < numEntries; ++i) {
            lh.asyncAddEntry(("" + i).getBytes(), new AsyncCallback.AddCallback(){

                public void addComplete(int rc, LedgerHandle lh, long entryId, Object ctx) {
                    if (0 != rc) {
                        addDone.countDown();
                        return;
                    }
                    if (numPendingAdds.decrementAndGet() == 0) {
                        addDone.countDown();
                    }
                }
            }, null);
        }
        latch1.countDown();
        latch2.countDown();
        addDone.await(10L, TimeUnit.SECONDS);
        Assert.assertEquals((long)0L, (long)numPendingAdds.get());
        LedgerHandle recoverLh = newBk.openLedgerNoRecovery(lh.getId(), this.digestType, "".getBytes());
        Assert.assertEquals((long)-1L, (long)recoverLh.getLastAddConfirmed());
        MockClientContext parallelReadCtx = MockClientContext.copyOf(this.bkc.getClientCtx()).setConf(ClientInternalConf.fromConfig((ClientConfiguration)newConf.setEnableParallelRecoveryRead(true)));
        LedgerRecoveryOp recoveryOp = new LedgerRecoveryOp(recoverLh, (ClientContext)parallelReadCtx);
        CompletableFuture f = recoveryOp.initiate();
        f.get(10L, TimeUnit.SECONDS);
        Assert.assertEquals((long)numEntries, (long)recoveryOp.readCount.get());
        Assert.assertEquals((long)numEntries, (long)recoveryOp.writeCount.get());
        Enumeration enumeration = recoverLh.readEntries(0L, (long)(numEntries - 1));
        int numReads = 0;
        while (enumeration.hasMoreElements()) {
            LedgerEntry entry = (LedgerEntry)enumeration.nextElement();
            Assert.assertEquals((long)numReads, (long)entry.getEntryId());
            Assert.assertEquals((long)numReads, (long)Integer.parseInt(new String(entry.getEntry())));
            ++numReads;
        }
        Assert.assertEquals((long)numEntries, (long)numReads);
        newBk.close();
    }
}

