/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.util.function.BooleanSupplier;
import org.apache.bookkeeper.client.BookKeeperClientStats;
import org.apache.bookkeeper.client.BookieWatcher;
import org.apache.bookkeeper.client.BookieWatcherImpl;
import org.apache.bookkeeper.client.ClientContext;
import org.apache.bookkeeper.client.ClientInternalConf;
import org.apache.bookkeeper.client.DefaultEnsemblePlacementPolicy;
import org.apache.bookkeeper.client.EnsemblePlacementPolicy;
import org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.discover.MockRegistrationClient;
import org.apache.bookkeeper.discover.RegistrationClient;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.MockLedgerManager;
import org.apache.bookkeeper.proto.BookieClient;
import org.apache.bookkeeper.proto.MockBookieClient;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.mockito.Mockito;

public class MockClientContext
implements ClientContext {
    private ClientInternalConf internalConf;
    private LedgerManager ledgerManager;
    private BookieWatcher bookieWatcher;
    private EnsemblePlacementPolicy placementPolicy;
    private BookieClient bookieClient;
    private OrderedExecutor mainWorkerPool;
    private OrderedScheduler scheduler;
    private BookKeeperClientStats clientStats;
    private BooleanSupplier isClientClosed;
    private MockRegistrationClient regClient;
    private ByteBufAllocator allocator;

    static MockClientContext create() throws Exception {
        ClientConfiguration conf = new ClientConfiguration();
        OrderedScheduler scheduler = (OrderedScheduler)OrderedScheduler.newSchedulerBuilder().name("mock-executor").numThreads(1).build();
        MockRegistrationClient regClient = new MockRegistrationClient();
        DefaultEnsemblePlacementPolicy placementPolicy = new DefaultEnsemblePlacementPolicy();
        BookieWatcherImpl bookieWatcherImpl = new BookieWatcherImpl(conf, (EnsemblePlacementPolicy)placementPolicy, (RegistrationClient)regClient, (StatsLogger)NullStatsLogger.INSTANCE);
        bookieWatcherImpl.initialBlockingBookieRead();
        return new MockClientContext().setConf(ClientInternalConf.fromConfig((ClientConfiguration)conf)).setLedgerManager(new MockLedgerManager()).setBookieWatcher((BookieWatcher)bookieWatcherImpl).setPlacementPolicy((EnsemblePlacementPolicy)placementPolicy).setRegistrationClient(regClient).setBookieClient(new MockBookieClient((OrderedExecutor)scheduler)).setByteBufAllocator((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT).setMainWorkerPool((OrderedExecutor)scheduler).setScheduler(scheduler).setClientStats(BookKeeperClientStats.newInstance((StatsLogger)NullStatsLogger.INSTANCE)).setIsClientClosed(() -> false);
    }

    static MockClientContext copyOf(ClientContext other) {
        return new MockClientContext().setConf(other.getConf()).setLedgerManager(other.getLedgerManager()).setBookieWatcher(other.getBookieWatcher()).setPlacementPolicy(other.getPlacementPolicy()).setBookieClient(other.getBookieClient()).setMainWorkerPool(other.getMainWorkerPool()).setScheduler(other.getScheduler()).setClientStats(other.getClientStats()).setByteBufAllocator(other.getByteBufAllocator()).setIsClientClosed(() -> ((ClientContext)other).isClientClosed());
    }

    public MockRegistrationClient getMockRegistrationClient() {
        Preconditions.checkState((this.regClient != null ? 1 : 0) != 0);
        return this.regClient;
    }

    public MockLedgerManager getMockLedgerManager() {
        Preconditions.checkState((boolean)(this.ledgerManager instanceof MockLedgerManager));
        return (MockLedgerManager)this.ledgerManager;
    }

    public MockBookieClient getMockBookieClient() {
        Preconditions.checkState((boolean)(this.bookieClient instanceof MockBookieClient));
        return (MockBookieClient)this.bookieClient;
    }

    public MockClientContext setConf(ClientInternalConf internalConf) {
        this.internalConf = MockClientContext.maybeSpy(internalConf);
        return this;
    }

    public MockClientContext setLedgerManager(LedgerManager ledgerManager) {
        this.ledgerManager = MockClientContext.maybeSpy(ledgerManager);
        return this;
    }

    public MockClientContext setBookieWatcher(BookieWatcher bookieWatcher) {
        this.bookieWatcher = MockClientContext.maybeSpy(bookieWatcher);
        return this;
    }

    public MockClientContext setPlacementPolicy(EnsemblePlacementPolicy placementPolicy) {
        this.placementPolicy = MockClientContext.maybeSpy(placementPolicy);
        return this;
    }

    public MockClientContext setBookieClient(BookieClient bookieClient) {
        this.bookieClient = MockClientContext.maybeSpy(bookieClient);
        return this;
    }

    public MockClientContext setMainWorkerPool(OrderedExecutor mainWorkerPool) {
        this.mainWorkerPool = MockClientContext.maybeSpy(mainWorkerPool);
        return this;
    }

    public MockClientContext setScheduler(OrderedScheduler scheduler) {
        this.scheduler = MockClientContext.maybeSpy(scheduler);
        return this;
    }

    public MockClientContext setClientStats(BookKeeperClientStats clientStats) {
        this.clientStats = clientStats;
        return this;
    }

    public MockClientContext setIsClientClosed(BooleanSupplier isClientClosed) {
        this.isClientClosed = isClientClosed;
        return this;
    }

    public MockClientContext setRegistrationClient(MockRegistrationClient regClient) {
        this.regClient = MockClientContext.maybeSpy(regClient);
        return this;
    }

    public MockClientContext setByteBufAllocator(ByteBufAllocator allocator) {
        this.allocator = allocator;
        return this;
    }

    private static <T> T maybeSpy(T orig) {
        if (Mockito.mockingDetails(orig).isSpy()) {
            return orig;
        }
        return (T)Mockito.spy(orig);
    }

    public ClientInternalConf getConf() {
        return this.internalConf;
    }

    public LedgerManager getLedgerManager() {
        return this.ledgerManager;
    }

    public BookieWatcher getBookieWatcher() {
        return this.bookieWatcher;
    }

    public EnsemblePlacementPolicy getPlacementPolicy() {
        return this.placementPolicy;
    }

    public BookieClient getBookieClient() {
        return this.bookieClient;
    }

    public OrderedExecutor getMainWorkerPool() {
        return this.mainWorkerPool;
    }

    public OrderedScheduler getScheduler() {
        return this.scheduler;
    }

    public BookKeeperClientStats getClientStats() {
        return this.clientStats;
    }

    public boolean isClientClosed() {
        return this.isClientClosed.getAsBoolean();
    }

    public ByteBufAllocator getByteBufAllocator() {
        return this.allocator;
    }
}

