/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import com.google.common.collect.Sets;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;
import org.apache.bookkeeper.client.DistributionSchedule;
import org.apache.bookkeeper.client.RoundRobinDistributionSchedule;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoundRobinDistributionScheduleTest {
    private static final Logger LOG = LoggerFactory.getLogger(RoundRobinDistributionScheduleTest.class);

    @Test
    public void testDistributionSchedule() throws Exception {
        RoundRobinDistributionSchedule schedule = new RoundRobinDistributionSchedule(3, 2, 5);
        DistributionSchedule.WriteSet wSet = schedule.getWriteSet(1L);
        Assert.assertEquals((String)"Write set is wrong size", (long)wSet.size(), (long)3L);
        DistributionSchedule.AckSet ackSet = schedule.getAckSet();
        Assert.assertFalse((String)"Shouldn't ack yet", (boolean)ackSet.completeBookieAndCheck(wSet.get(0)));
        Assert.assertFalse((String)"Shouldn't ack yet", (boolean)ackSet.completeBookieAndCheck(wSet.get(0)));
        Assert.assertTrue((String)"Should ack after 2 unique", (boolean)ackSet.completeBookieAndCheck(wSet.get(2)));
        Assert.assertTrue((String)"Should still be acking", (boolean)ackSet.completeBookieAndCheck(wSet.get(1)));
    }

    @Test
    public void testCoverageSets() {
        int errors = 0;
        for (int e = 6; e > 0; --e) {
            for (int w = e; w > 0; --w) {
                for (int a = w; a > 0; --a) {
                    errors += this.testCoverageForConfiguration(e, w, a);
                }
            }
        }
        Assert.assertEquals((String)"Should be no errors", (long)0L, (long)errors);
        RoundRobinDistributionSchedule schedule = new RoundRobinDistributionSchedule(5, 3, 5);
        DistributionSchedule.QuorumCoverageSet covSet = schedule.getCoverageSet();
        covSet.addBookie(0, -7);
        covSet.addBookie(1, -13);
        covSet.addBookie(2, -7);
        covSet.addBookie(3, 1);
        covSet.addBookie(4, 1);
        Assert.assertFalse((boolean)covSet.checkCovered());
    }

    boolean[] buildAvailable(int ensemble, Set<Integer> responses) {
        boolean[] available = new boolean[ensemble];
        for (int i = 0; i < ensemble; ++i) {
            available[i] = !responses.contains(i);
        }
        return available;
    }

    boolean canGetAckQuorum(int ensemble, int writeQuorum, int ackQuorum, boolean[] available) {
        for (int i = 0; i < ensemble; ++i) {
            int count = 0;
            for (int j = 0; j < writeQuorum; ++j) {
                if (!available[(i + j) % ensemble]) continue;
                ++count;
            }
            if (count < ackQuorum) continue;
            return true;
        }
        return false;
    }

    private int testCoverageForConfiguration(int ensemble, int writeQuorum, int ackQuorum) {
        RoundRobinDistributionSchedule schedule = new RoundRobinDistributionSchedule(writeQuorum, ackQuorum, ensemble);
        HashSet<Integer> indexes = new HashSet<Integer>();
        for (int i = 0; i < ensemble; ++i) {
            indexes.add(i);
        }
        Set subsets = Sets.powerSet(indexes);
        int errors = 0;
        for (Set subset : subsets) {
            DistributionSchedule.QuorumCoverageSet covSet = schedule.getCoverageSet();
            for (Integer i : subset) {
                covSet.addBookie(i.intValue(), 0);
            }
            boolean covSetSays = covSet.checkCovered();
            boolean[] nodesAvailable = this.buildAvailable(ensemble, subset);
            boolean canGetAck = this.canGetAckQuorum(ensemble, writeQuorum, ackQuorum, nodesAvailable);
            if (canGetAck != covSetSays) continue;
            LOG.error("e{}:w{}:a{} available {}    canGetAck {} covSetSays {}", new Object[]{ensemble, writeQuorum, ackQuorum, nodesAvailable, canGetAck, covSetSays});
            ++errors;
        }
        return errors;
    }

    @Test
    public void testMoveAndShift() {
        DistributionSchedule.WriteSet w = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{1, 2, 3, 4, 5});
        w.moveAndShift(3, 1);
        Assert.assertEquals((Object)w, (Object)RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{1, 4, 2, 3, 5}));
        w = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{1, 2, 3, 4, 5});
        w.moveAndShift(1, 3);
        Assert.assertEquals((Object)w, (Object)RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{1, 3, 4, 2, 5}));
        w = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{1, 2, 3, 4, 5});
        w.moveAndShift(0, 4);
        Assert.assertEquals((Object)w, (Object)RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{2, 3, 4, 5, 1}));
        w = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{1, 2, 3, 4, 5});
        w.moveAndShift(0, 0);
        Assert.assertEquals((Object)w, (Object)RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{1, 2, 3, 4, 5}));
        w = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{1, 2, 3, 4, 5});
        w.moveAndShift(4, 4);
        Assert.assertEquals((Object)w, (Object)RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{1, 2, 3, 4, 5}));
    }

    @Test
    public void testGetEntriesStripedToTheBookie() {
        int i;
        BitSet entriesStriped;
        int bookieIndex;
        int ensSize = 3;
        int writeQuorum = 3;
        int ackQuorum = 3;
        int startEntryId = 3;
        int lastEntryId = 5;
        RoundRobinDistributionSchedule schedule = new RoundRobinDistributionSchedule(writeQuorum, ackQuorum, ensSize);
        for (bookieIndex = 0; bookieIndex < ensSize; ++bookieIndex) {
            entriesStriped = schedule.getEntriesStripedToTheBookie(bookieIndex, (long)startEntryId, (long)lastEntryId);
            Assert.assertEquals((String)"Cardinality", (long)3L, (long)entriesStriped.cardinality());
            for (i = 0; i < entriesStriped.length(); ++i) {
                Assert.assertEquals((String)"EntryAvailability", (Object)schedule.hasEntry((long)(startEntryId + i), bookieIndex), (Object)entriesStriped.get(i));
            }
        }
        ensSize = 5;
        writeQuorum = 3;
        ackQuorum = 2;
        startEntryId = 100;
        lastEntryId = 122;
        schedule = new RoundRobinDistributionSchedule(writeQuorum, ackQuorum, ensSize);
        for (bookieIndex = 0; bookieIndex < ensSize; ++bookieIndex) {
            entriesStriped = schedule.getEntriesStripedToTheBookie(bookieIndex, (long)startEntryId, (long)lastEntryId);
            for (i = 0; i < entriesStriped.length(); ++i) {
                Assert.assertEquals((String)"EntryAvailability", (Object)schedule.hasEntry((long)(startEntryId + i), bookieIndex), (Object)entriesStriped.get(i));
            }
        }
        schedule = new RoundRobinDistributionSchedule(2, 2, 3);
        entriesStriped = schedule.getEntriesStripedToTheBookie(2, 0L, 0L);
        Assert.assertEquals((String)"Cardinality", (long)0L, (long)entriesStriped.cardinality());
        entriesStriped = schedule.getEntriesStripedToTheBookie(2, 3L, 3L);
        Assert.assertEquals((String)"Cardinality", (long)0L, (long)entriesStriped.cardinality());
        entriesStriped = schedule.getEntriesStripedToTheBookie(2, 4L, 4L);
        Assert.assertEquals((String)"Cardinality", (long)1L, (long)entriesStriped.cardinality());
    }
}

