/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.BookKeeperTestClient;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestAddEntryQuorumTimeout
extends BookKeeperClusterTestCase
implements AsyncCallback.AddCallback {
    private static final Logger logger = LoggerFactory.getLogger(TestAddEntryQuorumTimeout.class);
    final BookKeeper.DigestType digestType;
    final byte[] testPasswd = "".getBytes();

    public TestAddEntryQuorumTimeout() {
        super(3);
        this.baseClientConf.setAddEntryTimeout(10);
        this.baseClientConf.setAddEntryQuorumTimeout(1);
        this.digestType = BookKeeper.DigestType.CRC32;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.baseConf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addComplete(int rc, LedgerHandle lh, long entryId, Object ctx) {
        SyncObj x;
        SyncObj syncObj = x = (SyncObj)ctx;
        synchronized (syncObj) {
            x.rc = rc;
            ++x.counter;
            x.notify();
        }
    }

    @Test
    public void testBasicTimeout() throws Exception {
        BookKeeperTestClient bkc = new BookKeeperTestClient(this.baseClientConf);
        LedgerHandle lh = bkc.createLedger(3, 3, 3, this.digestType, this.testPasswd);
        List curEns = lh.getCurrentEnsemble();
        byte[] data = "foobar".getBytes();
        lh.addEntry(data);
        this.sleepBookie((BookieSocketAddress)curEns.get(0), 5).await();
        try {
            lh.addEntry(data);
            Assert.fail((String)"should have thrown");
        }
        catch (BKException.BKAddEntryQuorumTimeoutException bKAddEntryQuorumTimeoutException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForSyncObj(SyncObj syncObj) throws Exception {
        SyncObj syncObj2 = syncObj;
        synchronized (syncObj2) {
            while (syncObj.counter < 1) {
                logger.debug("Entries counter = " + syncObj.counter);
                syncObj.wait();
            }
        }
    }

    @Test
    public void testTimeoutWithPendingOps() throws Exception {
        BookKeeperTestClient bkc = new BookKeeperTestClient(this.baseClientConf);
        LedgerHandle lh = bkc.createLedger(3, 3, 3, this.digestType, this.testPasswd);
        List curEns = lh.getCurrentEnsemble();
        byte[] data = "foobar".getBytes();
        SyncObj syncObj1 = new SyncObj();
        SyncObj syncObj2 = new SyncObj();
        SyncObj syncObj3 = new SyncObj();
        lh.addEntry(data);
        this.sleepBookie((BookieSocketAddress)curEns.get(0), 5).await();
        lh.asyncAddEntry(data, (AsyncCallback.AddCallback)this, (Object)syncObj1);
        lh.asyncAddEntry(data, (AsyncCallback.AddCallback)this, (Object)syncObj2);
        lh.asyncAddEntry(data, (AsyncCallback.AddCallback)this, (Object)syncObj3);
        this.waitForSyncObj(syncObj1);
        Assert.assertEquals((long)-21L, (long)syncObj1.rc);
        this.waitForSyncObj(syncObj2);
        Assert.assertEquals((long)-21L, (long)syncObj2.rc);
        this.waitForSyncObj(syncObj3);
        Assert.assertEquals((long)-21L, (long)syncObj3.rc);
    }

    @Test
    public void testLedgerClosedAfterTimeout() throws Exception {
        BookKeeperTestClient bkc = new BookKeeperTestClient(this.baseClientConf);
        LedgerHandle lh = bkc.createLedger(3, 3, 3, this.digestType, this.testPasswd);
        List curEns = lh.getCurrentEnsemble();
        byte[] data = "foobar".getBytes();
        CountDownLatch b0latch = this.sleepBookie((BookieSocketAddress)curEns.get(0), 5);
        try {
            lh.addEntry(data);
            Assert.fail((String)"should have thrown");
        }
        catch (BKException.BKAddEntryQuorumTimeoutException bKAddEntryQuorumTimeoutException) {
            // empty catch block
        }
        b0latch.await();
        try {
            lh.addEntry(data);
            Assert.fail((String)"should have thrown");
        }
        catch (BKException.BKLedgerClosedException bKLedgerClosedException) {
            // empty catch block
        }
    }

    private static class SyncObj {
        volatile int counter = 0;
        volatile int rc = -1;
    }
}

