/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.ListenerBasedPendingReadOp;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestReadEntryListener
extends BookKeeperClusterTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(TestReadEntryListener.class);
    final BookKeeper.DigestType digestType;
    final byte[] passwd = "read-entry-listener".getBytes();

    public TestReadEntryListener() {
        super(6);
        this.digestType = BookKeeper.DigestType.CRC32;
    }

    long getLedgerToRead(int ensemble, int writeQuorum, int ackQuorum, int numEntries) throws Exception {
        LedgerHandle lh = this.bkc.createLedger(ensemble, writeQuorum, ackQuorum, this.digestType, this.passwd);
        for (int i = 0; i < numEntries; ++i) {
            lh.addEntry(("" + i).getBytes());
        }
        lh.close();
        return lh.getId();
    }

    ListenerBasedPendingReadOp createReadOp(LedgerHandle lh, long from, long to, BookkeeperInternalCallbacks.ReadEntryListener listener) {
        return new ListenerBasedPendingReadOp(lh, this.bkc.getClientCtx(), from, to, listener, null, false);
    }

    void basicReadTest(boolean parallelRead) throws Exception {
        EntryWithRC entry;
        int numEntries = 10;
        long id = this.getLedgerToRead(5, 2, 2, numEntries);
        LedgerHandle lh = this.bkc.openLedger(id, this.digestType, this.passwd);
        for (int i = 0; i < numEntries; ++i) {
            LatchListener listener = new LatchListener(i, 1);
            ListenerBasedPendingReadOp readOp = this.createReadOp(lh, i, i, listener);
            readOp.parallelRead(parallelRead).submit();
            listener.expectComplete();
            Assert.assertEquals((long)1L, (long)listener.resultCodes.size());
            entry = listener.resultCodes.get(i);
            Assert.assertNotNull((Object)entry);
            Assert.assertEquals((long)0L, (long)entry.rc);
            Assert.assertEquals((long)i, (long)Integer.parseInt(new String(entry.entry.getEntry())));
            Assert.assertTrue((boolean)listener.isInOrder());
        }
        LatchListener listener = new LatchListener(0L, numEntries);
        ListenerBasedPendingReadOp readOp = this.createReadOp(lh, 0L, numEntries - 1, listener);
        readOp.parallelRead(parallelRead).submit();
        listener.expectComplete();
        Assert.assertEquals((long)numEntries, (long)listener.resultCodes.size());
        for (int i = 0; i < numEntries; ++i) {
            entry = listener.resultCodes.get(i);
            Assert.assertNotNull((Object)entry);
            Assert.assertEquals((long)0L, (long)entry.rc);
            Assert.assertEquals((long)i, (long)Integer.parseInt(new String(entry.entry.getEntry())));
        }
        Assert.assertTrue((boolean)listener.isInOrder());
        lh.close();
    }

    @Test
    public void testBasicEnableParallelRead() throws Exception {
        this.basicReadTest(true);
    }

    @Test
    public void testBasicDisableParallelRead() throws Exception {
        this.basicReadTest(false);
    }

    private void readMissingEntriesTest(boolean parallelRead) throws Exception {
        int numEntries = 10;
        long id = this.getLedgerToRead(5, 2, 2, numEntries);
        LedgerHandle lh = this.bkc.openLedger(id, this.digestType, this.passwd);
        LatchListener listener = new LatchListener(11L, 1);
        ListenerBasedPendingReadOp readOp = this.createReadOp(lh, 11L, 11L, listener);
        readOp.parallelRead(parallelRead).submit();
        listener.expectComplete();
        Assert.assertEquals((long)1L, (long)listener.resultCodes.size());
        EntryWithRC entry = listener.resultCodes.get(11L);
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((long)-13L, (long)entry.rc);
        Assert.assertTrue((boolean)listener.isInOrder());
        listener = new LatchListener(11L, 3);
        readOp = this.createReadOp(lh, 11L, 13L, listener);
        readOp.parallelRead(parallelRead).submit();
        listener.expectComplete();
        Assert.assertEquals((long)3L, (long)listener.resultCodes.size());
        Assert.assertTrue((boolean)listener.isInOrder());
        for (int i = 11; i <= 13; ++i) {
            entry = listener.resultCodes.get(i);
            Assert.assertNotNull((Object)entry);
            Assert.assertEquals((long)-13L, (long)entry.rc);
        }
        listener = new LatchListener(5L, 10);
        readOp = this.createReadOp(lh, 5L, 14L, listener);
        readOp.parallelRead(parallelRead).submit();
        listener.expectComplete();
        Assert.assertEquals((long)10L, (long)listener.resultCodes.size());
        Assert.assertTrue((boolean)listener.isInOrder());
        for (long i = 5L; i <= 14L; ++i) {
            entry = listener.resultCodes.get(i);
            Assert.assertNotNull((Object)entry);
            if (i < 10L) {
                Assert.assertEquals((long)0L, (long)entry.rc);
                Assert.assertEquals((long)i, (long)Integer.parseInt(new String(entry.entry.getEntry())));
                continue;
            }
            Assert.assertEquals((long)-13L, (long)entry.rc);
        }
        lh.close();
    }

    @Test
    public void testReadMissingEntriesEnableParallelRead() throws Exception {
        this.readMissingEntriesTest(true);
    }

    @Test
    public void testReadMissingEntriesDisableParallelRead() throws Exception {
        this.readMissingEntriesTest(false);
    }

    private void readWithFailedBookiesTest(boolean parallelRead) throws Exception {
        int numEntries = 10;
        long id = this.getLedgerToRead(5, 3, 3, numEntries);
        LedgerHandle lh = this.bkc.openLedger(id, this.digestType, this.passwd);
        List ensemble = lh.getLedgerMetadata().getEnsembleAt(5L);
        this.killBookie((BookieSocketAddress)ensemble.get(0));
        this.killBookie((BookieSocketAddress)ensemble.get(1));
        LatchListener listener = new LatchListener(0L, numEntries);
        ListenerBasedPendingReadOp readOp = this.createReadOp(lh, 0L, numEntries - 1, listener);
        readOp.parallelRead(parallelRead).submit();
        listener.expectComplete();
        Assert.assertEquals((long)numEntries, (long)listener.resultCodes.size());
        for (int i = 0; i < numEntries; ++i) {
            EntryWithRC entry = listener.resultCodes.get(i);
            Assert.assertNotNull((Object)entry);
            Assert.assertEquals((long)0L, (long)entry.rc);
            Assert.assertEquals((long)i, (long)Integer.parseInt(new String(entry.entry.getEntry())));
        }
        lh.close();
    }

    @Test
    public void testReadWithFailedBookiesEnableParallelRead() throws Exception {
        this.readWithFailedBookiesTest(true);
    }

    @Test
    public void testReadWithFailedBookiesDisableParallelRead() throws Exception {
        this.readWithFailedBookiesTest(false);
    }

    private void readFailureWithFailedBookiesTest(boolean parallelRead) throws Exception {
        int numEntries = 10;
        long id = this.getLedgerToRead(5, 3, 3, numEntries);
        LedgerHandle lh = this.bkc.openLedger(id, this.digestType, this.passwd);
        List ensemble = lh.getLedgerMetadata().getEnsembleAt(5L);
        this.killBookie((BookieSocketAddress)ensemble.get(0));
        this.killBookie((BookieSocketAddress)ensemble.get(1));
        this.killBookie((BookieSocketAddress)ensemble.get(2));
        LatchListener listener = new LatchListener(0L, numEntries);
        ListenerBasedPendingReadOp readOp = this.createReadOp(lh, 0L, numEntries - 1, listener);
        readOp.parallelRead(parallelRead).submit();
        listener.expectComplete();
        Assert.assertEquals((long)numEntries, (long)listener.resultCodes.size());
        for (int i = 0; i < numEntries; ++i) {
            EntryWithRC entry = listener.resultCodes.get(i);
            Assert.assertNotNull((Object)entry);
            if (i % 5 == 0) {
                Assert.assertEquals((long)-8L, (long)entry.rc);
                continue;
            }
            Assert.assertEquals((long)0L, (long)entry.rc);
            Assert.assertEquals((long)i, (long)Integer.parseInt(new String(entry.entry.getEntry())));
        }
        lh.close();
    }

    @Test
    public void testReadFailureWithFailedBookiesEnableParallelRead() throws Exception {
        this.readFailureWithFailedBookiesTest(true);
    }

    @Test
    public void testReadFailureWithFailedBookiesDisableParallelRead() throws Exception {
        this.readFailureWithFailedBookiesTest(false);
    }

    static class LatchListener
    implements BookkeeperInternalCallbacks.ReadEntryListener {
        final CountDownLatch l;
        final Map<Long, EntryWithRC> resultCodes;
        boolean inOrder = true;
        long nextEntryId;

        LatchListener(long startEntryId, int numEntries) {
            this.l = new CountDownLatch(numEntries);
            this.resultCodes = new HashMap<Long, EntryWithRC>();
            this.nextEntryId = startEntryId;
        }

        public void onEntryComplete(int rc, LedgerHandle lh, LedgerEntry entry, Object ctx) {
            long entryId;
            if (0 == rc) {
                if (this.nextEntryId != entry.getEntryId()) {
                    this.inOrder = false;
                }
                entryId = entry.getEntryId();
            } else {
                entryId = this.nextEntryId;
            }
            this.resultCodes.put(entryId, new EntryWithRC(rc, entry));
            ++this.nextEntryId;
            this.l.countDown();
        }

        void expectComplete() throws Exception {
            this.l.await();
        }

        boolean isInOrder() {
            return this.inOrder;
        }
    }

    static class EntryWithRC {
        final LedgerEntry entry;
        final int rc;

        EntryWithRC(int rc, LedgerEntry entry) {
            this.rc = rc;
            this.entry = entry;
        }
    }
}

