/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.util.HashedWheelTimer;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookiesHealthInfo;
import org.apache.bookkeeper.client.DistributionSchedule;
import org.apache.bookkeeper.client.RegionAwareEnsemblePlacementPolicy;
import org.apache.bookkeeper.client.RoundRobinDistributionSchedule;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.feature.FeatureProvider;
import org.apache.bookkeeper.feature.SettableFeature;
import org.apache.bookkeeper.feature.SettableFeatureProvider;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.util.StaticDNSResolver;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRegionAwareEnsemblePlacementPolicy
extends TestCase {
    static final Logger LOG = LoggerFactory.getLogger(TestRegionAwareEnsemblePlacementPolicy.class);
    RegionAwareEnsemblePlacementPolicy repp;
    final ClientConfiguration conf = new ClientConfiguration();
    final ArrayList<BookieSocketAddress> ensemble = new ArrayList();
    DistributionSchedule.WriteSet writeSet = DistributionSchedule.NULL_WRITE_SET;
    BookieSocketAddress addr1;
    BookieSocketAddress addr2;
    BookieSocketAddress addr3;
    BookieSocketAddress addr4;
    HashedWheelTimer timer;

    static void updateMyRack(String rack) throws Exception {
        StaticDNSResolver.addNodeToRack(InetAddress.getLocalHost().getHostAddress(), rack);
        StaticDNSResolver.addNodeToRack(InetAddress.getLocalHost().getHostName(), rack);
        BookieSocketAddress bookieAddress = new BookieSocketAddress(InetAddress.getLocalHost().getHostAddress(), 0);
        StaticDNSResolver.addNodeToRack(bookieAddress.getSocketAddress().getHostName(), rack);
        StaticDNSResolver.addNodeToRack(bookieAddress.getSocketAddress().getAddress().getHostAddress(), rack);
        StaticDNSResolver.addNodeToRack("127.0.0.1", rack);
        StaticDNSResolver.addNodeToRack("localhost", rack);
    }

    protected void setUp() throws Exception {
        super.setUp();
        StaticDNSResolver.reset();
        TestRegionAwareEnsemblePlacementPolicy.updateMyRack("/default-region/default-rack");
        LOG.info("Set up static DNS Resolver.");
        this.conf.setProperty("reppDnsResolverClass", (Object)StaticDNSResolver.class.getName());
        this.addr1 = new BookieSocketAddress("127.0.0.2", 3181);
        this.addr2 = new BookieSocketAddress("127.0.0.3", 3181);
        this.addr3 = new BookieSocketAddress("127.0.0.4", 3181);
        this.addr4 = new BookieSocketAddress("127.0.0.5", 3181);
        StaticDNSResolver.addNodeToRack(this.addr1.getHostName(), "/r1/rack1");
        StaticDNSResolver.addNodeToRack(this.addr2.getHostName(), "/default-region/default-rack");
        StaticDNSResolver.addNodeToRack(this.addr3.getHostName(), "/default-region/default-rack");
        StaticDNSResolver.addNodeToRack(this.addr4.getHostName(), "/r1/rack2");
        this.ensemble.add(this.addr1);
        this.ensemble.add(this.addr2);
        this.ensemble.add(this.addr3);
        this.ensemble.add(this.addr4);
        this.writeSet = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{0, 1, 2, 3});
        this.timer = new HashedWheelTimer(new ThreadFactoryBuilder().setNameFormat("TestTimer-%d").build(), this.conf.getTimeoutTimerTickDurationMs(), TimeUnit.MILLISECONDS, this.conf.getTimeoutTimerNumTicks());
        this.repp = new RegionAwareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE);
    }

    protected void tearDown() throws Exception {
        this.repp.uninitalize();
        super.tearDown();
    }

    static BookiesHealthInfo getBookiesHealthInfo() {
        return TestRegionAwareEnsemblePlacementPolicy.getBookiesHealthInfo(new HashMap<BookieSocketAddress, Long>(), new HashMap<BookieSocketAddress, Long>());
    }

    static BookiesHealthInfo getBookiesHealthInfo(final Map<BookieSocketAddress, Long> bookieFailureHistory, final Map<BookieSocketAddress, Long> bookiePendingRequests) {
        return new BookiesHealthInfo(){

            public long getBookieFailureHistory(BookieSocketAddress bookieSocketAddress) {
                return bookieFailureHistory.getOrDefault(bookieSocketAddress, -1L);
            }

            public long getBookiePendingRequests(BookieSocketAddress bookieSocketAddress) {
                return bookiePendingRequests.getOrDefault(bookieSocketAddress, 0L);
            }
        };
    }

    @Test
    public void testNotReorderReadIfInDefaultRack() throws Exception {
        this.repp.uninitalize();
        TestRegionAwareEnsemblePlacementPolicy.updateMyRack("/default-region/default-rack");
        this.repp = new RegionAwareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE);
        DistributionSchedule.WriteSet origWriteSet = this.writeSet.copy();
        DistributionSchedule.WriteSet reorderSet = this.repp.reorderReadSequence(this.ensemble, TestRegionAwareEnsemblePlacementPolicy.getBookiesHealthInfo(), this.writeSet);
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((Object)origWriteSet, (Object)reorderSet);
    }

    @Test
    public void testNodeInSameRegion() throws Exception {
        this.repp.uninitalize();
        TestRegionAwareEnsemblePlacementPolicy.updateMyRack("/r1/rack3");
        this.repp = new RegionAwareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE);
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)"r1", (String)this.repp.myRegion);
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(this.addr1);
        addrs.add(this.addr2);
        addrs.add(this.addr3);
        addrs.add(this.addr4);
        this.repp.onClusterChanged(addrs, new HashSet());
        DistributionSchedule.WriteSet reorderSet = this.repp.reorderReadSequence(this.ensemble, TestRegionAwareEnsemblePlacementPolicy.getBookiesHealthInfo(), this.writeSet.copy());
        DistributionSchedule.WriteSet expectedSet = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{0, 3, 1, 2});
        LOG.info("write set : {}", (Object)this.writeSet);
        LOG.info("reorder set : {}", (Object)reorderSet);
        LOG.info("expected set : {}", (Object)expectedSet);
        LOG.info("reorder equals {}", (Object)reorderSet.equals(this.writeSet));
        TestRegionAwareEnsemblePlacementPolicy.assertFalse((boolean)reorderSet.equals(this.writeSet));
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((Object)expectedSet, (Object)reorderSet);
    }

    @Test
    public void testNodeNotInSameRegions() throws Exception {
        this.repp.uninitalize();
        TestRegionAwareEnsemblePlacementPolicy.updateMyRack("/r2/rack1");
        this.repp = new RegionAwareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE);
        DistributionSchedule.WriteSet origWriteSet = this.writeSet.copy();
        DistributionSchedule.WriteSet reorderSet = this.repp.reorderReadSequence(this.ensemble, TestRegionAwareEnsemblePlacementPolicy.getBookiesHealthInfo(), this.writeSet);
        LOG.info("reorder set : {}", (Object)reorderSet);
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((Object)origWriteSet, (Object)reorderSet);
    }

    @Test
    public void testNodeDown() throws Exception {
        this.repp.uninitalize();
        TestRegionAwareEnsemblePlacementPolicy.updateMyRack("/r1/rack1");
        this.repp = new RegionAwareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE);
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(this.addr1);
        addrs.add(this.addr2);
        addrs.add(this.addr3);
        addrs.add(this.addr4);
        this.repp.onClusterChanged(addrs, new HashSet());
        addrs.remove(this.addr1);
        this.repp.onClusterChanged(addrs, new HashSet());
        DistributionSchedule.WriteSet origWriteSet = this.writeSet.copy();
        DistributionSchedule.WriteSet reorderSet = this.repp.reorderReadSequence(this.ensemble, TestRegionAwareEnsemblePlacementPolicy.getBookiesHealthInfo(), this.writeSet);
        DistributionSchedule.WriteSet expectedSet = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{3, 1, 2, 0});
        LOG.info("reorder set : {}", (Object)reorderSet);
        TestRegionAwareEnsemblePlacementPolicy.assertFalse((boolean)reorderSet.equals(origWriteSet));
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((Object)expectedSet, (Object)reorderSet);
    }

    @Test
    public void testNodeReadOnly() throws Exception {
        this.repp.uninitalize();
        TestRegionAwareEnsemblePlacementPolicy.updateMyRack("/r1/rack1");
        this.repp = new RegionAwareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE);
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(this.addr1);
        addrs.add(this.addr2);
        addrs.add(this.addr3);
        addrs.add(this.addr4);
        this.repp.onClusterChanged(addrs, new HashSet());
        addrs.remove(this.addr1);
        HashSet<BookieSocketAddress> ro = new HashSet<BookieSocketAddress>();
        ro.add(this.addr1);
        this.repp.onClusterChanged(addrs, ro);
        DistributionSchedule.WriteSet origWriteSet = this.writeSet.copy();
        DistributionSchedule.WriteSet reorderSet = this.repp.reorderReadSequence(this.ensemble, TestRegionAwareEnsemblePlacementPolicy.getBookiesHealthInfo(), this.writeSet);
        DistributionSchedule.WriteSet expectedSet = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{3, 1, 2, 0});
        LOG.info("reorder set : {}", (Object)reorderSet);
        TestRegionAwareEnsemblePlacementPolicy.assertFalse((boolean)reorderSet.equals(origWriteSet));
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((Object)expectedSet, (Object)reorderSet);
    }

    @Test
    public void testNodeSlow() throws Exception {
        this.repp.uninitalize();
        TestRegionAwareEnsemblePlacementPolicy.updateMyRack("/r1/rack1");
        this.repp = new RegionAwareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE);
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(this.addr1);
        addrs.add(this.addr2);
        addrs.add(this.addr3);
        addrs.add(this.addr4);
        this.repp.onClusterChanged(addrs, new HashSet());
        this.repp.registerSlowBookie(this.addr1, 0L);
        HashMap<BookieSocketAddress, Long> bookiePendingMap = new HashMap<BookieSocketAddress, Long>();
        bookiePendingMap.put(this.addr1, 1L);
        this.repp.onClusterChanged(addrs, new HashSet());
        DistributionSchedule.WriteSet origWriteSet = this.writeSet.copy();
        DistributionSchedule.WriteSet reorderSet = this.repp.reorderReadSequence(this.ensemble, TestRegionAwareEnsemblePlacementPolicy.getBookiesHealthInfo(new HashMap<BookieSocketAddress, Long>(), bookiePendingMap), this.writeSet);
        DistributionSchedule.WriteSet expectedSet = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{3, 1, 2, 0});
        LOG.info("reorder set : {}", (Object)reorderSet);
        TestRegionAwareEnsemblePlacementPolicy.assertFalse((boolean)reorderSet.equals(origWriteSet));
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((Object)expectedSet, (Object)reorderSet);
    }

    @Test
    public void testTwoNodesSlow() throws Exception {
        this.repp.uninitalize();
        TestRegionAwareEnsemblePlacementPolicy.updateMyRack("/r1/rack1");
        this.repp = new RegionAwareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE);
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(this.addr1);
        addrs.add(this.addr2);
        addrs.add(this.addr3);
        addrs.add(this.addr4);
        this.repp.onClusterChanged(addrs, new HashSet());
        this.repp.registerSlowBookie(this.addr1, 0L);
        this.repp.registerSlowBookie(this.addr2, 0L);
        HashMap<BookieSocketAddress, Long> bookiePendingMap = new HashMap<BookieSocketAddress, Long>();
        bookiePendingMap.put(this.addr1, 1L);
        bookiePendingMap.put(this.addr2, 2L);
        this.repp.onClusterChanged(addrs, new HashSet());
        DistributionSchedule.WriteSet origWriteSet = this.writeSet.copy();
        DistributionSchedule.WriteSet reorderSet = this.repp.reorderReadSequence(this.ensemble, TestRegionAwareEnsemblePlacementPolicy.getBookiesHealthInfo(new HashMap<BookieSocketAddress, Long>(), bookiePendingMap), this.writeSet);
        DistributionSchedule.WriteSet expectedSet = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{3, 2, 0, 1});
        LOG.info("reorder set : {}", (Object)reorderSet);
        TestRegionAwareEnsemblePlacementPolicy.assertFalse((boolean)reorderSet.equals(origWriteSet));
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((Object)expectedSet, (Object)reorderSet);
    }

    @Test
    public void testTwoNodesDown() throws Exception {
        this.repp.uninitalize();
        TestRegionAwareEnsemblePlacementPolicy.updateMyRack("/r1/rack1");
        this.repp = new RegionAwareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE);
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(this.addr1);
        addrs.add(this.addr2);
        addrs.add(this.addr3);
        addrs.add(this.addr4);
        this.repp.onClusterChanged(addrs, new HashSet());
        addrs.remove(this.addr1);
        addrs.remove(this.addr2);
        this.repp.onClusterChanged(addrs, new HashSet());
        DistributionSchedule.WriteSet origWriteSet = this.writeSet.copy();
        DistributionSchedule.WriteSet reorderSet = this.repp.reorderReadSequence(this.ensemble, TestRegionAwareEnsemblePlacementPolicy.getBookiesHealthInfo(), this.writeSet);
        DistributionSchedule.WriteSet expectedSet = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{3, 2, 0, 1});
        LOG.info("reorder set : {}", (Object)reorderSet);
        TestRegionAwareEnsemblePlacementPolicy.assertFalse((boolean)reorderSet.equals(origWriteSet));
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((Object)expectedSet, (Object)reorderSet);
    }

    @Test
    public void testNodeDownAndNodeSlow() throws Exception {
        this.repp.uninitalize();
        TestRegionAwareEnsemblePlacementPolicy.updateMyRack("/r1/rack1");
        this.repp = new RegionAwareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE);
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(this.addr1);
        addrs.add(this.addr2);
        addrs.add(this.addr3);
        addrs.add(this.addr4);
        this.repp.onClusterChanged(addrs, new HashSet());
        this.repp.registerSlowBookie(this.addr1, 0L);
        HashMap<BookieSocketAddress, Long> bookiePendingMap = new HashMap<BookieSocketAddress, Long>();
        bookiePendingMap.put(this.addr1, 1L);
        addrs.remove(this.addr2);
        this.repp.onClusterChanged(addrs, new HashSet());
        DistributionSchedule.WriteSet origWriteSet = this.writeSet.copy();
        DistributionSchedule.WriteSet reorderSet = this.repp.reorderReadSequence(this.ensemble, TestRegionAwareEnsemblePlacementPolicy.getBookiesHealthInfo(new HashMap<BookieSocketAddress, Long>(), bookiePendingMap), this.writeSet);
        DistributionSchedule.WriteSet expectedSet = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{3, 2, 0, 1});
        LOG.info("reorder set : {}", (Object)reorderSet);
        TestRegionAwareEnsemblePlacementPolicy.assertFalse((boolean)reorderSet.equals(origWriteSet));
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((Object)expectedSet, (Object)reorderSet);
    }

    @Test
    public void testNodeDownAndReadOnlyAndNodeSlow() throws Exception {
        this.repp.uninitalize();
        TestRegionAwareEnsemblePlacementPolicy.updateMyRack("/r1/rack1");
        this.repp = new RegionAwareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE);
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(this.addr1);
        addrs.add(this.addr2);
        addrs.add(this.addr3);
        addrs.add(this.addr4);
        this.repp.onClusterChanged(addrs, new HashSet());
        addrs.remove(this.addr1);
        addrs.remove(this.addr2);
        HashSet<BookieSocketAddress> ro = new HashSet<BookieSocketAddress>();
        ro.add(this.addr2);
        this.repp.registerSlowBookie(this.addr3, 0L);
        HashMap<BookieSocketAddress, Long> bookiePendingMap = new HashMap<BookieSocketAddress, Long>();
        bookiePendingMap.put(this.addr3, 1L);
        this.repp.onClusterChanged(addrs, ro);
        DistributionSchedule.WriteSet origWriteSet = this.writeSet.copy();
        DistributionSchedule.WriteSet reorderSet = this.repp.reorderReadSequence(this.ensemble, TestRegionAwareEnsemblePlacementPolicy.getBookiesHealthInfo(new HashMap<BookieSocketAddress, Long>(), bookiePendingMap), this.writeSet);
        DistributionSchedule.WriteSet expectedSet = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{3, 1, 2, 0});
        LOG.info("reorder set : {}", (Object)reorderSet);
        TestRegionAwareEnsemblePlacementPolicy.assertFalse((boolean)reorderSet.equals(origWriteSet));
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((Object)expectedSet, (Object)reorderSet);
    }

    @Test
    public void testReplaceBookieWithEnoughBookiesInSameRegion() throws Exception {
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.4", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.5", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/default-region/default-rack");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/region1/r1");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/region1/r2");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/default-region/r3");
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(addr1);
        addrs.add(addr2);
        addrs.add(addr3);
        addrs.add(addr4);
        this.repp.onClusterChanged(addrs, new HashSet());
        BookieSocketAddress replacedBookie = (BookieSocketAddress)this.repp.replaceBookie(1, 1, 1, null, new ArrayList(), addr2, new HashSet()).getResult();
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((Object)addr3, (Object)replacedBookie);
    }

    @Test
    public void testReplaceBookieWithEnoughBookiesInDifferentRegion() throws Exception {
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.4", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.5", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/default-region/default-rack");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/region1/r2");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/region2/r3");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/region3/r4");
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(addr1);
        addrs.add(addr2);
        addrs.add(addr3);
        addrs.add(addr4);
        this.repp.onClusterChanged(addrs, new HashSet());
        HashSet<BookieSocketAddress> excludedAddrs = new HashSet<BookieSocketAddress>();
        excludedAddrs.add(addr1);
        BookieSocketAddress replacedBookie = (BookieSocketAddress)this.repp.replaceBookie(1, 1, 1, null, new ArrayList(), addr2, excludedAddrs).getResult();
        TestRegionAwareEnsemblePlacementPolicy.assertFalse((boolean)addr1.equals((Object)replacedBookie));
        TestRegionAwareEnsemblePlacementPolicy.assertTrue((addr3.equals((Object)replacedBookie) || addr4.equals((Object)replacedBookie) ? 1 : 0) != 0);
    }

    @Test
    public void testNewEnsembleBookieWithNotEnoughBookies() throws Exception {
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.4", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.5", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/default-region/default-rack");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/region2/r2");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/region3/r3");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/region4/r4");
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(addr1);
        addrs.add(addr2);
        addrs.add(addr3);
        addrs.add(addr4);
        this.repp.onClusterChanged(addrs, new HashSet());
        try {
            List list = (List)this.repp.newEnsemble(5, 5, 3, null, new HashSet()).getResult();
            LOG.info("Ensemble : {}", (Object)list);
            TestRegionAwareEnsemblePlacementPolicy.fail((String)"Should throw BKNotEnoughBookiesException when there is not enough bookies");
        }
        catch (BKException.BKNotEnoughBookiesException bKNotEnoughBookiesException) {
            // empty catch block
        }
    }

    @Test
    public void testReplaceBookieWithNotEnoughBookies() throws Exception {
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.4", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.5", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/default-region/default-rack");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/region2/r2");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/region3/r3");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/region4/r4");
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(addr1);
        addrs.add(addr2);
        addrs.add(addr3);
        addrs.add(addr4);
        this.repp.onClusterChanged(addrs, new HashSet());
        HashSet<BookieSocketAddress> excludedAddrs = new HashSet<BookieSocketAddress>();
        excludedAddrs.add(addr1);
        excludedAddrs.add(addr3);
        excludedAddrs.add(addr4);
        try {
            this.repp.replaceBookie(1, 1, 1, null, new ArrayList(), addr2, excludedAddrs);
            TestRegionAwareEnsemblePlacementPolicy.fail((String)"Should throw BKNotEnoughBookiesException when there is not enough bookies");
        }
        catch (BKException.BKNotEnoughBookiesException bKNotEnoughBookiesException) {
            // empty catch block
        }
    }

    @Test
    public void testNewEnsembleWithSingleRegion() throws Exception {
        this.repp.uninitalize();
        this.repp = new RegionAwareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE);
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.4", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.5", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/region1/r2");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/region1/r2");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/region1/r2");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/region1/r2");
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(addr1);
        addrs.add(addr2);
        addrs.add(addr3);
        addrs.add(addr4);
        this.repp.onClusterChanged(addrs, new HashSet());
        try {
            List ensemble = (List)this.repp.newEnsemble(3, 2, 2, null, new HashSet()).getResult();
            TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)0, (int)this.getNumCoveredRegionsInWriteQuorum(ensemble, 2));
            List ensemble2 = (List)this.repp.newEnsemble(4, 2, 2, null, new HashSet()).getResult();
            TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)0, (int)this.getNumCoveredRegionsInWriteQuorum(ensemble2, 2));
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            TestRegionAwareEnsemblePlacementPolicy.fail((String)"Should not get not enough bookies exception even there is only one rack.");
        }
    }

    @Test
    public void testNewEnsembleWithMultipleRegions() throws Exception {
        int numCovered;
        this.repp.uninitalize();
        this.repp = new RegionAwareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE);
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.4", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.5", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/default-region/default-rack");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/region1/r2");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/region1/r2");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/region1/r2");
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(addr1);
        addrs.add(addr2);
        addrs.add(addr3);
        addrs.add(addr4);
        this.repp.onClusterChanged(addrs, new HashSet());
        try {
            List ensemble = (List)this.repp.newEnsemble(3, 2, 2, null, new HashSet()).getResult();
            numCovered = this.getNumCoveredRegionsInWriteQuorum(ensemble, 2);
            TestRegionAwareEnsemblePlacementPolicy.assertTrue((numCovered >= 1 ? 1 : 0) != 0);
            TestRegionAwareEnsemblePlacementPolicy.assertTrue((numCovered < 3 ? 1 : 0) != 0);
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            TestRegionAwareEnsemblePlacementPolicy.fail((String)"Should not get not enough bookies exception even there is only one rack.");
        }
        try {
            List ensemble2 = (List)this.repp.newEnsemble(4, 2, 2, null, new HashSet()).getResult();
            numCovered = this.getNumCoveredRegionsInWriteQuorum(ensemble2, 2);
            TestRegionAwareEnsemblePlacementPolicy.assertTrue((numCovered >= 1 && numCovered < 3 ? 1 : 0) != 0);
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            TestRegionAwareEnsemblePlacementPolicy.fail((String)"Should not get not enough bookies exception even there is only one rack.");
        }
    }

    @Test
    public void testNewEnsembleWithEnoughRegions() throws Exception {
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.4", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.5", 3181);
        BookieSocketAddress addr5 = new BookieSocketAddress("127.0.0.6", 3181);
        BookieSocketAddress addr6 = new BookieSocketAddress("127.0.0.7", 3181);
        BookieSocketAddress addr7 = new BookieSocketAddress("127.0.0.8", 3181);
        BookieSocketAddress addr8 = new BookieSocketAddress("127.0.0.9", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/default-region/default-rack1");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/region1/r2");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/region2/r3");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/region3/r4");
        StaticDNSResolver.addNodeToRack(addr5.getHostName(), "/default-region/default-rack2");
        StaticDNSResolver.addNodeToRack(addr6.getHostName(), "/region1/r12");
        StaticDNSResolver.addNodeToRack(addr7.getHostName(), "/region2/r13");
        StaticDNSResolver.addNodeToRack(addr8.getHostName(), "/region3/r14");
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(addr1);
        addrs.add(addr2);
        addrs.add(addr3);
        addrs.add(addr4);
        addrs.add(addr5);
        addrs.add(addr6);
        addrs.add(addr7);
        addrs.add(addr8);
        this.repp.onClusterChanged(addrs, new HashSet());
        try {
            List ensemble1 = (List)this.repp.newEnsemble(3, 2, 2, null, new HashSet()).getResult();
            TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)3, (int)this.getNumCoveredRegionsInWriteQuorum(ensemble1, 2));
            List ensemble2 = (List)this.repp.newEnsemble(4, 2, 2, null, new HashSet()).getResult();
            TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)4, (int)this.getNumCoveredRegionsInWriteQuorum(ensemble2, 2));
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            TestRegionAwareEnsemblePlacementPolicy.fail((String)"Should not get not enough bookies exception even there is only one rack.");
        }
    }

    @Test
    public void testNewEnsembleWithThreeRegions() throws Exception {
        this.repp.uninitalize();
        this.repp = new RegionAwareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE);
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.4", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.5", 3181);
        BookieSocketAddress addr5 = new BookieSocketAddress("127.0.0.6", 3181);
        BookieSocketAddress addr6 = new BookieSocketAddress("127.0.0.7", 3181);
        BookieSocketAddress addr7 = new BookieSocketAddress("127.0.0.8", 3181);
        BookieSocketAddress addr8 = new BookieSocketAddress("127.0.0.9", 3181);
        BookieSocketAddress addr9 = new BookieSocketAddress("127.0.0.10", 3181);
        BookieSocketAddress addr10 = new BookieSocketAddress("127.0.0.11", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/region2/r1");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/region1/r2");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/region2/r3");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/region3/r4");
        StaticDNSResolver.addNodeToRack(addr5.getHostName(), "/region1/r11");
        StaticDNSResolver.addNodeToRack(addr6.getHostName(), "/region1/r12");
        StaticDNSResolver.addNodeToRack(addr7.getHostName(), "/region2/r13");
        StaticDNSResolver.addNodeToRack(addr8.getHostName(), "/region3/r14");
        StaticDNSResolver.addNodeToRack(addr9.getHostName(), "/region2/r23");
        StaticDNSResolver.addNodeToRack(addr10.getHostName(), "/region1/r24");
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(addr1);
        addrs.add(addr2);
        addrs.add(addr3);
        addrs.add(addr4);
        addrs.add(addr5);
        addrs.add(addr6);
        addrs.add(addr7);
        addrs.add(addr8);
        addrs.add(addr9);
        addrs.add(addr10);
        this.repp.onClusterChanged(addrs, new HashSet());
        try {
            List ensemble = (List)this.repp.newEnsemble(6, 6, 4, null, new HashSet()).getResult();
            assert (ensemble.contains(addr4));
            assert (ensemble.contains(addr8));
            assert (ensemble.size() == 6);
            TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)3, (int)this.getNumRegionsInEnsemble(ensemble));
            ensemble = (List)this.repp.newEnsemble(7, 7, 4, null, new HashSet()).getResult();
            assert (ensemble.contains(addr4));
            assert (ensemble.contains(addr8));
            assert (ensemble.size() == 7);
            TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)3, (int)this.getNumRegionsInEnsemble(ensemble));
            ensemble = (List)this.repp.newEnsemble(8, 8, 5, null, new HashSet()).getResult();
            assert (ensemble.contains(addr4));
            assert (ensemble.contains(addr8));
            assert (ensemble.size() == 8);
            TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)3, (int)this.getNumRegionsInEnsemble(ensemble));
            ensemble = (List)this.repp.newEnsemble(9, 9, 5, null, new HashSet()).getResult();
            assert (ensemble.contains(addr4));
            assert (ensemble.contains(addr8));
            assert (ensemble.size() == 9);
            TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)3, (int)this.getNumRegionsInEnsemble(ensemble));
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            TestRegionAwareEnsemblePlacementPolicy.fail((String)"Should not get not enough bookies exception even there is only one rack.");
        }
    }

    @Test
    public void testNewEnsembleWithThreeRegionsWithDisable() throws Exception {
        List ensemble;
        SettableFeatureProvider featureProvider = new SettableFeatureProvider("", 0);
        this.repp.uninitalize();
        this.repp = new RegionAwareEnsemblePlacementPolicy();
        this.conf.setProperty("reppDisallowBookiePlacementInRegionFeatureName", (Object)"disallowBookies");
        this.repp.initialize(this.conf, Optional.empty(), this.timer, (FeatureProvider)featureProvider, (StatsLogger)NullStatsLogger.INSTANCE);
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.4", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.5", 3181);
        BookieSocketAddress addr5 = new BookieSocketAddress("127.0.0.6", 3181);
        BookieSocketAddress addr6 = new BookieSocketAddress("127.0.0.7", 3181);
        BookieSocketAddress addr7 = new BookieSocketAddress("127.0.0.8", 3181);
        BookieSocketAddress addr8 = new BookieSocketAddress("127.0.0.9", 3181);
        BookieSocketAddress addr9 = new BookieSocketAddress("127.0.0.10", 3181);
        BookieSocketAddress addr10 = new BookieSocketAddress("127.0.0.11", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/region2/r1");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/region1/r2");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/region2/r3");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/region3/r4");
        StaticDNSResolver.addNodeToRack(addr5.getHostName(), "/region1/r11");
        StaticDNSResolver.addNodeToRack(addr6.getHostName(), "/region1/r12");
        StaticDNSResolver.addNodeToRack(addr7.getHostName(), "/region2/r13");
        StaticDNSResolver.addNodeToRack(addr8.getHostName(), "/region3/r14");
        StaticDNSResolver.addNodeToRack(addr9.getHostName(), "/region2/r23");
        StaticDNSResolver.addNodeToRack(addr10.getHostName(), "/region1/r24");
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(addr1);
        addrs.add(addr2);
        addrs.add(addr3);
        addrs.add(addr4);
        addrs.add(addr5);
        addrs.add(addr6);
        addrs.add(addr7);
        addrs.add(addr8);
        addrs.add(addr9);
        addrs.add(addr10);
        this.repp.onClusterChanged(addrs, new HashSet());
        try {
            ((SettableFeature)featureProvider.scope("region1").getFeature("disallowBookies")).set(true);
            ensemble = (List)this.repp.newEnsemble(6, 6, 4, null, new HashSet()).getResult();
            TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)2, (int)this.getNumRegionsInEnsemble(ensemble));
            assert (ensemble.contains(addr1));
            assert (ensemble.contains(addr3));
            assert (ensemble.contains(addr4));
            assert (ensemble.contains(addr7));
            assert (ensemble.contains(addr8));
            assert (ensemble.contains(addr9));
            assert (ensemble.size() == 6);
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            TestRegionAwareEnsemblePlacementPolicy.fail((String)"Should not get not enough bookies exception even there is only one rack.");
        }
        try {
            ((SettableFeature)featureProvider.scope("region2").getFeature("disallowBookies")).set(true);
            this.repp.newEnsemble(6, 6, 4, null, new HashSet());
            TestRegionAwareEnsemblePlacementPolicy.fail((String)"Should get not enough bookies exception even there is only one region with insufficient bookies.");
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            // empty catch block
        }
        try {
            ((SettableFeature)featureProvider.scope("region2").getFeature("disallowBookies")).set(false);
            ensemble = (List)this.repp.newEnsemble(6, 6, 4, null, new HashSet()).getResult();
            assert (ensemble.contains(addr1));
            assert (ensemble.contains(addr3));
            assert (ensemble.contains(addr4));
            assert (ensemble.contains(addr7));
            assert (ensemble.contains(addr8));
            assert (ensemble.contains(addr9));
            assert (ensemble.size() == 6);
            TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)2, (int)this.getNumRegionsInEnsemble(ensemble));
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            TestRegionAwareEnsemblePlacementPolicy.fail((String)"Should not get not enough bookies exception even there is only one rack.");
        }
    }

    @Test
    public void testNewEnsembleWithFiveRegions() throws Exception {
        this.repp.uninitalize();
        this.repp = new RegionAwareEnsemblePlacementPolicy();
        this.conf.setProperty("reppRegionsToWrite", (Object)"region1;region2;region3;region4;region5");
        this.conf.setProperty("reppMinimumRegionsForDurability", (Object)5);
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE);
        BookieSocketAddress addr1 = new BookieSocketAddress("127.1.0.2", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.1.0.3", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.1.0.4", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.1.0.5", 3181);
        BookieSocketAddress addr5 = new BookieSocketAddress("127.1.0.6", 3181);
        BookieSocketAddress addr6 = new BookieSocketAddress("127.1.0.7", 3181);
        BookieSocketAddress addr7 = new BookieSocketAddress("127.1.0.8", 3181);
        BookieSocketAddress addr8 = new BookieSocketAddress("127.1.0.9", 3181);
        BookieSocketAddress addr9 = new BookieSocketAddress("127.1.0.10", 3181);
        BookieSocketAddress addr10 = new BookieSocketAddress("127.1.0.11", 3181);
        BookieSocketAddress addr11 = new BookieSocketAddress("127.1.0.12", 3181);
        BookieSocketAddress addr12 = new BookieSocketAddress("127.1.0.13", 3181);
        BookieSocketAddress addr13 = new BookieSocketAddress("127.1.0.14", 3181);
        BookieSocketAddress addr14 = new BookieSocketAddress("127.1.0.15", 3181);
        BookieSocketAddress addr15 = new BookieSocketAddress("127.1.0.16", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/region1/r1");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/region1/r2");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/region1/r3");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/region2/r4");
        StaticDNSResolver.addNodeToRack(addr5.getHostName(), "/region2/r11");
        StaticDNSResolver.addNodeToRack(addr6.getHostName(), "/region2/r12");
        StaticDNSResolver.addNodeToRack(addr7.getHostName(), "/region3/r13");
        StaticDNSResolver.addNodeToRack(addr8.getHostName(), "/region3/r14");
        StaticDNSResolver.addNodeToRack(addr9.getHostName(), "/region3/r23");
        StaticDNSResolver.addNodeToRack(addr10.getHostName(), "/region4/r24");
        StaticDNSResolver.addNodeToRack(addr11.getHostName(), "/region4/r31");
        StaticDNSResolver.addNodeToRack(addr12.getHostName(), "/region4/r32");
        StaticDNSResolver.addNodeToRack(addr13.getHostName(), "/region5/r33");
        StaticDNSResolver.addNodeToRack(addr14.getHostName(), "/region5/r34");
        StaticDNSResolver.addNodeToRack(addr15.getHostName(), "/region5/r35");
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(addr1);
        addrs.add(addr2);
        addrs.add(addr3);
        addrs.add(addr4);
        addrs.add(addr5);
        addrs.add(addr6);
        addrs.add(addr7);
        addrs.add(addr8);
        addrs.add(addr9);
        addrs.add(addr10);
        addrs.add(addr11);
        addrs.add(addr12);
        addrs.add(addr13);
        addrs.add(addr14);
        addrs.add(addr15);
        this.repp.onClusterChanged(addrs, new HashSet());
        try {
            List ensemble = (List)this.repp.newEnsemble(10, 10, 10, null, new HashSet()).getResult();
            assert (ensemble.size() == 10);
            TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)5, (int)this.getNumRegionsInEnsemble(ensemble));
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            LOG.error("BKNotEnoughBookiesException", (Throwable)bnebe);
            TestRegionAwareEnsemblePlacementPolicy.fail((String)"Should not get not enough bookies exception even there is only one rack.");
        }
        try {
            HashSet<BookieSocketAddress> excludedAddrs = new HashSet<BookieSocketAddress>();
            excludedAddrs.add(addr10);
            List ensemble = (List)this.repp.newEnsemble(10, 10, 10, null, excludedAddrs).getResult();
            assert (ensemble.contains(addr11) && ensemble.contains(addr12));
            assert (ensemble.size() == 10);
            TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)5, (int)this.getNumRegionsInEnsemble(ensemble));
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            TestRegionAwareEnsemblePlacementPolicy.fail((String)"Should not get not enough bookies exception even there is only one rack.");
        }
    }

    @Test
    public void testEnsembleWithThreeRegionsReplace() throws Exception {
        this.testEnsembleWithThreeRegionsReplaceInternal(3, false, false);
    }

    @Test
    public void testEnsembleWithThreeRegionsReplaceDisableOneRegion() throws Exception {
        this.testEnsembleWithThreeRegionsReplaceInternal(2, false, true);
    }

    @Test
    public void testEnsembleWithThreeRegionsReplaceMinDurabilityOne() throws Exception {
        this.testEnsembleWithThreeRegionsReplaceInternal(1, false, false);
    }

    @Test
    public void testEnsembleWithThreeRegionsReplaceDisableDurability() throws Exception {
        this.testEnsembleWithThreeRegionsReplaceInternal(1, true, false);
    }

    public void testEnsembleWithThreeRegionsReplaceInternal(int minDurability, boolean disableDurability, boolean disableOneRegion) throws Exception {
        block18: {
            List ensemble;
            this.repp.uninitalize();
            this.repp = new RegionAwareEnsemblePlacementPolicy();
            this.conf.setProperty("reppRegionsToWrite", (Object)"region1;region2;region3");
            this.conf.setProperty("reppMinimumRegionsForDurability", (Object)minDurability);
            SettableFeatureProvider featureProvider = new SettableFeatureProvider("", 0);
            if (minDurability <= 1) {
                this.conf.setProperty("reppEnableDurabilityEnforcementInReplace", (Object)false);
            } else {
                this.conf.setProperty("reppEnableDurabilityEnforcementInReplace", (Object)true);
            }
            this.conf.setProperty("reppDisallowBookiePlacementInRegionFeatureName", (Object)"disallowBookies");
            this.repp.initialize(this.conf, Optional.empty(), this.timer, (FeatureProvider)featureProvider, (StatsLogger)NullStatsLogger.INSTANCE);
            BookieSocketAddress addr1 = new BookieSocketAddress("127.1.0.2", 3181);
            BookieSocketAddress addr2 = new BookieSocketAddress("127.1.0.3", 3181);
            BookieSocketAddress addr3 = new BookieSocketAddress("127.1.0.4", 3181);
            BookieSocketAddress addr4 = new BookieSocketAddress("127.1.0.5", 3181);
            BookieSocketAddress addr5 = new BookieSocketAddress("127.1.0.6", 3181);
            BookieSocketAddress addr6 = new BookieSocketAddress("127.1.0.7", 3181);
            BookieSocketAddress addr7 = new BookieSocketAddress("127.1.0.8", 3181);
            BookieSocketAddress addr8 = new BookieSocketAddress("127.1.0.9", 3181);
            BookieSocketAddress addr9 = new BookieSocketAddress("127.1.0.10", 3181);
            StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/region1/r1");
            StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/region1/r2");
            StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/region1/r3");
            StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/region2/r4");
            StaticDNSResolver.addNodeToRack(addr5.getHostName(), "/region2/r11");
            StaticDNSResolver.addNodeToRack(addr6.getHostName(), "/region2/r12");
            StaticDNSResolver.addNodeToRack(addr7.getHostName(), "/region3/r13");
            StaticDNSResolver.addNodeToRack(addr8.getHostName(), "/region3/r14");
            StaticDNSResolver.addNodeToRack(addr9.getHostName(), "/region3/r23");
            HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
            addrs.add(addr1);
            addrs.add(addr2);
            addrs.add(addr3);
            addrs.add(addr4);
            addrs.add(addr5);
            addrs.add(addr6);
            addrs.add(addr7);
            addrs.add(addr8);
            addrs.add(addr9);
            this.repp.onClusterChanged(addrs, new HashSet());
            SettableFeature disableDurabilityFeature = (SettableFeature)featureProvider.getFeature("repp_disable_durability_enforcement");
            if (disableDurability) {
                disableDurabilityFeature.set(true);
            }
            int ackQuorum = 4;
            if (minDurability > 2) {
                ackQuorum = 5;
            }
            try {
                ensemble = (List)this.repp.newEnsemble(6, 6, ackQuorum, null, new HashSet()).getResult();
                assert (ensemble.size() == 6);
                TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)3, (int)this.getNumRegionsInEnsemble(ensemble));
            }
            catch (BKException.BKNotEnoughBookiesException bnebe) {
                LOG.error("BKNotEnoughBookiesException", (Throwable)bnebe);
                TestRegionAwareEnsemblePlacementPolicy.fail((String)"Should not get not enough bookies exception even there is only one rack.");
                throw bnebe;
            }
            if (disableOneRegion) {
                ((SettableFeature)featureProvider.scope("region2").getFeature("disallowBookies")).set(true);
                HashSet<BookieSocketAddress> region2Bookies = new HashSet<BookieSocketAddress>();
                region2Bookies.add(addr4);
                region2Bookies.add(addr5);
                region2Bookies.add(addr6);
                HashSet region1And3Bookies = new HashSet(addrs);
                region1And3Bookies.removeAll(region2Bookies);
                HashSet excludedAddrs = new HashSet();
                for (BookieSocketAddress addr : region2Bookies) {
                    if (!ensemble.contains(addr)) continue;
                    BookieSocketAddress replacedBookie = (BookieSocketAddress)this.repp.replaceBookie(6, 6, ackQuorum, null, ensemble, addr, excludedAddrs).getResult();
                    ensemble.remove(addr);
                    ensemble.add(replacedBookie);
                }
                TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)2, (int)this.getNumRegionsInEnsemble(ensemble));
                TestRegionAwareEnsemblePlacementPolicy.assertTrue((boolean)ensemble.containsAll(region1And3Bookies));
            } else {
                BookieSocketAddress replacedBookieExpected;
                BookieSocketAddress bookieToReplace;
                if (ensemble.contains(addr4)) {
                    bookieToReplace = addr4;
                    replacedBookieExpected = ensemble.contains(addr5) ? addr6 : addr5;
                } else {
                    replacedBookieExpected = addr4;
                    bookieToReplace = addr5;
                }
                HashSet<BookieSocketAddress> excludedAddrs = new HashSet<BookieSocketAddress>();
                try {
                    BookieSocketAddress replacedBookie = (BookieSocketAddress)this.repp.replaceBookie(6, 6, ackQuorum, null, ensemble, bookieToReplace, excludedAddrs).getResult();
                    assert (replacedBookie.equals((Object)replacedBookieExpected));
                    TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)3, (int)this.getNumRegionsInEnsemble(ensemble));
                }
                catch (BKException.BKNotEnoughBookiesException bnebe) {
                    TestRegionAwareEnsemblePlacementPolicy.fail((String)"Should not get not enough bookies exception even there is only one rack.");
                }
                excludedAddrs.add(replacedBookieExpected);
                try {
                    this.repp.replaceBookie(6, 6, ackQuorum, null, ensemble, bookieToReplace, excludedAddrs);
                    if (minDurability > 1 && !disableDurabilityFeature.isAvailable()) {
                        TestRegionAwareEnsemblePlacementPolicy.fail((String)"Should throw BKNotEnoughBookiesException when there is not enough bookies");
                    }
                }
                catch (BKException.BKNotEnoughBookiesException bnebe) {
                    if (minDurability > 1 && !disableDurabilityFeature.isAvailable()) break block18;
                    TestRegionAwareEnsemblePlacementPolicy.fail((String)"Should not throw BKNotEnoughBookiesException when there is not enough bookies");
                }
            }
        }
    }

    @Test
    public void testEnsembleMinDurabilityOne() throws Exception {
        this.testEnsembleDurabilityDisabledInternal(1, false);
    }

    @Test
    public void testEnsembleDisableDurability() throws Exception {
        this.testEnsembleDurabilityDisabledInternal(2, true);
    }

    public void testEnsembleDurabilityDisabledInternal(int minDurability, boolean disableDurability) throws Exception {
        List ensemble;
        this.repp.uninitalize();
        this.repp = new RegionAwareEnsemblePlacementPolicy();
        this.conf.setProperty("reppRegionsToWrite", (Object)"region1;region2;region3");
        this.conf.setProperty("reppMinimumRegionsForDurability", (Object)minDurability);
        SettableFeatureProvider featureProvider = new SettableFeatureProvider("", 0);
        if (minDurability <= 1) {
            this.conf.setProperty("reppEnableDurabilityEnforcementInReplace", (Object)false);
        } else {
            this.conf.setProperty("reppEnableDurabilityEnforcementInReplace", (Object)true);
        }
        this.repp.initialize(this.conf, Optional.empty(), this.timer, (FeatureProvider)featureProvider, (StatsLogger)NullStatsLogger.INSTANCE);
        BookieSocketAddress addr1 = new BookieSocketAddress("127.1.0.2", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.1.0.3", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.1.0.4", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.1.0.5", 3181);
        BookieSocketAddress addr5 = new BookieSocketAddress("127.1.0.6", 3181);
        BookieSocketAddress addr6 = new BookieSocketAddress("127.1.0.7", 3181);
        BookieSocketAddress addr7 = new BookieSocketAddress("127.1.0.8", 3181);
        BookieSocketAddress addr8 = new BookieSocketAddress("127.1.0.9", 3181);
        BookieSocketAddress addr9 = new BookieSocketAddress("127.1.0.10", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/region1/r1");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/region1/r2");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/region1/r3");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/region1/r4");
        StaticDNSResolver.addNodeToRack(addr5.getHostName(), "/region1/r11");
        StaticDNSResolver.addNodeToRack(addr6.getHostName(), "/region1/r12");
        StaticDNSResolver.addNodeToRack(addr7.getHostName(), "/region1/r13");
        StaticDNSResolver.addNodeToRack(addr8.getHostName(), "/region1/r14");
        StaticDNSResolver.addNodeToRack(addr9.getHostName(), "/region1/r23");
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(addr1);
        addrs.add(addr2);
        addrs.add(addr3);
        addrs.add(addr4);
        addrs.add(addr5);
        addrs.add(addr6);
        addrs.add(addr7);
        addrs.add(addr8);
        addrs.add(addr9);
        this.repp.onClusterChanged(addrs, new HashSet());
        if (disableDurability) {
            ((SettableFeature)featureProvider.getFeature("repp_disable_durability_enforcement")).set(true);
        }
        try {
            ensemble = (List)this.repp.newEnsemble(6, 6, 4, null, new HashSet()).getResult();
            assert (ensemble.size() == 6);
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            LOG.error("BKNotEnoughBookiesException", (Throwable)bnebe);
            TestRegionAwareEnsemblePlacementPolicy.fail((String)"Should not get not enough bookies exception even there is only one rack.");
            throw bnebe;
        }
        HashSet excludedAddrs = new HashSet();
        try {
            this.repp.replaceBookie(6, 6, 4, null, ensemble, (BookieSocketAddress)ensemble.get(2), excludedAddrs);
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            TestRegionAwareEnsemblePlacementPolicy.fail((String)"Should not get not enough bookies exception even there is only one rack.");
        }
    }

    @Test
    public void testNewEnsembleFailWithFiveRegions() throws Exception {
        this.repp.uninitalize();
        this.repp = new RegionAwareEnsemblePlacementPolicy();
        this.conf.setProperty("reppRegionsToWrite", (Object)"region1;region2;region3;region4;region5");
        this.conf.setProperty("reppMinimumRegionsForDurability", (Object)5);
        this.conf.setProperty("reppEnableValidation", (Object)false);
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE);
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.4", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.5", 3181);
        BookieSocketAddress addr5 = new BookieSocketAddress("127.0.0.6", 3181);
        BookieSocketAddress addr6 = new BookieSocketAddress("127.0.0.7", 3181);
        BookieSocketAddress addr7 = new BookieSocketAddress("127.0.0.8", 3181);
        BookieSocketAddress addr8 = new BookieSocketAddress("127.0.0.9", 3181);
        BookieSocketAddress addr9 = new BookieSocketAddress("127.0.0.10", 3181);
        BookieSocketAddress addr10 = new BookieSocketAddress("127.0.0.11", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/region1/r1");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/region1/r2");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/region2/r3");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/region2/r4");
        StaticDNSResolver.addNodeToRack(addr5.getHostName(), "/region3/r11");
        StaticDNSResolver.addNodeToRack(addr6.getHostName(), "/region3/r12");
        StaticDNSResolver.addNodeToRack(addr7.getHostName(), "/region4/r13");
        StaticDNSResolver.addNodeToRack(addr8.getHostName(), "/region4/r14");
        StaticDNSResolver.addNodeToRack(addr9.getHostName(), "/region5/r23");
        StaticDNSResolver.addNodeToRack(addr10.getHostName(), "/region5/r24");
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(addr1);
        addrs.add(addr2);
        addrs.add(addr3);
        addrs.add(addr4);
        addrs.add(addr5);
        addrs.add(addr6);
        addrs.add(addr7);
        addrs.add(addr8);
        addrs.add(addr9);
        addrs.add(addr10);
        this.repp.onClusterChanged(addrs, new HashSet());
        HashSet<BookieSocketAddress> excludedAddrs = new HashSet<BookieSocketAddress>();
        excludedAddrs.add(addr10);
        excludedAddrs.add(addr9);
        try {
            LOG.info("Ensemble : {}", this.repp.newEnsemble(5, 5, 5, null, excludedAddrs).getResult());
            TestRegionAwareEnsemblePlacementPolicy.fail((String)"Should throw BKNotEnoughBookiesException when there is not enough bookies");
        }
        catch (BKException.BKNotEnoughBookiesException bKNotEnoughBookiesException) {
            // empty catch block
        }
    }

    private void prepareNetworkTopologyForReorderTests(String myRegion) throws Exception {
        this.repp.uninitalize();
        TestRegionAwareEnsemblePlacementPolicy.updateMyRack("/" + myRegion);
        this.repp = new RegionAwareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE);
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.4", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.5", 3181);
        BookieSocketAddress addr5 = new BookieSocketAddress("127.0.0.6", 3181);
        BookieSocketAddress addr6 = new BookieSocketAddress("127.0.0.7", 3181);
        BookieSocketAddress addr7 = new BookieSocketAddress("127.0.0.8", 3181);
        BookieSocketAddress addr8 = new BookieSocketAddress("127.0.0.9", 3181);
        BookieSocketAddress addr9 = new BookieSocketAddress("127.0.0.10", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/region1/r1");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/region1/r2");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/region1/r3");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/region2/r1");
        StaticDNSResolver.addNodeToRack(addr5.getHostName(), "/region2/r2");
        StaticDNSResolver.addNodeToRack(addr6.getHostName(), "/region2/r3");
        StaticDNSResolver.addNodeToRack(addr7.getHostName(), "/region3/r1");
        StaticDNSResolver.addNodeToRack(addr8.getHostName(), "/region3/r2");
        StaticDNSResolver.addNodeToRack(addr9.getHostName(), "/region3/r3");
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(addr1);
        addrs.add(addr2);
        addrs.add(addr3);
        addrs.add(addr4);
        addrs.add(addr5);
        addrs.add(addr6);
        addrs.add(addr7);
        addrs.add(addr8);
        addrs.add(addr9);
        this.repp.onClusterChanged(addrs, new HashSet());
    }

    @Test
    public void testBasicReorderReadSequenceWithLocalRegion() throws Exception {
        this.basicReorderReadSequenceWithLocalRegionTest("region2", false);
    }

    @Test
    public void testBasicReorderReadLACSequenceWithLocalRegion() throws Exception {
        this.basicReorderReadSequenceWithLocalRegionTest("region2", true);
    }

    private void basicReorderReadSequenceWithLocalRegionTest(String myRegion, boolean isReadLAC) throws Exception {
        this.prepareNetworkTopologyForReorderTests(myRegion);
        List ensemble = (List)this.repp.newEnsemble(9, 9, 5, null, new HashSet()).getResult();
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)9, (int)this.getNumCoveredRegionsInWriteQuorum(ensemble, 9));
        RoundRobinDistributionSchedule ds = new RoundRobinDistributionSchedule(9, 9, 9);
        LOG.info("My region is {}, ensemble : {}", (Object)this.repp.myRegion, (Object)ensemble);
        int ensembleSize = ensemble.size();
        for (int i = 0; i < ensembleSize; ++i) {
            int k;
            DistributionSchedule.WriteSet writeSet = ds.getWriteSet((long)i);
            DistributionSchedule.WriteSet origWriteSet = writeSet.copy();
            DistributionSchedule.WriteSet readSet = isReadLAC ? this.repp.reorderReadLACSequence(ensemble, TestRegionAwareEnsemblePlacementPolicy.getBookiesHealthInfo(), writeSet) : this.repp.reorderReadSequence(ensemble, TestRegionAwareEnsemblePlacementPolicy.getBookiesHealthInfo(), writeSet);
            LOG.info("Reorder {} => {}.", (Object)origWriteSet, (Object)readSet);
            for (k = 0; k < 2; ++k) {
                BookieSocketAddress address = (BookieSocketAddress)ensemble.get(readSet.get(k));
                TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)myRegion, (String)StaticDNSResolver.getRegion(address.getHostName()));
            }
            BookieSocketAddress remoteAddress = (BookieSocketAddress)ensemble.get(readSet.get(k));
            TestRegionAwareEnsemblePlacementPolicy.assertFalse((boolean)myRegion.equals(StaticDNSResolver.getRegion(remoteAddress.getHostName())));
            BookieSocketAddress localAddress = (BookieSocketAddress)ensemble.get(readSet.get(++k));
            TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)myRegion, (String)StaticDNSResolver.getRegion(localAddress.getHostName()));
            ++k;
            while (k < ensembleSize) {
                BookieSocketAddress address = (BookieSocketAddress)ensemble.get(readSet.get(k));
                TestRegionAwareEnsemblePlacementPolicy.assertFalse((boolean)myRegion.equals(StaticDNSResolver.getRegion(address.getHostName())));
                ++k;
            }
        }
    }

    @Test
    public void testBasicReorderReadSequenceWithRemoteRegion() throws Exception {
        this.basicReorderReadSequenceWithRemoteRegionTest("region4", false);
    }

    @Test
    public void testBasicReorderReadLACSequenceWithRemoteRegion() throws Exception {
        this.basicReorderReadSequenceWithRemoteRegionTest("region4", true);
    }

    private void basicReorderReadSequenceWithRemoteRegionTest(String myRegion, boolean isReadLAC) throws Exception {
        this.prepareNetworkTopologyForReorderTests(myRegion);
        List ensemble = (List)this.repp.newEnsemble(9, 9, 5, null, new HashSet()).getResult();
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)9, (int)this.getNumCoveredRegionsInWriteQuorum(ensemble, 9));
        RoundRobinDistributionSchedule ds = new RoundRobinDistributionSchedule(9, 9, 9);
        LOG.info("My region is {}, ensemble : {}", (Object)this.repp.myRegion, (Object)ensemble);
        int ensembleSize = ensemble.size();
        for (int i = 0; i < ensembleSize; ++i) {
            DistributionSchedule.WriteSet writeSet = ds.getWriteSet((long)i);
            DistributionSchedule.WriteSet readSet = isReadLAC ? this.repp.reorderReadLACSequence(ensemble, TestRegionAwareEnsemblePlacementPolicy.getBookiesHealthInfo(), writeSet.copy()) : this.repp.reorderReadSequence(ensemble, TestRegionAwareEnsemblePlacementPolicy.getBookiesHealthInfo(), writeSet.copy());
            TestRegionAwareEnsemblePlacementPolicy.assertEquals((Object)writeSet, (Object)readSet);
        }
    }

    @Test
    public void testReorderReadSequenceWithUnavailableOrReadOnlyBookies() throws Exception {
        this.reorderReadSequenceWithUnavailableOrReadOnlyBookiesTest(false);
    }

    @Test
    public void testReorderReadLACSequenceWithUnavailableOrReadOnlyBookies() throws Exception {
        this.reorderReadSequenceWithUnavailableOrReadOnlyBookiesTest(true);
    }

    static Set<BookieSocketAddress> getBookiesForRegion(List<BookieSocketAddress> ensemble, String region) {
        HashSet<BookieSocketAddress> regionBookies = new HashSet<BookieSocketAddress>();
        for (BookieSocketAddress address : ensemble) {
            String r = StaticDNSResolver.getRegion(address.getHostName());
            if (!r.equals(region)) continue;
            regionBookies.add(address);
        }
        return regionBookies;
    }

    static void appendBookieIndexByRegion(List<BookieSocketAddress> ensemble, DistributionSchedule.WriteSet writeSet, String region, List<Integer> finalSet) {
        for (int i = 0; i < writeSet.size(); ++i) {
            int bi = writeSet.get(i);
            String r = StaticDNSResolver.getRegion(ensemble.get(bi).getHostName());
            if (!r.equals(region)) continue;
            finalSet.add(bi);
        }
    }

    private void reorderReadSequenceWithUnavailableOrReadOnlyBookiesTest(boolean isReadLAC) throws Exception {
        String myRegion = "region4";
        String unavailableRegion = "region1";
        String writeRegion = "region2";
        String readOnlyRegion = "region3";
        this.prepareNetworkTopologyForReorderTests(myRegion);
        List ensemble = (List)this.repp.newEnsemble(9, 9, 5, null, new HashSet()).getResult();
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)9, (int)this.getNumCoveredRegionsInWriteQuorum(ensemble, 9));
        RoundRobinDistributionSchedule ds = new RoundRobinDistributionSchedule(9, 9, 9);
        LOG.info("My region is {}, ensemble : {}", (Object)this.repp.myRegion, (Object)ensemble);
        Set<BookieSocketAddress> readOnlyBookies = TestRegionAwareEnsemblePlacementPolicy.getBookiesForRegion(ensemble, readOnlyRegion);
        Set<BookieSocketAddress> writeBookies = TestRegionAwareEnsemblePlacementPolicy.getBookiesForRegion(ensemble, writeRegion);
        this.repp.onClusterChanged(writeBookies, readOnlyBookies);
        LOG.info("Writable Bookies {}, ReadOnly Bookies {}.", this.repp.knownBookies.keySet(), (Object)this.repp.readOnlyBookies);
        int ensembleSize = ensemble.size();
        for (int i = 0; i < ensembleSize; ++i) {
            DistributionSchedule.WriteSet writeSet = ds.getWriteSet((long)i);
            DistributionSchedule.WriteSet readSet = isReadLAC ? this.repp.reorderReadLACSequence(ensemble, TestRegionAwareEnsemblePlacementPolicy.getBookiesHealthInfo(), writeSet.copy()) : this.repp.reorderReadSequence(ensemble, TestRegionAwareEnsemblePlacementPolicy.getBookiesHealthInfo(), writeSet.copy());
            LOG.info("Reorder {} => {}.", (Object)writeSet, (Object)readSet);
            ArrayList<Integer> expectedReadSet = new ArrayList<Integer>();
            TestRegionAwareEnsemblePlacementPolicy.appendBookieIndexByRegion(ensemble, writeSet, writeRegion, expectedReadSet);
            TestRegionAwareEnsemblePlacementPolicy.appendBookieIndexByRegion(ensemble, writeSet, readOnlyRegion, expectedReadSet);
            TestRegionAwareEnsemblePlacementPolicy.appendBookieIndexByRegion(ensemble, writeSet, unavailableRegion, expectedReadSet);
            TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)expectedReadSet.size(), (int)readSet.size());
            for (int j = 0; j < expectedReadSet.size(); ++j) {
                TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)((Integer)expectedReadSet.get(j)), (int)readSet.get(j));
            }
        }
    }

    private int getNumRegionsInEnsemble(List<BookieSocketAddress> ensemble) {
        HashSet<String> regions = new HashSet<String>();
        for (BookieSocketAddress addr : ensemble) {
            regions.add(StaticDNSResolver.getRegion(addr.getHostName()));
        }
        return regions.size();
    }

    private int getNumCoveredRegionsInWriteQuorum(List<BookieSocketAddress> ensemble, int writeQuorumSize) throws Exception {
        int ensembleSize = ensemble.size();
        int numCoveredWriteQuorums = 0;
        for (int i = 0; i < ensembleSize; ++i) {
            HashSet<String> regions = new HashSet<String>();
            for (int j = 0; j < writeQuorumSize; ++j) {
                int bookieIdx = (i + j) % ensembleSize;
                BookieSocketAddress addr = ensemble.get(bookieIdx);
                regions.add(StaticDNSResolver.getRegion(addr.getHostName()));
            }
            numCoveredWriteQuorums += regions.size() > 1 ? 1 : 0;
        }
        return numCoveredWriteQuorums;
    }

    @Test
    public void testNodeWithFailures() throws Exception {
        this.repp.uninitalize();
        TestRegionAwareEnsemblePlacementPolicy.updateMyRack("/r2/rack1");
        this.repp = new RegionAwareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE);
        BookieSocketAddress addr5 = new BookieSocketAddress("127.0.0.6", 3181);
        BookieSocketAddress addr6 = new BookieSocketAddress("127.0.0.7", 3181);
        BookieSocketAddress addr7 = new BookieSocketAddress("127.0.0.8", 3181);
        BookieSocketAddress addr8 = new BookieSocketAddress("127.0.0.9", 3181);
        StaticDNSResolver.addNodeToRack(this.addr2.getHostName(), "/r2/rack1");
        StaticDNSResolver.addNodeToRack(this.addr3.getHostName(), "/r2/rack2");
        StaticDNSResolver.addNodeToRack(addr5.getHostName(), "/r1/rack3");
        StaticDNSResolver.addNodeToRack(addr6.getHostName(), "/r2/rack3");
        StaticDNSResolver.addNodeToRack(addr7.getHostName(), "/r2/rack4");
        StaticDNSResolver.addNodeToRack(addr8.getHostName(), "/r1/rack4");
        this.ensemble.add(addr5);
        this.ensemble.add(addr6);
        this.ensemble.add(addr7);
        this.ensemble.add(addr8);
        DistributionSchedule.WriteSet writeSet2 = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{0, 1, 2, 3, 4, 5, 6, 7});
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(this.addr1);
        addrs.add(this.addr2);
        addrs.add(this.addr3);
        addrs.add(this.addr4);
        addrs.add(addr5);
        addrs.add(addr6);
        addrs.add(addr7);
        addrs.add(addr8);
        this.repp.onClusterChanged(addrs, new HashSet());
        HashMap<BookieSocketAddress, Long> bookieFailures = new HashMap<BookieSocketAddress, Long>();
        bookieFailures.put(this.addr1, 20L);
        bookieFailures.put(this.addr2, 22L);
        bookieFailures.put(this.addr3, 24L);
        bookieFailures.put(this.addr4, 25L);
        LOG.info("write set : {}", (Object)writeSet2);
        DistributionSchedule.WriteSet reoderSet = this.repp.reorderReadSequence(this.ensemble, TestRegionAwareEnsemblePlacementPolicy.getBookiesHealthInfo(bookieFailures, new HashMap<BookieSocketAddress, Long>()), writeSet2);
        LOG.info("reorder set : {}", (Object)reoderSet);
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((Object)this.ensemble.get(reoderSet.get(0)), (Object)addr6);
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((Object)this.ensemble.get(reoderSet.get(1)), (Object)addr7);
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((Object)this.ensemble.get(reoderSet.get(2)), (Object)addr5);
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((Object)this.ensemble.get(reoderSet.get(3)), (Object)this.addr2);
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((Object)this.ensemble.get(reoderSet.get(4)), (Object)this.addr3);
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((Object)this.ensemble.get(reoderSet.get(5)), (Object)addr8);
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((Object)this.ensemble.get(reoderSet.get(6)), (Object)this.addr1);
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((Object)this.ensemble.get(reoderSet.get(7)), (Object)this.addr4);
    }
}

