/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client.impl;

import com.google.common.base.Charsets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import org.apache.bookkeeper.client.api.LedgerEntry;
import org.apache.bookkeeper.client.impl.LedgerEntryImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class LedgerEntryImplTest {
    private final long ledgerId;
    private final long entryId;
    private final long length;
    private final byte[] dataBytes = "test-ledger-entry-impl".getBytes(Charsets.UTF_8);
    private final ByteBuf dataBuf = Unpooled.wrappedBuffer((byte[])this.dataBytes);
    private final LedgerEntryImpl entryImpl = LedgerEntryImpl.create((long)this.ledgerId, (long)this.entryId, (long)this.length, (ByteBuf)this.dataBuf);

    public LedgerEntryImplTest() {
        this.ledgerId = 1234L;
        this.entryId = 3579L;
        this.length = 200L;
    }

    @After
    public void teardown() {
        this.entryImpl.close();
        Assert.assertEquals((long)0L, (long)this.dataBuf.refCnt());
    }

    @Test
    public void testGetters() {
        Assert.assertEquals((long)this.ledgerId, (long)this.entryImpl.getLedgerId());
        Assert.assertEquals((long)this.entryId, (long)this.entryImpl.getEntryId());
        Assert.assertEquals((long)this.length, (long)this.entryImpl.getLength());
        Assert.assertArrayEquals((byte[])this.dataBytes, (byte[])this.entryImpl.getEntryBytes());
        Assert.assertEquals((long)0L, (long)this.entryImpl.getEntryBuffer().readerIndex());
        Assert.assertEquals((long)this.dataBytes.length, (long)this.entryImpl.getEntryBuffer().readableBytes());
        ByteBuffer nioBuffer = this.entryImpl.getEntryNioBuffer();
        Assert.assertEquals((long)this.dataBytes.length, (long)nioBuffer.remaining());
        byte[] readBytes = new byte[nioBuffer.remaining()];
        nioBuffer.get(readBytes);
        Assert.assertArrayEquals((byte[])this.dataBytes, (byte[])readBytes);
        Assert.assertEquals((long)0L, (long)this.entryImpl.getEntryBuffer().readerIndex());
        Assert.assertEquals((long)this.dataBytes.length, (long)this.entryImpl.getEntryBuffer().readableBytes());
    }

    @Test
    public void testSetters() {
        Assert.assertEquals((long)this.ledgerId, (long)this.entryImpl.getLedgerId());
        Assert.assertEquals((long)this.entryId, (long)this.entryImpl.getEntryId());
        Assert.assertEquals((long)this.length, (long)this.entryImpl.getLength());
        this.entryImpl.setLength(this.length * 2L);
        Assert.assertEquals((long)(this.length * 2L), (long)this.entryImpl.getLength());
        this.entryImpl.setEntryId(this.entryId * 2L);
        Assert.assertEquals((long)(this.entryId * 2L), (long)this.entryImpl.getEntryId());
        byte[] anotherBytes = "another-ledger-entry-impl".getBytes(Charsets.UTF_8);
        ByteBuf anotherBuf = Unpooled.wrappedBuffer((byte[])anotherBytes);
        this.entryImpl.setEntryBuf(anotherBuf);
        Assert.assertEquals((long)0L, (long)this.dataBuf.refCnt());
    }

    @Test
    public void testDuplicate() {
        LedgerEntryImpl duplicatedEntry = LedgerEntryImpl.duplicate((LedgerEntry)this.entryImpl);
        Assert.assertEquals((long)2L, (long)this.dataBuf.refCnt());
        Assert.assertEquals((long)this.ledgerId, (long)duplicatedEntry.getLedgerId());
        Assert.assertEquals((long)this.entryId, (long)duplicatedEntry.getEntryId());
        Assert.assertEquals((long)this.length, (long)duplicatedEntry.getLength());
        Assert.assertArrayEquals((byte[])this.dataBytes, (byte[])duplicatedEntry.getEntryBytes());
        duplicatedEntry.close();
        Assert.assertEquals((long)1L, (long)this.dataBuf.refCnt());
    }
}

